/*
 * Decompiled with CFR 0.152.
 */
package roomeqwizard.api;

import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.List;
import roomeqwizard.HE;
import roomeqwizard.LA;
import roomeqwizard.LengthUnit;
import roomeqwizard.SpeakerID;
import roomeqwizard.TD;
import roomeqwizard.UC;
import roomeqwizard.api.APIResponse;
import roomeqwizard.api.model.Absorptions;
import roomeqwizard.api.model.FrequencyResponse;
import roomeqwizard.api.model.MicPositionOffsets;
import roomeqwizard.api.model.RoomDimensions;
import roomeqwizard.api.model.RoomPosition;
import roomeqwizard.api.model.RoomSimOptions;
import roomeqwizard.api.model.RoomSimSources;
import roomeqwizard.api.model.SourceConfiguration;
import roomeqwizard.api.model.ValidValues;
import roomeqwizard.lG;
import roomeqwizard.vA;
import spark.Request;
import spark.Response;

public class RoomSimService {
    private static final String UNIT_KEY = "unit";
    private static final String MIC_POSN_KEY = "micposition";
    private static List<String> lengthUnits;
    private static List<String> sourceNames;
    private static List<String> enclosureTypes;
    private static List<String> micPositions;
    private vA roomPanel;

    public static String getUNIT_KEY() {
        return UNIT_KEY;
    }

    public static LengthUnit getDefaultLengthUnit() {
        return LengthUnit.METRE;
    }

    public static String getLengthUnitKey() {
        return UNIT_KEY;
    }

    public static String getMicPosnKey() {
        return MIC_POSN_KEY;
    }

    public RoomSimService() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                LA.A();
                RoomSimService.this.roomPanel = vA.\u0153();
            }
        });
    }

    public static List<String> getLengthUnits() {
        if (lengthUnits == null) {
            lengthUnits = new ArrayList<String>();
            for (LengthUnit lengthUnit : LengthUnit.values()) {
                lengthUnits.add(lengthUnit.apiName());
            }
        }
        return lengthUnits;
    }

    public Boolean getRoomIsSealed() {
        return lG.\u01de();
    }

    public APIResponse setRoomIsSealed(Boolean bl, Response response) {
        if (bl == null) {
            return APIResponse.badRequest(response, "No setting in request");
        }
        lG.\u00f3(bl);
        return APIResponse.ok(response, "Update processed");
    }

    public RoomDimensions getRoomDimensions(LengthUnit lengthUnit) {
        return RoomDimensions.builder().unit(lengthUnit.apiName()).length(lengthUnit.metresToUnit(this.roomPanel.\u014b())).width(lengthUnit.metresToUnit(this.roomPanel.\u014d())).height(lengthUnit.metresToUnit(this.roomPanel.\u013f())).build();
    }

    public APIResponse setRoomDimensions(RoomDimensions roomDimensions, Response response) {
        double d2;
        LengthUnit lengthUnit = RoomSimService.getDefaultLengthUnit();
        boolean bl = false;
        if (roomDimensions.getUnit() != null && (lengthUnit = LengthUnit.getFromApiName(roomDimensions.getUnit())) == null) {
            return APIResponse.badRequest(response, roomDimensions.getUnit() + " is not a valid unit");
        }
        if (roomDimensions.getLength() != null) {
            d2 = lengthUnit.toMetres(roomDimensions.getLength());
            if (!this.validDimension(d2)) {
                return this.badDimension(response, lengthUnit, roomDimensions.getLength());
            }
            this.roomPanel.P(d2);
            bl = true;
        }
        if (roomDimensions.getWidth() != null) {
            d2 = lengthUnit.toMetres(roomDimensions.getWidth());
            if (!this.validDimension(d2)) {
                return this.badDimension(response, lengthUnit, roomDimensions.getWidth());
            }
            this.roomPanel.T(d2);
            bl = true;
        }
        if (roomDimensions.getHeight() != null) {
            d2 = lengthUnit.toMetres(roomDimensions.getHeight());
            if (!this.validDimension(d2)) {
                return this.badDimension(response, lengthUnit, roomDimensions.getHeight());
            }
            this.roomPanel.X(d2);
            bl = true;
        }
        if (!bl) {
            return APIResponse.badRequest(response, "Nothing to update in the request");
        }
        return APIResponse.ok(response, "Update processed");
    }

    private APIResponse badDimension(Response response, LengthUnit lengthUnit, double d2) {
        return APIResponse.badRequest(response, d2 + " is not withing the valid range of " + HE.K.format(lengthUnit.metresToUnit(vA.\u0145())) + " to " + HE.K.format(lengthUnit.metresToUnit(vA.\u0134())) + " " + lengthUnit.suffix());
    }

    private boolean validDimension(double d2) {
        return d2 >= vA.\u0145() && d2 <= vA.\u0134();
    }

    public Absorptions getAbsorptions() {
        return this.roomPanel.\u0144();
    }

    public APIResponse setAbsorptions(Absorptions absorptions, Response response) {
        double d2;
        boolean bl = false;
        if (absorptions.getFront() != null) {
            d2 = absorptions.getFront();
            if (!this.validAbsorption(d2)) {
                return this.badAbsorption(response, d2);
            }
            this.roomPanel.M(d2);
            bl = true;
        }
        if (absorptions.getBack() != null) {
            d2 = absorptions.getBack();
            if (!this.validAbsorption(d2)) {
                return this.badAbsorption(response, d2);
            }
            this.roomPanel.Y(d2);
            bl = true;
        }
        if (absorptions.getLeft() != null) {
            d2 = absorptions.getLeft();
            if (!this.validAbsorption(d2)) {
                return this.badAbsorption(response, d2);
            }
            this.roomPanel.b(d2);
            bl = true;
        }
        if (absorptions.getRight() != null) {
            d2 = absorptions.getRight();
            if (!this.validAbsorption(d2)) {
                return this.badAbsorption(response, d2);
            }
            this.roomPanel._(d2);
            bl = true;
        }
        if (absorptions.getCeiling() != null) {
            d2 = absorptions.getCeiling();
            if (!this.validAbsorption(d2)) {
                return this.badAbsorption(response, d2);
            }
            this.roomPanel.S(d2);
            bl = true;
        }
        if (absorptions.getFloor() != null) {
            d2 = absorptions.getFloor();
            if (!this.validAbsorption(d2)) {
                return this.badAbsorption(response, d2);
            }
            this.roomPanel.N(d2);
            bl = true;
        }
        if (!bl) {
            return APIResponse.badRequest(response, "Nothing to update in the request");
        }
        return APIResponse.ok(response, "Update processed");
    }

    private APIResponse badAbsorption(Response response, double d2) {
        return APIResponse.badRequest(response, d2 + " is not withing the valid range of " + HE.K.format(vA.\u0145()) + " to " + HE.K.format(vA.\u0134()));
    }

    private boolean validAbsorption(double d2) {
        return d2 >= vA.\u0135() && d2 <= vA.\u014e();
    }

    public MicPositionOffsets getMicPositionOffsets(LengthUnit lengthUnit) {
        return this.roomPanel.A(lengthUnit);
    }

    public APIResponse setMicPositionOffsets(MicPositionOffsets micPositionOffsets, Response response) {
        double d2;
        LengthUnit lengthUnit = RoomSimService.getDefaultLengthUnit();
        if (micPositionOffsets.getUnit() != null && (lengthUnit = LengthUnit.getFromApiName(micPositionOffsets.getUnit())) == null) {
            return APIResponse.badRequest(response, micPositionOffsets.getUnit() + " is not a valid unit");
        }
        boolean bl = false;
        if (micPositionOffsets.getAbove() != null) {
            d2 = micPositionOffsets.getAbove();
            this.roomPanel.Q(lengthUnit.toMetres(d2));
            bl = true;
        }
        if (micPositionOffsets.getBelow() != null) {
            d2 = micPositionOffsets.getBelow();
            this.roomPanel.U(lengthUnit.toMetres(d2));
            bl = true;
        }
        if (micPositionOffsets.getLeft() != null) {
            d2 = micPositionOffsets.getLeft();
            this.roomPanel.R(lengthUnit.toMetres(d2));
            bl = true;
        }
        if (micPositionOffsets.getRight() != null) {
            d2 = micPositionOffsets.getRight();
            this.roomPanel.O(lengthUnit.toMetres(d2));
            bl = true;
        }
        if (micPositionOffsets.getInFront() != null) {
            d2 = micPositionOffsets.getInFront();
            this.roomPanel.Z(lengthUnit.toMetres(d2));
            bl = true;
        }
        if (micPositionOffsets.getBehind() != null) {
            d2 = micPositionOffsets.getBehind();
            this.roomPanel.W(lengthUnit.toMetres(d2));
            bl = true;
        }
        if (!bl) {
            return APIResponse.badRequest(response, "Nothing to update in the request");
        }
        return APIResponse.ok(response, "Update processed");
    }

    public RoomSimSources getSources() {
        return this.roomPanel.\u0146();
    }

    public APIResponse setSources(RoomSimSources roomSimSources, Response response) {
        if (roomSimSources == null || roomSimSources.getSources() == null) {
            return APIResponse.badRequest(response, "No sources in request");
        }
        List<String> list = roomSimSources.getSources();
        ArrayList<SpeakerID> arrayList = new ArrayList<SpeakerID>();
        for (String string : list) {
            SpeakerID speakerID = SpeakerID.getFromApiName(string);
            if (speakerID == null) {
                ValidValues validValues = ValidValues.builder().message(string + " is not a recognised source name").validValues(RoomSimService.getSourceNames()).build();
                return APIResponse.badRequest(response, validValues);
            }
            arrayList.add(speakerID);
        }
        if (arrayList.isEmpty()) {
            return APIResponse.badRequest(response, "No sources in request");
        }
        this.roomPanel.B(arrayList);
        return APIResponse.ok(response, "Sources updated");
    }

    public static List<String> getSourceNames() {
        if (sourceNames == null) {
            sourceNames = new ArrayList<String>();
            for (SpeakerID speakerID : SpeakerID.values()) {
                sourceNames.add(speakerID.apiName());
            }
        }
        return sourceNames;
    }

    public RoomPosition getHeadPosition(LengthUnit lengthUnit) {
        return this.roomPanel.B(lengthUnit);
    }

    public APIResponse setHeadPosition(RoomPosition roomPosition, Response response) {
        if (roomPosition == null) {
            return APIResponse.badRequest(response, "No position in request");
        }
        LengthUnit lengthUnit = RoomSimService.getDefaultLengthUnit();
        if (roomPosition.getUnit() != null && (lengthUnit = LengthUnit.getFromApiName(roomPosition.getUnit())) == null) {
            return APIResponse.badRequest(response, roomPosition.getUnit() + " is not a valid unit");
        }
        this.roomPanel.A(roomPosition, lengthUnit);
        return APIResponse.ok(response, "Head position updated");
    }

    public RoomPosition getSourcePosition(SpeakerID speakerID, LengthUnit lengthUnit) {
        return this.roomPanel.A(speakerID, lengthUnit);
    }

    public APIResponse setSourcePosition(RoomPosition roomPosition, Response response, SpeakerID speakerID) {
        if (roomPosition == null) {
            return APIResponse.badRequest(response, "No position in request");
        }
        LengthUnit lengthUnit = RoomSimService.getDefaultLengthUnit();
        if (roomPosition.getUnit() != null && (lengthUnit = LengthUnit.getFromApiName(roomPosition.getUnit())) == null) {
            return APIResponse.badRequest(response, roomPosition.getUnit() + " is not a valid unit");
        }
        this.roomPanel.A(speakerID, roomPosition, lengthUnit);
        return APIResponse.ok(response, "Source position updated");
    }

    public SourceConfiguration getSourceConfiguration(SpeakerID speakerID) {
        return this.roomPanel.A(speakerID);
    }

    public APIResponse setSourceConfiguration(SourceConfiguration sourceConfiguration, Response response, SpeakerID speakerID) {
        if (sourceConfiguration == null) {
            return APIResponse.badRequest(response, "No configuration in request");
        }
        if (sourceConfiguration.getEnclosureType() != null && UC.A(sourceConfiguration.getEnclosureType()) == null) {
            ValidValues validValues = ValidValues.builder().message(sourceConfiguration.getEnclosureType() + " is not a recognised enclosure type").validValues(RoomSimService.getEnclosureTypes()).build();
            return APIResponse.badRequest(response, validValues);
        }
        this.roomPanel.A(speakerID, sourceConfiguration);
        return APIResponse.ok(response, "Source configuration updated");
    }

    public static List<String> getEnclosureTypes() {
        if (enclosureTypes == null) {
            enclosureTypes = new ArrayList<String>();
            for (UC uC2 : UC.values()) {
                enclosureTypes.add(uC2.B());
            }
        }
        return enclosureTypes;
    }

    public RoomSimOptions getOptions() {
        return RoomSimOptions.builder().showAnechoicResponses(this.roomPanel.\u0154()).timeAlignSpeakersAndSubs(lG.\u01e0()).alignSubsIndividually(lG.C()).subsHaveSameDelay(lG.\u03ae()).subsDelayms(lG.\u03ae() ? lG.A(SpeakerID.SUB1.getLabel(), 0) : 0).useCrossoverFilter(lG.\u03a6()).crossoverFrequencyHz(lG.\u02a0()).build();
    }

    public APIResponse setOptions(RoomSimOptions roomSimOptions, Response response) {
        if (roomSimOptions == null) {
            return APIResponse.badRequest(response, "No options in request");
        }
        boolean bl = false;
        if (roomSimOptions.getShowAnechoicResponses() != null) {
            this.roomPanel.Z(roomSimOptions.getShowAnechoicResponses());
            bl = true;
        }
        if (roomSimOptions.getTimeAlignSpeakersAndSubs() != null) {
            lG.c(roomSimOptions.getTimeAlignSpeakersAndSubs());
            bl = true;
        }
        if (roomSimOptions.getAlignSubsIndividually() != null) {
            lG.L(roomSimOptions.getAlignSubsIndividually());
            bl = true;
        }
        if (roomSimOptions.getSubsHaveSameDelay() != null) {
            lG.\u00a4(roomSimOptions.getSubsHaveSameDelay());
            bl = true;
        }
        if (roomSimOptions.getSubsDelayms() != null) {
            this.roomPanel.N(roomSimOptions.getSubsDelayms());
            bl = true;
        }
        if (roomSimOptions.getUseCrossoverFilter() != null) {
            lG.X(roomSimOptions.getUseCrossoverFilter());
            bl = true;
        }
        if (roomSimOptions.getCrossoverFrequencyHz() != null) {
            this.roomPanel.L(roomSimOptions.getCrossoverFrequencyHz());
            bl = true;
        }
        if (!bl) {
            return APIResponse.badRequest(response, "Nothing to update in the request");
        }
        return APIResponse.ok(response, "Options updated");
    }

    public static List<String> getMicPositions() {
        if (micPositions == null) {
            micPositions = new ArrayList<String>();
            for (TD tD2 : TD.values()) {
                micPositions.add(tD2.E());
            }
        }
        return micPositions;
    }

    public static boolean hasMicPosition(String string) {
        for (String string2 : RoomSimService.getMicPositions()) {
            if (!string2.equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    public FrequencyResponse getFrequencyResponse(Request request, Response response, SpeakerID speakerID) {
        String string = request.queryParams(RoomSimService.getMicPosnKey());
        TD tD2 = TD.A(string);
        response.header("Content-Encoding", "gzip");
        FrequencyResponse frequencyResponse = this.roomPanel.A(speakerID, tD2);
        return frequencyResponse;
    }
}

