/*
 * Decompiled with CFR 0.152.
 */
package roomeqwizard.api;

import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import roomeqwizard.$B;
import roomeqwizard.CEALimit;
import roomeqwizard.DistortionUnit;
import roomeqwizard.HF;
import roomeqwizard.HL;
import roomeqwizard.NoiseCurve;
import roomeqwizard.RoomEQ_Wizard;
import roomeqwizard.VF;
import roomeqwizard.Window;
import roomeqwizard.ZK;
import roomeqwizard.api.APIResponse;
import roomeqwizard.api.Publisher;
import roomeqwizard.api.model.Command;
import roomeqwizard.api.model.FrequencyResponse;
import roomeqwizard.api.model.RTAAppearanceConfiguration;
import roomeqwizard.api.model.RTACommand;
import roomeqwizard.api.model.RTAConfiguration;
import roomeqwizard.api.model.RTADistortion;
import roomeqwizard.api.model.RTADistortionConfiguration;
import roomeqwizard.api.model.RTALevel;
import roomeqwizard.api.model.RTAStatus;
import roomeqwizard.api.model.Subscriber;
import roomeqwizard.api.model.SubscriptionType;
import roomeqwizard.api.model.ValidValues;
import roomeqwizard.kJ;
import roomeqwizard.lG;
import roomeqwizard.sE;
import spark.Request;
import spark.Response;

public class RTAService
extends Publisher {
    private static final String AXIS_UNIT_KEY = "unit";
    private static final String DIST_UNIT_KEY = "distortion";
    private static final String INDEX_KEY = "index";
    private static List<String> modes;
    private static List<String> commands;
    private static List<String> rtaLengths;
    private static List<String> smoothingChoices;
    private static List<String> windowChoices;
    private static List<String> overlapChoices;
    private static List<String> averagingChoices;
    private static List<String> units;
    private static List<String> distortionUnits;
    private static List<Integer> updateIntervals;
    private static List<Integer> peakHolds;
    private static List<Integer> peakDecayRates;
    private static List<String> noiseCurveChoices;
    private static List<String> ceaLimitChoices;
    private HL rtaFrame;

    public static String getAXIS_UNIT_KEY() {
        return AXIS_UNIT_KEY;
    }

    public static String getDIST_UNIT_KEY() {
        return DIST_UNIT_KEY;
    }

    public static String getINDEX_KEY() {
        return INDEX_KEY;
    }

    public RTAService() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                RTAService.this.rtaFrame = HL.F();
            }
        });
    }

    @Override
    public void addSubscriptionToSource(SubscriptionType subscriptionType) {
        sE.\u0142().A(subscriptionType, this);
    }

    @Override
    public void removeSubscriptionFromSource(SubscriptionType subscriptionType) {
        sE.\u0142().B(subscriptionType, this);
    }

    private ValidValues checkAxisUnit(Map<String, String> map) {
        $B $B;
        if (map != null && map.containsKey(AXIS_UNIT_KEY) && ($B = $B.B(map.get(AXIS_UNIT_KEY))) == null) {
            ValidValues validValues = ValidValues.builder().message(map.get(AXIS_UNIT_KEY) + " is not a recognised axis unit").validValues(RTAService.getUnits()).build();
            return validValues;
        }
        return null;
    }

    private ValidValues checkIndex(Map<String, String> map) {
        if (map != null && map.containsKey(INDEX_KEY)) {
            try {
                int n2;
                Integer n3 = Integer.valueOf(map.get(INDEX_KEY));
                int n4 = n2 = RoomEQ_Wizard._ != null ? RoomEQ_Wizard._.R() : 1;
                if (n2 < 2) {
                    return ValidValues.builder().message("index is only valid when multiple inputs are being captured").validValues(Collections.EMPTY_LIST).build();
                }
                if (n3 < 1 || n3 > n2) {
                    return ValidValues.builder().message(map.get(INDEX_KEY) + " is not valid, the valid range is from 1 to " + n2).validValues(Collections.EMPTY_LIST).build();
                }
            }
            catch (NumberFormatException numberFormatException) {
                return ValidValues.builder().message(map.get(INDEX_KEY) + " is not a valid index").validValues(Collections.EMPTY_LIST).build();
            }
        }
        return null;
    }

    private ValidValues checkDistortionUnit(Map<String, String> map) {
        DistortionUnit distortionUnit;
        if (map != null && map.containsKey(DIST_UNIT_KEY) && (distortionUnit = DistortionUnit.getFromApiName(map.get(DIST_UNIT_KEY))) == null) {
            ValidValues validValues = ValidValues.builder().message(map.get(DIST_UNIT_KEY) + " is not a recognised distortion unit").validValues(RTAService.getDistortionUnits()).build();
            return validValues;
        }
        return null;
    }

    @Override
    public ValidValues checkSubscriptionParameters(SubscriptionType subscriptionType, Subscriber subscriber) {
        switch (subscriptionType) {
            case RTA_CURRENT: 
            case RTA_PEAK: {
                ValidValues validValues = this.checkAxisUnit(subscriber.getParameters());
                if (validValues != null) {
                    return validValues;
                }
                validValues = this.checkIndex(subscriber.getParameters());
                return validValues;
            }
            case RTA_LEVEL: {
                ValidValues validValues = this.checkAxisUnit(subscriber.getParameters());
                return validValues;
            }
            case RTA_DISTORTION: {
                ValidValues validValues = this.checkAxisUnit(subscriber.getParameters());
                if (validValues != null) {
                    return validValues;
                }
                validValues = this.checkDistortionUnit(subscriber.getParameters());
                return validValues;
            }
            case RTA_STATUS: {
                return null;
            }
        }
        assert (false) : "Unhandled enum type " + (Object)((Object)subscriptionType);
        return null;
    }

    public static boolean isEnabled() {
        return HF.O();
    }

    public static List<Integer> getUpdateIntervals() {
        if (updateIntervals == null) {
            updateIntervals = Arrays.asList(sE.\u014b());
        }
        return updateIntervals;
    }

    public static List<Integer> getPeakHolds() {
        if (peakHolds == null) {
            peakHolds = Arrays.asList(sE.\u0141());
        }
        return peakHolds;
    }

    public static List<Integer> getPeakDecays() {
        if (peakDecayRates == null) {
            peakDecayRates = Arrays.asList(sE.\u013f());
        }
        return peakDecayRates;
    }

    public static List<String> getCommands() {
        if (commands == null) {
            commands = new ArrayList<String>();
            for (RTACommand rTACommand : RTACommand.values()) {
                commands.add(rTACommand.commandName());
            }
        }
        return commands;
    }

    public static List<String> getSmoothingChoices() {
        if (smoothingChoices == null) {
            smoothingChoices = new ArrayList<String>();
            for (kJ kJ2 : kJ.values()) {
                smoothingChoices.add(kJ2.A());
            }
        }
        return smoothingChoices;
    }

    public static List<String> getRTALengths() {
        if (rtaLengths == null) {
            rtaLengths = new ArrayList<String>();
            for (ZK zK2 : ZK.values()) {
                rtaLengths.add(zK2.A());
            }
        }
        return rtaLengths;
    }

    public static List<String> getWindowChoices() {
        if (windowChoices == null) {
            windowChoices = new ArrayList<String>();
            List<Window.Types> list = Arrays.asList(sE.\u0140());
            for (Window.Types types : list) {
                windowChoices.add(types.apiName());
            }
        }
        return windowChoices;
    }

    public static List<String> getModes() {
        if (modes == null) {
            modes = Arrays.asList(sE.\u0156());
        }
        return modes;
    }

    public static List<String> getAveragingChoices() {
        if (averagingChoices == null) {
            averagingChoices = Arrays.asList(sE.\u014a());
        }
        return averagingChoices;
    }

    public static List<String> getOverlapChoices() {
        if (overlapChoices == null) {
            overlapChoices = Arrays.asList(sE.\u0144());
        }
        return overlapChoices;
    }

    public static List<String> getUnits() {
        if (units == null) {
            $B[] $BArray;
            units = new ArrayList<String>();
            for ($B $B : $BArray = sE.\u014f()) {
                units.add($B.C());
            }
        }
        return units;
    }

    public static List<String> getDistortionUnits() {
        if (distortionUnits == null) {
            distortionUnits = new ArrayList<String>();
            for (DistortionUnit distortionUnit : DistortionUnit.values()) {
                distortionUnits.add(distortionUnit.apiName());
            }
        }
        return distortionUnits;
    }

    public static List<String> getNoiseCurves() {
        if (noiseCurveChoices == null) {
            noiseCurveChoices = new ArrayList<String>();
            for (NoiseCurve noiseCurve : NoiseCurve.values()) {
                noiseCurveChoices.add(noiseCurve.apiName());
            }
        }
        return noiseCurveChoices;
    }

    public static List<String> getCEALimits() {
        if (ceaLimitChoices == null) {
            ceaLimitChoices = new ArrayList<String>();
            for (CEALimit cEALimit : CEALimit.values()) {
                ceaLimitChoices.add(cEALimit.apiName());
            }
        }
        return ceaLimitChoices;
    }

    public RTAStatus getStatus() {
        return RTAStatus.builder().enabled(HF.O()).running(VF.\u01c5()).build();
    }

    public FrequencyResponse getRTAData(Request request, Response response) {
        FrequencyResponse frequencyResponse;
        response.header("Content-Encoding", "gzip");
        String string = request.queryParamOrDefault(AXIS_UNIT_KEY, sE.\u013e().C());
        $B $B = $B.B(string);
        String string2 = null;
        if ($B == null) {
            $B = sE.\u013e();
            string2 = string + " is not a recognised axis unit, returning " + sE.\u013e().C() + " data";
        }
        int n2 = 0;
        if (request.queryParams().contains(INDEX_KEY)) {
            int n3 = RoomEQ_Wizard._ != null ? RoomEQ_Wizard._.R() : 1;
            String string3 = "";
            if (n3 < 2) {
                string3 = "Input index is only a valid parameter when capturing multiple inupts";
            } else {
                String string4 = request.queryParams(INDEX_KEY);
                try {
                    n2 = Integer.parseInt(string4);
                    if (n2 < 1 || n2 > n3) {
                        string3 = string4 + " is not valid, the valid range is from 1 to " + n3;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    string3 = string4 + " is not a valid index value, the valid range is from 1 to " + n3;
                }
            }
            if (!string3.isEmpty()) {
                string2 = string2 != null ? string2 + string3 : string3;
                return FrequencyResponse.builder().message(string2).build();
            }
        }
        if ((frequencyResponse = sE.\u0142().B($B, n2)) != null) {
            if (string2 != null) {
                frequencyResponse.setMessage(string2);
            }
            return frequencyResponse;
        }
        return FrequencyResponse.builder().message("There is no data").build();
    }

    public FrequencyResponse getRTAPeakData(Request request, Response response) {
        FrequencyResponse frequencyResponse;
        response.header("Content-Encoding", "gzip");
        String string = request.queryParamOrDefault(AXIS_UNIT_KEY, sE.\u013e().C());
        $B $B = $B.B(string);
        String string2 = null;
        if ($B == null) {
            $B = sE.\u013e();
            string2 = string + " is not a recognised axis unit, returning " + sE.\u013e().C() + " data";
        }
        int n2 = 0;
        if (request.queryParams().contains(INDEX_KEY)) {
            int n3 = RoomEQ_Wizard._ != null ? RoomEQ_Wizard._.R() : 1;
            String string3 = "";
            if (n3 < 2) {
                string3 = "Input index is only a valid parameter when capturing multiple inupts";
            } else {
                String string4 = request.queryParams(INDEX_KEY);
                try {
                    n2 = Integer.parseInt(string4);
                    if (n2 < 1 || n2 > n3) {
                        string3 = string4 + " is not valid, the valid range is from 1 to " + n3;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    string3 = string4 + " is not a valid index value, the valid range is from 1 to " + n3;
                }
            }
            if (!string3.isEmpty()) {
                string2 = string2 != null ? string2 + string3 : string3;
                return FrequencyResponse.builder().message(string2).build();
            }
        }
        if ((frequencyResponse = sE.\u0142().A($B, n2)) != null) {
            if (string2 != null) {
                frequencyResponse.setMessage(string2);
            }
            return frequencyResponse;
        }
        return FrequencyResponse.builder().message("There is no data").build();
    }

    public RTAConfiguration getConfiguration() {
        VF vF2 = this.rtaFrame.C();
        return RTAConfiguration.builder().mode(sE.\u0156()[lG.\u02bb()]).fftLength(ZK.B(lG.\u02c0()).A()).window(lG.e().toString()).averaging(lG.\u03a0()).stopAt(lG.h()).stopAtValue(lG.Z()).maximumOverlap(lG.\u03b5()).smoothing(kJ.B(vF2.\u01b9()).A()).restartCaptureOnGeneratorChange(lG.\u0197()).calcDistortionEnabled(lG.\u0160()).use64BitFFT(lG.\u01e6()).adjustRTALevels(lG.\u0157()).fundamentalFromSineGen(lG.Y()).build();
    }

    public APIResponse setConfiguration(final RTAConfiguration rTAConfiguration, Response response) {
        Object object;
        Object object2;
        boolean bl = false;
        final VF vF2 = this.rtaFrame.C();
        if (rTAConfiguration.getCalcDistortionEnabled() != null) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    vF2.f(rTAConfiguration.getCalcDistortionEnabled());
                }
            });
            bl = true;
        }
        if (rTAConfiguration.getRestartCaptureOnGeneratorChange() != null) {
            lG.o(rTAConfiguration.getRestartCaptureOnGeneratorChange());
            bl = true;
        }
        if (rTAConfiguration.getFundamentalFromSineGen() != null) {
            lG.n(rTAConfiguration.getFundamentalFromSineGen());
            bl = true;
        }
        if (rTAConfiguration.getUse64BitFFT() != null) {
            lG.x(rTAConfiguration.getUse64BitFFT());
            bl = true;
        }
        if (rTAConfiguration.getAdjustRTALevels() != null) {
            lG.Z(rTAConfiguration.getAdjustRTALevels());
            bl = true;
        }
        if (rTAConfiguration.getMode() != null) {
            int n2;
            object2 = sE.\u0156();
            object = null;
            int n3 = 0;
            for (n2 = 0; n2 < ((String[])object2).length; ++n2) {
                String string = object2[n2];
                if (!string.equalsIgnoreCase(rTAConfiguration.getMode())) continue;
                object = string;
                n3 = n2;
                break;
            }
            if (object == null) {
                ValidValues validValues = ValidValues.builder().message(rTAConfiguration.getMode() + " is not a recognised RTA mode").validValues(RTAService.getModes()).build();
                return APIResponse.badRequest(response, validValues);
            }
            n2 = n3;
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    sE.\u0142().a(n2);
                }
            });
            bl = true;
        }
        if (rTAConfiguration.getFftLength() != null) {
            object2 = ZK.A(rTAConfiguration.getFftLength());
            if (object2 == null) {
                object = ValidValues.builder().message(rTAConfiguration.getFftLength() + " is not a valid FFT length").validValues(RTAService.getRTALengths()).build();
                return APIResponse.badRequest(response, (ValidValues)object);
            }
            EventQueue.invokeLater(new Runnable((ZK)((Object)object2)){
                final /* synthetic */ ZK val$len;
                {
                    this.val$len = zK2;
                }

                @Override
                public void run() {
                    sE.\u0142().A(this.val$len);
                }
            });
            bl = true;
        }
        if (rTAConfiguration.getSmoothing() != null) {
            object2 = kJ.A(rTAConfiguration.getSmoothing());
            if (object2 == null) {
                object = ValidValues.builder().message(rTAConfiguration.getSmoothing() + " is not a recognised smoothing option").validValues(RTAService.getSmoothingChoices()).build();
                return APIResponse.badRequest(response, (ValidValues)object);
            }
            EventQueue.invokeLater(new Runnable((kJ)((Object)object2)){
                final /* synthetic */ kJ val$smoothing;
                {
                    this.val$smoothing = kJ2;
                }

                @Override
                public void run() {
                    sE.\u0142().A(this.val$smoothing);
                }
            });
            bl = true;
        }
        if (rTAConfiguration.getAveraging() != null) {
            object2 = null;
            for (String string : RTAService.getAveragingChoices()) {
                if (!string.equalsIgnoreCase(rTAConfiguration.getAveraging())) continue;
                object2 = string;
                break;
            }
            if (object2 == null) {
                object = ValidValues.builder().message(rTAConfiguration.getAveraging() + " is not a recognised RTA averaging option").validValues(RTAService.getAveragingChoices()).build();
                return APIResponse.badRequest(response, (ValidValues)object);
            }
            object = object2;
            EventQueue.invokeLater(new Runnable((String)object){
                final /* synthetic */ String val$theAverage;
                {
                    this.val$theAverage = string;
                }

                @Override
                public void run() {
                    sE.\u0142().E(this.val$theAverage);
                }
            });
            bl = true;
        }
        if (rTAConfiguration.getStopAt() != null) {
            lG.\u00d1(rTAConfiguration.getStopAt());
        }
        if (rTAConfiguration.getStopAtValue() != null) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    sE.\u0142().Y(rTAConfiguration.getStopAtValue());
                }
            });
        }
        if (rTAConfiguration.getMaximumOverlap() != null) {
            object2 = null;
            for (String string : RTAService.getOverlapChoices()) {
                if (!string.equalsIgnoreCase(rTAConfiguration.getMaximumOverlap())) continue;
                object2 = string;
                break;
            }
            if (object2 == null) {
                object = ValidValues.builder().message(rTAConfiguration.getMaximumOverlap() + " is not a recognised maximum overlap option").validValues(RTAService.getOverlapChoices()).build();
                return APIResponse.badRequest(response, (ValidValues)object);
            }
            object = object2;
            EventQueue.invokeLater(new Runnable((String)object){
                final /* synthetic */ String val$theOverlap;
                {
                    this.val$theOverlap = string;
                }

                @Override
                public void run() {
                    sE.\u0142().F(this.val$theOverlap);
                }
            });
            bl = true;
        }
        if (rTAConfiguration.getWindow() != null) {
            object2 = Window.Types.getTypeFromDescription(rTAConfiguration.getWindow());
            object = Arrays.asList(sE.\u0140());
            if (object2 == null) {
                ValidValues validValues = ValidValues.builder().message(rTAConfiguration.getWindow() + " is not a recognised window type").validValues(RTAService.getWindowChoices()).build();
                return APIResponse.badRequest(response, validValues);
            }
            if (!object.contains(object2)) {
                ValidValues validValues = ValidValues.builder().message(rTAConfiguration.getWindow() + " is not a window type the RTA accepts").validValues(RTAService.getWindowChoices()).build();
                return APIResponse.badRequest(response, validValues);
            }
            EventQueue.invokeLater(new Runnable((Window.Types)((Object)object2)){
                final /* synthetic */ Window.Types val$windowType;
                {
                    this.val$windowType = types;
                }

                @Override
                public void run() {
                    sE.\u0142().B(this.val$windowType);
                }
            });
            bl = true;
        }
        if (!bl) {
            return APIResponse.badRequest(response, "No configuration entries in the request");
        }
        return APIResponse.ok(response, "Configuration processed");
    }

    public RTADistortionConfiguration getRTADistortionConfiguration() {
        return RTADistortionConfiguration.builder().lowPass(lG.\u01f3()).highPass(lG.\u01ae()).enableLowPass(lG.\u01fa()).enableHighPass(lG.H()).useManualFundamental(lG.\u037a()).manualFundamentalVrms(lG.\u0112()).useAES17StandardNotch(lG.\u03a5()).showHarmonicPhase(lG.\u025e()).highlightFundamental(lG.\u0203()).distortionUnit(lG.\u03c9().apiName()).useCoherentAveraging(lG.\u00e1()).monitorClockRateMatch(lG.\u01fc()).build();
    }

    public APIResponse setDistortionConfiguration(RTADistortionConfiguration rTADistortionConfiguration, Response response) {
        boolean bl = false;
        if (rTADistortionConfiguration.getLowPass() != null) {
            lG.\u0125(rTADistortionConfiguration.getLowPass());
            bl = true;
        }
        if (rTADistortionConfiguration.getEnableLowPass() != null) {
            lG.\u00d8(rTADistortionConfiguration.getEnableLowPass());
            bl = true;
        }
        if (rTADistortionConfiguration.getHighPass() != null) {
            lG.\u00f2(rTADistortionConfiguration.getHighPass());
            bl = true;
        }
        if (rTADistortionConfiguration.getEnableHighPass() != null) {
            lG.r(rTADistortionConfiguration.getEnableHighPass());
            bl = true;
        }
        if (rTADistortionConfiguration.getUseManualFundamental() != null) {
            lG.\u00e9(rTADistortionConfiguration.getUseManualFundamental());
            bl = true;
        }
        if (rTADistortionConfiguration.getUseAES17StandardNotch() != null) {
            lG.t(rTADistortionConfiguration.getUseAES17StandardNotch());
            bl = true;
        }
        if (rTADistortionConfiguration.getShowHarmonicPhase() != null) {
            lG.k(rTADistortionConfiguration.getShowHarmonicPhase());
            bl = true;
        }
        if (rTADistortionConfiguration.getHighlightFundamental() != null) {
            lG.\u00cd(rTADistortionConfiguration.getHighlightFundamental());
            bl = true;
        }
        if (rTADistortionConfiguration.getUseCoherentAveraging() != null) {
            lG.\u00a5(rTADistortionConfiguration.getUseCoherentAveraging());
            bl = true;
        }
        if (rTADistortionConfiguration.getMonitorClockRateMatch() != null) {
            lG.\u00b5(rTADistortionConfiguration.getMonitorClockRateMatch());
            bl = true;
        }
        if (rTADistortionConfiguration.getDistortionUnit() != null) {
            final DistortionUnit distortionUnit = DistortionUnit.getFromApiName(rTADistortionConfiguration.getDistortionUnit());
            if (distortionUnit == null) {
                ValidValues validValues = ValidValues.builder().message(rTADistortionConfiguration.getDistortionUnit() + " is not a recognised distortion unit").validValues(RTAService.getDistortionUnits()).build();
                return APIResponse.badRequest(response, validValues);
            }
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    sE.\u0142().A(distortionUnit);
                }
            });
            bl = true;
        }
        if (!bl) {
            return APIResponse.badRequest(response, "No configuration entries in the request");
        }
        return APIResponse.ok(response, "Configuration processed");
    }

    public RTAAppearanceConfiguration getRTAAppearanceConfiguration() {
        return RTAAppearanceConfiguration.builder().updateInterval(lG.\u012c()).peakHoldSeconds(lG.\u020f()).peakDecaydBPerSecond(lG.\u0285()).showNoiseCurves(lG.\u0264()).noiseCurveType(lG.\u0250().apiName()).dBWRefResistance((double)Math.round(1024.0 * Math.pow(10.0, lG.\u012b() / 10.0)) / 1024.0).ceaMaxSPLLimitType(lG.\u01ab().apiName()).useBarsOnRTA(lG.\u0417()).useBarsOnSpectrum(lG.n()).showPeakSPLForToneBursts(lG.\u0276()).build();
    }

    public APIResponse setAppearanceConfiguration(final RTAAppearanceConfiguration rTAAppearanceConfiguration, Response response) {
        int n2;
        boolean bl = false;
        if (rTAAppearanceConfiguration.getUpdateInterval() != null) {
            n2 = rTAAppearanceConfiguration.getUpdateInterval();
            if (!RTAService.getUpdateIntervals().contains(n2)) {
                ValidValues validValues = ValidValues.builder().message(n2 + " is not a recognised update interval").validValues(RTAService.getUpdateIntervals()).build();
                return APIResponse.badRequest(response, validValues);
            }
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    sE.\u0142().b(n2);
                }
            });
            bl = true;
        }
        if (rTAAppearanceConfiguration.getPeakHoldSeconds() != null) {
            n2 = rTAAppearanceConfiguration.getPeakHoldSeconds();
            if (!RTAService.getPeakHolds().contains(n2)) {
                ValidValues validValues = ValidValues.builder().message(n2 + " is not a recognised peak hold time").validValues(RTAService.getPeakHolds()).build();
                return APIResponse.badRequest(response, validValues);
            }
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    sE.\u0142().T(n2);
                }
            });
            bl = true;
        }
        if (rTAAppearanceConfiguration.getPeakDecaydBPerSecond() != null) {
            n2 = rTAAppearanceConfiguration.getPeakDecaydBPerSecond();
            if (!RTAService.getPeakDecays().contains(n2)) {
                ValidValues validValues = ValidValues.builder().message(n2 + " is not a recognised peak decay rate").validValues(RTAService.getPeakDecays()).build();
                return APIResponse.badRequest(response, validValues);
            }
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    sE.\u0142()._(n2);
                }
            });
            bl = true;
        }
        if (rTAAppearanceConfiguration.getShowNoiseCurves() != null) {
            lG.\u00c4(rTAAppearanceConfiguration.getShowNoiseCurves());
            bl = true;
        }
        if (rTAAppearanceConfiguration.getNoiseCurveType() != null) {
            final NoiseCurve noiseCurve = NoiseCurve.getFromApiName(rTAAppearanceConfiguration.getNoiseCurveType());
            if (noiseCurve == null) {
                ValidValues validValues = ValidValues.builder().message(rTAAppearanceConfiguration.getNoiseCurveType() + " is not a recognised noise curve type").validValues(RTAService.getNoiseCurves()).build();
                return APIResponse.badRequest(response, validValues);
            }
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    sE.\u0142().A(noiseCurve);
                }
            });
            bl = true;
        }
        if (rTAAppearanceConfiguration.getDBWRefResistance() != null) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    sE.\u0142().G(rTAAppearanceConfiguration.getDBWRefResistance());
                }
            });
            bl = true;
        }
        if (rTAAppearanceConfiguration.getCeaMaxSPLLimitType() != null) {
            final CEALimit cEALimit = CEALimit.getFromApiName(rTAAppearanceConfiguration.getCeaMaxSPLLimitType());
            if (cEALimit == null) {
                ValidValues validValues = ValidValues.builder().message(rTAAppearanceConfiguration.getCeaMaxSPLLimitType() + " is not a recognised CEA max SPL limit choise").validValues(RTAService.getCEALimits()).build();
                return APIResponse.badRequest(response, validValues);
            }
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    sE.\u0142().A(cEALimit);
                }
            });
            bl = true;
        }
        if (rTAAppearanceConfiguration.getUseBarsOnRTA() != null) {
            lG.l(rTAAppearanceConfiguration.getUseBarsOnRTA());
            bl = true;
        }
        if (rTAAppearanceConfiguration.getUseBarsOnSpectrum() != null) {
            lG.R(rTAAppearanceConfiguration.getUseBarsOnSpectrum());
            bl = true;
        }
        if (rTAAppearanceConfiguration.getShowPeakSPLForToneBursts() != null) {
            lG.\u00c7(rTAAppearanceConfiguration.getShowPeakSPLForToneBursts());
            bl = true;
        }
        if (!bl) {
            return APIResponse.badRequest(response, "No configuration entries in the request");
        }
        return APIResponse.ok(response, "Configuration processed");
    }

    public List<RTALevel> getRTALevels(Request request, Response response) {
        String string = request.queryParamOrDefault(AXIS_UNIT_KEY, sE.\u013e().C());
        $B $B = $B.B(string);
        String string2 = null;
        if ($B == null) {
            $B = sE.\u013e();
            string2 = string + " is not a recognised axis unit, returning " + sE.\u013e().C() + " data";
        }
        return Arrays.asList(sE.\u0142().A($B, string2));
    }

    public List<RTADistortion> getRTADistortion(Request request, Response response) {
        String string;
        DistortionUnit distortionUnit;
        String string2 = request.queryParamOrDefault(AXIS_UNIT_KEY, sE.\u013e().C());
        $B $B = $B.B(string2);
        String string3 = null;
        if ($B == null) {
            $B = sE.\u013e();
            string3 = string2 + " is not a recognised axis unit, returning " + sE.\u013e().C() + " data";
        }
        if ((distortionUnit = DistortionUnit.getFromApiName(string = request.queryParamOrDefault(DIST_UNIT_KEY, sE.\u0154().apiName()))) == null) {
            distortionUnit = sE.\u0154();
            String string4 = string + " is not a recognised distortion unit, returning " + sE.\u0154().apiName() + " data";
            string3 = string3 == null ? string4 : string3 + ". " + string4;
        }
        return Arrays.asList(sE.A(sE.\u0142().\u014e(), $B, distortionUnit, string3));
    }

    public APIResponse runCommand(Command command, Response response) {
        if (command.getCommand() == null) {
            return APIResponse.badRequest(response, "No command in the request");
        }
        String string = command.getCommand();
        RTACommand rTACommand = RTACommand.getFromCommandName(string);
        if (rTACommand == null) {
            ValidValues validValues = ValidValues.builder().message(string + " is not a recognised command").validValues(RTAService.getCommands()).build();
            return APIResponse.badRequest(response, validValues);
        }
        final VF vF2 = this.rtaFrame.C();
        switch (rTACommand) {
            case START: {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        vF2.\u01c3();
                    }
                });
                return APIResponse.accepted(response, "Starting RTA");
            }
            case STOP: {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        VF.\u01b8();
                    }
                });
                return APIResponse.accepted(response, "Stopping RTA");
            }
            case RESET_AVG: {
                vF2.\u01be();
                return APIResponse.accepted(response, "Averaging reset");
            }
            case SAVE_CURRENT: {
                if (!vF2.\u01b7()) {
                    return APIResponse.badRequest(response, "Nothing to save");
                }
                return APIResponse.ok(response, "Current RTA data saved as a new measurement");
            }
            case SAVE_PEAK: {
                if (!vF2.\u01c2()) {
                    return APIResponse.badRequest(response, "Nothing to save");
                }
                return APIResponse.ok(response, "Peak RTA data saved as a new measurement");
            }
            case SAVE_BOTH: {
                if (!vF2.\u01b4()) {
                    return APIResponse.badRequest(response, "Nothing to save");
                }
                return APIResponse.ok(response, "Current and peak RTA data saved as a new measurements");
            }
        }
        assert (false) : "Unhandled enum type";
        return APIResponse.notImplemented(response, string + " is not implemented yet");
    }
}

