/*
 * Decompiled with CFR 0.152.
 */
package roomeqwizard.api;

import com.google.gson.Gson;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import roomeqwizard.RoomEQ_Wizard;
import roomeqwizard.api.APIResponse;
import roomeqwizard.api.model.ErrorMessage;
import roomeqwizard.api.model.Subscriber;
import roomeqwizard.api.model.SubscriptionType;
import roomeqwizard.api.model.ValidValues;
import spark.Response;

public abstract class Publisher {
    private EnumMap<SubscriptionType, ArrayList<Subscriber>> subscriberMap = new EnumMap(SubscriptionType.class);
    private EnumMap<SubscriptionType, Map<String, String>> subscriptionParameters = new EnumMap(SubscriptionType.class);

    private static void removeUrlFromList(ArrayList<Subscriber> arrayList, Subscriber subscriber) {
        ArrayList<Subscriber> arrayList2 = new ArrayList<Subscriber>();
        for (Subscriber subscriber2 : arrayList) {
            if (!subscriber2.getUrl().equalsIgnoreCase(subscriber.getUrl())) continue;
            arrayList2.add(subscriber2);
        }
        for (Subscriber subscriber2 : arrayList2) {
            arrayList.remove(subscriber2);
        }
    }

    public APIResponse addSubscriber(Subscriber subscriber, SubscriptionType subscriptionType, Response response) {
        String string = subscriber.getUrl();
        if (string == null || string.isEmpty()) {
            return APIResponse.badRequest(response, "No URL in subscribe request");
        }
        try {
            URL uRL = new URL(URLDecoder.decode(subscriber.getUrl(), StandardCharsets.UTF_8.toString()));
            ValidValues validValues = this.checkSubscriptionParameters(subscriptionType, subscriber);
            if (validValues != null) {
                return APIResponse.badRequest(response, validValues);
            }
            this.addSubscriptionTypeAndSetParameters(subscriptionType, subscriber.getParameters());
            ArrayList<Subscriber> arrayList = this.subscriberMap.get((Object)subscriptionType);
            Publisher.removeUrlFromList(arrayList, subscriber);
            arrayList.add(subscriber);
            return APIResponse.ok(response, "Subscription added");
        }
        catch (UnsupportedEncodingException | MalformedURLException iOException) {
            return APIResponse.badRequest(response, string + " is not a properly formatted URL");
        }
    }

    public abstract ValidValues checkSubscriptionParameters(SubscriptionType var1, Subscriber var2);

    public APIResponse removeSubscriber(Subscriber subscriber, SubscriptionType subscriptionType, Response response) {
        String string = subscriber.getUrl();
        if (string == null || string.isEmpty()) {
            return APIResponse.badRequest(response, "No URL in unsubscribe request");
        }
        ArrayList<Subscriber> arrayList = this.subscriberMap.get((Object)subscriptionType);
        if (arrayList == null || !arrayList.contains(subscriber)) {
            return APIResponse.badRequest(response, "No subscription found ");
        }
        arrayList.remove(subscriber);
        if (arrayList.isEmpty()) {
            this.removeSubscriptionFromSource(subscriptionType);
        }
        return APIResponse.ok(response, "Subscription removed");
    }

    public void updateSubscribers(SubscriptionType subscriptionType, Object object) {
        List<Subscriber> list;
        if (this.subscriberMap.get((Object)subscriptionType) != null && !(list = Collections.synchronizedList((List)this.subscriberMap.get((Object)subscriptionType))).isEmpty()) {
            Gson gson = new Gson();
            String string = gson.toJson(object);
            ExecutorService executorService = Executors.newFixedThreadPool(list.size());
            ArrayList<Runnable> arrayList = new ArrayList<Runnable>();
            for (Subscriber object2 : list) {
                arrayList.add(Publisher.postToSubscriber(object2, string, list));
            }
            for (Runnable runnable : arrayList) {
                executorService.execute(runnable);
            }
            executorService.shutdown();
        }
    }

    public static void postToSubscriber(Subscriber subscriber, Object object) {
        Gson gson = new Gson();
        String string = gson.toJson(object);
        ExecutorService executorService = Executors.newFixedThreadPool(1);
        executorService.execute(Publisher.postToSubscriber(subscriber, string, null));
        executorService.shutdown();
    }

    private static Runnable postToSubscriber(final Subscriber subscriber, final String string, final List<Subscriber> list) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    URL uRL = new URL(URLDecoder.decode(subscriber.getUrl(), StandardCharsets.UTF_8.toString()));
                    HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
                    httpURLConnection.setRequestMethod("POST");
                    httpURLConnection.setRequestProperty("Content-Type", "application/json");
                    httpURLConnection.setRequestProperty("Accept", "*/*");
                    httpURLConnection.setDoOutput(true);
                    httpURLConnection.setReadTimeout(1000);
                    OutputStream outputStream = httpURLConnection.getOutputStream();
                    Object object = null;
                    try {
                        byte[] byArray = string.getBytes("utf-8");
                        outputStream.write(byArray, 0, byArray.length);
                        outputStream.flush();
                    }
                    catch (Throwable throwable) {
                        object = throwable;
                        throw throwable;
                    }
                    finally {
                        if (outputStream != null) {
                            if (object != null) {
                                try {
                                    outputStream.close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)object).addSuppressed(throwable);
                                }
                            } else {
                                outputStream.close();
                            }
                        }
                    }
                    int n2 = httpURLConnection.getResponseCode();
                    if (n2 < 200 || n2 > 299) {
                        if (list != null) {
                            list.remove(subscriber);
                        }
                        object = ErrorMessage.builder().time(RoomEQ_Wizard.\u00a2()).title("Subscription removed").message("Removed subscriber " + subscriber.getUrl() + " due to return code " + n2).build();
                        RoomEQ_Wizard.A((ErrorMessage)object);
                    }
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    if (list != null) {
                        list.remove(subscriber);
                    }
                    ErrorMessage errorMessage = ErrorMessage.builder().time(RoomEQ_Wizard.\u00a2()).title("Subscription removed").message("Removed subscriber " + subscriber.getUrl() + " due to timeout").build();
                    RoomEQ_Wizard.A(errorMessage);
                }
                catch (MalformedURLException malformedURLException) {
                    if (list != null) {
                        list.remove(subscriber);
                    }
                    ErrorMessage errorMessage = ErrorMessage.builder().time(RoomEQ_Wizard.\u00a2()).title("Subscription removed").message("Removed subscriber " + subscriber.getUrl() + " due to invalid URL").build();
                    RoomEQ_Wizard.A(errorMessage);
                }
                catch (IOException iOException) {
                    if (list != null) {
                        list.remove(subscriber);
                    }
                    ErrorMessage errorMessage = ErrorMessage.builder().time(RoomEQ_Wizard.\u00a2()).title("Subscription removed").message("Removed subscriber " + subscriber.getUrl() + " due to IO exception " + iOException).build();
                    RoomEQ_Wizard.A(errorMessage);
                }
            }
        };
        return runnable;
    }

    public void addSubscriptionTypeAndSetParameters(SubscriptionType subscriptionType, Map<String, String> map) {
        if (!this.subscriberMap.containsKey((Object)subscriptionType)) {
            this.subscriberMap.put(subscriptionType, new ArrayList());
            this.subscriptionParameters.put(subscriptionType, map);
            this.addSubscriptionToSource(subscriptionType);
        } else {
            this.subscriptionParameters.put(subscriptionType, map);
        }
    }

    public abstract void addSubscriptionToSource(SubscriptionType var1);

    public abstract void removeSubscriptionFromSource(SubscriptionType var1);

    public Map<String, String> getSubscriptionParameters(SubscriptionType subscriptionType) {
        return this.subscriptionParameters.get((Object)subscriptionType);
    }

    public List<Subscriber> getSubscribers(SubscriptionType subscriptionType) {
        ArrayList<Subscriber> arrayList = this.subscriberMap.get((Object)subscriptionType);
        return arrayList != null ? arrayList : Collections.emptyList();
    }
}

