/*
 * Decompiled with CFR 0.152.
 */
package roomeqwizard.api;

import java.awt.EventQueue;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.SwingWorker;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import roomeqwizard.$B;
import roomeqwizard.AK;
import roomeqwizard.BG;
import roomeqwizard.Equaliser;
import roomeqwizard.FB;
import roomeqwizard.FilterSet;
import roomeqwizard.GD;
import roomeqwizard.HE;
import roomeqwizard.HH;
import roomeqwizard.IRData;
import roomeqwizard.MeasData;
import roomeqwizard.MinPhaseTails;
import roomeqwizard.NI;
import roomeqwizard.NK;
import roomeqwizard.PB;
import roomeqwizard.PE;
import roomeqwizard.RoomEQ_Wizard;
import roomeqwizard.SD;
import roomeqwizard.SpectrogramAmplitude;
import roomeqwizard.SpectrogramMode;
import roomeqwizard.TG;
import roomeqwizard.Target;
import roomeqwizard.TargetShape;
import roomeqwizard.UJ;
import roomeqwizard.Window;
import roomeqwizard.WindowSettings;
import roomeqwizard.XE;
import roomeqwizard.XG;
import roomeqwizard.XOverChoice;
import roomeqwizard.XOverSlope;
import roomeqwizard.YF;
import roomeqwizard.YH;
import roomeqwizard.api.API;
import roomeqwizard.api.APIResponse;
import roomeqwizard.api.EQService;
import roomeqwizard.api.Publisher;
import roomeqwizard.api.model.Command;
import roomeqwizard.api.model.EQCommand;
import roomeqwizard.api.model.EqualiserEntry;
import roomeqwizard.api.model.FilterList;
import roomeqwizard.api.model.FilterSetting;
import roomeqwizard.api.model.FrequencyResponse;
import roomeqwizard.api.model.IRWindows;
import roomeqwizard.api.model.ImpulseResponse;
import roomeqwizard.api.model.MeasurementSummary;
import roomeqwizard.api.model.MeasurementsCommand;
import roomeqwizard.api.model.MeasurementsListChange;
import roomeqwizard.api.model.ProcessCommand;
import roomeqwizard.api.model.ProcessMeasurements;
import roomeqwizard.api.model.ProcessResult;
import roomeqwizard.api.model.ProcessSingleMeasurement;
import roomeqwizard.api.model.Result;
import roomeqwizard.api.model.RoomCurveSettings;
import roomeqwizard.api.model.SingleMeasurementCommand;
import roomeqwizard.api.model.Subscriber;
import roomeqwizard.api.model.SubscriptionType;
import roomeqwizard.api.model.TargetSettings;
import roomeqwizard.api.model.ValidValues;
import roomeqwizard.eG;
import roomeqwizard.g;
import roomeqwizard.gG;
import roomeqwizard.hA;
import roomeqwizard.iA;
import roomeqwizard.jA;
import roomeqwizard.kJ;
import roomeqwizard.lG;
import roomeqwizard.qG;
import roomeqwizard.tF;
import roomeqwizard.u;
import roomeqwizard.vC;
import roomeqwizard.wH;
import spark.Request;
import spark.Response;

public class MeasurementsService
extends Publisher
implements ListSelectionListener,
ListDataListener,
tF {
    private static final String AXIS_UNIT_KEY = "unit";
    private static final String WINDOWED_KEY = "windowed";
    private static final String NORMALISED_KEY = "normalised";
    private static final String SMOOTHING_KEY = "smoothing";
    private static final String PPO_KEY = "ppo";
    private static final String WINDOW_WIDTH_KEY = "window width ms";
    private static final String RANGE_KEY = "time range ms";
    private static final String RISETIME_KEY = "rise time ms";
    private static final String AS_CSD_KEY = "use csd mode";
    private static final String MODE_KEY = "mode";
    private static final String SLICES_KEY = "slices";
    private static final String BEFORE_KEY = "before ms";
    private static final String AFTER_KEY = "after ms";
    private static final String WINDOW_TYPE_KEY = "window type";
    private static final String LEFT_WINDOW_TYPE_KEY = "left window type";
    private static final String RIGHT_WINDOW_TYPE_KEY = "right window type";
    private static final String AMPLITUDE_KEY = "amplitude";
    private static final String BANDWIDTH_KEY = "bandwidth";
    private static final String SPAN_PERIODS_KEY = "periods";
    private static final String APPEND_LF_TAIL_KEY = "append lf tail";
    private static final String APPEND_HF_TAIL_KEY = "append hf tail";
    private static final String LF_TAIL_START_KEY = "lf tail start";
    private static final String HF_TAIL_START_KEY = "hf tail start";
    private static final String LF_TAIL_SLOPE_KEY = "lf tail slope";
    private static final String HF_TAIL_SLOPE_KEY = "hf tail slope";
    private static final String REPLICATE_DATA_KEY = "replicate data";
    private static final String WARP_FREQ_KEY = "frequency warping";
    private static final String INCLUDE_CAL_KEY = "include cal";
    private static final String UNIT_KEY = "unit";
    private static final String OFFSET_KEY = "offset";
    private static List<String> commands;
    private static List<String> windowChoices;
    private static List<String> amplitudeChoices;
    private static List<String> singleCommands;
    private static List<String> processCommands;
    private static List<String> arithmeticFunctions;
    private static List<String> frequencyResponseUnits;
    private static List<String> impulseResponseUnits;
    private static List<String> smoothingChoices;
    private static List<String> fractionalOctaveSmoothingChoices;
    private static List<String> offsetUnits;
    private static final List<$B> FREQ_RESP_AXIS_TYPES;
    private static final List<$B> IMPULSE_RESP_AXIS_TYPES;
    private static List<String> eqCommands;
    private iA eqPanel;
    private static AK allSPL;
    private static ProcessResult processResult;
    private static URL processResultUrl;
    private static PB csd;
    private static SpectrogramAmplitude amplitude;
    private volatile boolean deletingAll = false;

    public static String getAXIS_UNIT_KEY() {
        return "unit";
    }

    public static String getWINDOWED_KEY() {
        return WINDOWED_KEY;
    }

    public static String getNORMALISED_KEY() {
        return NORMALISED_KEY;
    }

    public static String getSMOOTHING_KEY() {
        return SMOOTHING_KEY;
    }

    public static String getPPO_KEY() {
        return PPO_KEY;
    }

    public MeasurementsService() {
        NI nI2 = g.getMeasPanesList();
        nI2.A(this);
        RoomEQ_Wizard.X.addListDataListener(this);
        try {
            EventQueue.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    XG.K();
                    MeasurementsService.this.eqPanel = iA.\u01d1();
                    allSPL = g.getGraphPanel().\u01af();
                }
            });
        }
        catch (InterruptedException | InvocationTargetException exception) {
            // empty catch block
        }
    }

    public static List<String> getFrequencyResponseUnits() {
        if (frequencyResponseUnits == null) {
            frequencyResponseUnits = new ArrayList<String>();
            for ($B $B : FREQ_RESP_AXIS_TYPES) {
                frequencyResponseUnits.add($B.C());
            }
        }
        return frequencyResponseUnits;
    }

    public static List<String> getImpulseResponseUnits() {
        if (impulseResponseUnits == null) {
            impulseResponseUnits = new ArrayList<String>();
            for ($B $B : IMPULSE_RESP_AXIS_TYPES) {
                impulseResponseUnits.add($B.C());
            }
        }
        return impulseResponseUnits;
    }

    public static List<String> getSmoothingChoices() {
        if (smoothingChoices == null) {
            smoothingChoices = new ArrayList<String>();
            for (kJ kJ2 : kJ.values()) {
                smoothingChoices.add(kJ2.A());
            }
        }
        return smoothingChoices;
    }

    public static List<String> getFractionalOctaveSmoothingChoices() {
        if (fractionalOctaveSmoothingChoices == null) {
            fractionalOctaveSmoothingChoices = new ArrayList<String>();
            for (kJ kJ2 : kJ.values()) {
                if (!kJ2.B()) continue;
                fractionalOctaveSmoothingChoices.add(kJ2.A());
            }
        }
        return fractionalOctaveSmoothingChoices;
    }

    public List<String> getEQCommands() {
        if (eqCommands == null) {
            eqCommands = new ArrayList<String>();
            for (EQCommand eQCommand : EQCommand.values()) {
                eqCommands.add(eQCommand.apiName());
            }
        }
        return eqCommands;
    }

    public static List<String> getOffsetUnits() {
        if (offsetUnits == null) {
            offsetUnits = new ArrayList<String>();
            for (YF yF2 : YF.values()) {
                offsetUnits.add(yF2.A());
            }
        }
        return offsetUnits;
    }

    public APIResponse runEQCommand(Command command, Response response, int n2) {
        SD sD2 = RoomEQ_Wizard.w();
        final MeasData measData = sD2.D(n2);
        if (command.getCommand() == null) {
            return APIResponse.badRequest(response, "No command in the request");
        }
        String string = command.getCommand();
        final EQCommand eQCommand = EQCommand.getFromApiName(string);
        if (eQCommand == null) {
            ValidValues validValues = ValidValues.builder().message(string + " is not a recognised EQ command").validValues(this.getEQCommands()).build();
            return APIResponse.badRequest(response, validValues);
        }
        if (API.runningACommand()) {
            return APIResponse.badRequest(response, API.getRunningCommand() + " is running, it must complete before " + string + " can run");
        }
        switch (eQCommand) {
            case CALC_TARGET_LEVEL: {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MeasurementsService.this.eqPanel.\u01d8().G(measData, MeasurementsService.this, eQCommand.apiName());
                    }
                });
                return API.commandAccepted(response, eQCommand.apiName());
            }
            case MATCH_TARGET: {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MeasurementsService.this.eqPanel.\u01d2().D(measData, MeasurementsService.this, eQCommand.apiName());
                    }
                });
                return API.commandAccepted(response, eQCommand.apiName());
            }
            case OPTIMISE_GAIN: {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MeasurementsService.this.eqPanel.\u01d2().F(measData, MeasurementsService.this, eQCommand.apiName());
                    }
                });
                return API.commandAccepted(response, eQCommand.apiName());
            }
            case OPTIMISE_GAIN_AND_Q: {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MeasurementsService.this.eqPanel.\u01d2().A(measData, MeasurementsService.this, eQCommand.apiName());
                    }
                });
                return API.commandAccepted(response, eQCommand.apiName());
            }
            case OPTIMISE_GAIN_Q_AND_FC: {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MeasurementsService.this.eqPanel.\u01d2().C(measData, MeasurementsService.this, eQCommand.apiName());
                    }
                });
                return API.commandAccepted(response, eQCommand.apiName());
            }
            case MEASUREMENT_FROM_FILTERS: {
                if (!sD2.C()) {
                    return APIResponse.badRequest(response, MeasurementsService.measurementsAtMax());
                }
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TG.E(measData, MeasurementsService.this, eQCommand.apiName());
                    }
                });
                return API.commandAccepted(response, eQCommand.apiName());
            }
            case MEASUREMENT_FROM_PREDICTED: {
                if (!sD2.C()) {
                    return APIResponse.badRequest(response, MeasurementsService.measurementsAtMax());
                }
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TG.B(measData, MeasurementsService.this, eQCommand.apiName());
                    }
                });
                return API.commandAccepted(response, eQCommand.apiName());
            }
            case MEASUREMENT_FROM_TARGET: {
                if (!sD2.C()) {
                    return APIResponse.badRequest(response, MeasurementsService.measurementsAtMax());
                }
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        eG.H(measData, MeasurementsService.this, eQCommand.apiName());
                    }
                });
                return API.commandAccepted(response, eQCommand.apiName());
            }
        }
        assert (false) : "Unhandled enum type";
        return APIResponse.notImplemented(response, string + " is not implemented yet");
    }

    static String measurementsAtMax() {
        return "There are already " + RoomEQ_Wizard.w().getSize() + " measurements loaded which is the maximum, the maximum can be changed in the View preferences";
    }

    public static $B getDefaultImpulseResponseAxis() {
        return $B.d;
    }

    public Map<Integer, MeasurementSummary> getMeasurementSummaries() {
        SD sD2 = RoomEQ_Wizard.w();
        TreeMap<Integer, MeasurementSummary> treeMap = new TreeMap<Integer, MeasurementSummary>();
        ArrayList<MeasData> arrayList = sD2.E();
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            MeasData measData = arrayList.get(i2);
            treeMap.put(i2 + 1, measData.getMeasurementSummary());
        }
        return treeMap;
    }

    public APIResponse setSelectedIndex(Integer n2, Response response) {
        SD sD2 = RoomEQ_Wizard.w();
        if (n2 > 0 && n2 <= sD2.K()) {
            g.getMeasPanesList().H(n2 - 1);
            return APIResponse.ok(response, n2 + " selected");
        }
        return APIResponse.badRequest(response, "There is no measurement at " + n2);
    }

    public Integer getSelectedIndex() {
        return g.getMeasPanesList().O() + 1;
    }

    public MeasurementSummary getMeasurementSummary(int n2) {
        SD sD2 = RoomEQ_Wizard.w();
        if (n2 >= 0 && n2 < sD2.K()) {
            MeasData measData = sD2.D(n2);
            return measData.getMeasurementSummary();
        }
        return null;
    }

    public boolean measurementExistsAt(int n2) {
        SD sD2 = RoomEQ_Wizard.w();
        return n2 >= 0 && n2 < sD2.K();
    }

    public boolean measurementHasIR(int n2) {
        SD sD2 = RoomEQ_Wizard.w();
        MeasData measData = sD2.D(n2);
        return measData.hasIR();
    }

    public APIResponse setSummary(MeasurementSummary measurementSummary, Response response, int n2) {
        boolean bl = false;
        SD sD2 = RoomEQ_Wizard.w();
        MeasData measData = sD2.D(n2);
        if (measurementSummary.getTitle() != null) {
            measData.setShortDesc(measurementSummary.getTitle(), true);
            bl = true;
        }
        if (measurementSummary.getNotes() != null) {
            measData.setMeasNotes(measurementSummary.getNotes());
            bl = true;
        }
        if (!bl) {
            return APIResponse.badRequest(response, "Nothing to update in the request");
        }
        return APIResponse.ok(response, "Update processed");
    }

    public EqualiserEntry getEqualiser(int n2) {
        SD sD2 = RoomEQ_Wizard.w();
        if (n2 >= 0 && n2 < sD2.K()) {
            MeasData measData = sD2.D(n2);
            Equaliser equaliser = measData.getEqualiser();
            EqualiserEntry equaliserEntry = EqualiserEntry.builder().manufacturer(equaliser.getManufacturer().A()).model(equaliser.getModel()).build();
            return equaliserEntry;
        }
        return null;
    }

    public APIResponse setEqualiser(EqualiserEntry equaliserEntry, Response response, int n2) {
        SD sD2 = RoomEQ_Wizard.w();
        MeasData measData = sD2.D(n2);
        if (equaliserEntry.getManufacturer() != null) {
            PE pE2 = PE.A(equaliserEntry.getManufacturer());
            if (pE2 == null) {
                ValidValues validValues = ValidValues.builder().message(equaliserEntry.getManufacturer() + " is not a valid manufacturer").validValues(EQService.getManufacturers()).build();
                return APIResponse.badRequest(response, validValues);
            }
            if (equaliserEntry.getModel() != null) {
                List<Equaliser> list = FB.A(pE2);
                for (Equaliser equaliser : list) {
                    if (!equaliser.getModel().equalsIgnoreCase(equaliserEntry.getModel())) continue;
                    FB.A(equaliser, measData);
                    return APIResponse.ok(response, "Equaliser selected");
                }
                return APIResponse.badRequest(response, equaliserEntry.getModel() + " is not a recognised model for " + pE2.A());
            }
        }
        return APIResponse.badRequest(response, "No manufacturer in the request");
    }

    public TargetSettings getTargetSettings(int n2) {
        SD sD2 = RoomEQ_Wizard.w();
        if (n2 >= 0 && n2 < sD2.K()) {
            MeasData measData = sD2.D(n2);
            Target target = measData.getTarget();
            TargetSettings targetSettings = TargetSettings.builder().shape(target.getTargetShape().apiName()).bassManagementSlopedBPerOctave(target.getBassMgmtSlope().getSlopedB()).bassManagementCutoffHz((int)Math.round(target.getBassMgmtCutoff())).lowFreqSlopedBPerOctave(target.getSubLFSlope().getSlopedB()).lowFreqCutoffHz((int)Math.round(target.getSubLFCutoff())).lowPassCrossoverType(target.getXOverLPChoice().apiName()).lowPassCutoffHz((int)Math.round(target.getXOverLPCutoff())).highPassCrossoverType(target.getXOverHPChoice().apiName()).highPassCutoffHz((int)Math.round(target.getXOverHPCutoff())).build();
            return targetSettings;
        }
        return null;
    }

    public APIResponse setTargetSettings(TargetSettings targetSettings, Response response, int n2) {
        Enum enum_;
        SD sD2 = RoomEQ_Wizard.w();
        final MeasData measData = sD2.D(n2);
        boolean bl = false;
        if (targetSettings.getShape() != null) {
            enum_ = TargetShape.getFromApiName(targetSettings.getShape());
            if (enum_ == null) {
                ValidValues validValues = ValidValues.builder().message(targetSettings.getShape() + " is not a valid target shape").validValues(EQService.getTargetShapes()).build();
                return APIResponse.badRequest(response, validValues);
            }
            measData.setTargetShape((TargetShape)enum_);
            bl = true;
        }
        if (targetSettings.getBassManagementSlopedBPerOctave() != null) {
            enum_ = XOverSlope.getSlopeFromdBPerOctave(targetSettings.getBassManagementSlopedBPerOctave());
            if (enum_ == null) {
                ValidValues validValues = ValidValues.builder().message(targetSettings.getBassManagementSlopedBPerOctave() + " is not a valid slope").validValues(EQService.getSlopes()).build();
                return APIResponse.badRequest(response, validValues);
            }
            measData.setBassMgmtSlope((XOverSlope)enum_);
            bl = true;
        }
        if (targetSettings.getBassManagementCutoffHz() != null) {
            int n3 = targetSettings.getBassManagementCutoffHz();
            if (!EQService.cutoffIsValid(n3, eG.c())) {
                return APIResponse.badRequest(response, EQService.validCutoffValues(eG.c()));
            }
            measData.setBassMgmtCutoff(n3);
            bl = true;
        }
        if (targetSettings.getLowFreqSlopedBPerOctave() != null) {
            XOverSlope xOverSlope = XOverSlope.getSlopeFromdBPerOctave(targetSettings.getLowFreqSlopedBPerOctave());
            if (xOverSlope == null) {
                ValidValues validValues = ValidValues.builder().message(targetSettings.getLowFreqSlopedBPerOctave() + " is not a valid slope").validValues(EQService.getSlopes()).build();
                return APIResponse.badRequest(response, validValues);
            }
            measData.setSubLFSlope(xOverSlope);
            bl = true;
        }
        if (targetSettings.getLowFreqCutoffHz() != null) {
            int n4 = targetSettings.getLowFreqCutoffHz();
            if (!EQService.cutoffIsValid(n4, eG.d())) {
                return APIResponse.badRequest(response, EQService.validCutoffValues(eG.d()));
            }
            measData.setSubLFCutoff(n4);
            bl = true;
        }
        if (targetSettings.getLowPassCrossoverType() != null) {
            XOverChoice xOverChoice = XOverChoice.getFromApiName(targetSettings.getLowPassCrossoverType());
            if (xOverChoice == null) {
                ValidValues validValues = ValidValues.builder().message(targetSettings.getShape() + " is not a valid crossover type").validValues(EQService.getCrossoverTypes()).build();
                return APIResponse.badRequest(response, validValues);
            }
            measData.setXOverLPChoice(xOverChoice);
            bl = true;
        }
        if (targetSettings.getHighPassCrossoverType() != null) {
            XOverChoice xOverChoice = XOverChoice.getFromApiName(targetSettings.getHighPassCrossoverType());
            if (xOverChoice == null) {
                ValidValues validValues = ValidValues.builder().message(targetSettings.getShape() + " is not a valid crossover type").validValues(EQService.getCrossoverTypes()).build();
                return APIResponse.badRequest(response, validValues);
            }
            measData.setXOverHPChoice(xOverChoice);
            bl = true;
        }
        if (targetSettings.getLowPassCutoffHz() != null) {
            int n5 = targetSettings.getLowPassCutoffHz();
            if (!EQService.cutoffIsValid(n5, eG.c())) {
                return APIResponse.badRequest(response, EQService.validCutoffValues(eG.c()));
            }
            measData.setXOverLPCutoff(n5);
            bl = true;
        }
        if (targetSettings.getHighPassCutoffHz() != null) {
            int n6 = targetSettings.getHighPassCutoffHz();
            if (!EQService.cutoffIsValid(n6, eG.c())) {
                return APIResponse.badRequest(response, EQService.validCutoffValues(eG.c()));
            }
            measData.setXOverHPCutoff(n6);
            bl = true;
        }
        if (!bl) {
            return APIResponse.badRequest(response, "Nothing to update in the request");
        }
        if (n2 == g.getMeasPanesList().O()) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MeasurementsService.this.eqPanel.\u01d8().D(measData, true);
                }
            });
        }
        return APIResponse.ok(response, "Update processed");
    }

    public IRWindows getIRWindows(int n2) {
        SD sD2 = RoomEQ_Wizard.w();
        if (n2 >= 0 && n2 < sD2.K()) {
            MeasData measData = sD2.D(n2);
            IRData iRData = measData.getIRData();
            WindowSettings windowSettings = iRData.getWindows();
            Double d2 = null;
            Double d3 = null;
            boolean bl = iRData.fdwEnabled();
            if (bl) {
                if (iRData.isFdwAsCycles()) {
                    d2 = iRData.getFdwWidth();
                } else {
                    d3 = iRData.getFdwWidth();
                }
            }
            IRWindows iRWindows = IRWindows.builder().addFDW(bl).fdwWidthCycles(d2).fdwWidthOctaves(d3).leftWindowType(windowSettings.getPreWindowType().apiName()).rightWindowType(windowSettings.getPostWindowType().apiName()).leftWindowWidthms(windowSettings.getPreImpulseDurn() * 1000.0).rightWindowWidthms(windowSettings.getPostImpulseDurn() * 1000.0).refTimems(windowSettings.getWinRefTime() * 1000.0).build();
            return iRWindows;
        }
        return null;
    }

    public APIResponse setIRWindows(IRWindows iRWindows, Response response, int n2) {
        Window.Types types;
        String string;
        SD sD2 = RoomEQ_Wizard.w();
        final MeasData measData = sD2.D(n2);
        IRData iRData = measData.getIRData();
        WindowSettings windowSettings = iRData.getWindows().copy();
        boolean bl = false;
        if (iRWindows.getRefTimems() != null) {
            double d2 = iRWindows.getRefTimems() / 1000.0;
            if (!windowSettings.isValidRef(d2)) {
                return APIResponse.badRequest(response, iRWindows.getRefTimems() + " ms reference time is not within the IR span of " + HE.U.format(windowSettings.getStartTime() * 1000.0) + "ms to " + HE.U.format(windowSettings.getEndTime() * 1000.0) + "ms");
            }
            windowSettings.setWinRefTime(d2);
            bl = true;
        }
        List<Window.Types> list = Arrays.asList(Window.Types.leftRightSet());
        if (iRWindows.getLeftWindowType() != null) {
            string = iRWindows.getLeftWindowType();
            types = Window.Types.getTypeFromDescription(string);
            if (types == null || !list.contains((Object)types)) {
                ValidValues validValues = ValidValues.builder().message(string + " is not a valid window type").validValues(MeasurementsService.getWindowChoices()).build();
                return APIResponse.badRequest(response, validValues);
            }
            windowSettings.setPreWindowType(types);
            bl = true;
        }
        if (iRWindows.getLeftWindowType() != null) {
            string = iRWindows.getLeftWindowType();
            types = Window.Types.getTypeFromDescription(string);
            if (types == null || !list.contains((Object)types)) {
                ValidValues validValues = ValidValues.builder().message(string + " is not a valid window type").validValues(MeasurementsService.getWindowChoices()).build();
                return APIResponse.badRequest(response, validValues);
            }
            windowSettings.setPreWindowType(types);
            bl = true;
        }
        if (iRWindows.getRightWindowType() != null) {
            string = iRWindows.getRightWindowType();
            types = Window.Types.getTypeFromDescription(string);
            if (types == null || !list.contains((Object)types)) {
                ValidValues validValues = ValidValues.builder().message(string + " is not a valid window type").validValues(MeasurementsService.getWindowChoices()).build();
                return APIResponse.badRequest(response, validValues);
            }
            windowSettings.setPostWindowType(types);
            bl = true;
        }
        if (iRWindows.getLeftWindowWidthms() != null) {
            double d3 = iRWindows.getLeftWindowWidthms() / 1000.0;
            if (d3 < 0.0) {
                return APIResponse.badRequest(response, "Window widths cannot be negative");
            }
            windowSettings.setPreWindowDurn(d3);
            bl = true;
        }
        if (iRWindows.getRightWindowWidthms() != null) {
            double d4 = iRWindows.getRightWindowWidthms() / 1000.0;
            if (d4 <= 0.0) {
                return APIResponse.badRequest(response, "Right window width must be > 0");
            }
            windowSettings.setPostWindowDurn(d4);
            bl = true;
        }
        if (bl) {
            iRData.setWindows(windowSettings);
        }
        if (iRWindows.isAddFDW()) {
            boolean bl2 = iRWindows.isAddFDW();
            if (bl2) {
                iRData.setFdwEnabledAndRemoveFDWIfFalse(true);
            } else {
                iRData.setFdwEnabledAndRemoveFDWIfFalse(false);
            }
        }
        if (iRWindows.getFdwWidthCycles() != null) {
            double d5 = iRWindows.getFdwWidthCycles();
            if (d5 < 1.0 || d5 > 35.0) {
                return APIResponse.badRequest(response, d5 + " is outside the valid FDW cycles range of " + 1 + " to " + 35);
            }
            iRData.setFdwAsCycles(true);
            iRData.setFdwWidth(d5);
            bl = true;
        }
        if (iRWindows.getFdwWidthOctaves() != null) {
            double d6 = iRWindows.getFdwWidthOctaves();
            if (d6 < 1.0 || d6 > 48.0) {
                return APIResponse.badRequest(response, d6 + " is outside the valid FDW octaves range of " + 1 + " to " + 48);
            }
            iRData.setFdwAsCycles(false);
            iRData.setFdwWidth(d6);
            bl = true;
        }
        if (!bl) {
            return APIResponse.badRequest(response, "Nothing to update in the request");
        }
        measData.applyWindows();
        if (RoomEQ_Wizard.s() && n2 == g.getMeasPanesList().O()) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    vC.B().A(measData);
                }
            });
        }
        return APIResponse.ok(response, "Update processed");
    }

    public Double getTargetLevel(int n2) {
        SD sD2 = RoomEQ_Wizard.w();
        if (n2 >= 0 && n2 < sD2.K()) {
            MeasData measData = sD2.D(n2);
            return measData.getTargetLevel();
        }
        return null;
    }

    public APIResponse setTargetLevel(Double d2, Response response, int n2) {
        SD sD2 = RoomEQ_Wizard.w();
        final MeasData measData = sD2.D(n2);
        if (d2 != null) {
            measData.setTargetLevel(d2);
            if (n2 == g.getMeasPanesList().O()) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MeasurementsService.this.eqPanel.\u01d8().D(measData, true);
                    }
                });
            }
            return APIResponse.ok(response, "Target level set");
        }
        return APIResponse.badRequest(response, "No level in request");
    }

    public RoomCurveSettings getRoomCurveSettings(int n2) {
        SD sD2 = RoomEQ_Wizard.w();
        if (n2 >= 0 && n2 < sD2.K()) {
            MeasData measData = sD2.D(n2);
            RoomCurveSettings roomCurveSettings = RoomCurveSettings.builder().addRoomCurve(measData.addRoomCurve()).lowFreqRiseStartHz(measData.getLFRiseStart()).lowFreqRiseEndHz(measData.getLFRiseEnd()).lowFreqRiseSlopedBPerOctave(measData.getLFRiseSlope()).highFreqFallStartHz(measData.getHFFallStart()).highFreqFallSlopedBPerOctave(measData.getHFFallSlope()).build();
            return roomCurveSettings;
        }
        return null;
    }

    public APIResponse setRoomCurveSettings(RoomCurveSettings roomCurveSettings, Response response, int n2) {
        int n3;
        SD sD2 = RoomEQ_Wizard.w();
        final MeasData measData = sD2.D(n2);
        boolean bl = false;
        if (roomCurveSettings.getAddRoomCurve() != null) {
            measData.setAddRoomCurve(roomCurveSettings.getAddRoomCurve());
            bl = true;
        }
        if (roomCurveSettings.getLowFreqRiseStartHz() != null) {
            n3 = roomCurveSettings.getLowFreqRiseStartHz();
            if (n3 < eG.o() || n3 > eG.X()) {
                return APIResponse.badRequest(response, "The low freq rise start must be between " + eG.o() + " and " + eG.X() + " Hz");
            }
            measData.setLFRiseStart(n3);
            bl = true;
        }
        if (roomCurveSettings.getLowFreqRiseEndHz() != null) {
            n3 = roomCurveSettings.getLowFreqRiseEndHz();
            if (n3 < eG.g() || n3 > eG.n()) {
                return APIResponse.badRequest(response, "The low freq rise end must be between " + eG.g() + " and " + eG.n() + " Hz");
            }
            measData.setLFRiseEnd(n3);
            bl = true;
        }
        if (roomCurveSettings.getLowFreqRiseSlopedBPerOctave() != null) {
            double d2 = roomCurveSettings.getLowFreqRiseSlopedBPerOctave();
            if (d2 < eG.i() || d2 > eG.p()) {
                return APIResponse.badRequest(response, "The slope must be between " + eG.i() + " and " + eG.p() + " dB per octave");
            }
            measData.setLFRiseSlope(d2);
            bl = true;
        }
        if (roomCurveSettings.getHighFreqFallStartHz() != null) {
            int n4 = roomCurveSettings.getHighFreqFallStartHz();
            if (n4 < eG.r() || n4 > eG._()) {
                return APIResponse.badRequest(response, "The high freq fall start must be between " + eG.r() + " and " + eG._() + " Hz");
            }
            measData.setHFFallStart(n4);
            bl = true;
        }
        if (roomCurveSettings.getHighFreqFallSlopedBPerOctave() != null) {
            double d3 = roomCurveSettings.getHighFreqFallSlopedBPerOctave();
            if (d3 < eG.i() || d3 > eG.p()) {
                return APIResponse.badRequest(response, "The slope must be between " + eG.i() + " and " + eG.p() + " dB per octave");
            }
            measData.setHFFallSlope(d3);
            bl = true;
        }
        if (!bl) {
            return APIResponse.badRequest(response, "Nothing to update in the request");
        }
        if (n2 == g.getMeasPanesList().O()) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MeasurementsService.this.eqPanel.\u01d8().D(measData, true);
                }
            });
        }
        return APIResponse.ok(response, "Update processed");
    }

    public FrequencyResponse getTargetResponse(Request request, Response response, int n2) {
        SD sD2 = RoomEQ_Wizard.w();
        if (n2 < 0 || n2 >= sD2.K()) {
            return null;
        }
        MeasData measData = sD2.D(n2);
        response.header("Content-Encoding", "gzip");
        String string = request.queryParamOrDefault("unit", MeasData.getDefaultAxis(measData).C());
        $B $B = $B.B(string);
        String string2 = null;
        if ($B == null || !MeasurementsService.supportsFrequencyResponseAxisType(measData, $B)) {
            $B = MeasData.getDefaultAxis(measData);
            string2 = string + " is not a valid axis unit, returning " + MeasData.getDefaultAxis(measData).C() + " data. ";
        }
        Integer n3 = 96;
        String string3 = request.queryParamOrDefault(PPO_KEY, "");
        if (!string3.isEmpty()) {
            try {
                n3 = Integer.valueOf(string3.trim());
            }
            catch (NumberFormatException numberFormatException) {
                if (string2 == null) {
                    string2 = "";
                }
                string2 = string2 + string3 + " is not a valid ppo value, returning 96 PPO data. ";
                n3 = 96;
            }
        }
        if (n3 != null && (n3 <= 0 || 96.0 / (double)n3.intValue() != (double)(96 / n3))) {
            if (string2 == null) {
                string2 = "";
            }
            string2 = string2 + string3 + " is not a valid ppo value, ppo must be > 0  and a factor of 96, returning 96 PPO data. ";
            n3 = 96;
        }
        FrequencyResponse frequencyResponse = measData.getTargetFrequencyResponse($B, string2, n3);
        return frequencyResponse;
    }

    public FrequencyResponse getMeasuredFrequencyResponse(Request request, Response response, int n2) {
        SD sD2 = RoomEQ_Wizard.w();
        if (n2 < 0 || n2 >= sD2.K()) {
            return null;
        }
        MeasData measData = sD2.D(n2);
        return this.getFrequencyResponse(request, response, measData);
    }

    public FrequencyResponse getPredictedFrequencyResponse(Request request, Response response, int n2) {
        SD sD2 = RoomEQ_Wizard.w();
        if (n2 < 0 || n2 >= sD2.K()) {
            return null;
        }
        MeasData measData = sD2.D(n2);
        if (!measData.hasEqualisedMeas()) {
            return this.getFrequencyResponse(request, response, measData);
        }
        return this.getFrequencyResponse(request, response, measData.getEqualisedMeas());
    }

    public FrequencyResponse getFrequencyResponse(Request request, Response response, MeasData measData) {
        String string;
        kJ kJ2;
        response.header("Content-Encoding", "gzip");
        String string2 = request.queryParamOrDefault("unit", MeasData.getDefaultAxis(measData).C());
        $B $B = $B.B(string2);
        String string3 = null;
        if ($B == null || !MeasurementsService.supportsFrequencyResponseAxisType(measData, $B)) {
            $B = MeasData.getDefaultAxis(measData);
            string3 = string2 + " is not a valid axis unit, returning " + MeasData.getDefaultAxis(measData).C() + " data. ";
        }
        if ((kJ2 = kJ.A(string = request.queryParamOrDefault(SMOOTHING_KEY, kJ.B(measData.getOctaveFrac()).A()))) == null) {
            kJ2 = kJ.B(measData.getOctaveFrac());
            if (string3 == null) {
                string3 = "";
            }
            string3 = string3 + string + " is not a valid smoothing, returning " + kJ2.A() + " data. ";
        }
        Integer n2 = null;
        String string4 = request.queryParamOrDefault(PPO_KEY, "");
        if (!string4.isEmpty()) {
            try {
                n2 = Integer.valueOf(string4.trim());
            }
            catch (NumberFormatException numberFormatException) {
                if (string3 == null) {
                    string3 = "";
                }
                string3 = string3 + string4 + " is not a valid ppo value, returning 96 PPO data. ";
                n2 = 96;
            }
        }
        if (n2 != null && (n2 <= 0 || 96.0 / (double)n2.intValue() != (double)(96 / n2))) {
            if (string3 == null) {
                string3 = "";
            }
            string3 = string3 + string4 + " is not a valid ppo value, ppo must be > 0  and a factor of 96, returning 96 PPO data. ";
            n2 = 96;
        }
        double d2 = measData.getOctaveFrac();
        if (kJ2.C() != measData.getOctaveFrac()) {
            measData.smooth(kJ2.C(), true);
        }
        FrequencyResponse frequencyResponse = measData.getFrequencyResponse($B, string3, n2);
        measData.smooth(d2, true);
        return frequencyResponse;
    }

    public ImpulseResponse getMeasuredImpulseResponse(Request request, Response response, int n2) {
        SD sD2 = RoomEQ_Wizard.w();
        if (n2 < 0 || n2 >= sD2.K()) {
            return null;
        }
        MeasData measData = sD2.D(n2);
        return this.getImpulseResponse(request, response, measData);
    }

    public ImpulseResponse getFiltersImpulseResponse(Request request, Response response, int n2, double d2, int n3) {
        SD sD2 = RoomEQ_Wizard.w();
        if (n2 < 0 || n2 >= sD2.K()) {
            return null;
        }
        MeasData measData = sD2.D(n2);
        return this.getFiltersImpulseResponse(request, response, measData, d2, n3);
    }

    public ImpulseResponse getPredictedImpulseResponse(Request request, Response response, int n2) {
        SD sD2 = RoomEQ_Wizard.w();
        if (n2 < 0 || n2 >= sD2.K()) {
            return null;
        }
        MeasData measData = sD2.D(n2);
        if (!measData.hasEqualisedMeas()) {
            return this.getImpulseResponse(request, response, measData);
        }
        return this.getImpulseResponse(request, response, measData.getEqualisedMeas());
    }

    public ImpulseResponse getImpulseResponse(Request request, Response response, MeasData measData) {
        response.header("Content-Encoding", "gzip");
        String string = request.queryParamOrDefault("unit", MeasurementsService.getDefaultImpulseResponseAxis().C());
        $B $B = $B.B(string);
        String string2 = null;
        if ($B == null || !IMPULSE_RESP_AXIS_TYPES.contains((Object)$B)) {
            $B = MeasurementsService.getDefaultImpulseResponseAxis();
            string2 = string + " is not a valid axis unit, returning " + MeasurementsService.getDefaultImpulseResponseAxis().C() + " data";
        }
        String string3 = request.queryParamOrDefault(NORMALISED_KEY, "true");
        String string4 = request.queryParamOrDefault(WINDOWED_KEY, "false");
        return measData.getImpulseResponse($B, string2, Boolean.parseBoolean(string4), Boolean.parseBoolean(string3));
    }

    public ImpulseResponse getFiltersImpulseResponse(Request request, Response response, MeasData measData, double d2, int n2) {
        response.header("Content-Encoding", "gzip");
        String string = null;
        return measData.getFiltersImpulseResponse(d2, n2, string);
    }

    public List<FilterSetting> getFilters(int n2) {
        SD sD2 = RoomEQ_Wizard.w();
        if (n2 < 0 || n2 >= sD2.K()) {
            return null;
        }
        MeasData measData = sD2.D(n2);
        return measData.getFilterSet().getAPIFilterList();
    }

    public APIResponse setFilter(FilterSetting filterSetting, Response response, int n2) {
        SD sD2 = RoomEQ_Wizard.w();
        final MeasData measData = sD2.D(n2);
        if (filterSetting != null) {
            Equaliser equaliser = measData.getEqualiser();
            int n3 = equaliser.getNumRegularFilters() + equaliser.getNumXOverFilters();
            FilterSet filterSet = measData.getFilterSet();
            if (filterSetting.getIndex() == null) {
                return APIResponse.badRequest(response, "FilterSetting must have an index");
            }
            int n4 = filterSetting.getIndex();
            if (n4 < 1) {
                return APIResponse.badRequest(response, "FilterSetting index values start at 1");
            }
            if (n4 > n3) {
                return APIResponse.badRequest(response, "Index " + n4 + " is too large, the " + (Object)((Object)equaliser.getManufacturer()) + " " + equaliser.getModel() + " equaliser has " + n3 + " filters");
            }
            int n5 = n4 - 1;
            Result result = filterSet.updateFilter(n5, filterSetting);
            if (!result.isSuccess()) {
                return APIResponse.badRequest(response, result.getFailureMessage());
            }
            measData.applyFiltersImmediate(true);
            if (n2 == g.getMeasPanesList().O()) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        YH.\u0164().A(measData);
                    }
                });
            }
            return APIResponse.ok(response, "Filter set");
        }
        return APIResponse.badRequest(response, "No filter in request");
    }

    public APIResponse setFilters(FilterList filterList, Response response, int n2) {
        SD sD2 = RoomEQ_Wizard.w();
        final MeasData measData = sD2.D(n2);
        if (filterList != null && filterList.getFilters() != null && !filterList.getFilters().isEmpty()) {
            List<FilterSetting> list = filterList.getFilters();
            Equaliser equaliser = measData.getEqualiser();
            int n3 = equaliser.getNumRegularFilters() + equaliser.getNumXOverFilters();
            FilterSet filterSet = measData.getFilterSet();
            for (FilterSetting filterSetting : list) {
                if (filterSetting.getIndex() == null) {
                    return APIResponse.badRequest(response, "FilterSetting must have an index");
                }
                int n4 = filterSetting.getIndex();
                if (n4 < 1) {
                    return APIResponse.badRequest(response, "FilterSetting index values start at 1");
                }
                if (n4 > n3) {
                    return APIResponse.badRequest(response, "Index " + n4 + " is too large, the " + (Object)((Object)equaliser.getManufacturer()) + " " + equaliser.getModel() + " equaliser has " + n3 + " filters");
                }
                int n5 = n4 - 1;
                Result result = filterSet.updateFilter(n5, filterSetting);
                if (result.isSuccess()) continue;
                return APIResponse.badRequest(response, result.getFailureMessage());
            }
            measData.applyFiltersImmediate(true);
            if (n2 == g.getMeasPanesList().O()) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MeasurementsService.this.eqPanel.\u01d8().D(measData, true);
                    }
                });
            }
            return APIResponse.ok(response, "Filters set");
        }
        return APIResponse.badRequest(response, "No filters in request");
    }

    public static boolean supportsFrequencyResponseAxisType(MeasData measData, $B $B) {
        if (measData.isImpedance()) {
            return $B == $B.G;
        }
        return $B != $B.G && FREQ_RESP_AXIS_TYPES.contains((Object)$B);
    }

    public APIResponse deleteMeasurement(final int n2, Response response) {
        if (g.getMeasPanesList().F()) {
            return APIResponse.badRequest(response, "There is already a measurement deletion in progress");
        }
        if (API.runningACommand()) {
            return APIResponse.badRequest(response, API.getRunningCommand() + " is running, it must complete before delete can run");
        }
        SD sD2 = RoomEQ_Wizard.w();
        if (n2 >= 0 && n2 < sD2.K()) {
            MeasData measData = sD2.D(n2);
            if (measData.isLocked()) {
                return APIResponse.badRequest(response, "The measurement at " + (n2 + 1) + "is locked and cannot be deleted");
            }
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        g.getMeasPanesList().A(n2, true, true);
                    }
                });
            }
            catch (InterruptedException | InvocationTargetException exception) {
                // empty catch block
            }
            return APIResponse.ok(response, "Measurement " + (n2 + 1) + " deleted");
        }
        return APIResponse.notFound(response, "There is no measurement at index " + (n2 + 1) + ", there are " + this.numMeasurements() + " measurements");
    }

    public APIResponse deleteAll(Response response) {
        if (this.deletingAll) {
            return APIResponse.badRequest(response, "There is already a measurement deletion in progress");
        }
        if (API.runningACommand()) {
            return APIResponse.badRequest(response, API.getRunningCommand() + " is running, it must complete before delete all can run");
        }
        this.deletingAll = true;
        final NI nI2 = g.getMeasPanesList();
        int n2 = nI2.A();
        try {
            EventQueue.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    nI2.A(false);
                }
            });
        }
        catch (InterruptedException | InvocationTargetException exception) {
            // empty catch block
        }
        this.deletingAll = false;
        return APIResponse.ok(response, n2 + " measurements deleted");
    }

    public int numMeasurements() {
        SD sD2 = RoomEQ_Wizard.w();
        return sD2.K();
    }

    public List<String> getCommands() {
        if (commands == null) {
            commands = new ArrayList<String>();
            for (MeasurementsCommand measurementsCommand : MeasurementsCommand.values()) {
                commands.add(measurementsCommand.commandName());
            }
        }
        return commands;
    }

    public static List<String> getWindowChoices() {
        if (windowChoices == null) {
            windowChoices = new ArrayList<String>();
            List<Window.Types> list = Arrays.asList(Window.Types.leftRightSet());
            for (Window.Types types : list) {
                windowChoices.add(types.apiName());
            }
        }
        return windowChoices;
    }

    public static List<String> getAmplitudeChoices() {
        if (amplitudeChoices == null) {
            amplitudeChoices = new ArrayList<String>();
            for (SpectrogramAmplitude spectrogramAmplitude : SpectrogramAmplitude.values()) {
                amplitudeChoices.add(spectrogramAmplitude.apiName());
            }
        }
        return amplitudeChoices;
    }

    /*
     * WARNING - void declaration
     */
    public APIResponse runCommand(Command command, Response response) {
        if (command.getCommand() == null) {
            return APIResponse.badRequest(response, "No command in the request");
        }
        String string = command.getCommand();
        MeasurementsCommand measurementsCommand = MeasurementsCommand.getFromCommandName(string);
        if (measurementsCommand == null) {
            ValidValues validValues = ValidValues.builder().message(string + " is not a recognised command").validValues(this.getCommands()).build();
            return APIResponse.badRequest(response, validValues);
        }
        if (API.runningACommand()) {
            return APIResponse.badRequest(response, API.getRunningCommand() + " is running, it must complete before " + string + " can run");
        }
        switch (measurementsCommand) {
            case SAVE_ALL: {
                File file;
                NI nI2 = g.getMeasPanesList();
                int n2 = nI2.A();
                if (n2 == 0) {
                    return APIResponse.badRequest(response, "There are no measurements");
                }
                if (command.getParameters() == null || command.getParameters().isEmpty()) {
                    return APIResponse.badRequest(response, "The command does not have a filename to save the measurements to");
                }
                String string2 = command.getParameters().get(0);
                String string3 = "Notes:";
                if (command.getParameters().size() > 1) {
                    String object2 = string3 + command.getParameters().get(1);
                }
                if ((file = new File(string2)).isDirectory()) {
                    return APIResponse.badRequest(response, string2 + " is a folder");
                }
                if (!string2.toLowerCase().endsWith(".mdat")) {
                    return APIResponse.badRequest(response, "The filename should end with .mdat");
                }
                try {
                    RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
                    try (ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(randomAccessFile.getFD()));){
                        void var8_14;
                        XE.A(objectOutputStream, (String)var8_14, RoomEQ_Wizard.X.E(), file, true);
                        objectOutputStream.close();
                    }
                    lG.O(string2);
                    XE.H().A(file);
                }
                catch (IOException iOException) {
                    return APIResponse.badRequest(response, "IOException trying to save measurement data\n" + iOException.getMessage());
                }
                return APIResponse.ok(response, "Saved all measurements");
            }
            case LOAD: {
                Serializable serializable;
                if (command.getParameters() == null || command.getParameters().isEmpty()) {
                    return APIResponse.badRequest(response, "The command does not have any filenames to load");
                }
                List<String> list = command.getParameters();
                ArrayList<Serializable> arrayList = new ArrayList<Serializable>(list.size());
                for (String string2 : list) {
                    try {
                        serializable = new File(string2);
                    }
                    catch (Exception exception) {
                        return APIResponse.badRequest(response, "Could not find " + string2);
                    }
                    if (!((File)serializable).isFile() || !((File)serializable).exists()) {
                        return APIResponse.badRequest(response, "Could not find " + string2);
                    }
                    arrayList.add(serializable);
                }
                ArrayList arrayList2 = new ArrayList(arrayList.size());
                ArrayList<File> arrayList3 = new ArrayList<File>(arrayList.size());
                serializable = new ArrayList(arrayList.size());
                for (File file : arrayList) {
                    String string3 = file.getPath().toLowerCase();
                    if (string3.endsWith(".mdat")) {
                        arrayList2.add(file);
                        continue;
                    }
                    if (XE.\u00c3.C(string3)) {
                        arrayList3.add(file);
                        continue;
                    }
                    if (XE.I.C(string3)) {
                        ((ArrayList)serializable).add(file);
                        continue;
                    }
                    return APIResponse.badRequest(response, file.getName() + " is not a file type REW can load as a measurement");
                }
                if (!(arrayList2.isEmpty() && arrayList3.isEmpty() && ((ArrayList)serializable).isEmpty())) {
                    XE.A(arrayList2, arrayList3, (ArrayList<File>)serializable, this, measurementsCommand.commandName());
                    return API.commandAccepted(response, measurementsCommand.commandName());
                }
                return APIResponse.badRequest(response, "No files to load");
            }
        }
        assert (false) : "Unhandled enum type";
        return APIResponse.notImplemented(response, string + " is not implemented yet");
    }

    public List<String> getProcessCommands() {
        if (processCommands == null) {
            processCommands = new ArrayList<String>();
            for (ProcessCommand processCommand : ProcessCommand.values()) {
                processCommands.add(processCommand.commandName());
            }
        }
        return processCommands;
    }

    public List<String> getArithmeticFunctions() {
        if (arithmeticFunctions == null) {
            arithmeticFunctions = new ArrayList<String>();
            for (u u2 : u.U()) {
                arithmeticFunctions.add(u2.toString());
            }
        }
        return arithmeticFunctions;
    }

    public APIResponse runProcessMeasurements(ProcessMeasurements processMeasurements, Response response) {
        if (processMeasurements == null || processMeasurements.getProcessName() == null) {
            return APIResponse.badRequest(response, "No process in the request");
        }
        if (processMeasurements.getMeasurementIndices() == null || processMeasurements.getMeasurementIndices().isEmpty()) {
            return APIResponse.badRequest(response, "No measurement indices in the request");
        }
        String string = processMeasurements.getProcessName();
        ProcessCommand processCommand = ProcessCommand.getFromCommandName(string);
        if (processCommand == null) {
            ValidValues validValues = ValidValues.builder().message(string + " is not a recognised process").validValues(this.getProcessCommands()).build();
            return APIResponse.badRequest(response, validValues);
        }
        processResult = null;
        processResultUrl = null;
        String string2 = processMeasurements.getResultUrl();
        if (string2 != null && !string2.isEmpty()) {
            try {
                processResultUrl = new URL(URLDecoder.decode(processMeasurements.getResultUrl(), StandardCharsets.UTF_8.toString()));
            }
            catch (UnsupportedEncodingException | MalformedURLException iOException) {
                return APIResponse.badRequest(response, string2 + " is not a properly formatted URL");
            }
        }
        SD sD2 = RoomEQ_Wizard.w();
        List<Integer> list = processMeasurements.getMeasurementIndices();
        if (list == null || list.isEmpty()) {
            return APIResponse.badRequest(response, "There are no measurement indices in the request");
        }
        for (Integer n2 : list) {
            if (n2 >= 1 && n2 <= sD2.K()) continue;
            return APIResponse.badRequest(response, n2 + " is not a valid measurement index, there are " + sD2.K() + " measurements");
        }
        if (API.runningACommand()) {
            return APIResponse.badRequest(response, API.getRunningCommand() + " is running, it must complete before " + string + " can run");
        }
        this.setProcessResultNotYetAvailable(processCommand.commandName());
        switch (processCommand) {
            case ALIGN_SPL: {
                return this.processAlignSpl(processMeasurements, response, list, processCommand);
            }
            case APPLY_SMOOTHING: {
                return this.processSmoothing(processMeasurements, response, list, processCommand);
            }
            case VECTOR_AVERAGE: {
                if (!sD2.C()) {
                    return APIResponse.badRequest(response, MeasurementsService.measurementsAtMax());
                }
                return this.processVectorAverage(response, list, processCommand);
            }
            case RMS_AVERAGE: {
                if (!sD2.C()) {
                    return APIResponse.badRequest(response, MeasurementsService.measurementsAtMax());
                }
                return this.processRMSAverage(response, list, processCommand);
            }
            case DB_AVERAGE: {
                if (!sD2.C()) {
                    return APIResponse.badRequest(response, MeasurementsService.measurementsAtMax());
                }
                return this.processdBAverage(response, list, processCommand);
            }
            case ARITHMETIC: {
                if (!sD2.C()) {
                    return APIResponse.badRequest(response, MeasurementsService.measurementsAtMax());
                }
                return this.processArithmetic(processMeasurements, response, list, processCommand);
            }
            case CROSS_CORR_ALIGN: {
                return this.processCrossCorrAlign(response, list, processCommand);
            }
            case TIME_ALIGN: {
                return this.processTimeAlign(response, list, processCommand);
            }
            case ALIGN_IR_START: {
                return this.processIRStartAlign(response, list, processCommand);
            }
            case REMOVE_IR_DELAYS: {
                return this.processRemoveIRDelays(response, list, processCommand);
            }
        }
        assert (false) : "Unhandled enum type";
        processResult = null;
        return APIResponse.notImplemented(response, string + " is not implemented yet");
    }

    private APIResponse processCrossCorrAlign(Response response, List<Integer> list, ProcessCommand processCommand) {
        SD sD2 = RoomEQ_Wizard.w();
        ArrayList<MeasData> arrayList = new ArrayList<MeasData>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        HashMap hashMap = new HashMap();
        for (Integer object : list) {
            MeasData n3 = sD2.D(object - 1);
            if (!n3.hasIR()) {
                arrayList2.add(object);
                continue;
            }
            int arrayList3 = (int)Math.round(n3.getSampleRate());
            if (!hashMap.containsKey(arrayList3)) {
                hashMap.put(arrayList3, new ArrayList());
            }
            ((ArrayList)hashMap.get(arrayList3)).add(object);
            arrayList.add(n3);
        }
        if (!arrayList2.isEmpty()) {
            processResult = null;
            return this.handleMeasurementsMissingIR(arrayList2, response);
        }
        if (arrayList.size() < 2) {
            processResult = null;
            return APIResponse.badRequest(response, processCommand.commandName() + " requires at least two measurements");
        }
        if (hashMap.keySet().size() > 1) {
            processResult = null;
            StringBuilder stringBuilder = new StringBuilder(processCommand.commandName() + " requires that all the measurements have the same sample rate, but ");
            Iterator iterator = hashMap.keySet().iterator();
            while (iterator.hasNext()) {
                boolean bl;
                int n2 = (Integer)iterator.next();
                ArrayList arrayList3 = (ArrayList)hashMap.get(n2);
                stringBuilder.append(" ").append(arrayList3.get(0));
                boolean bl2 = bl = arrayList3.size() > 1;
                if (bl) {
                    for (int i2 = 1; i2 < arrayList3.size(); ++i2) {
                        stringBuilder.append(", ").append(arrayList3.get(i2));
                    }
                }
                stringBuilder.append(bl ? " are " : " is ").append(HE.A((double)n2)).append("; ");
            }
            return APIResponse.badRequest(response, stringBuilder.toString());
        }
        AK.A(arrayList, (tF)this, processCommand.commandName());
        return API.commandAccepted(response, processCommand.commandName());
    }

    private APIResponse handleMeasurementsMissingIR(ArrayList<Integer> arrayList, Response response) {
        StringBuilder stringBuilder = new StringBuilder("The measurement");
        StringBuilder stringBuilder2 = new StringBuilder("" + arrayList.get(0));
        if (arrayList.size() > 1) {
            stringBuilder.append("s");
            for (int i2 = 1; i2 < arrayList.size(); ++i2) {
                stringBuilder2.append(", ").append(arrayList.get(i2));
            }
        }
        stringBuilder.append(" at ").append(stringBuilder2.toString());
        stringBuilder.append(arrayList.size() > 1 ? " do " : " does ").append("not have an impulse response");
        return APIResponse.badRequest(response, stringBuilder.toString());
    }

    private APIResponse processTimeAlign(Response response, List<Integer> list, ProcessCommand processCommand) {
        SD sD2 = RoomEQ_Wizard.w();
        ArrayList<MeasData> arrayList = new ArrayList<MeasData>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        for (Integer n2 : list) {
            MeasData measData = sD2.D(n2 - 1);
            if (!measData.hasIR()) {
                arrayList2.add(n2);
                continue;
            }
            arrayList.add(measData);
        }
        if (!arrayList2.isEmpty()) {
            processResult = null;
            return this.handleMeasurementsMissingIR(arrayList2, response);
        }
        AK.D(arrayList, (tF)this, processCommand.commandName());
        return API.commandAccepted(response, processCommand.commandName());
    }

    private APIResponse processIRStartAlign(Response response, List<Integer> list, ProcessCommand processCommand) {
        SD sD2 = RoomEQ_Wizard.w();
        ArrayList<MeasData> arrayList = new ArrayList<MeasData>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        for (Integer n2 : list) {
            MeasData measData = sD2.D(n2 - 1);
            if (!measData.hasIR()) {
                arrayList2.add(n2);
                continue;
            }
            arrayList.add(measData);
        }
        if (!arrayList2.isEmpty()) {
            processResult = null;
            return this.handleMeasurementsMissingIR(arrayList2, response);
        }
        AK.B(arrayList, (tF)this, processCommand.commandName());
        return API.commandAccepted(response, processCommand.commandName());
    }

    private APIResponse processRemoveIRDelays(Response response, List<Integer> list, ProcessCommand processCommand) {
        SD sD2 = RoomEQ_Wizard.w();
        ArrayList<MeasData> arrayList = new ArrayList<MeasData>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        for (Integer n2 : list) {
            MeasData measData = sD2.D(n2 - 1);
            if (!measData.hasIR()) {
                arrayList2.add(n2);
                continue;
            }
            arrayList.add(measData);
        }
        if (!arrayList2.isEmpty()) {
            processResult = null;
            return this.handleMeasurementsMissingIR(arrayList2, response);
        }
        qG qG2 = new qG(arrayList, null, this, processCommand.commandName());
        qG2.execute();
        return API.commandAccepted(response, processCommand.commandName());
    }

    private APIResponse processVectorAverage(Response response, List<Integer> list, ProcessCommand processCommand) {
        SD sD2 = RoomEQ_Wizard.w();
        ArrayList<MeasData> arrayList = new ArrayList<MeasData>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        for (Integer n2 : list) {
            MeasData measData = sD2.D(n2 - 1);
            if (!measData.hasIR()) {
                arrayList2.add(n2);
                continue;
            }
            arrayList.add(measData);
        }
        if (!arrayList2.isEmpty()) {
            processResult = null;
            return this.handleMeasurementsMissingIR(arrayList2, response);
        }
        if (arrayList.size() < 2) {
            processResult = null;
            return APIResponse.badRequest(response, processCommand.commandName() + " requires at least two measurements");
        }
        AK.C(arrayList, (tF)this, processCommand.commandName());
        return API.commandAccepted(response, processCommand.commandName());
    }

    private APIResponse processRMSAverage(Response response, List<Integer> list, ProcessCommand processCommand) {
        SD sD2 = RoomEQ_Wizard.w();
        ArrayList<MeasData> arrayList = new ArrayList<MeasData>();
        for (Integer n2 : list) {
            MeasData measData = sD2.D(n2 - 1);
            if (measData.isSteppedLevel()) {
                processResult = null;
                return APIResponse.badRequest(response, "The measurement at " + n2 + " is a stepped level measurement and cannot be averaged");
            }
            arrayList.add(measData);
        }
        allSPL.A(arrayList, false);
        this.setCompletedProcessResults(processCommand.commandName(), null);
        return APIResponse.ok(response, processCommand.commandName() + " completed");
    }

    private APIResponse processdBAverage(Response response, List<Integer> list, ProcessCommand processCommand) {
        SD sD2 = RoomEQ_Wizard.w();
        ArrayList<MeasData> arrayList = new ArrayList<MeasData>();
        for (Integer n2 : list) {
            MeasData measData = sD2.D(n2 - 1);
            if (measData.isSteppedLevel()) {
                processResult = null;
                return APIResponse.badRequest(response, "The measurement at " + n2 + " is a stepped level measurement and cannot be averaged");
            }
            arrayList.add(measData);
        }
        allSPL.A(arrayList, true);
        this.setCompletedProcessResults(processCommand.commandName(), null);
        return APIResponse.ok(response, processCommand.commandName() + " completed");
    }

    private APIResponse processSmoothing(ProcessMeasurements processMeasurements, Response response, List<Integer> list, ProcessCommand processCommand) {
        Map<String, String> map = processMeasurements.getParameters();
        String string = MeasurementsService.getSMOOTHING_KEY();
        ArrayList<String> arrayList = API.checkForMissingParameters(map, string);
        if (!arrayList.isEmpty()) {
            processResult = null;
            return API.handleMissingParameters(arrayList, response);
        }
        String string2 = map.get(string).trim();
        kJ kJ2 = kJ.A(string2);
        if (kJ2 == null) {
            processResult = null;
            ValidValues validValues = ValidValues.builder().message(string2 + " is not a recognised smoothing").validValues(MeasurementsService.getSmoothingChoices()).build();
            return APIResponse.badRequest(response, validValues);
        }
        SD sD2 = RoomEQ_Wizard.w();
        ArrayList<MeasData> arrayList2 = new ArrayList<MeasData>();
        for (Integer serializable : list) {
            MeasData measData = sD2.D(serializable - 1);
            if (!measData.isSPLData()) {
                processResult = null;
                return APIResponse.badRequest(response, "The measurement at " + serializable + " is not an SPL measurement");
            }
            arrayList2.add(measData);
        }
        for (MeasData measData : arrayList2) {
            measData.smooth(kJ2.C(), false);
        }
        this.setCompletedProcessResults(processCommand.commandName(), null);
        return APIResponse.ok(response, "Smoothing applied");
    }

    private void setCompletedProcessResults(String string, Map<Integer, Map<String, String>> map) {
        SingleMeasurementCommand singleMeasurementCommand;
        API.clearCommand();
        if (map == null && (singleMeasurementCommand = SingleMeasurementCommand.getFromCommandName(string)) != null && singleMeasurementCommand.generatesCSD() && csd != null) {
            map = new TreeMap<Integer, Map<String, String>>();
            Map<String, String> map2 = MeasurementsService.produceCSDResult(csd, amplitude, false);
            map.put(0, map2);
        }
        processResult = ProcessResult.builder().processName(string).message("Completed").results(map).build();
        this.publishProcessResultIfRequired();
    }

    private static Map<String, String> produceCSDResult(PB pB2, SpectrogramAmplitude spectrogramAmplitude, boolean bl) {
        boolean bl2 = pB2.S() == SpectrogramMode.BURST_DECAY;
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        float[] fArray = pB2.N();
        int n2 = pB2.C(0);
        float[] fArray2 = new float[fArray.length - n2];
        System.arraycopy(fArray, n2, fArray2, 0, fArray2.length);
        treeMap.put("Frequencies", API.encodeArray(fArray2));
        int n3 = pB2.M();
        double d2 = pB2.K();
        float[] fArray3 = new float[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            fArray3[i2] = (float)(d2 + pB2.H() * (double)i2);
        }
        treeMap.put(bl2 ? "Periods" : "Times", API.encodeArray(fArray3));
        float[][] fArray4 = bl && pB2.B() != null ? pB2.B() : pB2.I();
        for (int i3 = 0; i3 < n3; ++i3) {
            float[] fArray5 = new float[fArray.length - n2];
            for (int i4 = n2; i4 < fArray.length; ++i4) {
                fArray5[i4 - n2] = (float)pB2.A(spectrogramAmplitude, (double)fArray4[i3][i4]);
            }
            treeMap.put("" + i3, API.encodeArray(fArray5));
        }
        return treeMap;
    }

    private void publishProcessResultIfRequired() {
        if (processResultUrl != null) {
            Subscriber subscriber = Subscriber.builder().url(processResultUrl.toString()).build();
            Publisher.postToSubscriber(subscriber, processResult);
        }
    }

    @Override
    public void taskCompleted(String string, Map<Integer, Map<String, String>> map) {
        this.setCompletedProcessResults(string, map);
    }

    private APIResponse processAlignSpl(ProcessMeasurements processMeasurements, Response response, List<Integer> list, ProcessCommand processCommand) {
        double d2;
        double d3;
        Map<String, String> map = processMeasurements.getParameters();
        String string = "targetdB";
        String string2 = "frequencyHz";
        String string3 = "spanOctaves";
        ArrayList<String> arrayList = API.checkForMissingParameters(map, "targetdB", "frequencyHz", "spanOctaves");
        if (!arrayList.isEmpty()) {
            return API.handleMissingParameters(arrayList, response);
        }
        String string4 = "average";
        String string5 = "dB";
        String string6 = "Hz";
        String string7 = "oct";
        boolean bl = false;
        double d4 = 0.0;
        String string8 = map.get("targetdB").trim();
        if (string8.equalsIgnoreCase("average")) {
            bl = true;
        } else {
            try {
                d4 = Double.parseDouble(MeasurementsService.stripUnit(string8, "dB"));
            }
            catch (NumberFormatException numberFormatException) {
                return APIResponse.badRequest(response, map.get("targetdB") + " could not be processed to get a target level to use. It should either be \"" + "average" + "\" to use the average levelof the measurements or a dB SPL figure, such as \"75.0\"");
            }
        }
        try {
            d3 = Double.parseDouble(MeasurementsService.stripUnit(map.get("frequencyHz").trim(), "Hz"));
        }
        catch (NumberFormatException numberFormatException) {
            return APIResponse.badRequest(response, map.get("frequencyHz") + " could not be processed to get a centre frequency to use. It should be a frequency in Hz, such as \"1000\"");
        }
        try {
            d2 = Double.parseDouble(MeasurementsService.stripUnit(map.get("spanOctaves").trim(), "oct"));
        }
        catch (NumberFormatException numberFormatException) {
            return APIResponse.badRequest(response, map.get("spanOctaves") + " could not be processed to get a span to use. It should be a number of octaves, such as \"2\"");
        }
        SD sD2 = RoomEQ_Wizard.w();
        ArrayList<MeasData> arrayList2 = new ArrayList<MeasData>();
        for (Integer n2 : list) {
            MeasData measData = sD2.D(n2 - 1);
            if (!measData.isSPLData()) {
                return APIResponse.badRequest(response, "The measurement at " + n2 + " is not an SPL measurement");
            }
            arrayList2.add(measData);
        }
        jA jA2 = new jA();
        if (jA2.A(arrayList2, false, true)) {
            if (!(d3 > (double)jA2.J) || !(d3 < (double)jA2.L)) {
                return APIResponse.badRequest(response, "The centre frequency " + d3 + " is not within the overlapping frequency range of the measurements, which is " + jA2.J + " to " + jA2.L + " Hz");
            }
        } else {
            return APIResponse.badRequest(response, "The measurements do not have overlapping frequency ranges");
        }
        double d5 = Math.pow(2.0, 0.5 * d2);
        UJ.A(arrayList2, d3 / d5, d3 * d5, d4, bl);
        TreeMap<Integer, Map<String, String>> treeMap = new TreeMap<Integer, Map<String, String>>();
        for (Integer n3 : list) {
            MeasData measData = sD2.D(n3 - 1);
            TreeMap<String, String> treeMap2 = new TreeMap<String, String>();
            treeMap2.put("alignSPLOffsetdB", HE.L.format(measData.getAlignSPLOffset()));
            treeMap.put(n3, treeMap2);
        }
        this.setCompletedProcessResults(processCommand.commandName(), treeMap);
        return APIResponse.ok(response, processCommand.commandName() + " completed");
    }

    private static String stripUnit(String string, String string2) {
        if (string.toLowerCase().endsWith(string2.toLowerCase())) {
            return string.substring(0, string.length() - string2.length()).trim();
        }
        return string;
    }

    private APIResponse processArithmetic(ProcessMeasurements processMeasurements, Response response, List<Integer> list, ProcessCommand processCommand) {
        Object object;
        MeasData[] measDataArray;
        Object object2;
        Object object3;
        Object object4;
        Object object6;
        Object object7;
        Object object8;
        Serializable serializable;
        if (list.size() != 2) {
            processResult = null;
            return APIResponse.badRequest(response, "There must be two measurement indices in an arithmetic request");
        }
        Map<String, String> map = processMeasurements.getParameters();
        String string = "function";
        ArrayList<String> arrayList = API.checkForMissingParameters(map, "function");
        if (!arrayList.isEmpty()) {
            processResult = null;
            return API.handleMissingParameters(arrayList, response);
        }
        String string2 = map.get("function").trim();
        u u2 = u.A(string2);
        if (u2 == null) {
            processResult = null;
            ValidValues validValues = ValidValues.builder().message(string2 + " is not a recognised arithmetic function").validValues(this.getArithmeticFunctions()).build();
            return APIResponse.badRequest(response, validValues);
        }
        ArrayList<String> arrayList2 = u2.B();
        if (!arrayList2.isEmpty() && !((ArrayList)(serializable = API.checkForMissingParameters(map, arrayList2))).isEmpty()) {
            processResult = null;
            return API.handleMissingParameters((ArrayList<String>)serializable, response);
        }
        serializable = Double.valueOf(0.0);
        Double d2 = 0.0;
        Double d3 = 0.0;
        Integer n2 = null;
        Integer n3 = null;
        Integer n4 = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (u2.C()) {
            String string3;
            object8 = u.b();
            object7 = u.S();
            object6 = "lowerLimit";
            String object52 = "upperLimit";
            object4 = u.I();
            object3 = "mergeBlend";
            object2 = "targetLevel";
            measDataArray = "autoTarget";
            String string4 = "excludeNotches";
            object = "dB";
            String string5 = "Hz";
            String string6 = "%";
            if (map.containsKey(object8)) {
                string3 = map.get(object8).trim();
                try {
                    serializable = Double.valueOf(MeasurementsService.stripUnit(string3, "%"));
                }
                catch (NumberFormatException numberFormatException) {
                    processResult = null;
                    return APIResponse.badRequest(response, string3 + " could not be processed to get a regularisation value to use. It should be a percentage figure, such as \"0.5\"");
                }
            }
            if (map.containsKey(object7)) {
                string3 = map.get(object7).trim();
                try {
                    d3 = Double.valueOf(MeasurementsService.stripUnit(string3, "dB"));
                }
                catch (NumberFormatException numberFormatException) {
                    processResult = null;
                    return APIResponse.badRequest(response, string3 + " could not be processed to get a maxgain value to use. It should be a dB figure, such as \"3.0\"");
                }
            }
            if (map.containsKey("lowerLimit")) {
                string3 = map.get("lowerLimit").trim();
                try {
                    n2 = Double.valueOf(MeasurementsService.stripUnit(string3, "Hz")).intValue();
                }
                catch (NumberFormatException numberFormatException) {
                    processResult = null;
                    return APIResponse.badRequest(response, string3 + " could not be processed to get a lower limit frequency to use. It should be a frequency in Hz, such as \"100\"");
                }
            }
            if (map.containsKey("upperLimit")) {
                string3 = map.get("upperLimit").trim();
                try {
                    n3 = Double.valueOf(MeasurementsService.stripUnit(string3, "Hz")).intValue();
                }
                catch (NumberFormatException numberFormatException) {
                    processResult = null;
                    return APIResponse.badRequest(response, string3 + " could not be processed to get an upper limit frequency to use. It should be a frequency in Hz, such as \"1000\"");
                }
            }
            if (map.containsKey(object4)) {
                string3 = map.get(object4).trim();
                try {
                    n4 = Double.valueOf(MeasurementsService.stripUnit(string3, "Hz")).intValue();
                }
                catch (NumberFormatException numberFormatException) {
                    processResult = null;
                    return APIResponse.badRequest(response, string3 + " could not be processed to get a merge frequency to use. It should be a frequency in Hz, such as \"200\"");
                }
            }
            if (map.containsKey("targetLevel")) {
                string3 = map.get("targetLevel").trim();
                try {
                    d2 = Double.valueOf(MeasurementsService.stripUnit(string3, "dB"));
                }
                catch (NumberFormatException numberFormatException) {
                    processResult = null;
                    return APIResponse.badRequest(response, string3 + " could not be processed to get a target level to use. It should be a dB figure, such as \"0.0\"");
                }
            }
            if (map.containsKey("mergeBlend")) {
                string3 = map.get("mergeBlend").trim();
                bl = Boolean.parseBoolean(string3);
            }
            if (map.containsKey("autoTarget")) {
                string3 = map.get("autoTarget").trim();
                bl2 = Boolean.parseBoolean(string3);
            }
            if (map.containsKey("excludeNotches")) {
                string3 = map.get("excludeNotches").trim();
                bl3 = Boolean.parseBoolean(string3);
            }
        }
        object8 = RoomEQ_Wizard.w();
        object7 = new ArrayList();
        for (Integer n5 : list) {
            object4 = ((SD)object8).D(n5 - 1);
            if (!AK.f((MeasData)object4)) {
                processResult = null;
                return APIResponse.badRequest(response, "The measurement at index " + n5 + " cannot be used for arithmetic");
            }
            ((ArrayList)object7).add(object4);
        }
        object6 = (MeasData)((ArrayList)object7).get(0);
        MeasData measData = (MeasData)((ArrayList)object7).get(1);
        object2 = new jA();
        object4 = u2.R() ? measData : object6;
        measDataArray = new MeasData[]{object4, object3 = u2.O() ? object6 : measData};
        if (!((jA)object2).A(measDataArray, u2.B((MeasData)object4, (MeasData)object3), true)) {
            processResult = null;
            return APIResponse.badRequest(response, "The measurements cannot be used for arithmetic, check the error log for the reason");
        }
        if (u2.G()) {
            double d4;
            u2.E(n4.intValue());
            double d5 = d4 = bl ? HH.A() : 1.0;
            if ((double)n4.intValue() * d4 > (double)measData.getEndFreq()) {
                processResult = null;
                return APIResponse.badRequest(response, "The selected merge frequency span is past the end of measurement B, " + measData.getTitle());
            }
            if ((double)n4.intValue() / d4 < (double)((MeasData)object6).getStartFreq()) {
                processResult = null;
                return APIResponse.badRequest(response, "The selected merge frequency span is before the start of measurement A, " + ((MeasData)object6).getTitle());
            }
            if ((double)n4.intValue() / d4 < (double)measData.getStartFreq()) {
                processResult = null;
                return APIResponse.badRequest(response, "The selected merge frequency span is before the start of measurement B, " + measData.getTitle());
            }
        } else if (u2.W()) {
            u2.E((Double)serializable / 100.0);
        } else if (u2.a()) {
            u2.E(d3);
        }
        BG bG2 = BG.G().A(u2).A(measDataArray).A((jA)object2).A((String)null).B((String)null).C(n2 != null).A(n3 != null).A(n2).B(n3).D(bl).A(d2).E(bl2).B(bl3).A();
        object = new HH(bG2, this, processCommand.commandName());
        ((SwingWorker)object).execute();
        return API.commandAccepted(response, string2);
    }

    public ProcessResult getProcessResult() {
        if (processResult == null) {
            return ProcessResult.builder().processName("").message("There is no process").build();
        }
        return processResult;
    }

    public List<String> getSingleCommands() {
        if (singleCommands == null) {
            singleCommands = new ArrayList<String>();
            for (SingleMeasurementCommand singleMeasurementCommand : SingleMeasurementCommand.values()) {
                singleCommands.add(singleMeasurementCommand.commandName());
            }
        }
        return singleCommands;
    }

    public APIResponse runSingleCommand(ProcessSingleMeasurement processSingleMeasurement, Response response, int n2) {
        if (processSingleMeasurement.getCommand() == null) {
            return APIResponse.badRequest(response, "No command in the request");
        }
        String string = processSingleMeasurement.getCommand();
        SingleMeasurementCommand singleMeasurementCommand = SingleMeasurementCommand.getFromCommandName(string);
        if (singleMeasurementCommand == null) {
            ValidValues validValues = ValidValues.builder().message(string + " is not a recognised command").validValues(this.getSingleCommands()).build();
            return APIResponse.badRequest(response, validValues);
        }
        processResultUrl = null;
        processResult = null;
        String string2 = processSingleMeasurement.getResultUrl();
        if (string2 != null && !string2.isEmpty()) {
            try {
                processResultUrl = new URL(URLDecoder.decode(processSingleMeasurement.getResultUrl(), StandardCharsets.UTF_8.toString()));
            }
            catch (UnsupportedEncodingException | MalformedURLException iOException) {
                return APIResponse.badRequest(response, string2 + " is not a properly formatted URL");
            }
        }
        if (API.runningACommand()) {
            return APIResponse.badRequest(response, API.getRunningCommand() + " is running, it must complete before " + string + " can run");
        }
        SD sD2 = RoomEQ_Wizard.w();
        MeasData measData = sD2.D(n2);
        switch (singleMeasurementCommand) {
            case SAVE: {
                return this.handleSaveCommand(processSingleMeasurement, response, measData, string);
            }
            case APPLY_SMOOTHING: {
                return this.handleSmoothingCommand(processSingleMeasurement, response, measData, string);
            }
            case RESPONSE_COPY: {
                if (!sD2.C()) {
                    return APIResponse.badRequest(response, MeasurementsService.measurementsAtMax());
                }
                this.setProcessResultNotYetAvailable(string);
                AK.A(measData, (tF)this, string);
                return API.commandAccepted(response, string);
            }
            case GENERATE_WATERFALL: 
            case GENERATE_EQ_WATERFALL: {
                return this.handleWaterfallCommand(processSingleMeasurement, response, measData, n2, singleMeasurementCommand);
            }
            case GENERATE_SPECTROGRAM: 
            case GENERATE_EQ_SPECTROGRAM: {
                return this.handleSpectrogramCommand(processSingleMeasurement, response, measData, n2, singleMeasurementCommand);
            }
            case MIC_IN_BOX: {
                if (!sD2.C()) {
                    return APIResponse.badRequest(response, MeasurementsService.measurementsAtMax());
                }
                if (!measData.isSPLData()) {
                    return APIResponse.badRequest(response, measData.getTitle() + " at " + (n2 + 1) + " is not an SPL measurement");
                }
                this.setProcessResultNotYetAvailable(string);
                AK.C(measData, (tF)this, string);
                return API.commandAccepted(response, string);
            }
            case TRIM_IR: {
                if (!sD2.C()) {
                    return APIResponse.badRequest(response, MeasurementsService.measurementsAtMax());
                }
                if (!measData.hasIR()) {
                    return APIResponse.badRequest(response, measData.getTitle() + " at " + (n2 + 1) + " does not have an impulse response");
                }
                this.setProcessResultNotYetAvailable(string);
                AK.B(measData, (tF)this, string);
                return API.commandAccepted(response, string);
            }
            case MERGE_CAL: {
                if (!sD2.C()) {
                    return APIResponse.badRequest(response, MeasurementsService.measurementsAtMax());
                }
                if (!measData.hasIR()) {
                    return APIResponse.badRequest(response, measData.getTitle() + " at " + (n2 + 1) + " does not have an impulse response");
                }
                if (!measData.hasMeterCal() && !measData.hasScCal()) {
                    return APIResponse.badRequest(response, measData.getTitle() + " at " + (n2 + 1) + " does not have any cal data");
                }
                this.setProcessResultNotYetAvailable(string);
                AK.D(measData, (tF)this, string);
                return API.commandAccepted(response, string);
            }
            case EXCESS_PHASE: 
            case MIN_PHASE: {
                if (!sD2.C()) {
                    return APIResponse.badRequest(response, MeasurementsService.measurementsAtMax());
                }
                if (!measData.allowsMinPhaseCopy()) {
                    return APIResponse.badRequest(response, measData.getTitle() + " at " + (n2 + 1) + " is a " + measData.getSourceTypeDescription() + " measurement and cannot generate a minimum phase version");
                }
                return this.handleMinOrExcessPhaseCommand(processSingleMeasurement, response, measData, string);
            }
            case ESTIMATE_IR_DELAY: {
                if (!measData.hasIR()) {
                    return APIResponse.badRequest(response, measData.getTitle() + " at " + (n2 + 1) + " does not have an impulse response");
                }
                this.setProcessResultNotYetAvailable(string);
                GD gD2 = new GD(measData, this, string);
                gD2.execute();
                return API.commandAccepted(response, string);
            }
            case OFFSET_T_ZERO: {
                if (!measData.hasIR()) {
                    return APIResponse.badRequest(response, measData.getTitle() + " at " + (n2 + 1) + " does not have an impulse response");
                }
                return this.handleTZeroOffsetCommand(processSingleMeasurement, response, measData, string);
            }
            case ADD_SPL_OFFSET: {
                if (!measData.isSPLData()) {
                    return APIResponse.badRequest(response, measData.getTitle() + " at " + (n2 + 1) + " is not an SPL measurement");
                }
                return this.handleSPLOffsetCommand(processSingleMeasurement, response, measData, string);
            }
        }
        assert (false) : "Unhandled enum type";
        processResult = null;
        return APIResponse.notImplemented(response, string + " is not implemented yet");
    }

    private void setProcessResultNotYetAvailable(String string) {
        processResult = ProcessResult.builder().processName(string).message("Result not yet available").build();
    }

    private APIResponse handleWaterfallCommand(ProcessSingleMeasurement processSingleMeasurement, Response response, MeasData measData, int n2, SingleMeasurementCommand singleMeasurementCommand) {
        if (!measData.isSPLData()) {
            return APIResponse.badRequest(response, measData.getTitle() + " at " + (n2 + 1) + " is not an SPL measurement");
        }
        if (!measData.hasIR()) {
            return APIResponse.badRequest(response, measData.getTitle() + " at " + (n2 + 1) + " does not have an impulse response");
        }
        Map<String, String> map = processSingleMeasurement.getParameters();
        ArrayList<String> arrayList = API.checkForMissingParameters(map, MODE_KEY, SLICES_KEY);
        if (!arrayList.isEmpty()) {
            return API.handleMissingParameters(arrayList, response);
        }
        String string = map.get(MODE_KEY).trim();
        SpectrogramMode spectrogramMode = SpectrogramMode.getFromApiName(string);
        if (spectrogramMode == null || !gG.B(spectrogramMode)) {
            ValidValues validValues = ValidValues.builder().message(string + " is not a valid waterfall mode").validValues(gG.\u0171()).build();
            return APIResponse.badRequest(response, validValues);
        }
        String string2 = map.get(SLICES_KEY).trim();
        Double d2 = this.getDoubleFromParam(string2);
        if (d2 == null) {
            return APIResponse.badRequest(response, map.get(SLICES_KEY) + " is not a valid number of slices");
        }
        Integer n3 = d2.intValue();
        if (n3 < gG.\u016d() || n3 > gG.\u016f()) {
            return APIResponse.badRequest(response, string2 + " is not a valid number of slices, the range is " + gG.\u016d() + " to " + gG.\u016f());
        }
        csd = null;
        MeasData measData2 = measData;
        MeasData measData3 = singleMeasurementCommand == SingleMeasurementCommand.GENERATE_EQ_WATERFALL && measData.hasEqualisedMeas() ? measData.getEqualisedMeas() : measData;
        switch (spectrogramMode) {
            case STFT: {
                arrayList = API.checkForMissingParameters(map, LEFT_WINDOW_TYPE_KEY, RIGHT_WINDOW_TYPE_KEY, WINDOW_WIDTH_KEY, RANGE_KEY, RISETIME_KEY, AS_CSD_KEY, PPO_KEY, SMOOTHING_KEY);
                if (!arrayList.isEmpty()) {
                    return API.handleMissingParameters(arrayList, response);
                }
                Double d3 = this.getDoubleFromParam(map.get(WINDOW_WIDTH_KEY));
                if (d3 == null) {
                    return APIResponse.badRequest(response, map.get(WINDOW_WIDTH_KEY) + " is not a valid window width in ms");
                }
                Double d4 = this.getDoubleFromParam(map.get(RANGE_KEY));
                if (d4 == null) {
                    return APIResponse.badRequest(response, map.get(RANGE_KEY) + " is not a valid time range ms");
                }
                Double d5 = this.getDoubleFromParam(map.get(RISETIME_KEY));
                if (d5 == null) {
                    return APIResponse.badRequest(response, map.get(RISETIME_KEY) + " is not a valid rise time ms");
                }
                Boolean bl = Boolean.valueOf(map.get(AS_CSD_KEY).trim());
                Double d6 = this.getDoubleFromParam(map.get(PPO_KEY));
                if (d6 == null) {
                    return APIResponse.badRequest(response, map.get(PPO_KEY) + " is not a valid points per octave");
                }
                String string3 = map.get(SMOOTHING_KEY);
                if (string3 == null) {
                    return APIResponse.badRequest(response, map.get(SMOOTHING_KEY) + " is not a valid points per octave");
                }
                kJ kJ2 = kJ.A(string3);
                if (kJ2 == null || !MeasurementsService.getFractionalOctaveSmoothingChoices().contains(kJ2.A())) {
                    ValidValues validValues = ValidValues.builder().message(string3 + " is not a valid smoothing").validValues(MeasurementsService.getFractionalOctaveSmoothingChoices()).build();
                    return APIResponse.badRequest(response, validValues);
                }
                List<Window.Types> list = Arrays.asList(Window.Types.leftRightSet());
                String string4 = map.get(LEFT_WINDOW_TYPE_KEY);
                if (string4 == null || string4.isEmpty()) {
                    return APIResponse.badRequest(response, map.get(LEFT_WINDOW_TYPE_KEY) + " is not a valid window type");
                }
                Window.Types types = Window.Types.getTypeFromDescription(string4);
                if (types == null || !list.contains((Object)types)) {
                    ValidValues validValues = ValidValues.builder().message(string4 + " is not a window type the spectrogram accepts").validValues(MeasurementsService.getWindowChoices()).build();
                    return APIResponse.badRequest(response, validValues);
                }
                String string5 = map.get(RIGHT_WINDOW_TYPE_KEY);
                if (string5 == null || string5.isEmpty()) {
                    return APIResponse.badRequest(response, map.get(RIGHT_WINDOW_TYPE_KEY) + " is not a valid window type");
                }
                Window.Types types2 = Window.Types.getTypeFromDescription(string5);
                if (types2 == null || !list.contains((Object)types2)) {
                    ValidValues validValues = ValidValues.builder().message(string5 + " is not a window type the spectrogram accepts").validValues(MeasurementsService.getWindowChoices()).build();
                    return APIResponse.badRequest(response, validValues);
                }
                NK nK2 = NK.K().A(spectrogramMode).B(n3).B(d3 / 1000.0).C(d4 / 1000.0).A(d5 / 1000.0).A(bl).C(d6.intValue()).F((int)kJ2.C()).B(types).C(types2).A();
                csd = PB.B(measData3, measData2, nK2, this, singleMeasurementCommand.commandName());
                if (csd == null) {
                    return APIResponse.badRequest(response, "Unable to generate a waterfall with the parameters provided");
                }
                amplitude = SpectrogramAmplitude.LOG_DBSPL;
                this.setProcessResultNotYetAvailable(singleMeasurementCommand.commandName());
                return API.commandAccepted(response, singleMeasurementCommand.commandName());
            }
            case BURST_DECAY: {
                Integer n4;
                arrayList = API.checkForMissingParameters(map, BANDWIDTH_KEY, SPAN_PERIODS_KEY, PPO_KEY);
                if (!arrayList.isEmpty()) {
                    return API.handleMissingParameters(arrayList, response);
                }
                Double d7 = this.getDoubleFromParam(map.get(SPAN_PERIODS_KEY));
                if (d7 == null || !PB.A(d7.intValue())) {
                    String string6 = PB.C() + " to " + PB.E();
                    return APIResponse.badRequest(response, map.get(SPAN_PERIODS_KEY) + " is not a valid span in periods setting, valid is " + string6);
                }
                String string7 = map.get(BANDWIDTH_KEY).trim();
                if (string7 == null || !PB.G().contains(string7)) {
                    ValidValues validValues = ValidValues.builder().message(string7 + " is not a valid bandwidth").validValues(PB.G()).build();
                    return APIResponse.badRequest(response, validValues);
                }
                try {
                    n4 = Integer.valueOf(string7.substring(2));
                }
                catch (NumberFormatException numberFormatException) {
                    ValidValues validValues = ValidValues.builder().message(string7 + " is not a valid bandwidth").validValues(PB.G()).build();
                    return APIResponse.badRequest(response, validValues);
                }
                Double d8 = this.getDoubleFromParam(map.get(PPO_KEY));
                if (d8 == null) {
                    return APIResponse.badRequest(response, map.get(PPO_KEY) + " is not a valid points per octave");
                }
                NK nK3 = NK.K().A(spectrogramMode).B(n3).C(d8.intValue()).E(d7.intValue()).D(n4).C(measData3.isAudioData() ? lG.\u01c8() : lG.\u03e9()).A();
                csd = PB.B(measData3, measData2, nK3, this, singleMeasurementCommand.commandName());
                if (csd == null) {
                    return APIResponse.badRequest(response, "Unable to generate a waterfall with the parameters provided");
                }
                this.setProcessResultNotYetAvailable(singleMeasurementCommand.commandName());
                return API.commandAccepted(response, singleMeasurementCommand.commandName());
            }
        }
        assert (false) : "Unhandled enum type";
        return APIResponse.notImplemented(response, singleMeasurementCommand.commandName() + " is not implemented yet");
    }

    private APIResponse handleSpectrogramCommand(ProcessSingleMeasurement processSingleMeasurement, Response response, MeasData measData, int n2, SingleMeasurementCommand singleMeasurementCommand) {
        if (!measData.isSPLData()) {
            return APIResponse.badRequest(response, measData.getTitle() + " at " + (n2 + 1) + " is not an SPL measurement");
        }
        if (!measData.hasIR()) {
            return APIResponse.badRequest(response, measData.getTitle() + " at " + (n2 + 1) + " does not have an impulse response");
        }
        Map<String, String> map = processSingleMeasurement.getParameters();
        ArrayList<String> arrayList = API.checkForMissingParameters(map, MODE_KEY, SLICES_KEY, PPO_KEY, AMPLITUDE_KEY);
        if (!arrayList.isEmpty()) {
            return API.handleMissingParameters(arrayList, response);
        }
        String string = map.get(MODE_KEY).trim();
        SpectrogramMode spectrogramMode = SpectrogramMode.getFromApiName(string);
        if (spectrogramMode == null || !hA.A(spectrogramMode)) {
            ValidValues validValues = ValidValues.builder().message(string + " is not a valid spectrogram mode").validValues(hA.\u0103()).build();
            return APIResponse.badRequest(response, validValues);
        }
        String string2 = map.get(SLICES_KEY).trim();
        Double d2 = this.getDoubleFromParam(string2);
        if (d2 == null) {
            return APIResponse.badRequest(response, map.get(SLICES_KEY) + " is not a valid number of slices");
        }
        Integer n3 = d2.intValue();
        if (n3 < hA.\u0100() || n3 > hA.\u010e()) {
            return APIResponse.badRequest(response, string2 + " is not a valid number of slices, the range is " + hA.\u0100() + " to " + hA.\u010e());
        }
        Double d3 = this.getDoubleFromParam(map.get(PPO_KEY));
        if (d3 == null) {
            return APIResponse.badRequest(response, map.get(PPO_KEY) + " is not a valid points per octave");
        }
        String string3 = map.get(AMPLITUDE_KEY);
        if (string3 == null || string3.isEmpty()) {
            return APIResponse.badRequest(response, map.get(AMPLITUDE_KEY) + " is not a valid amplitude");
        }
        amplitude = SpectrogramAmplitude.getFromApiName(string3);
        if (amplitude == null) {
            ValidValues validValues = ValidValues.builder().message(string3 + " is not a recognised spectrogram amplitude").validValues(MeasurementsService.getAmplitudeChoices()).build();
            return APIResponse.badRequest(response, validValues);
        }
        csd = null;
        MeasData measData2 = measData;
        MeasData measData3 = singleMeasurementCommand == SingleMeasurementCommand.GENERATE_EQ_SPECTROGRAM && measData.hasEqualisedMeas() ? measData.getEqualisedMeas() : measData;
        switch (spectrogramMode) {
            case STFT: {
                Object object;
                arrayList = API.checkForMissingParameters(map, WINDOW_WIDTH_KEY, WINDOW_TYPE_KEY, BEFORE_KEY, AFTER_KEY);
                if (!arrayList.isEmpty()) {
                    return API.handleMissingParameters(arrayList, response);
                }
                Double d4 = this.getDoubleFromParam(map.get(WINDOW_WIDTH_KEY));
                if (d4 == null) {
                    return APIResponse.badRequest(response, map.get(WINDOW_WIDTH_KEY) + " is not a valid window width in ms");
                }
                String string4 = map.get(WINDOW_TYPE_KEY);
                if (string4 == null || string4.isEmpty()) {
                    return APIResponse.badRequest(response, map.get(WINDOW_TYPE_KEY) + " is not a valid window type");
                }
                Window.Types types = Window.Types.getTypeFromDescription(string4);
                List<Window.Types> list = Arrays.asList(Window.Types.leftRightSet());
                if (types == null || !list.contains((Object)types)) {
                    ValidValues validValues = ValidValues.builder().message(string4 + " is not a window type the spectrogram accepts").validValues(MeasurementsService.getWindowChoices()).build();
                    return APIResponse.badRequest(response, validValues);
                }
                double d5 = 0.0;
                double d6 = 0.0;
                arrayList = API.checkForMissingParameters(map, new String[0]);
                if (measData.isAudioData()) {
                    if (arrayList.size() < 2) {
                        return APIResponse.badRequest(response, "Audio data spectrograms are generated for the full response, before and after are not used");
                    }
                } else {
                    if (!arrayList.isEmpty()) {
                        return API.handleMissingParameters(arrayList, response);
                    }
                    object = this.getDoubleFromParam(map.get(BEFORE_KEY));
                    if (object == null) {
                        return APIResponse.badRequest(response, map.get(BEFORE_KEY) + " is not a valid before time range in ms");
                    }
                    d5 = (Double)object;
                    Double d7 = this.getDoubleFromParam(map.get(AFTER_KEY));
                    if (d7 == null) {
                        return APIResponse.badRequest(response, map.get(AFTER_KEY) + " is not a valid after time range in ms");
                    }
                    d6 = d7;
                }
                if ((csd = PB.A(measData3, measData2, (NK)(object = NK.K().A(spectrogramMode).B(n3).A(types).B(d4 / 1000.0).E(d5 / 1000.0).D(d6 / 1000.0).C(d3.intValue()).A()), this, singleMeasurementCommand.commandName())) == null) {
                    return APIResponse.badRequest(response, "Unable to generate a spectrogram with the parameters provided");
                }
                this.setProcessResultNotYetAvailable(singleMeasurementCommand.commandName());
                return API.commandAccepted(response, singleMeasurementCommand.commandName());
            }
            case BURST_DECAY: {
                Integer n4;
                arrayList = API.checkForMissingParameters(map, BANDWIDTH_KEY, SPAN_PERIODS_KEY, PPO_KEY);
                if (!arrayList.isEmpty()) {
                    return API.handleMissingParameters(arrayList, response);
                }
                Double d8 = this.getDoubleFromParam(map.get(SPAN_PERIODS_KEY));
                if (d8 == null || !PB.A(d8.intValue())) {
                    String string5 = PB.C() + " to " + PB.E();
                    return APIResponse.badRequest(response, map.get(SPAN_PERIODS_KEY) + " is not a valid span in periods setting, valid is " + string5);
                }
                String string6 = map.get(BANDWIDTH_KEY).trim();
                if (string6 == null || !PB.G().contains(string6)) {
                    ValidValues validValues = ValidValues.builder().message(string6 + " is not a valid bandwidth").validValues(PB.G()).build();
                    return APIResponse.badRequest(response, validValues);
                }
                try {
                    n4 = Integer.valueOf(string6.substring(2));
                }
                catch (NumberFormatException numberFormatException) {
                    ValidValues validValues = ValidValues.builder().message(string6 + " is not a valid bandwidth").validValues(PB.G()).build();
                    return APIResponse.badRequest(response, validValues);
                }
                NK nK2 = NK.K().A(spectrogramMode).B(n3).C(d3.intValue()).E(d8.intValue()).D(n4).A();
                csd = PB.A(measData3, measData2, nK2, this, singleMeasurementCommand.commandName());
                if (csd == null) {
                    return APIResponse.badRequest(response, "Unable to generate a spectrogram with the parameters provided");
                }
                this.setProcessResultNotYetAvailable(singleMeasurementCommand.commandName());
                return API.commandAccepted(response, singleMeasurementCommand.commandName());
            }
            case WAVELET: 
            case AIRYCWT: 
            case MORLETCWT: {
                Object object;
                Object object2;
                arrayList = API.checkForMissingParameters(map, BANDWIDTH_KEY, PPO_KEY, BEFORE_KEY, AFTER_KEY);
                if (!arrayList.isEmpty()) {
                    return API.handleMissingParameters(arrayList, response);
                }
                double d9 = 0.0;
                double d10 = 0.0;
                arrayList = API.checkForMissingParameters(map, new String[0]);
                if (measData.isAudioData()) {
                    if (arrayList.size() < 2) {
                        return APIResponse.badRequest(response, "Audio data spectrograms are generated for the full response, before and after are not used");
                    }
                } else {
                    if (!arrayList.isEmpty()) {
                        return API.handleMissingParameters(arrayList, response);
                    }
                    object2 = this.getDoubleFromParam(map.get(BEFORE_KEY));
                    if (object2 == null) {
                        return APIResponse.badRequest(response, map.get(BEFORE_KEY) + " is not a valid before time range in ms");
                    }
                    d9 = (Double)object2;
                    object = this.getDoubleFromParam(map.get(AFTER_KEY));
                    if (object == null) {
                        return APIResponse.badRequest(response, map.get(AFTER_KEY) + " is not a valid after time range in ms");
                    }
                    d10 = (Double)object;
                }
                if ((object2 = map.get(BANDWIDTH_KEY).trim()) == null || !PB.G().contains(object2)) {
                    object = ValidValues.builder().message((String)object2 + " is not a valid bandwidth").validValues(PB.G()).build();
                    return APIResponse.badRequest(response, (ValidValues)object);
                }
                try {
                    object = Integer.valueOf(((String)object2).substring(2));
                }
                catch (NumberFormatException numberFormatException) {
                    ValidValues validValues = ValidValues.builder().message((String)object2 + " is not a valid bandwidth").validValues(PB.G()).build();
                    return APIResponse.badRequest(response, validValues);
                }
                NK nK3 = NK.K().A(spectrogramMode).B(n3).C(d3.intValue()).E(d9 / 1000.0).D(d10 / 1000.0).A((Integer)object).A();
                csd = PB.A(measData3, measData2, nK3, this, singleMeasurementCommand.commandName());
                if (csd == null) {
                    return APIResponse.badRequest(response, "Unable to generate a spectrogram with the parameters provided");
                }
                this.setProcessResultNotYetAvailable(singleMeasurementCommand.commandName());
                return API.commandAccepted(response, singleMeasurementCommand.commandName());
            }
        }
        assert (false) : "Unhandled enum type";
        return APIResponse.notImplemented(response, singleMeasurementCommand.commandName() + " is not implemented yet");
    }

    private Double getDoubleFromParam(String string) {
        try {
            return Double.valueOf(string.trim());
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    private APIResponse handleMinOrExcessPhaseCommand(ProcessSingleMeasurement processSingleMeasurement, Response response, MeasData measData, String string) {
        Double d2;
        Comparable<Boolean> comparable;
        Map<String, String> map = processSingleMeasurement.getParameters();
        ArrayList<String> arrayList = API.checkForMissingParameters(map, APPEND_LF_TAIL_KEY, APPEND_HF_TAIL_KEY, INCLUDE_CAL_KEY);
        if (!arrayList.isEmpty()) {
            return API.handleMissingParameters(arrayList, response);
        }
        MinPhaseTails minPhaseTails = new MinPhaseTails();
        minPhaseTails.setIncludeCal(Boolean.parseBoolean(map.get(INCLUDE_CAL_KEY).trim()));
        Boolean bl = Boolean.valueOf(map.get(APPEND_LF_TAIL_KEY).trim());
        minPhaseTails.setAppendLFTail(bl);
        if (bl.booleanValue()) {
            arrayList = API.checkForMissingParameters(map, LF_TAIL_START_KEY, LF_TAIL_SLOPE_KEY);
            if (!arrayList.isEmpty()) {
                return API.handleMissingParameters(arrayList, response);
            }
            comparable = this.getDoubleFromParam(map.get(LF_TAIL_START_KEY));
            if (comparable == null) {
                return APIResponse.badRequest(response, map.get(LF_TAIL_START_KEY) + " is not a valid LF tail start frequency in Hz");
            }
            d2 = this.getDoubleFromParam(map.get(LF_TAIL_SLOPE_KEY));
            if (d2 == null) {
                return APIResponse.badRequest(response, map.get(LF_TAIL_SLOPE_KEY) + " is not a valid LF tail slope in dB/octave");
            }
            if (d2 < 0.0) {
                return APIResponse.badRequest(response, map.get(LF_TAIL_SLOPE_KEY) + " is not valid, LF tail slope cannot be negative");
            }
            minPhaseTails.setLfStart((Double)comparable);
            minPhaseTails.setLfSlope(d2 * wH.I());
        }
        comparable = Boolean.valueOf(map.get(APPEND_HF_TAIL_KEY).trim());
        minPhaseTails.setAppendHFTail((Boolean)comparable);
        if (((Boolean)comparable).booleanValue()) {
            arrayList = API.checkForMissingParameters(map, HF_TAIL_START_KEY, HF_TAIL_SLOPE_KEY, WARP_FREQ_KEY);
            if (!arrayList.isEmpty()) {
                return API.handleMissingParameters(arrayList, response);
            }
            d2 = this.getDoubleFromParam(map.get(HF_TAIL_START_KEY));
            if (d2 == null) {
                return APIResponse.badRequest(response, map.get(HF_TAIL_START_KEY) + " is not a valid HF tail start frequency in Hz");
            }
            Double d3 = this.getDoubleFromParam(map.get(HF_TAIL_SLOPE_KEY));
            if (d3 == null) {
                return APIResponse.badRequest(response, map.get(HF_TAIL_SLOPE_KEY) + " is not a valid HF tail slope in dB/octave");
            }
            if (d3 > 0.0) {
                return APIResponse.badRequest(response, map.get(HF_TAIL_SLOPE_KEY) + " is not valid, HF tail slope cannot be positive");
            }
            minPhaseTails.setHfStart(d2);
            minPhaseTails.setHfSlope(d3 * wH.I());
            minPhaseTails.setWarpFreq(Boolean.parseBoolean(map.get(WARP_FREQ_KEY).trim()));
        }
        if (!bl.booleanValue() && !((Boolean)comparable).booleanValue()) {
            arrayList = API.checkForMissingParameters(map, REPLICATE_DATA_KEY);
            if (!arrayList.isEmpty()) {
                return API.handleMissingParameters(arrayList, response);
            }
            minPhaseTails.setReplicateData(Boolean.parseBoolean(map.get(REPLICATE_DATA_KEY).trim()));
        }
        this.setProcessResultNotYetAvailable(string);
        if (string.toLowerCase().contains("excess")) {
            AK.A(measData, minPhaseTails, (tF)this, string);
        } else {
            AK.B(measData, minPhaseTails, this, string);
        }
        return API.commandAccepted(response, string);
    }

    private APIResponse handleSmoothingCommand(ProcessSingleMeasurement processSingleMeasurement, Response response, MeasData measData, String string) {
        Map<String, String> map = processSingleMeasurement.getParameters();
        String string2 = MeasurementsService.getSMOOTHING_KEY();
        ArrayList<String> arrayList = API.checkForMissingParameters(map, string2);
        if (!arrayList.isEmpty()) {
            return API.handleMissingParameters(arrayList, response);
        }
        String string3 = map.get(string2).trim();
        kJ kJ2 = kJ.A(string3);
        if (kJ2 == null) {
            ValidValues validValues = ValidValues.builder().message(string3 + " is not a recognised smoothing").validValues(MeasurementsService.getSmoothingChoices()).build();
            return APIResponse.badRequest(response, validValues);
        }
        if (kJ2.C() != measData.getOctaveFrac()) {
            measData.smooth(kJ2.C(), false);
        }
        this.setCompletedProcessResults(string, null);
        return APIResponse.ok(response, string + " completed");
    }

    private APIResponse handleTZeroOffsetCommand(ProcessSingleMeasurement processSingleMeasurement, Response response, MeasData measData, String string) {
        double d2;
        Map<String, String> map = processSingleMeasurement.getParameters();
        ArrayList<String> arrayList = API.checkForMissingParameters(map, OFFSET_KEY, "unit");
        if (!arrayList.isEmpty()) {
            return API.handleMissingParameters(arrayList, response);
        }
        String string2 = map.get(OFFSET_KEY).trim();
        try {
            d2 = Double.parseDouble(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return APIResponse.badRequest(response, string2 + " could not be processed to get an offset value to use");
        }
        String string3 = map.get("unit").trim();
        YF yF2 = YF.A(string3);
        if (yF2 == null) {
            ValidValues validValues = ValidValues.builder().message(string3 + " is not a recognised offset unit").validValues(MeasurementsService.getOffsetUnits()).build();
            return APIResponse.badRequest(response, validValues);
        }
        double d3 = 0.0;
        switch (yF2) {
            case F: {
                d3 = d2;
                break;
            }
            case B: {
                d3 = d2 / lG.\u00f1();
                break;
            }
            case G: {
                d3 = d2 * 0.3048 / lG.\u00f1();
                break;
            }
            case A: {
                d3 = d2 / measData.getSampleRate();
                break;
            }
            default: {
                assert (false) : "Unhandled enum type";
                break;
            }
        }
        measData.offsetIRStartAndWinRef(d3);
        this.setCompletedProcessResults(string, null);
        return APIResponse.ok(response, string + " completed");
    }

    private APIResponse handleSPLOffsetCommand(ProcessSingleMeasurement processSingleMeasurement, Response response, MeasData measData, String string) {
        double d2;
        Map<String, String> map = processSingleMeasurement.getParameters();
        ArrayList<String> arrayList = API.checkForMissingParameters(map, OFFSET_KEY);
        if (!arrayList.isEmpty()) {
            return API.handleMissingParameters(arrayList, response);
        }
        String string2 = map.get(OFFSET_KEY).trim();
        try {
            d2 = Double.parseDouble(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return APIResponse.badRequest(response, string2 + " could not be processed to get an offset value to use");
        }
        measData.addSPLOffset(d2);
        this.setCompletedProcessResults(string, null);
        return APIResponse.ok(response, string + " completed");
    }

    private APIResponse handleSaveCommand(ProcessSingleMeasurement processSingleMeasurement, Response response, MeasData measData, String string) {
        Map<String, String> map = processSingleMeasurement.getParameters();
        String string2 = "filename";
        ArrayList<String> arrayList = API.checkForMissingParameters(map, "filename");
        if (!arrayList.isEmpty()) {
            return API.handleMissingParameters(arrayList, response);
        }
        String string3 = map.get("filename").trim();
        File file = new File(string3);
        if (file.isDirectory()) {
            return APIResponse.badRequest(response, string3 + " is a folder");
        }
        if (!string3.toLowerCase().endsWith(".mdat")) {
            return APIResponse.badRequest(response, "The filename should end with .mdat");
        }
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
            try (ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(randomAccessFile.getFD()));){
                ArrayList<MeasData> arrayList2 = new ArrayList<MeasData>(1);
                arrayList2.add(measData);
                XE.A(objectOutputStream, null, arrayList2, file, true);
                objectOutputStream.close();
            }
            lG.O(string3);
            XE.H().A(file);
            this.setCompletedProcessResults(string, null);
        }
        catch (IOException iOException) {
            return APIResponse.badRequest(response, "IOException trying to save measurement data\n" + iOException.getMessage());
        }
        return APIResponse.ok(response, string + " completed");
    }

    @Override
    public ValidValues checkSubscriptionParameters(SubscriptionType subscriptionType, Subscriber subscriber) {
        return null;
    }

    @Override
    public void addSubscriptionToSource(SubscriptionType subscriptionType) {
    }

    @Override
    public void removeSubscriptionFromSource(SubscriptionType subscriptionType) {
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.updateSubscribers(SubscriptionType.MEASUREMENT, MeasurementsListChange.builder().changeDescription("selectionChanged").firstIndex(listSelectionEvent.getFirstIndex() + 1).lastIndex(listSelectionEvent.getLastIndex() + 1).build());
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.updateSubscribers(SubscriptionType.MEASUREMENT, MeasurementsListChange.builder().changeDescription("added").firstIndex(listDataEvent.getIndex0() + 1).lastIndex(listDataEvent.getIndex1() + 1).build());
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.updateSubscribers(SubscriptionType.MEASUREMENT, MeasurementsListChange.builder().changeDescription("removed").firstIndex(listDataEvent.getIndex0() + 1).lastIndex(listDataEvent.getIndex1() + 1).build());
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        this.updateSubscribers(SubscriptionType.MEASUREMENT, MeasurementsListChange.builder().changeDescription("changed").firstIndex(listDataEvent.getIndex0() + 1).lastIndex(listDataEvent.getIndex1() + 1).build());
    }

    static {
        FREQ_RESP_AXIS_TYPES = Arrays.asList($B.Y, $B.c, $B.s, $B.R, $B.q, $B.o, $B.n, $B.z, $B.\u00c0, $B.\u00a2, $B.G);
        IMPULSE_RESP_AXIS_TYPES = Arrays.asList($B.c, $B.d);
    }
}

