/*
 * Decompiled with CFR 0.152.
 */
package roomeqwizard.api;

import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import roomeqwizard.F;
import roomeqwizard.FilterSetSource;
import roomeqwizard.HF;
import roomeqwizard.LevelUnit;
import roomeqwizard.MA;
import roomeqwizard.MJ;
import roomeqwizard.MeasData;
import roomeqwizard.MeasurementMode;
import roomeqwizard.NamingOption;
import roomeqwizard.RI;
import roomeqwizard.RoomEQ_Wizard;
import roomeqwizard.SD;
import roomeqwizard.TZero;
import roomeqwizard.TimingReference;
import roomeqwizard.api.APIResponse;
import roomeqwizard.api.MeasurementsService;
import roomeqwizard.api.Publisher;
import roomeqwizard.api.model.ChannelList;
import roomeqwizard.api.model.Command;
import roomeqwizard.api.model.FrequencySpan;
import roomeqwizard.api.model.MeasureCommand;
import roomeqwizard.api.model.MeasurementNaming;
import roomeqwizard.api.model.Protections;
import roomeqwizard.api.model.Subscriber;
import roomeqwizard.api.model.SubscriptionType;
import roomeqwizard.api.model.ValidValues;
import roomeqwizard.api.model.Value;
import roomeqwizard.eA;
import roomeqwizard.eC;
import roomeqwizard.lG;
import roomeqwizard.pK;
import spark.Response;

public class MeasureService
extends Publisher {
    private static List<String> commands;
    private static List<String> namingOptions;
    private static List<String> dateTimeFormats;
    private static List<String> levelUnits;
    private static List<String> sweepRepetitions;
    private static List<String> timingReferenceChoices;
    private static List<String> tZeroChoices;
    private static List<String> playbackModes;
    private static List<String> measurementModes;
    private eA measureDialog;

    public MeasureService() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                MeasureService.this.measureDialog = eA.\u0124();
            }
        });
    }

    public static List<String> getNamingOptions() {
        if (namingOptions == null) {
            namingOptions = new ArrayList<String>();
            for (NamingOption namingOption : NamingOption.values()) {
                namingOptions.add(namingOption.apiName());
            }
        }
        return namingOptions;
    }

    public static List<String> getDateTimeFormats() {
        if (dateTimeFormats == null) {
            dateTimeFormats = Arrays.asList(NamingOption.DATE_TIME_FORMATS);
        }
        return dateTimeFormats;
    }

    public static List<String> getLevelUnits() {
        if (levelUnits == null) {
            levelUnits = new ArrayList<String>();
            for (LevelUnit levelUnit : LevelUnit.values()) {
                levelUnits.add(levelUnit.suffix());
            }
        }
        return levelUnits;
    }

    public static List<String> getValidSweepRepetitions() {
        if (sweepRepetitions == null) {
            sweepRepetitions = new ArrayList<String>();
            for (Integer n2 : MJ.L) {
                sweepRepetitions.add("" + n2);
            }
        }
        return sweepRepetitions;
    }

    public static List<String> getTimingReferenceChoices() {
        if (timingReferenceChoices == null) {
            timingReferenceChoices = new ArrayList<String>();
            for (TimingReference timingReference : TimingReference.values()) {
                timingReferenceChoices.add(timingReference.apiName());
            }
        }
        return timingReferenceChoices;
    }

    public static List<String> getTZeroChoices() {
        if (tZeroChoices == null) {
            tZeroChoices = new ArrayList<String>();
            for (TZero tZero : TZero.values()) {
                tZeroChoices.add(tZero.apiName());
            }
        }
        return tZeroChoices;
    }

    public static List<String> getPlaybackModes() {
        if (playbackModes == null) {
            playbackModes = new ArrayList<String>();
            for (RI rI2 : RI.values()) {
                playbackModes.add(rI2.A());
            }
        }
        return playbackModes;
    }

    public static List<String> getMeasurementModes() {
        if (measurementModes == null) {
            measurementModes = new ArrayList<String>();
            for (MeasurementMode measurementMode : MeasurementMode.values()) {
                measurementModes.add(measurementMode.apiName());
            }
        }
        return measurementModes;
    }

    public String getNotes() {
        return lG.\u0290();
    }

    public APIResponse setNotes(String string, Response response) {
        boolean bl = false;
        if (string != null) {
            lG.c(string);
            bl = true;
        }
        if (!bl) {
            return APIResponse.badRequest(response, "No notes in the request");
        }
        return APIResponse.ok(response, "Notes set");
    }

    public Integer getSweepRepetitions() {
        return RoomEQ_Wizard.v.D();
    }

    public APIResponse setSweepRepetitions(Integer n2, Response response) {
        boolean bl = false;
        if (F.\u00e2()) {
            return APIResponse.badRequest(response, "Multiple sweeps are not allowed when using a USB mic");
        }
        if (!this.measureDialog.\u00d9().allowsMultipleSweeps()) {
            return APIResponse.badRequest(response, "Multiple sweeps are not allowed when the timing reference is " + this.measureDialog.\u00d9().shortDescription());
        }
        if (n2 != null) {
            if (!Arrays.asList(MJ.L).contains(n2)) {
                ValidValues validValues = ValidValues.builder().message(n2 + " is not a valid number of repetitions").validValues(MeasureService.getValidSweepRepetitions()).build();
                return APIResponse.badRequest(response, validValues);
            }
            RoomEQ_Wizard.v.E(n2);
            bl = true;
        }
        if (!bl) {
            return APIResponse.badRequest(response, "No value in the request");
        }
        return APIResponse.ok(response, "Repetitions set");
    }

    public APIResponse setFilteredSPLFilterSource(Integer n2, Response response) {
        SD sD2 = RoomEQ_Wizard.w();
        if (n2 > 0 && n2 <= sD2.K()) {
            MeasData measData = sD2.D(n2 - 1);
            RoomEQ_Wizard.A(measData);
            return APIResponse.ok(response, "Measurement " + n2 + ": " + measData.getTitle() + " set as the source of filters for Filtered SPL measurement");
        }
        return APIResponse.badRequest(response, "There is no measurement at " + n2);
    }

    public Integer getFilteredSPLFilterSource() {
        FilterSetSource filterSetSource = RoomEQ_Wizard.z();
        if (filterSetSource == null || !(filterSetSource instanceof MeasData)) {
            return null;
        }
        MeasData measData = (MeasData)filterSetSource;
        SD sD2 = RoomEQ_Wizard.w();
        int n2 = sD2.C(measData);
        if (n2 < 0) {
            return null;
        }
        return n2 + 1;
    }

    public String getPlaybackMode() {
        return this.measureDialog.\u011c().A();
    }

    public APIResponse setPlaybackMode(String string, Response response) {
        boolean bl = false;
        if (string != null) {
            RI rI2 = RI.A(string);
            if (rI2 == null) {
                ValidValues validValues = ValidValues.builder().message(string + " is not a valid playback mode").validValues(MeasureService.getPlaybackModes()).build();
                return APIResponse.badRequest(response, validValues);
            }
            if (rI2 == RI.A && !this.measureDialog.\u00d3()) {
                return APIResponse.badRequest(response, "Playback from 8c is not available");
            }
            this.measureDialog.B(rI2);
            bl = true;
        }
        if (!bl) {
            return APIResponse.badRequest(response, "No setting in the request");
        }
        return APIResponse.ok(response, "Playback mode set");
    }

    public String getMeasurementMode() {
        return this.measureDialog.\u0129().apiName();
    }

    public APIResponse setMeasurementMode(String string, Response response) {
        if (string == null) {
            return APIResponse.badRequest(response, "No setting in the request");
        }
        MeasurementMode measurementMode = MeasurementMode.getFromApiName(string);
        if (measurementMode == null) {
            ValidValues validValues = ValidValues.builder().message(string + " is not a valid measurement mode").validValues(MeasureService.getMeasurementModes()).build();
            return APIResponse.badRequest(response, validValues);
        }
        this.measureDialog.A(measurementMode);
        return APIResponse.ok(response, "Measurement mode set");
    }

    public List<String> getSequentialChoices() {
        return this.measureDialog.\u010a();
    }

    public ChannelList getSequentialChannels() {
        return ChannelList.builder().channels(this.measureDialog.\u0119()).build();
    }

    public APIResponse setSequentialChannels(ChannelList channelList, Response response) {
        if (channelList == null || channelList.getChannels() == null || channelList.getChannels().isEmpty()) {
            return APIResponse.badRequest(response, "No channels in the request");
        }
        List<String> list = this.getSequentialChoices();
        for (String string : channelList.getChannels()) {
            if (list.contains(string)) continue;
            ValidValues validValues = ValidValues.builder().message(string + " is not a valid channel").validValues(list).build();
            return APIResponse.badRequest(response, validValues);
        }
        this.measureDialog.A(channelList.getChannels());
        return APIResponse.ok(response, "Channels set");
    }

    public String getTimingReference() {
        return lG.\u01fb().apiName();
    }

    public APIResponse setTimingReference(String string, Response response) {
        boolean bl = false;
        if (string != null) {
            TimingReference timingReference = TimingReference.getFromApiName(string);
            if (timingReference == null) {
                ValidValues validValues = ValidValues.builder().message(string + " is not a valid timing reference").validValues(MeasureService.getTimingReferenceChoices()).build();
                return APIResponse.badRequest(response, validValues);
            }
            lG.B(timingReference);
            bl = true;
        }
        if (!bl) {
            return APIResponse.badRequest(response, "No setting in the request");
        }
        return APIResponse.ok(response, "Timing reference set");
    }

    public String getTZero() {
        return lG.\u0429().apiName();
    }

    public APIResponse setTZero(String string, Response response) {
        boolean bl = false;
        if (string != null) {
            TZero tZero = TZero.getFromApiName(string);
            if (tZero == null) {
                ValidValues validValues = ValidValues.builder().message(string + " is not a valid t=0 option").validValues(MeasureService.getTZeroChoices()).build();
                return APIResponse.badRequest(response, validValues);
            }
            lG.A(tZero);
            bl = true;
        }
        if (!bl) {
            return APIResponse.badRequest(response, "No setting in the request");
        }
        return APIResponse.ok(response, "t=0 option set");
    }

    public Boolean getMergeLoopbackCal() {
        return lG.\u0207();
    }

    public APIResponse setMergeLoopbackCal(Boolean bl, Response response) {
        if (bl == null) {
            return APIResponse.badRequest(response, "No setting in request");
        }
        lG.\u00e3(bl);
        return APIResponse.ok(response, "Merge calibration choice set");
    }

    public Boolean getPlayDither() {
        return lG.x();
    }

    public APIResponse setPlayDither(Boolean bl, Response response) {
        if (bl == null) {
            return APIResponse.badRequest(response, "No setting in request");
        }
        lG.I(bl);
        return APIResponse.ok(response, "Choice set");
    }

    public Boolean getFillSilenceWithDither() {
        return lG.\u0156();
    }

    public APIResponse setFillSilenceWithDither(Boolean bl, Response response) {
        if (bl == null) {
            return APIResponse.badRequest(response, "No setting in request");
        }
        lG.C(bl);
        return APIResponse.ok(response, "Choice set");
    }

    public Boolean getCaptureNoiseFloor() {
        return lG.q();
    }

    public APIResponse setCaptureNoiseFloor(Boolean bl, Response response) {
        if (bl == null) {
            return APIResponse.badRequest(response, "No setting in request");
        }
        lG.\u00c6(bl);
        return APIResponse.ok(response, "Choice set");
    }

    public Boolean getInvertSecondOutput() {
        return lG.\u0268();
    }

    public APIResponse setInvertSecondOutput(Boolean bl, Response response) {
        if (bl == null) {
            return APIResponse.badRequest(response, "No setting in request");
        }
        lG.i(bl);
        return APIResponse.ok(response, "Choice set");
    }

    public Boolean getLfeMinus10dB() {
        return lG.\u012d();
    }

    public APIResponse setLfeMinus10dB(Boolean bl, Response response) {
        if (bl == null) {
            return APIResponse.badRequest(response, "No setting in request");
        }
        lG.\u00df(bl);
        return APIResponse.ok(response, "Choice set");
    }

    public Boolean getUseLfeEndFreq() {
        return lG.\u0118();
    }

    public APIResponse setUseLfeEndFreq(Boolean bl, Response response) {
        if (bl == null) {
            return APIResponse.badRequest(response, "No setting in request");
        }
        lG.\u00e2(bl);
        return APIResponse.ok(response, "Choice set");
    }

    public Integer getLfeEndFreq() {
        return lG.\u038c();
    }

    public APIResponse setLfeEndFreq(Integer n2, Response response) {
        if (n2 == null) {
            return APIResponse.badRequest(response, "No setting in request");
        }
        lG.i(n2);
        return APIResponse.ok(response, "Choice set");
    }

    public Double getTimingRefTrim() {
        return lG.\u0212();
    }

    public APIResponse setTimingRefTrim(Double d2, Response response) {
        if (d2 == null) {
            return APIResponse.badRequest(response, "No setting in request");
        }
        lG.X(d2);
        return APIResponse.ok(response, "Timing ref trim set");
    }

    public Double getTimingOffset() {
        return lG.\u00a4();
    }

    public APIResponse setTimingOffset(Double d2, Response response) {
        if (d2 == null) {
            return APIResponse.badRequest(response, "No setting in request");
        }
        lG.T(d2);
        return APIResponse.ok(response, "Timing offset set");
    }

    public Integer getNumMeasurements() {
        return lG.\u0416();
    }

    public APIResponse setNumMeasurements(Integer n2, Response response) {
        if (n2 == null) {
            return APIResponse.badRequest(response, "No setting in request");
        }
        if (n2 < 1 || n2 > lG.\u00f8()) {
            return APIResponse.badRequest(response, "Number of measurements must be between 1 and " + lG.\u00f8());
        }
        this.measureDialog.H(n2);
        return APIResponse.ok(response, "Number set");
    }

    public Integer getStartDelay() {
        return lG.o();
    }

    public APIResponse setStartDelay(Integer n2, Response response) {
        if (n2 == null) {
            return APIResponse.badRequest(response, "No setting in request");
        }
        if (n2 < 0 || n2 > eA.\u0116()) {
            return APIResponse.badRequest(response, "Start delay must be between 0 and " + eA.\u0116() + " seconds");
        }
        lG.\u00a3(n2);
        return APIResponse.ok(response, "Start delay set");
    }

    public Integer getInterMeasDelay() {
        return lG.\u01da();
    }

    public APIResponse setInterMeasDelay(Integer n2, Response response) {
        if (n2 == null) {
            return APIResponse.badRequest(response, "No setting in request");
        }
        if (n2 < 0 || n2 > eA.\u0116()) {
            return APIResponse.badRequest(response, "Between measurements delay must be between 0 and " + eA.\u0116() + " seconds");
        }
        lG.\u00d8(n2);
        return APIResponse.ok(response, "Between measurements delay set");
    }

    public Value getLevel() {
        return Value.builder().value(lG.\u027e().convertdBFSToUnit(RoomEQ_Wizard.v.G())).unit(lG.\u027e().suffix()).build();
    }

    public APIResponse setLevel(Value value, Response response) {
        LevelUnit levelUnit = value.getUnit() == null ? LevelUnit.DBFS : LevelUnit.getUnitFromSuffix(value.getUnit());
        if (levelUnit == null) {
            ValidValues validValues = ValidValues.builder().message(value.getUnit() + " is not a valid level unit").validValues(MeasureService.getLevelUnits()).build();
            return APIResponse.badRequest(response, validValues);
        }
        Double d2 = value.getValue();
        if (d2 == null) {
            return APIResponse.badRequest(response, "No level value in request");
        }
        double d3 = levelUnit.convertTodBFS(d2);
        if (d3 > pK.\u020c()) {
            return APIResponse.badRequest(response, "Level is above the maximum allowed of " + levelUnit.convertdBFSToUnit(pK.\u020c()) + " " + levelUnit.suffix());
        }
        if (d3 < pK.\u01ee()) {
            return APIResponse.badRequest(response, "Level is below the minimum allowed of " + levelUnit.convertdBFSToUnit(pK.\u01ee()) + " " + levelUnit.suffix());
        }
        this.measureDialog.A(d2, levelUnit);
        return APIResponse.ok(response, "Level set");
    }

    public FrequencySpan getFrequencySpan() {
        return FrequencySpan.builder().startFrequency(RoomEQ_Wizard.v.O()).endFrequency(RoomEQ_Wizard.v.J()).build();
    }

    public APIResponse setFrequencySpan(FrequencySpan frequencySpan, Response response) {
        int n2;
        boolean bl = false;
        int n3 = (int)RoomEQ_Wizard.v.N() / 2;
        if (frequencySpan.getStartFrequency() != null) {
            n2 = frequencySpan.getStartFrequency();
            if (n2 >= n3) {
                return APIResponse.badRequest(response, "The start frequency must be less than half the sample rate, which is " + n3);
            }
            RoomEQ_Wizard.v.B(n2);
            bl = true;
        }
        if (frequencySpan.getEndFrequency() != null) {
            n2 = frequencySpan.getEndFrequency();
            if (n2 > n3) {
                return APIResponse.badRequest(response, "The end frequency cannot be more than half the sample rate, which is " + n3);
            }
            RoomEQ_Wizard.v.C(n2);
            bl = true;
        }
        if (!bl) {
            return APIResponse.badRequest(response, "No frequencies in the request");
        }
        return APIResponse.ok(response, "Frequency span set");
    }

    public Protections getProtectionOptions() {
        return Protections.builder().clippingAbort(lG.\u03a8()).splLimitAbort(lG.\u03ce()).dBSPLLimit(lG.\u01a4()).build();
    }

    public APIResponse setProtectionOptions(Protections protections, Response response) {
        boolean bl = false;
        if (protections.getClippingAbort() != null) {
            lG.\u00f2(protections.getClippingAbort());
            bl = true;
        }
        if (protections.getSplLimitAbort() != null) {
            lG.g(protections.getSplLimitAbort());
            bl = true;
        }
        if (protections.getDBSPLLimit() != null) {
            lG.\u00e8(protections.getDBSPLLimit());
            bl = true;
        }
        if (!bl) {
            return APIResponse.badRequest(response, "No settings in the request");
        }
        return APIResponse.ok(response, "Protections set");
    }

    public MeasurementNaming getNaming() {
        return MeasurementNaming.builder().title(lG.\u011e()).namingOption(lG.\u0148().apiName()).nextNumber(lG.\u0451()).numberIncrement(lG.\u019c()).dateTimeFormat(lG.\u00c4()).prefixMeasNameWithOutput(lG.\u0298()).build();
    }

    public APIResponse setNaming(MeasurementNaming measurementNaming, Response response) {
        Object object;
        boolean bl = false;
        if (measurementNaming.getTitle() != null) {
            lG.t(measurementNaming.getTitle());
            bl = true;
        }
        if (measurementNaming.getNamingOption() != null) {
            object = NamingOption.getFromApiName(measurementNaming.getNamingOption());
            if (object == null) {
                ValidValues validValues = ValidValues.builder().message(measurementNaming.getNamingOption() + " is not a valid naming option").validValues(MeasureService.getNamingOptions()).build();
                return APIResponse.badRequest(response, validValues);
            }
            lG.A(object);
            bl = true;
        }
        if (measurementNaming.getDateTimeFormat() != null) {
            object = measurementNaming.getDateTimeFormat();
            String[] stringArray = NamingOption.DATE_TIME_FORMATS;
            String string = null;
            for (String string2 : stringArray) {
                if (!string2.equalsIgnoreCase((String)object)) continue;
                string = string2;
                break;
            }
            if (string == null) {
                ValidValues validValues = ValidValues.builder().message((String)object + " is not a recognised date/time format").validValues(MeasureService.getDateTimeFormats()).build();
                return APIResponse.badRequest(response, validValues);
            }
            lG.B(string);
            bl = true;
        }
        if (measurementNaming.getNextNumber() != null) {
            lG.M(measurementNaming.getNextNumber());
            bl = true;
        }
        if (measurementNaming.getNumberIncrement() != null) {
            lG.r(measurementNaming.getNumberIncrement());
            bl = true;
        }
        if (measurementNaming.getPrefixMeasNameWithOutput() != null) {
            lG.\u00dc(measurementNaming.getPrefixMeasNameWithOutput());
            bl = true;
        }
        if (!bl) {
            return APIResponse.badRequest(response, "No naming options in the request");
        }
        return APIResponse.ok(response, "Options processed, next name: " + this.measureDialog.\u00e4());
    }

    @Override
    public void addSubscriptionToSource(SubscriptionType subscriptionType) {
        this.measureDialog.C(subscriptionType, this);
    }

    @Override
    public void removeSubscriptionFromSource(SubscriptionType subscriptionType) {
        this.measureDialog.D(subscriptionType, this);
    }

    @Override
    public ValidValues checkSubscriptionParameters(SubscriptionType subscriptionType, Subscriber subscriber) {
        switch (subscriptionType) {
            case MEASUREMENT_PROGRESS: {
                break;
            }
            default: {
                assert (false) : "Unhandled enum type " + (Object)((Object)subscriptionType);
                break;
            }
        }
        return null;
    }

    public List<String> getCommands() {
        if (commands == null) {
            commands = new ArrayList<String>();
            for (MeasureCommand measureCommand : MeasureCommand.values()) {
                commands.add(measureCommand.commandName());
            }
        }
        return commands;
    }

    public APIResponse runCommand(Command command, Response response) {
        if (command.getCommand() == null) {
            return APIResponse.badRequest(response, "No command in the request");
        }
        String string = command.getCommand();
        MeasureCommand measureCommand = MeasureCommand.getFromCommandName(string);
        if (measureCommand == null) {
            ValidValues validValues = ValidValues.builder().message(string + " is not a recognised command").validValues(this.getCommands()).build();
            return APIResponse.badRequest(response, validValues);
        }
        if (measureCommand != MeasureCommand.CANCEL) {
            if (!HF.O()) {
                return APIResponse.badRequest(response, "There is no audio input");
            }
            if (!RoomEQ_Wizard.w().C()) {
                return APIResponse.badRequest(response, MeasurementsService.measurementsAtMax());
            }
            if (eC.D()) {
                return APIResponse.badRequest(response, "There is already a measurement in progress");
            }
        }
        boolean bl = true;
        switch (measureCommand) {
            case CANCEL: {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MeasureService.this.measureDialog.A(false, true);
                    }
                });
                return APIResponse.accepted(response, "Cancelled measurement");
            }
            case SPL: {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        eC.A(MA.I, false, true, true);
                    }
                });
                return APIResponse.accepted(response, "Starting measurement");
            }
            case FILTERED_SPL: {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        eC.A(MA.H, false, true, true);
                    }
                });
                return APIResponse.accepted(response, "Starting measurement");
            }
            case IMPEDANCE: {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        eC.A(MA.C, false, true, true);
                    }
                });
                return APIResponse.accepted(response, "Starting measurement");
            }
            case IMPEDANCE_OPEN_CAL: {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        eC.A(MA.B, false, true, true);
                    }
                });
                return APIResponse.accepted(response, "Starting measurement");
            }
            case IMPEDANCE_SHORT_CAL: {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        eC.A(MA.E, false, true, true);
                    }
                });
                return APIResponse.accepted(response, "Starting measurement");
            }
            case IMPEDANCE_REF_CAL: {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        eC.A(MA.A, false, true, true);
                    }
                });
                return APIResponse.accepted(response, "Starting measurement");
            }
        }
        assert (false) : "Unhandled enum type";
        return APIResponse.notImplemented(response, string + " is not implemented yet");
    }
}

