/*
 * Decompiled with CFR 0.152.
 */
package roomeqwizard.api;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import roomeqwizard.$B;
import roomeqwizard.F;
import roomeqwizard.HF;
import roomeqwizard.api.APIResponse;
import roomeqwizard.api.Publisher;
import roomeqwizard.api.model.Command;
import roomeqwizard.api.model.InputLevels;
import roomeqwizard.api.model.InputLevelsCommand;
import roomeqwizard.api.model.Subscriber;
import roomeqwizard.api.model.SubscriptionType;
import roomeqwizard.api.model.ValidValues;
import roomeqwizard.gD;
import roomeqwizard.lD;
import roomeqwizard.lG;
import spark.Response;

public class InputLevelsService
extends Publisher
implements gD {
    private static final String AXIS_UNIT_KEY = "unit";
    private static List<String> commands;
    private static List<String> axisUnits;
    private static volatile boolean monitoringInputs;
    private static InputLevelsService instance;
    private static $B axisUnit;
    private static final Object lock;
    private static InputLevels lastInputLevels;

    private InputLevelsService() {
        instance = this;
    }

    public static InputLevelsService getInstance() {
        if (instance == null) {
            instance = new InputLevelsService();
        }
        return instance;
    }

    public static List<String> getAxisUnits() {
        if (axisUnits == null) {
            $B[] $BArray = new $B[]{$B.Y, $B.c, $B.q, $B.o, $B.n, $B.z, $B.\u00a2};
            axisUnits = new ArrayList<String>();
            for ($B $B : $BArray) {
                axisUnits.add($B.C());
            }
        }
        return axisUnits;
    }

    public static InputLevels getInputLevels() {
        if (lastInputLevels == null) {
            return InputLevels.builder().build();
        }
        return lastInputLevels;
    }

    @Override
    public void addSubscriptionToSource(SubscriptionType subscriptionType) {
    }

    @Override
    public void removeSubscriptionFromSource(SubscriptionType subscriptionType) {
    }

    @Override
    public ValidValues checkSubscriptionParameters(SubscriptionType subscriptionType, Subscriber subscriber) {
        switch (subscriptionType) {
            case INPUT_LEVELS: {
                ValidValues validValues = this.checkAxisUnit(subscriber.getParameters());
                if (validValues == null) break;
                return validValues;
            }
            default: {
                assert (false) : "Unhandled enum type " + (Object)((Object)subscriptionType);
                break;
            }
        }
        return null;
    }

    private ValidValues checkAxisUnit(Map<String, String> map) {
        if (map != null && map.containsKey(AXIS_UNIT_KEY)) {
            $B $B = $B.B(map.get(AXIS_UNIT_KEY));
            if ($B == null) {
                axisUnit = $B.c;
                ValidValues validValues = ValidValues.builder().message(map.get(AXIS_UNIT_KEY) + " is not a recognised level unit").validValues(InputLevelsService.getAxisUnits()).build();
                return validValues;
            }
            axisUnit = $B;
        }
        return null;
    }

    public List<String> getCommands() {
        if (commands == null) {
            commands = new ArrayList<String>();
            for (InputLevelsCommand inputLevelsCommand : InputLevelsCommand.values()) {
                commands.add(inputLevelsCommand.commandName());
            }
        }
        return commands;
    }

    public APIResponse runCommand(Command command, Response response) {
        if (command.getCommand() == null) {
            return APIResponse.badRequest(response, "No command in the request");
        }
        String string = command.getCommand();
        InputLevelsCommand inputLevelsCommand = InputLevelsCommand.getFromCommandName(string);
        if (inputLevelsCommand == null) {
            ValidValues validValues = ValidValues.builder().message(string + " is not a recognised command").validValues(this.getCommands()).build();
            return APIResponse.badRequest(response, validValues);
        }
        switch (inputLevelsCommand) {
            case START: {
                HF.J().A(this);
                monitoringInputs = true;
                return APIResponse.ok(response, "Starting input levels monitoring");
            }
            case STOP: {
                HF.A(this);
                monitoringInputs = false;
                return APIResponse.ok(response, "Stopping input levels monitoring");
            }
        }
        assert (false) : "Unhandled enum type";
        return APIResponse.notImplemented(response, string + " is not implemented yet");
    }

    @Override
    public void captureStarted() {
    }

    @Override
    public void handleCaptureStartFailure() {
    }

    @Override
    public void captureStopped() {
        monitoringInputs = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void inputLevelsUpdated(double[] dArray, double[] dArray2, double d2) {
        if (monitoringInputs) {
            ArrayList<Double> arrayList = new ArrayList<Double>(dArray.length);
            ArrayList<Double> arrayList2 = new ArrayList<Double>(dArray2.length);
            double d3 = lG.\u017d ? 3.0103 : 0.0;
            int n2 = F.A();
            for (int i2 = 0; i2 < n2 && i2 < dArray.length; ++i2) {
                int n3 = F.\u00fa() + i2;
                lD lD2 = new lD(axisUnit, d3, n3);
                double d4 = lD2.A(dArray[i2]);
                arrayList.add(d4);
                double d5 = lD2.A(dArray2[i2]);
                arrayList2.add(d5);
            }
            Object object = lock;
            synchronized (object) {
                lastInputLevels = InputLevels.builder().unit(axisUnit.C()).rms(arrayList).peak(arrayList2).timeSpanSeconds(d2).build();
            }
            InputLevelsService.getInstance().updateSubscribers(SubscriptionType.INPUT_LEVELS, lastInputLevels);
        }
    }

    static {
        monitoringInputs = false;
        axisUnit = $B.c;
        lock = new Object();
    }
}

