/*
 * Decompiled with CFR 0.152.
 */
package roomeqwizard.api;

import java.awt.EventQueue;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.TreeSet;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.TransferQueue;
import java.util.logging.Level;
import roomeqwizard.IG;
import roomeqwizard.WizardLogger;
import roomeqwizard.XE;
import roomeqwizard.api.APIResponse;
import roomeqwizard.api.Publisher;
import roomeqwizard.api.model.FilePath;
import roomeqwizard.api.model.Subscriber;
import roomeqwizard.api.model.SubscriptionType;
import roomeqwizard.api.model.ValidValues;
import spark.Response;

public class ImportService
extends Publisher {
    private static final String INPUT_DELIM = ",";
    private static final String RANGE_DELIM = "-";
    private static IG frame;
    private static final int MAX_IMPORT_QUEUE_SIZE = 9;
    private TransferQueue<SweepRecording> recordingQueue;
    private RecordingQueueConsumer sweepRecordingImporter;
    private TransferQueue<ImportFile> freqRespQueue;
    private FreqRespQueueConsumer freqRespImporter;
    private TransferQueue<ImportFile> impulseRespQueue;
    private ImpulseRespQueueConsumer impulseRespImporter;
    private String lastFRFileImported = "";
    private String lastIRFileImported = "";

    public ImportService() {
        try {
            EventQueue.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    frame = IG.D();
                }
            });
        }
        catch (InterruptedException | InvocationTargetException exception) {
            // empty catch block
        }
    }

    public static String getSweepStimulus() {
        File file = frame.J();
        if (file == null) {
            return "";
        }
        try {
            return file.getCanonicalPath();
        }
        catch (IOException iOException) {
            return "";
        }
    }

    public static String getSweepResponse() {
        File file = frame.G();
        if (file == null) {
            return "";
        }
        try {
            return file.getCanonicalPath();
        }
        catch (IOException iOException) {
            return "";
        }
    }

    public APIResponse setSweepStimulus(String string, Response response) {
        APIResponse aPIResponse = this.validateFilePath(string, response);
        if (aPIResponse != null) {
            return aPIResponse;
        }
        final StringBuilder stringBuilder = new StringBuilder();
        final File file = new File(string);
        try {
            EventQueue.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    stringBuilder.append(frame.A(file));
                }
            });
        }
        catch (InterruptedException | InvocationTargetException exception) {
            // empty catch block
        }
        if (stringBuilder.toString().isEmpty()) {
            return APIResponse.badRequest(response, string + " could not be loaded as a sweep stimulus");
        }
        return APIResponse.ok(response, stringBuilder.toString().replaceAll("\n", " "));
    }

    public APIResponse importFrequencyResponse(FilePath filePath, Response response) {
        if (filePath == null) {
            return APIResponse.badRequest(response, "Nothing in the request");
        }
        String string = filePath.getPath();
        if (string == null) {
            return APIResponse.badRequest(response, "No file path in the request");
        }
        APIResponse aPIResponse = this.validateFilePath(string, response);
        if (aPIResponse != null) {
            return aPIResponse;
        }
        File file = new File(string);
        if (!XE.I.accept(file)) {
            return APIResponse.badRequest(response, "The file is not an accepted type, valid file types are " + XE.I.B());
        }
        if (this.freqRespQueue == null) {
            this.freqRespQueue = new LinkedTransferQueue<ImportFile>();
        }
        if (this.freqRespImporter == null) {
            this.freqRespImporter = new FreqRespQueueConsumer(this.freqRespQueue);
            new Thread(this.freqRespImporter).start();
        }
        if (this.freqRespQueue.size() > 9) {
            return APIResponse.badRequest(response, "Too many frequency response imports pending, there are already 9 to process");
        }
        FreqRespQueueProducer freqRespQueueProducer = new FreqRespQueueProducer(this.freqRespQueue, ImportFile.builder().file(file).build());
        new Thread(freqRespQueueProducer).start();
        return APIResponse.accepted(response, "Loading frequency response in progress");
    }

    public String getLastFRFileImported() {
        return this.lastFRFileImported;
    }

    public APIResponse importImpulseResponse(FilePath filePath, Response response) {
        Object object;
        if (filePath == null) {
            return APIResponse.badRequest(response, "Nothing in the request");
        }
        String string = filePath.getPath();
        if (string == null) {
            return APIResponse.badRequest(response, "No file path in the request");
        }
        APIResponse aPIResponse = this.validateFilePath(string, response);
        if (aPIResponse != null) {
            return aPIResponse;
        }
        String string2 = filePath.getChannels();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        if (string2 != null && !string2.isEmpty() && !string2.trim().equalsIgnoreCase("all")) {
            object = ImportService.validateChannelsText(string2);
            if (object != null && !((String)object).isEmpty()) {
                return APIResponse.badRequest(response, string2 + " is not valid: " + (String)object);
            }
            arrayList.clear();
            arrayList.addAll(ImportService.inputsToProcess(string2));
        }
        if (!XE.\u00c3.accept((File)(object = new File(string)))) {
            return APIResponse.badRequest(response, "The file is not an accepted type, valid file types are " + XE.\u00c3.B());
        }
        if (this.impulseRespQueue == null) {
            this.impulseRespQueue = new LinkedTransferQueue<ImportFile>();
        }
        if (this.impulseRespImporter == null) {
            this.impulseRespImporter = new ImpulseRespQueueConsumer(this.impulseRespQueue);
            new Thread(this.impulseRespImporter).start();
        }
        if (this.impulseRespQueue.size() > 9) {
            return APIResponse.badRequest(response, "Too many frequency response imports pending, there are already 9 to process");
        }
        ImpulseRespQueueProducer impulseRespQueueProducer = new ImpulseRespQueueProducer(this.impulseRespQueue, ImportFile.builder().file((File)object).inputs(arrayList).build());
        new Thread(impulseRespQueueProducer).start();
        return APIResponse.accepted(response, "Loading impulse response in progress");
    }

    public String getLastIRFileImported() {
        return this.lastIRFileImported;
    }

    public APIResponse validateFilePath(String string, Response response) {
        if (string == null || string.isEmpty()) {
            return APIResponse.badRequest(response, "No file path in the request");
        }
        try {
            File file = new File(string);
            file.getCanonicalPath();
            if (!file.canRead()) {
                return APIResponse.badRequest(response, string + " cannot be found");
            }
            if (file.isDirectory()) {
                return APIResponse.badRequest(response, string + " is a directory, not a file");
            }
        }
        catch (IOException iOException) {
            return APIResponse.badRequest(response, string + " is not a valid file path");
        }
        return null;
    }

    public APIResponse setSweepResponse(FilePath filePath, Response response) {
        Object object;
        if (filePath == null) {
            return APIResponse.badRequest(response, "Nothing in the request");
        }
        if (ImportService.getSweepStimulus().isEmpty()) {
            return APIResponse.badRequest(response, "The sweep stimulus must be set before setting the sweep response");
        }
        String string = filePath.getPath();
        if (string == null) {
            return APIResponse.badRequest(response, "No file path in the request");
        }
        APIResponse aPIResponse = this.validateFilePath(string, response);
        if (aPIResponse != null) {
            return aPIResponse;
        }
        String string2 = filePath.getChannels();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        if (string2 != null && !string2.isEmpty() && !string2.trim().equalsIgnoreCase("all")) {
            object = ImportService.validateChannelsText(string2);
            if (object != null && !((String)object).isEmpty()) {
                return APIResponse.badRequest(response, string2 + " is not valid: " + (String)object);
            }
            arrayList.clear();
            arrayList.addAll(ImportService.inputsToProcess(string2));
        }
        object = new File(string);
        if (this.recordingQueue == null) {
            this.recordingQueue = new LinkedTransferQueue<SweepRecording>();
        }
        if (this.sweepRecordingImporter == null) {
            this.sweepRecordingImporter = new RecordingQueueConsumer(this.recordingQueue);
            new Thread(this.sweepRecordingImporter).start();
        }
        if (this.recordingQueue.size() > 9) {
            return APIResponse.badRequest(response, "Too many sweep response imports pending, there are already 9 to process");
        }
        RecordingQueueProducer recordingQueueProducer = new RecordingQueueProducer(this.recordingQueue, SweepRecording.builder().file((File)object).inputs(arrayList).build());
        new Thread(recordingQueueProducer).start();
        return APIResponse.accepted(response, "Loading sweep response in progress");
    }

    private static String validateChannelsText(String string) {
        if (string == null || string.isEmpty()) {
            return "";
        }
        try {
            String[] stringArray;
            for (String string2 : stringArray = string.split(INPUT_DELIM)) {
                int n2;
                String[] stringArray2 = string2.split(RANGE_DELIM);
                if (stringArray2.length == 1) {
                    n2 = Integer.parseInt(string2);
                    if (n2 != 0) continue;
                    return "The first channel number is 1, 0 is not valid";
                }
                if (stringArray2.length == 2) {
                    n2 = Integer.parseInt(stringArray2[0]);
                    if (n2 == 0) {
                        return "The first channel number is 1, 0 is not valid";
                    }
                    int n3 = Integer.parseInt(stringArray2[1]);
                    if (n3 >= n2) continue;
                    return "The end of a range must be greater than the start, this is not valid: " + string2;
                }
                return "A range can only have two values, this is not valid: " + string2;
            }
            return "";
        }
        catch (NumberFormatException numberFormatException) {
            return "Enter numbers separated by commas or use dash to specify a range, e.g. 1-4";
        }
    }

    private static ArrayList<Integer> inputsToProcess(String string) {
        String[] stringArray;
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        if (string != null && !string.isEmpty()) {
            try {
                for (String string2 : stringArray = string.split(INPUT_DELIM)) {
                    int n2;
                    String[] stringArray2 = string2.split(RANGE_DELIM);
                    if (stringArray2.length == 1) {
                        n2 = Integer.parseInt(string2) - 1;
                        treeSet.add(n2);
                        continue;
                    }
                    if (stringArray2.length != 2) continue;
                    n2 = Integer.parseInt(stringArray2[0]) - 1;
                    int n3 = Integer.parseInt(stringArray2[1]) - 1;
                    for (int i2 = n2; i2 <= n3; ++i2) {
                        treeSet.add(i2);
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                WizardLogger.getLogger().log(Level.SEVERE, "Invalid text for inputs group: {0}", string);
            }
        }
        stringArray = new ArrayList();
        stringArray.addAll(treeSet);
        return stringArray;
    }

    @Override
    public ValidValues checkSubscriptionParameters(SubscriptionType subscriptionType, Subscriber subscriber) {
        return null;
    }

    @Override
    public void addSubscriptionToSource(SubscriptionType subscriptionType) {
    }

    @Override
    public void removeSubscriptionFromSource(SubscriptionType subscriptionType) {
    }

    private class ImpulseRespQueueConsumer
    implements Runnable {
        private TransferQueue<ImportFile> transferQueue;

        public ImpulseRespQueueConsumer(TransferQueue<ImportFile> transferQueue) {
            this.transferQueue = transferQueue;
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        ImportFile importFile;
                        boolean bl;
                        if (bl = XE.A((importFile = (ImportFile)this.transferQueue.take()).getFile(), importFile.inputs, true)) {
                            ImportService.this.lastIRFileImported = importFile.getFile().getAbsolutePath().replace("\\", "/");
                        }
                        ImportService.this.updateSubscribers(SubscriptionType.IMPORT, importFile.toString() + " import completed");
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }

    private class ImpulseRespQueueProducer
    implements Runnable {
        private TransferQueue<ImportFile> transferQueue;
        private ImportFile file;

        public ImpulseRespQueueProducer(TransferQueue<ImportFile> transferQueue, ImportFile importFile) {
            this.transferQueue = transferQueue;
            this.file = importFile;
        }

        @Override
        public void run() {
            try {
                this.transferQueue.transfer(this.file);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private class FreqRespQueueConsumer
    implements Runnable {
        private TransferQueue<ImportFile> transferQueue;

        public FreqRespQueueConsumer(TransferQueue<ImportFile> transferQueue) {
            this.transferQueue = transferQueue;
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        ImportFile importFile = (ImportFile)this.transferQueue.take();
                        boolean bl = importFile.getFile().getName().toLowerCase().endsWith(".zma");
                        boolean bl2 = XE.A(importFile.getFile(), bl, true);
                        if (bl2) {
                            ImportService.this.lastFRFileImported = importFile.getFile().getAbsolutePath().replace("\\", "/");
                        }
                        ImportService.this.updateSubscribers(SubscriptionType.IMPORT, importFile.toString() + " import completed");
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }

    private class FreqRespQueueProducer
    implements Runnable {
        private TransferQueue<ImportFile> transferQueue;
        private ImportFile file;

        public FreqRespQueueProducer(TransferQueue<ImportFile> transferQueue, ImportFile importFile) {
            this.transferQueue = transferQueue;
            this.file = importFile;
        }

        @Override
        public void run() {
            try {
                this.transferQueue.transfer(this.file);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private class RecordingQueueConsumer
    implements Runnable {
        private TransferQueue<SweepRecording> transferQueue;

        public RecordingQueueConsumer(TransferQueue<SweepRecording> transferQueue) {
            this.transferQueue = transferQueue;
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        SweepRecording sweepRecording = (SweepRecording)this.transferQueue.take();
                        frame.A(sweepRecording.getFile(), sweepRecording.getInputs());
                        ImportService.this.updateSubscribers(SubscriptionType.IMPORT, sweepRecording.toString() + " import completed");
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }

    private class RecordingQueueProducer
    implements Runnable {
        private TransferQueue<SweepRecording> transferQueue;
        private SweepRecording recording;

        public RecordingQueueProducer(TransferQueue<SweepRecording> transferQueue, SweepRecording sweepRecording) {
            this.transferQueue = transferQueue;
            this.recording = sweepRecording;
        }

        @Override
        public void run() {
            try {
                this.transferQueue.transfer(this.recording);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private static class ImportFile {
        private File file;
        private ArrayList<Integer> inputs;

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(this.file.getPath());
            if (this.inputs != null) {
                stringBuilder.append(" with ").append(this.inputs.size()).append(" channels");
            }
            return stringBuilder.toString();
        }

        ImportFile(File file, ArrayList<Integer> arrayList) {
            this.file = file;
            this.inputs = arrayList;
        }

        public static ImportFileBuilder builder() {
            return new ImportFileBuilder();
        }

        public File getFile() {
            return this.file;
        }

        public ArrayList<Integer> getInputs() {
            return this.inputs;
        }

        public void setFile(File file) {
            this.file = file;
        }

        public void setInputs(ArrayList<Integer> arrayList) {
            this.inputs = arrayList;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof ImportFile)) {
                return false;
            }
            ImportFile importFile = (ImportFile)object;
            if (!importFile.canEqual(this)) {
                return false;
            }
            File file = this.getFile();
            File file2 = importFile.getFile();
            if (file == null ? file2 != null : !((Object)file).equals(file2)) {
                return false;
            }
            ArrayList<Integer> arrayList = this.getInputs();
            ArrayList<Integer> arrayList2 = importFile.getInputs();
            return !(arrayList == null ? arrayList2 != null : !((Object)arrayList).equals(arrayList2));
        }

        protected boolean canEqual(Object object) {
            return object instanceof ImportFile;
        }

        public int hashCode() {
            int n2 = 59;
            int n3 = 1;
            File file = this.getFile();
            n3 = n3 * 59 + (file == null ? 43 : ((Object)file).hashCode());
            ArrayList<Integer> arrayList = this.getInputs();
            n3 = n3 * 59 + (arrayList == null ? 43 : ((Object)arrayList).hashCode());
            return n3;
        }

        public static class ImportFileBuilder {
            private File file;
            private ArrayList<Integer> inputs;

            ImportFileBuilder() {
            }

            public ImportFileBuilder file(File file) {
                this.file = file;
                return this;
            }

            public ImportFileBuilder inputs(ArrayList<Integer> arrayList) {
                this.inputs = arrayList;
                return this;
            }

            public ImportFile build() {
                return new ImportFile(this.file, this.inputs);
            }

            public String toString() {
                return "ImportService.ImportFile.ImportFileBuilder(file=" + this.file + ", inputs=" + this.inputs + ")";
            }
        }
    }

    private static class SweepRecording {
        private File file;
        private ArrayList<Integer> inputs;

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(this.file.getPath());
            if (this.inputs != null) {
                stringBuilder.append(" with ").append(this.inputs.size()).append(" channels");
            }
            return stringBuilder.toString();
        }

        SweepRecording(File file, ArrayList<Integer> arrayList) {
            this.file = file;
            this.inputs = arrayList;
        }

        public static SweepRecordingBuilder builder() {
            return new SweepRecordingBuilder();
        }

        public File getFile() {
            return this.file;
        }

        public ArrayList<Integer> getInputs() {
            return this.inputs;
        }

        public void setFile(File file) {
            this.file = file;
        }

        public void setInputs(ArrayList<Integer> arrayList) {
            this.inputs = arrayList;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof SweepRecording)) {
                return false;
            }
            SweepRecording sweepRecording = (SweepRecording)object;
            if (!sweepRecording.canEqual(this)) {
                return false;
            }
            File file = this.getFile();
            File file2 = sweepRecording.getFile();
            if (file == null ? file2 != null : !((Object)file).equals(file2)) {
                return false;
            }
            ArrayList<Integer> arrayList = this.getInputs();
            ArrayList<Integer> arrayList2 = sweepRecording.getInputs();
            return !(arrayList == null ? arrayList2 != null : !((Object)arrayList).equals(arrayList2));
        }

        protected boolean canEqual(Object object) {
            return object instanceof SweepRecording;
        }

        public int hashCode() {
            int n2 = 59;
            int n3 = 1;
            File file = this.getFile();
            n3 = n3 * 59 + (file == null ? 43 : ((Object)file).hashCode());
            ArrayList<Integer> arrayList = this.getInputs();
            n3 = n3 * 59 + (arrayList == null ? 43 : ((Object)arrayList).hashCode());
            return n3;
        }

        public static class SweepRecordingBuilder {
            private File file;
            private ArrayList<Integer> inputs;

            SweepRecordingBuilder() {
            }

            public SweepRecordingBuilder file(File file) {
                this.file = file;
                return this;
            }

            public SweepRecordingBuilder inputs(ArrayList<Integer> arrayList) {
                this.inputs = arrayList;
                return this;
            }

            public SweepRecording build() {
                return new SweepRecording(this.file, this.inputs);
            }

            public String toString() {
                return "ImportService.SweepRecording.SweepRecordingBuilder(file=" + this.file + ", inputs=" + this.inputs + ")";
            }
        }
    }
}

