/*
 * Decompiled with CFR 0.152.
 */
package roomeqwizard.api;

import com.google.gson.JsonSyntaxException;
import io.github.manusant.ss.conf.TypifyProvider;
import java.awt.EventQueue;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import roomeqwizard.DecadeFraction;
import roomeqwizard.FadeFraction;
import roomeqwizard.FourToneSignal;
import roomeqwizard.HE;
import roomeqwizard.LevelUnit;
import roomeqwizard.MG;
import roomeqwizard.MJ;
import roomeqwizard.MultitoneSpacing;
import roomeqwizard.NoiseSelection;
import roomeqwizard.OctaveFraction;
import roomeqwizard.PeriodicNoiseSpectrum;
import roomeqwizard.RoomEQ_Wizard;
import roomeqwizard.ThreeToneSignal;
import roomeqwizard.ToneBurstPeriod;
import roomeqwizard.TwoToneSignal;
import roomeqwizard.WG;
import roomeqwizard.Window;
import roomeqwizard.ZK;
import roomeqwizard.api.APIResponse;
import roomeqwizard.api.model.CEABurstConfiguration;
import roomeqwizard.api.model.Command;
import roomeqwizard.api.model.FourToneConfiguration;
import roomeqwizard.api.model.GeneratorCommand;
import roomeqwizard.api.model.GeneratorStatus;
import roomeqwizard.api.model.LinearSweepConfiguration;
import roomeqwizard.api.model.LogSweepConfiguration;
import roomeqwizard.api.model.MeasSweepConfiguration;
import roomeqwizard.api.model.MultitoneConfiguration;
import roomeqwizard.api.model.MultitoneDetails;
import roomeqwizard.api.model.PeriodicNoiseConfiguration;
import roomeqwizard.api.model.Protections;
import roomeqwizard.api.model.RandomNoiseConfiguration;
import roomeqwizard.api.model.SawtoothConfiguration;
import roomeqwizard.api.model.Signal;
import roomeqwizard.api.model.SignalCommand;
import roomeqwizard.api.model.SineConfiguration;
import roomeqwizard.api.model.SineDistortion;
import roomeqwizard.api.model.SquareConfiguration;
import roomeqwizard.api.model.ThreeToneConfiguration;
import roomeqwizard.api.model.ToneBurstConfiguration;
import roomeqwizard.api.model.TwoToneConfiguration;
import roomeqwizard.api.model.ValidValues;
import roomeqwizard.api.model.Value;
import roomeqwizard.lG;
import roomeqwizard.pK;
import roomeqwizard.uB;
import roomeqwizard.vE;
import spark.Request;
import spark.Response;

public class GeneratorService {
    private static List<String> EMPTY_LIST_STRING = Collections.emptyList();
    private static List<String> commands;
    private static List<String> levelUnits;
    private static List<String> signalTypes;
    private static List<String> pinkTypes;
    private static List<String> whiteTypes;
    private static List<String> twoToneTypes;
    private static List<String> threeToneTypes;
    private static List<String> fourToneTypes;
    private static List<String> fadeFractions;
    private static List<String> sweepLengths;
    private static List<String> rtaLengths;
    private static List<String> multitoneLengths;
    private static List<String> spectrumTypes;
    private static List<String> multitoneSpacings;
    private static List<String> octaveFractions;
    private static List<String> decadeFractions;

    public GeneratorStatus getStatus() {
        return new GeneratorStatus();
    }

    public static List<String> getSignals() {
        if (signalTypes == null) {
            signalTypes = new ArrayList<String>();
            for (vE vE2 : vE.values()) {
                if (vE2 == vE.U) {
                    if (!pK.\u0273()) continue;
                    signalTypes.add(vE2.E());
                    continue;
                }
                signalTypes.add(vE2.E());
            }
        }
        return signalTypes;
    }

    public static List<String> getCommands() {
        if (commands == null) {
            commands = new ArrayList<String>();
            for (GeneratorCommand generatorCommand : GeneratorCommand.values()) {
                commands.add(generatorCommand.commandName());
            }
        }
        return commands;
    }

    public static List<String> getLevelUnits() {
        if (levelUnits == null) {
            levelUnits = new ArrayList<String>();
            for (LevelUnit levelUnit : LevelUnit.values()) {
                levelUnits.add(levelUnit.suffix());
            }
        }
        return levelUnits;
    }

    public static List<String> getPinkTypes() {
        if (pinkTypes == null) {
            pinkTypes = new ArrayList<String>();
            for (NoiseSelection noiseSelection : NoiseSelection.values()) {
                pinkTypes.add(noiseSelection.apiName());
            }
        }
        return pinkTypes;
    }

    public static List<String> getWhiteTypes() {
        if (whiteTypes == null) {
            whiteTypes = new ArrayList<String>();
            for (NoiseSelection noiseSelection : NoiseSelection.values()) {
                if (noiseSelection.pinkOnly()) continue;
                whiteTypes.add(noiseSelection.apiName());
            }
        }
        return whiteTypes;
    }

    public static List<String> getTwoToneTypes() {
        if (twoToneTypes == null) {
            twoToneTypes = new ArrayList<String>();
            for (TwoToneSignal twoToneSignal : TwoToneSignal.values()) {
                twoToneTypes.add(twoToneSignal.apiName());
            }
        }
        return twoToneTypes;
    }

    public static List<String> getThreeToneTypes() {
        if (threeToneTypes == null) {
            threeToneTypes = new ArrayList<String>();
            for (ThreeToneSignal threeToneSignal : ThreeToneSignal.values()) {
                threeToneTypes.add(threeToneSignal.apiName());
            }
        }
        return threeToneTypes;
    }

    public static List<String> getFourToneTypes() {
        if (fourToneTypes == null) {
            fourToneTypes = new ArrayList<String>();
            for (FourToneSignal fourToneSignal : FourToneSignal.values()) {
                fourToneTypes.add(fourToneSignal.apiName());
            }
        }
        return fourToneTypes;
    }

    public static List<String> getFadeFractions() {
        if (fadeFractions == null) {
            fadeFractions = new ArrayList<String>();
            for (FadeFraction fadeFraction : FadeFraction.values()) {
                fadeFractions.add(fadeFraction.apiName());
            }
        }
        return fadeFractions;
    }

    public static List<String> getSweepLengths() {
        if (sweepLengths == null) {
            sweepLengths = new ArrayList<String>();
            for (uB uB2 : uB.values()) {
                sweepLengths.add(uB2.D());
            }
        }
        return sweepLengths;
    }

    public static List<String> getSequenceLengths() {
        if (rtaLengths == null) {
            rtaLengths = new ArrayList<String>();
            for (ZK zK2 : ZK.values()) {
                rtaLengths.add(zK2.A());
            }
        }
        return rtaLengths;
    }

    public static List<String> getMultitoneLengths() {
        if (multitoneLengths == null) {
            multitoneLengths = new ArrayList<String>();
            for (ZK zK2 : pK.\u01ed()) {
                multitoneLengths.add(zK2.A());
            }
        }
        return multitoneLengths;
    }

    public static List<String> getSpectrumTypes() {
        if (spectrumTypes == null) {
            spectrumTypes = new ArrayList<String>();
            for (PeriodicNoiseSpectrum periodicNoiseSpectrum : PeriodicNoiseSpectrum.values()) {
                spectrumTypes.add(periodicNoiseSpectrum.apiName());
            }
        }
        return spectrumTypes;
    }

    public static List<String> getMultitoneSpacings() {
        if (multitoneSpacings == null) {
            multitoneSpacings = new ArrayList<String>();
            for (MultitoneSpacing multitoneSpacing : MultitoneSpacing.values()) {
                multitoneSpacings.add(multitoneSpacing.apiName());
            }
        }
        return multitoneSpacings;
    }

    public static List<String> getOctaveFractions() {
        if (octaveFractions == null) {
            octaveFractions = new ArrayList<String>();
            for (OctaveFraction octaveFraction : OctaveFraction.values()) {
                octaveFractions.add(octaveFraction.apiName());
            }
        }
        return octaveFractions;
    }

    public static List<String> getDecadeFractions() {
        if (decadeFractions == null) {
            decadeFractions = new ArrayList<String>();
            for (DecadeFraction decadeFraction : DecadeFraction.values()) {
                decadeFractions.add(decadeFraction.apiName());
            }
        }
        return decadeFractions;
    }

    public APIResponse runCommand(Command command, Response response) {
        if (command.getCommand() == null) {
            return APIResponse.badRequest(response, "No command in the request");
        }
        String string = command.getCommand();
        GeneratorCommand generatorCommand = GeneratorCommand.getFromCommandName(string);
        if (generatorCommand == null) {
            ValidValues validValues = ValidValues.builder().message(string + " is not a recognised command").validValues(GeneratorService.getCommands()).build();
            return APIResponse.badRequest(response, validValues);
        }
        pK pK2 = pK.\u01fe();
        if (!pK2.isEnabled()) {
            return APIResponse.badRequest(response, "The generator is disabled,  no available audio output");
        }
        switch (generatorCommand) {
            case PLAY: {
                if (pK.\u0250()) {
                    return APIResponse.ok(response, "Generator already playing");
                }
                pK2.\u0205();
                return APIResponse.accepted(response, "Starting generator");
            }
            case STOP: {
                if (!pK.\u0250()) {
                    return APIResponse.ok(response, "Generator already stopped");
                }
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        pK.\u01de();
                    }
                });
                return APIResponse.accepted(response, "Stopping generator");
            }
        }
        assert (false) : "Unhandled enum type";
        return APIResponse.notImplemented(response, string + " is not implemented yet");
    }

    public List<String> getCurrentSignalCommands() {
        pK pK2 = pK.\u01fe();
        return this.getSignalCommands(pK2.\u01e8());
    }

    public List<String> getSignalCommands(vE vE2) {
        switch (vE2) {
            case S: {
                return Arrays.asList(SignalCommand.PREV_ONE_THIRD.commandName(), SignalCommand.NEXT_ONE_THIRD.commandName(), SignalCommand.DIST_FROM_RTA.commandName());
            }
            case A: 
            case M: 
            case E: 
            case C: {
                return this.nextPrevThirdOctave();
            }
            case D: 
            case T: 
            case J: 
            case F: {
                return this.nextPrevOctaveAndThirdOctave();
            }
        }
        return EMPTY_LIST_STRING;
    }

    private List<String> nextPrevThirdOctave() {
        return Arrays.asList(SignalCommand.PREV_ONE_THIRD.commandName(), SignalCommand.NEXT_ONE_THIRD.commandName());
    }

    private List<String> nextPrevOctaveAndThirdOctave() {
        return Arrays.asList(SignalCommand.PREV_OCTAVE.commandName(), SignalCommand.NEXT_OCTAVE.commandName(), SignalCommand.PREV_ONE_THIRD.commandName(), SignalCommand.NEXT_ONE_THIRD.commandName());
    }

    public APIResponse runSignalCommand(Command command, Response response) {
        if (command.getCommand() == null) {
            return APIResponse.badRequest(response, "No command in the request");
        }
        pK pK2 = pK.\u01fe();
        vE vE2 = pK2.\u01e8();
        List<String> list = this.getSignalCommands(vE2);
        if (list.isEmpty()) {
            return APIResponse.badRequest(response, vE2.E() + " does not accept commands");
        }
        String string = command.getCommand();
        SignalCommand signalCommand = SignalCommand.getFromCommandName(string);
        if (signalCommand == null) {
            ValidValues validValues = ValidValues.builder().message(string + " is not a recognised signal command").validValues(list).build();
            return APIResponse.badRequest(response, validValues);
        }
        if (!list.contains(signalCommand.commandName())) {
            ValidValues validValues = ValidValues.builder().message(string + " is not a recognised command for " + vE2.E()).validValues(list).build();
            return APIResponse.badRequest(response, validValues);
        }
        if (signalCommand == SignalCommand.DIST_FROM_RTA) {
            WG wG2 = WG.A();
            String string2 = wG2.I();
            if (string2.isEmpty()) {
                return APIResponse.ok(response, "Distortion set from RTA");
            }
            return APIResponse.badRequest(response, string2);
        }
        if (vE2.A()) {
            switch (signalCommand) {
                case PREV_ONE_THIRD: {
                    double d2 = pK2.\u02d1();
                    return APIResponse.accepted(response, "Setting frequency to " + HE.A(d2));
                }
                case NEXT_ONE_THIRD: {
                    double d3 = pK2.\u01fa();
                    return APIResponse.accepted(response, "Setting frequency to " + HE.A(d3));
                }
            }
            assert (false) : "Unhandled enum type " + (Object)((Object)signalCommand);
            return APIResponse.notImplemented(response, string + " is not implemented yet");
        }
        switch (signalCommand) {
            case PREV_OCTAVE: {
                switch (vE2) {
                    case D: {
                        return APIResponse.accepted(response, "Setting centre frequency to " + pK2.\u0263());
                    }
                    case J: {
                        return APIResponse.accepted(response, "Setting centre frequency to " + pK2.\u027e());
                    }
                    case T: {
                        return APIResponse.accepted(response, "Setting centre frequency to " + pK2.\u02c1());
                    }
                    case F: {
                        return APIResponse.accepted(response, "Setting centre frequency to " + pK2.\u01eb());
                    }
                }
                assert (false) : "Unhandled enum type " + (Object)((Object)signalCommand);
                return APIResponse.notImplemented(response, string + " has not been implemented for " + vE2.E());
            }
            case NEXT_OCTAVE: {
                switch (vE2) {
                    case D: {
                        return APIResponse.accepted(response, "Setting centre frequency to " + pK2.\u020f());
                    }
                    case J: {
                        return APIResponse.accepted(response, "Setting centre frequency to " + pK2.\u0278());
                    }
                    case T: {
                        return APIResponse.accepted(response, "Setting centre frequency to " + pK2.\u02b4());
                    }
                    case F: {
                        return APIResponse.accepted(response, "Setting centre frequency to " + pK2.\u01e4());
                    }
                }
                assert (false) : "Unhandled enum type " + (Object)((Object)signalCommand);
                return APIResponse.notImplemented(response, string + " has not been implemented for " + vE2.E());
            }
            case PREV_ONE_THIRD: {
                switch (vE2) {
                    case D: {
                        return APIResponse.accepted(response, "Setting centre frequency to " + pK2.\u01e6());
                    }
                    case J: {
                        return APIResponse.accepted(response, "Setting centre frequency to " + pK2.\u02bc());
                    }
                    case T: {
                        return APIResponse.accepted(response, "Setting centre frequency to " + pK2.\u0258());
                    }
                    case F: {
                        return APIResponse.accepted(response, "Setting centre frequency to " + pK2.\u0206());
                    }
                }
                assert (false) : "Unhandled enum type " + (Object)((Object)signalCommand);
                return APIResponse.notImplemented(response, string + " has not been implemented for " + vE2.E());
            }
            case NEXT_ONE_THIRD: {
                switch (vE2) {
                    case D: {
                        return APIResponse.accepted(response, "Setting centre frequency to " + pK2.\u0299());
                    }
                    case J: {
                        return APIResponse.accepted(response, "Setting centre frequency to " + pK2.\u0265());
                    }
                    case T: {
                        return APIResponse.accepted(response, "Setting centre frequency to " + pK2.\u02be());
                    }
                    case F: {
                        return APIResponse.accepted(response, "Setting centre frequency to " + pK2.\u02b2());
                    }
                }
                assert (false) : "Unhandled enum type " + (Object)((Object)signalCommand);
                return APIResponse.notImplemented(response, string + " has not been implemented for " + vE2.E());
            }
        }
        assert (false) : "Unhandled enum type " + (Object)((Object)signalCommand);
        return APIResponse.notImplemented(response, string + " has not been implemented");
    }

    public Value getLevel() {
        pK pK2 = pK.\u01fe();
        return Value.builder().value(lG.\u027e().convertdBFSToUnit(pK2.\u02b7())).unit(lG.\u027e().suffix()).build();
    }

    public APIResponse setLevel(Value value, Response response) {
        pK pK2 = pK.\u01fe();
        if (!pK2.\u01e8().C()) {
            return APIResponse.badRequest(response, pK2.\u01e8().E() + " does not allow level setting");
        }
        LevelUnit levelUnit = value.getUnit() == null ? LevelUnit.DBFS : LevelUnit.getUnitFromSuffix(value.getUnit());
        if (levelUnit == null) {
            ValidValues validValues = ValidValues.builder().message(value.getUnit() + " is not a valid level unit").validValues(GeneratorService.getLevelUnits()).build();
            return APIResponse.badRequest(response, validValues);
        }
        Double d2 = value.getValue();
        if (d2 == null) {
            return APIResponse.badRequest(response, "No level value in request");
        }
        double d3 = levelUnit.convertTodBFS(d2);
        if (d3 > pK.\u020c()) {
            return APIResponse.badRequest(response, "Level is above the maximum allowed of " + levelUnit.convertdBFSToUnit(pK.\u020c()) + " " + levelUnit.suffix());
        }
        if (d3 < pK.\u01ee()) {
            return APIResponse.badRequest(response, "Level is below the minimum allowed of " + levelUnit.convertdBFSToUnit(pK.\u01ee()) + " " + levelUnit.suffix());
        }
        pK2.B(d2, levelUnit);
        return APIResponse.ok(response, "Level set");
    }

    public Value getFrequency() {
        pK pK2 = pK.\u01fe();
        return Value.builder().value(pK2.\u0266()).unit("Hz").build();
    }

    public APIResponse setFrequency(Value value, Response response) {
        Object object;
        pK pK2 = pK.\u01fe();
        if (!pK2.\u01e8().A()) {
            return APIResponse.badRequest(response, pK2.\u01e8().E() + " does not have a frequency setting");
        }
        double d2 = 1.0;
        if (value.getUnit() != null && ((String)(object = value.getUnit())).equalsIgnoreCase("kHz")) {
            d2 = 1000.0;
        }
        if ((object = value.getValue()) == null) {
            return APIResponse.badRequest(response, "No frequency value in request");
        }
        double d3 = (Double)object * d2;
        if (d3 > pK.\u0271()) {
            return APIResponse.badRequest(response, "Frequency is above the maximum allowed of " + pK.\u0271() + " Hz");
        }
        if (d3 < pK.\u0269()) {
            return APIResponse.badRequest(response, "Frequency is below the minimum allowed of " + pK.\u0269() + " Hz");
        }
        pK2.t(d3);
        return APIResponse.ok(response, "Frequency set");
    }

    public Protections getGeneratorProtection() {
        return Protections.builder().splLimitAbort(lG.\u014e()).dBSPLLimit(lG.M()).clippingAbort(lG.\u01b0()).build();
    }

    public APIResponse setGeneratorProtection(Protections protections, Response response) {
        boolean bl = false;
        if (protections.getSplLimitAbort() != null) {
            lG.U(protections.getSplLimitAbort());
            bl = true;
        }
        if (protections.getDBSPLLimit() != null) {
            pK pK2 = pK.\u01fe();
            pK2.v(protections.getDBSPLLimit());
            bl = true;
        }
        if (protections.getClippingAbort() != null) {
            lG.\u00e4(protections.getClippingAbort());
            bl = true;
        }
        if (bl) {
            return APIResponse.ok(response, "Configuration processed");
        }
        return APIResponse.badRequest(response, "No configuration entries in the request");
    }

    public Signal getSignal() {
        pK pK2 = pK.\u01fe();
        return Signal.builder().signal(pK2.\u01e8().E()).build();
    }

    public Object getSignalConfiguration(vE vE2) {
        switch (vE2) {
            case S: {
                return this.getSineConfiguration();
            }
            case A: {
                return this.getSquareConfiguration();
            }
            case M: {
                return this.getSawtoothConfiguration();
            }
            case E: {
                return this.getToneBurstConfiguration();
            }
            case C: {
                return this.getCEABurstConfiguration();
            }
            case Q: {
                return this.getTwoToneConfiguration();
            }
            case N: {
                return this.getThreeToneConfiguration();
            }
            case U: {
                return this.getFourToneConfiguration();
            }
            case D: {
                return this.getPinkNoiseConfiguration();
            }
            case T: {
                return this.getWhiteNoiseConfiguration();
            }
            case J: {
                return this.getPinkPNConfiguration();
            }
            case F: {
                return this.getWhitePNConfiguration();
            }
            case V: {
                return this.getLinearSweepConfiguration();
            }
            case B: {
                return this.getLogSweepConfiguration();
            }
            case I: {
                return GeneratorService.getMeasSweepConfiguration();
            }
            case L: {
                return this.getMultitoneConfiguration();
            }
        }
        assert (false) : "Unhandled signal type " + (Object)((Object)vE2);
        return null;
    }

    public APIResponse setConfiguration(Request request, Response response) {
        pK pK2 = pK.\u01fe();
        vE vE2 = pK2.\u01e8();
        try {
            switch (vE2) {
                case S: {
                    SineConfiguration sineConfiguration = (SineConfiguration)TypifyProvider.json().fromJson(request.body(), SineConfiguration.class);
                    return this.setSineConfiguration(sineConfiguration, response);
                }
                case A: {
                    SquareConfiguration squareConfiguration = (SquareConfiguration)TypifyProvider.json().fromJson(request.body(), SquareConfiguration.class);
                    return this.setSquareConfiguration(squareConfiguration, response);
                }
                case M: {
                    SawtoothConfiguration sawtoothConfiguration = (SawtoothConfiguration)TypifyProvider.json().fromJson(request.body(), SawtoothConfiguration.class);
                    return this.setSawtoothConfiguration(sawtoothConfiguration, response);
                }
                case E: {
                    ToneBurstConfiguration toneBurstConfiguration = (ToneBurstConfiguration)TypifyProvider.json().fromJson(request.body(), ToneBurstConfiguration.class);
                    return this.setToneBurstConfiguration(toneBurstConfiguration, response);
                }
                case C: {
                    CEABurstConfiguration cEABurstConfiguration = (CEABurstConfiguration)TypifyProvider.json().fromJson(request.body(), CEABurstConfiguration.class);
                    return this.setCEABurstConfiguration(cEABurstConfiguration, response);
                }
                case R: {
                    return APIResponse.badRequest(response, "J-test does not have any configuration");
                }
                case Q: {
                    TwoToneConfiguration twoToneConfiguration = (TwoToneConfiguration)TypifyProvider.json().fromJson(request.body(), TwoToneConfiguration.class);
                    return this.setTwoToneConfiguration(twoToneConfiguration, response);
                }
                case N: {
                    ThreeToneConfiguration threeToneConfiguration = (ThreeToneConfiguration)TypifyProvider.json().fromJson(request.body(), ThreeToneConfiguration.class);
                    return this.setThreeToneConfiguration(threeToneConfiguration, response);
                }
                case U: {
                    FourToneConfiguration fourToneConfiguration = (FourToneConfiguration)TypifyProvider.json().fromJson(request.body(), FourToneConfiguration.class);
                    return this.setFourToneConfiguration(fourToneConfiguration, response);
                }
                case D: {
                    RandomNoiseConfiguration randomNoiseConfiguration = (RandomNoiseConfiguration)TypifyProvider.json().fromJson(request.body(), RandomNoiseConfiguration.class);
                    return this.setPinkNoiseConfiguration(randomNoiseConfiguration, response);
                }
                case T: {
                    RandomNoiseConfiguration randomNoiseConfiguration = (RandomNoiseConfiguration)TypifyProvider.json().fromJson(request.body(), RandomNoiseConfiguration.class);
                    return this.setWhiteNoiseConfiguration(randomNoiseConfiguration, response);
                }
                case J: {
                    PeriodicNoiseConfiguration periodicNoiseConfiguration = (PeriodicNoiseConfiguration)TypifyProvider.json().fromJson(request.body(), PeriodicNoiseConfiguration.class);
                    return this.setPinkPNConfiguration(periodicNoiseConfiguration, response);
                }
                case F: {
                    PeriodicNoiseConfiguration periodicNoiseConfiguration = (PeriodicNoiseConfiguration)TypifyProvider.json().fromJson(request.body(), PeriodicNoiseConfiguration.class);
                    return this.setWhitePNConfiguration(periodicNoiseConfiguration, response);
                }
                case V: {
                    LinearSweepConfiguration linearSweepConfiguration = (LinearSweepConfiguration)TypifyProvider.json().fromJson(request.body(), LinearSweepConfiguration.class);
                    return this.setLinearSweepConfiguration(linearSweepConfiguration, response);
                }
                case B: {
                    LogSweepConfiguration logSweepConfiguration = (LogSweepConfiguration)TypifyProvider.json().fromJson(request.body(), LogSweepConfiguration.class);
                    return this.setLogSweepConfiguration(logSweepConfiguration, response);
                }
                case I: {
                    MeasSweepConfiguration measSweepConfiguration = (MeasSweepConfiguration)TypifyProvider.json().fromJson(request.body(), MeasSweepConfiguration.class);
                    return GeneratorService.setMeasSweepConfiguration(measSweepConfiguration, response);
                }
                case L: {
                    MultitoneConfiguration multitoneConfiguration = (MultitoneConfiguration)TypifyProvider.json().fromJson(request.body(), MultitoneConfiguration.class);
                    return this.setMultitoneConfiguration(multitoneConfiguration, response);
                }
            }
            assert (false) : "Unhandled signal type " + (Object)((Object)vE2);
            return APIResponse.notImplemented(response);
        }
        catch (JsonSyntaxException jsonSyntaxException) {
            return APIResponse.badRequest(response, "Exception trying to parse request: " + jsonSyntaxException.getLocalizedMessage());
        }
    }

    public RandomNoiseConfiguration getPinkNoiseConfiguration() {
        double d2 = GeneratorService.freqStToFreqValue(lG.\u0293());
        double d3 = GeneratorService.freqStToFreqValue(lG.G());
        return RandomNoiseConfiguration.builder().type(lG.\u0196().apiName()).octaveCentre(d2).thirdOctaveCentre(d3).customLowCut(lG.\u01a2()).customLowCutFreq(lG.\u027f()).customHighCut(lG.\u03de()).customHighCutFreq(lG.\u03d6()).customFilterOrder(lG.\u0181().getOrder()).build();
    }

    public APIResponse setPinkNoiseConfiguration(RandomNoiseConfiguration randomNoiseConfiguration, Response response) {
        boolean bl = false;
        pK pK2 = pK.\u01fe();
        if (randomNoiseConfiguration.getType() != null) {
            NoiseSelection noiseSelection = NoiseSelection.getFromApiName(randomNoiseConfiguration.getType());
            if (noiseSelection != null) {
                pK2.D(noiseSelection);
                bl = true;
            } else {
                ValidValues validValues = ValidValues.builder().message(randomNoiseConfiguration.getType() + " is not a valid noise type").validValues(GeneratorService.getPinkTypes()).build();
                return APIResponse.badRequest(response, validValues);
            }
        }
        if (randomNoiseConfiguration.getOctaveCentre() != null) {
            double d2 = randomNoiseConfiguration.getOctaveCentre();
            if (pK2.j(d2)) {
                bl = true;
            } else {
                return APIResponse.badRequest(response, d2 + " is not a valid octave centre frequency");
            }
        }
        if (randomNoiseConfiguration.getThirdOctaveCentre() != null) {
            double d3 = randomNoiseConfiguration.getThirdOctaveCentre();
            if (pK2.f(d3)) {
                bl = true;
            } else {
                return APIResponse.badRequest(response, d3 + " is not a valid octave centre frequency");
            }
        }
        if (randomNoiseConfiguration.getCustomLowCut() != null) {
            pK2.\u00c6(randomNoiseConfiguration.getCustomLowCut());
            bl = true;
        }
        if (randomNoiseConfiguration.getCustomLowCutFreq() != null) {
            pK2.h(randomNoiseConfiguration.getCustomLowCutFreq());
            bl = true;
        }
        if (randomNoiseConfiguration.getCustomHighCut() != null) {
            pK2.p(randomNoiseConfiguration.getCustomHighCut());
            bl = true;
        }
        if (randomNoiseConfiguration.getCustomHighCutFreq() != null) {
            pK2.r(randomNoiseConfiguration.getCustomHighCutFreq());
            bl = true;
        }
        if (randomNoiseConfiguration.getCustomFilterOrder() != null) {
            if (pK2.\u00a3(randomNoiseConfiguration.getCustomFilterOrder())) {
                bl = true;
            } else {
                return APIResponse.badRequest(response, randomNoiseConfiguration.getCustomFilterOrder() + " is not a valid filter order for random noise");
            }
        }
        if (bl) {
            return APIResponse.ok(response, "Configuration processed");
        }
        return APIResponse.badRequest(response, "No configuration entries found in the request");
    }

    public RandomNoiseConfiguration getWhiteNoiseConfiguration() {
        double d2 = GeneratorService.freqStToFreqValue(lG.\u03cd());
        double d3 = GeneratorService.freqStToFreqValue(lG.l());
        return RandomNoiseConfiguration.builder().type(lG.\u01af().apiName()).octaveCentre(d2).thirdOctaveCentre(d3).customLowCut(lG.\u00d9()).customLowCutFreq(lG.\u0280()).customHighCut(lG.\u0140()).customHighCutFreq(lG.\u00c0()).customFilterOrder(lG.\u0286().getOrder()).build();
    }

    public APIResponse setWhiteNoiseConfiguration(RandomNoiseConfiguration randomNoiseConfiguration, Response response) {
        boolean bl = false;
        pK pK2 = pK.\u01fe();
        if (randomNoiseConfiguration.getType() != null) {
            NoiseSelection noiseSelection = NoiseSelection.getFromApiName(randomNoiseConfiguration.getType());
            if (noiseSelection == null || !pK2.B(noiseSelection)) {
                ValidValues validValues = ValidValues.builder().message(randomNoiseConfiguration.getType() + " is not a valid type for white noise").validValues(GeneratorService.getWhiteTypes()).build();
                return APIResponse.badRequest(response, validValues);
            }
            bl = true;
        }
        if (randomNoiseConfiguration.getOctaveCentre() != null) {
            double d2 = randomNoiseConfiguration.getOctaveCentre();
            if (pK2.u(d2)) {
                bl = true;
            } else {
                return APIResponse.badRequest(response, d2 + " is not a valid octave centre frequency");
            }
        }
        if (randomNoiseConfiguration.getThirdOctaveCentre() != null) {
            double d3 = randomNoiseConfiguration.getThirdOctaveCentre();
            if (pK2.v(d3)) {
                bl = true;
            } else {
                return APIResponse.badRequest(response, d3 + " is not a valid octave centre frequency");
            }
        }
        if (randomNoiseConfiguration.getCustomLowCut() != null) {
            pK2.z(randomNoiseConfiguration.getCustomLowCut());
            bl = true;
        }
        if (randomNoiseConfiguration.getCustomLowCutFreq() != null) {
            pK2.l(randomNoiseConfiguration.getCustomLowCutFreq());
            bl = true;
        }
        if (randomNoiseConfiguration.getCustomHighCut() != null) {
            pK2.s(randomNoiseConfiguration.getCustomHighCut());
            bl = true;
        }
        if (randomNoiseConfiguration.getCustomHighCutFreq() != null) {
            pK2._(randomNoiseConfiguration.getCustomHighCutFreq());
            bl = true;
        }
        if (randomNoiseConfiguration.getCustomFilterOrder() != null) {
            if (pK2.j(randomNoiseConfiguration.getCustomFilterOrder())) {
                bl = true;
            } else {
                return APIResponse.badRequest(response, randomNoiseConfiguration.getCustomFilterOrder() + " is not a valid filter order for random noise");
            }
        }
        if (bl) {
            return APIResponse.ok(response, "Configuration processed");
        }
        return APIResponse.badRequest(response, "No configuration entries found in the request");
    }

    public PeriodicNoiseConfiguration getPinkPNConfiguration() {
        double d2 = GeneratorService.freqStToFreqValue(lG.\u0188());
        double d3 = GeneratorService.freqStToFreqValue(lG.\u015d());
        return PeriodicNoiseConfiguration.builder().type(lG.\u00d3().apiName()).octaveCentre(d2).thirdOctaveCentre(d3).customLowCut(lG.\u0204()).customLowCutFreq(lG.\u03bb()).customHighCut(lG.\u016e()).customHighCutFreq(lG.\u0134()).customFilterOrder(lG.\u041e().getOrder()).minimiseCrestFactor(lG.\u0200()).sequenceLength(ZK.B(lG.\u02c0()).A()).build();
    }

    public APIResponse setPinkPNConfiguration(PeriodicNoiseConfiguration periodicNoiseConfiguration, Response response) {
        Enum enum_;
        boolean bl = false;
        pK pK2 = pK.\u01fe();
        if (periodicNoiseConfiguration.getType() != null) {
            enum_ = NoiseSelection.getFromApiName(periodicNoiseConfiguration.getType());
            if (enum_ != null) {
                pK2.A((NoiseSelection)enum_);
                bl = true;
            } else {
                ValidValues validValues = ValidValues.builder().message(periodicNoiseConfiguration.getType() + " is not a valid noise type").validValues(GeneratorService.getPinkTypes()).build();
                return APIResponse.badRequest(response, validValues);
            }
        }
        if (periodicNoiseConfiguration.getOctaveCentre() != null) {
            double d2 = periodicNoiseConfiguration.getOctaveCentre();
            if (pK2.\u00a4(d2)) {
                bl = true;
            } else {
                return APIResponse.badRequest(response, d2 + " is not a valid octave centre frequency");
            }
        }
        if (periodicNoiseConfiguration.getThirdOctaveCentre() != null) {
            double d3 = periodicNoiseConfiguration.getThirdOctaveCentre();
            if (pK2.s(d3)) {
                bl = true;
            } else {
                return APIResponse.badRequest(response, d3 + " is not a valid octave centre frequency");
            }
        }
        if (periodicNoiseConfiguration.getCustomLowCut() != null) {
            pK2.q(periodicNoiseConfiguration.getCustomLowCut());
            bl = true;
        }
        if (periodicNoiseConfiguration.getCustomLowCutFreq() != null) {
            pK2.\u00c4(periodicNoiseConfiguration.getCustomLowCutFreq());
            bl = true;
        }
        if (periodicNoiseConfiguration.getCustomHighCut() != null) {
            pK2.o(periodicNoiseConfiguration.getCustomHighCut());
            bl = true;
        }
        if (periodicNoiseConfiguration.getCustomHighCutFreq() != null) {
            pK2.n(periodicNoiseConfiguration.getCustomHighCutFreq());
            bl = true;
        }
        if (periodicNoiseConfiguration.getCustomFilterOrder() != null) {
            if (pK2.\u00c2(periodicNoiseConfiguration.getCustomFilterOrder())) {
                bl = true;
            } else {
                return APIResponse.badRequest(response, periodicNoiseConfiguration.getCustomFilterOrder() + " is not a valid filter order for periodic noise. For brickwall use 0.");
            }
        }
        if (periodicNoiseConfiguration.getMinimiseCrestFactor() != null) {
            lG.u(periodicNoiseConfiguration.getMinimiseCrestFactor());
            bl = true;
        }
        if (periodicNoiseConfiguration.getSequenceLength() != null) {
            enum_ = ZK.A(periodicNoiseConfiguration.getSequenceLength());
            if (enum_ != null) {
                pK.B((ZK)enum_);
                bl = true;
            } else {
                ValidValues validValues = ValidValues.builder().message(periodicNoiseConfiguration.getSequenceLength() + " is not a valid sequence length").validValues(rtaLengths).build();
                return APIResponse.badRequest(response, validValues);
            }
        }
        if (bl) {
            return APIResponse.ok(response, "Configuration processed");
        }
        return APIResponse.badRequest(response, "No configuration entries found in the request");
    }

    public PeriodicNoiseConfiguration getWhitePNConfiguration() {
        double d2 = GeneratorService.freqStToFreqValue(lG.s());
        double d3 = GeneratorService.freqStToFreqValue(lG.\u01ff());
        return PeriodicNoiseConfiguration.builder().type(lG.\u02b5().apiName()).octaveCentre(d2).thirdOctaveCentre(d3).customLowCut(lG.\u0205()).customLowCutFreq(lG.\u0209()).customHighCut(lG.\u03e7()).customHighCutFreq(lG.\u038f()).customFilterOrder(lG.\u01ef().getOrder()).minimiseCrestFactor(lG.\u03b1()).sequenceLength(ZK.B(lG.\u02c0()).A()).build();
    }

    public APIResponse setWhitePNConfiguration(PeriodicNoiseConfiguration periodicNoiseConfiguration, Response response) {
        Enum enum_;
        boolean bl = false;
        pK pK2 = pK.\u01fe();
        if (periodicNoiseConfiguration.getType() != null) {
            enum_ = NoiseSelection.getFromApiName(periodicNoiseConfiguration.getType());
            if (enum_ == null || !pK2.C((NoiseSelection)enum_)) {
                ValidValues validValues = ValidValues.builder().message(periodicNoiseConfiguration.getType() + " is not a valid type for white periodic noise").validValues(GeneratorService.getWhiteTypes()).build();
                return APIResponse.badRequest(response, validValues);
            }
            bl = true;
        }
        if (periodicNoiseConfiguration.getOctaveCentre() != null) {
            double d2 = periodicNoiseConfiguration.getOctaveCentre();
            if (pK2.m(d2)) {
                bl = true;
            } else {
                return APIResponse.badRequest(response, d2 + " is not a valid octave centre frequency");
            }
        }
        if (periodicNoiseConfiguration.getThirdOctaveCentre() != null) {
            double d3 = periodicNoiseConfiguration.getThirdOctaveCentre();
            if (pK2.\u00a2(d3)) {
                bl = true;
            } else {
                return APIResponse.badRequest(response, d3 + " is not a valid octave centre frequency");
            }
        }
        if (periodicNoiseConfiguration.getCustomLowCut() != null) {
            pK2.j(periodicNoiseConfiguration.getCustomLowCut());
            bl = true;
        }
        if (periodicNoiseConfiguration.getCustomLowCutFreq() != null) {
            pK2.q(periodicNoiseConfiguration.getCustomLowCutFreq());
            bl = true;
        }
        if (periodicNoiseConfiguration.getCustomHighCut() != null) {
            pK2.\u00a4(periodicNoiseConfiguration.getCustomHighCut());
            bl = true;
        }
        if (periodicNoiseConfiguration.getCustomHighCutFreq() != null) {
            pK2.y(periodicNoiseConfiguration.getCustomHighCutFreq());
            bl = true;
        }
        if (periodicNoiseConfiguration.getCustomFilterOrder() != null) {
            if (pK2.\u00cb(periodicNoiseConfiguration.getCustomFilterOrder())) {
                bl = true;
            } else {
                return APIResponse.badRequest(response, periodicNoiseConfiguration.getCustomFilterOrder() + " is not a valid filter order for periodic noise. For brickwall use 0.");
            }
        }
        if (periodicNoiseConfiguration.getMinimiseCrestFactor() != null) {
            lG.P(periodicNoiseConfiguration.getMinimiseCrestFactor());
            bl = true;
        }
        if (periodicNoiseConfiguration.getSequenceLength() != null) {
            enum_ = ZK.A(periodicNoiseConfiguration.getSequenceLength());
            if (enum_ != null) {
                pK.B((ZK)enum_);
                bl = true;
            } else {
                ValidValues validValues = ValidValues.builder().message(periodicNoiseConfiguration.getSequenceLength() + " is not a valid sequence length").validValues(rtaLengths).build();
                return APIResponse.badRequest(response, validValues);
            }
        }
        if (bl) {
            return APIResponse.ok(response, "Configuration processed");
        }
        return APIResponse.badRequest(response, "No configuration entries found in the request");
    }

    private static double freqStToFreqValue(String string) {
        String string2 = " Hz";
        int n2 = string.indexOf(string2);
        if (n2 > 0) {
            string = string.substring(0, n2);
        }
        try {
            double d2 = Double.parseDouble(string);
            return d2;
        }
        catch (NumberFormatException numberFormatException) {
            assert (false) : "Invalid frequency string " + string;
            return 1000.0;
        }
    }

    public SineConfiguration getSineConfiguration() {
        return SineConfiguration.builder().frequency(lG.\u0427()).lockFrequencyToRTAFFT(lG.\u02bf()).addHarmonicDistortion(pK.\u01fe().\u02a8()).addDither(lG.\u0191()).ditherBits(lG.\u00fb()).build();
    }

    public SineDistortion getSineDistortion() {
        WG wG2 = WG.A();
        return SineDistortion.builder().addH2(wG2.B(2)).addH3(wG2.B(3)).addH4(wG2.B(4)).addH5(wG2.B(5)).addH6(wG2.B(6)).addH7(wG2.B(7)).addH8(wG2.B(8)).addH9(wG2.B(9)).dBH2(wG2.F(2)).dBH3(wG2.F(3)).dBH4(wG2.F(4)).dBH5(wG2.F(5)).dBH6(wG2.F(6)).dBH7(wG2.F(7)).dBH8(wG2.F(8)).dBH9(wG2.F(9)).degreesH2(wG2.E(2)).degreesH3(wG2.E(3)).degreesH4(wG2.E(4)).degreesH5(wG2.E(5)).degreesH6(wG2.E(6)).degreesH7(wG2.E(7)).degreesH8(wG2.E(8)).degreesH9(wG2.E(9)).build();
    }

    public APIResponse setSineDistortion(SineDistortion sineDistortion, Response response) {
        boolean bl = false;
        WG wG2 = WG.A();
        if (sineDistortion.getAddH2() != null) {
            wG2.A(2, sineDistortion.getAddH2());
            bl = true;
        }
        if (sineDistortion.getDBH2() != null) {
            wG2.B(2, sineDistortion.getDBH2());
            bl = true;
        }
        if (sineDistortion.getDegreesH2() != null) {
            wG2.A(2, sineDistortion.getDegreesH2());
            bl = true;
        }
        if (sineDistortion.getAddH3() != null) {
            wG2.A(3, sineDistortion.getAddH3());
            bl = true;
        }
        if (sineDistortion.getDBH3() != null) {
            wG2.B(3, sineDistortion.getDBH3());
            bl = true;
        }
        if (sineDistortion.getDegreesH3() != null) {
            wG2.A(3, sineDistortion.getDegreesH3());
            bl = true;
        }
        if (sineDistortion.getAddH4() != null) {
            wG2.A(4, sineDistortion.getAddH4());
            bl = true;
        }
        if (sineDistortion.getDBH4() != null) {
            wG2.B(4, sineDistortion.getDBH4());
            bl = true;
        }
        if (sineDistortion.getDegreesH4() != null) {
            wG2.A(4, sineDistortion.getDegreesH4());
            bl = true;
        }
        if (sineDistortion.getAddH5() != null) {
            wG2.A(5, sineDistortion.getAddH5());
            bl = true;
        }
        if (sineDistortion.getDBH5() != null) {
            wG2.B(5, sineDistortion.getDBH5());
            bl = true;
        }
        if (sineDistortion.getDegreesH5() != null) {
            wG2.A(5, sineDistortion.getDegreesH5());
            bl = true;
        }
        if (sineDistortion.getAddH6() != null) {
            wG2.A(6, sineDistortion.getAddH6());
            bl = true;
        }
        if (sineDistortion.getDBH6() != null) {
            wG2.B(6, sineDistortion.getDBH6());
            bl = true;
        }
        if (sineDistortion.getDegreesH6() != null) {
            wG2.A(6, sineDistortion.getDegreesH6());
            bl = true;
        }
        if (sineDistortion.getAddH7() != null) {
            wG2.A(7, sineDistortion.getAddH7());
            bl = true;
        }
        if (sineDistortion.getDBH7() != null) {
            wG2.B(7, sineDistortion.getDBH7());
            bl = true;
        }
        if (sineDistortion.getDegreesH7() != null) {
            wG2.A(7, sineDistortion.getDegreesH7());
            bl = true;
        }
        if (sineDistortion.getAddH8() != null) {
            wG2.A(8, sineDistortion.getAddH8());
            bl = true;
        }
        if (sineDistortion.getDBH8() != null) {
            wG2.B(8, sineDistortion.getDBH8());
            bl = true;
        }
        if (sineDistortion.getDegreesH8() != null) {
            wG2.A(8, sineDistortion.getDegreesH8());
            bl = true;
        }
        if (sineDistortion.getAddH9() != null) {
            wG2.A(9, sineDistortion.getAddH9());
            bl = true;
        }
        if (sineDistortion.getDBH9() != null) {
            wG2.B(9, sineDistortion.getDBH9());
            bl = true;
        }
        if (sineDistortion.getDegreesH9() != null) {
            wG2.A(9, sineDistortion.getDegreesH9());
            bl = true;
        }
        if (bl) {
            return APIResponse.ok(response, "Distortion processed");
        }
        return APIResponse.badRequest(response, "No distortion entries in the request");
    }

    public APIResponse setSineConfiguration(SineConfiguration sineConfiguration, Response response) {
        boolean bl = false;
        pK pK2 = pK.\u01fe();
        if (sineConfiguration.getFrequency() != null) {
            double d2 = sineConfiguration.getFrequency();
            if (pK2.\u01e8() == vE.S) {
                pK2.t(d2);
            } else {
                lG.R(d2);
            }
            bl = true;
        }
        if (sineConfiguration.getLockFrequencyToRTAFFT() != null) {
            lG.\u00d0(sineConfiguration.getLockFrequencyToRTAFFT());
            bl = true;
        }
        if (sineConfiguration.getAddHarmonicDistortion() != null) {
            pK2.\u00ca(sineConfiguration.getAddHarmonicDistortion());
        }
        if (sineConfiguration.getAddDither() != null) {
            lG.Y(sineConfiguration.getAddDither());
            bl = true;
        }
        if (sineConfiguration.getDitherBits() != null) {
            int n2;
            int n3;
            int n4 = sineConfiguration.getDitherBits();
            if (n4 < (n3 = MG.B()) | n4 > (n2 = MG.A())) {
                return APIResponse.badRequest(response, "The requested dither bits of " + n4 + " is outside the allowed range of " + n3 + " to " + n2);
            }
            lG.\u00dd(n4);
            bl = true;
        }
        if (bl) {
            return APIResponse.ok(response, "Configuration processed");
        }
        return APIResponse.badRequest(response, "No configuration entries in the request");
    }

    public SquareConfiguration getSquareConfiguration() {
        return SquareConfiguration.builder().frequency(lG.\u028d()).dutyCyclePercent((int)Math.round(lG.\u00e7())).bandLimit(lG.\u017e()).addDither(lG.\u0191()).ditherBits(lG.\u00fb()).build();
    }

    public APIResponse setSquareConfiguration(SquareConfiguration squareConfiguration, Response response) {
        boolean bl = false;
        pK pK2 = pK.\u01fe();
        if (squareConfiguration.getFrequency() != null) {
            double d2 = squareConfiguration.getFrequency();
            if (pK2.\u01e8() == vE.A) {
                pK2.t(d2);
            } else {
                lG.M(d2);
            }
            bl = true;
        }
        if (squareConfiguration.getDutyCyclePercent() != null) {
            lG.a(squareConfiguration.getDutyCyclePercent().doubleValue());
            bl = true;
        }
        if (squareConfiguration.getBandLimit() != null) {
            lG.\u00f1(squareConfiguration.getBandLimit());
            bl = true;
        }
        if (squareConfiguration.getAddDither() != null) {
            lG.Y(squareConfiguration.getAddDither());
            bl = true;
        }
        if (squareConfiguration.getDitherBits() != null) {
            int n2;
            int n3;
            int n4 = squareConfiguration.getDitherBits();
            if (n4 < (n3 = MG.B()) | n4 > (n2 = MG.A())) {
                return APIResponse.badRequest(response, "The requested dither bits of " + n4 + " is outside the allowed range of " + n3 + " to " + n2);
            }
            lG.\u00dd(n4);
            bl = true;
        }
        if (bl) {
            return APIResponse.ok(response, "Configuration processed");
        }
        return APIResponse.badRequest(response, "No configuration entries found in the request");
    }

    public SawtoothConfiguration getSawtoothConfiguration() {
        return SawtoothConfiguration.builder().frequency(lG.\u0427()).bandLimit(lG.\u00ec()).invert(lG.\u0114()).addDither(lG.\u0191()).ditherBits(lG.\u00fb()).build();
    }

    public APIResponse setSawtoothConfiguration(SawtoothConfiguration sawtoothConfiguration, Response response) {
        boolean bl = false;
        if (sawtoothConfiguration.getFrequency() != null) {
            double d2 = sawtoothConfiguration.getFrequency();
            pK pK2 = pK.\u01fe();
            if (pK2.\u01e8() == vE.M) {
                pK2.t(d2);
            } else {
                lG.g(d2);
            }
            bl = true;
        }
        if (sawtoothConfiguration.getBandLimit() != null) {
            lG.\u00f9(sawtoothConfiguration.getBandLimit());
            bl = true;
        }
        if (sawtoothConfiguration.getInvert() != null) {
            lG.B(sawtoothConfiguration.getInvert());
            bl = true;
        }
        if (sawtoothConfiguration.getAddDither() != null) {
            lG.Y(sawtoothConfiguration.getAddDither());
            bl = true;
        }
        if (sawtoothConfiguration.getDitherBits() != null) {
            int n2;
            int n3;
            int n4 = sawtoothConfiguration.getDitherBits();
            if (n4 < (n3 = MG.B()) | n4 > (n2 = MG.A())) {
                return APIResponse.badRequest(response, "The requested dither bits of " + n4 + " is outside the allowed range of " + n3 + " to " + n2);
            }
            lG.\u00dd(n4);
            bl = true;
        }
        if (bl) {
            return APIResponse.ok(response, "Configuration processed");
        }
        return APIResponse.badRequest(response, "No configuration entries found in the request");
    }

    public ToneBurstConfiguration getToneBurstConfiguration() {
        int n2;
        String string;
        double d2;
        if (lG.\u0396()) {
            d2 = lG.\u0444();
            string = "cycles";
        } else {
            d2 = lG.\u03b0();
            string = "ms";
        }
        ToneBurstPeriod toneBurstPeriod = lG.\u0437();
        switch (toneBurstPeriod) {
            case CYCLES: {
                n2 = lG.T();
                break;
            }
            case DURN: {
                n2 = lG.\u0297();
                break;
            }
            case SAMPLES: {
                n2 = lG.\u0128();
                break;
            }
            default: {
                assert (false) : "Unhandled enum type";
                n2 = 0;
            }
        }
        return ToneBurstConfiguration.builder().frequency(lG.\u0275()).window(lG.\u0141().toString()).windowWidth(d2).windowWidthUnit(string).period(n2).periodUnit(toneBurstPeriod.unit()).repeat(lG.\u01c1()).build();
    }

    public APIResponse setToneBurstConfiguration(ToneBurstConfiguration toneBurstConfiguration, Response response) {
        Object object;
        Object object2;
        List<Object> list;
        double d2;
        boolean bl = false;
        pK pK2 = pK.\u01fe();
        if (toneBurstConfiguration.getFrequency() != null) {
            d2 = toneBurstConfiguration.getFrequency();
            if (pK2.\u01e8() == vE.E) {
                pK2.t(d2);
            } else {
                lG.f(d2);
            }
            bl = true;
        }
        if (toneBurstConfiguration.getWindow() != null) {
            Window.Types types = Window.Types.getTypeFromDescription(toneBurstConfiguration.getWindow());
            list = Arrays.asList(pK.\u01ec());
            object2 = new ArrayList();
            for (Object object3 : list) {
                object2.add(((Window.Types)((Object)object3)).toString());
            }
            if (types == null) {
                object = ValidValues.builder().message(toneBurstConfiguration.getWindow() + " is not a recognised window type").validValues((List)object2).build();
                return APIResponse.badRequest(response, (ValidValues)object);
            }
            if (list.contains((Object)types)) {
                pK2.B(types);
                bl = true;
            } else {
                object = ValidValues.builder().message(toneBurstConfiguration.getWindow() + " is not a window type toneburst accepts").validValues((List)object2).build();
                return APIResponse.badRequest(response, (ValidValues)object);
            }
        }
        if (toneBurstConfiguration.getWindowWidth() != null) {
            d2 = toneBurstConfiguration.getWindowWidth();
            object2 = toneBurstConfiguration.getWindowWidthUnit();
            object = Arrays.asList("cycles", "ms");
            if (object2 == null) {
                Object object3;
                object3 = ValidValues.builder().message("A window width unit is required").validValues((List)object).build();
                return APIResponse.badRequest(response, (ValidValues)object3);
            }
            switch (((String)object2).toLowerCase()) {
                case "cycles": {
                    double d3 = 2.0 * d2;
                    if (d3 != (double)((int)d3)) {
                        return APIResponse.badRequest(response, "Window widths in cycles must be a multiple of 0.5");
                    }
                    pK2.\u0260();
                    pK2.\u00aa(d2);
                    bl = true;
                    break;
                }
                case "ms": 
                case "milliseconds": {
                    if (d2 != (double)((int)d2)) {
                        return APIResponse.badRequest(response, "Window widths in ms must be a whole number");
                    }
                    pK2.\u026c();
                    pK2.\u00aa(d2);
                    bl = true;
                    break;
                }
                default: {
                    ValidValues validValues = ValidValues.builder().message((String)object2 + " is not a valid window width unit").validValues((List)object).build();
                    return APIResponse.badRequest(response, validValues);
                }
            }
        }
        if (toneBurstConfiguration.getPeriod() != null) {
            String string = toneBurstConfiguration.getPeriodUnit();
            list = ToneBurstPeriod.units();
            if (string == null) {
                object2 = ValidValues.builder().message("A period unit is required").validValues(list).build();
                return APIResponse.badRequest(response, (ValidValues)object2);
            }
            int n2 = toneBurstConfiguration.getPeriod();
            switch (string.toLowerCase()) {
                case "cycles": {
                    pK2.\u0274();
                    pK2.\u00c7(n2);
                    bl = true;
                    break;
                }
                case "ms": 
                case "milliseconds": {
                    pK2.\u0211();
                    pK2.\u00c7(n2);
                    bl = true;
                    break;
                }
                case "samples": {
                    ZK zK2 = ZK.C(n2);
                    if (zK2 != null) {
                        pK2.\u029b();
                        pK2.\u00c7(n2);
                        bl = true;
                        break;
                    }
                    ValidValues validValues = ValidValues.builder().message(n2 + " is not a valid samples length, it should be a power of 2 between 8192 and " + ZK.C().B()).validValues(rtaLengths).build();
                    return APIResponse.badRequest(response, validValues);
                }
                default: {
                    ValidValues validValues = ValidValues.builder().message(string + " is not a valid period unit").validValues(list).build();
                    return APIResponse.badRequest(response, validValues);
                }
            }
        }
        if (toneBurstConfiguration.getRepeat() != null) {
            pK2.\u00ba(toneBurstConfiguration.getRepeat());
        }
        if (bl) {
            return APIResponse.ok(response, "Configuration processed");
        }
        return APIResponse.badRequest(response, "No configuration entries in the request");
    }

    public CEABurstConfiguration getCEABurstConfiguration() {
        return CEABurstConfiguration.builder().frequency(lG.\u00f6()).repeat(lG.\u027c()).build();
    }

    public APIResponse setCEABurstConfiguration(CEABurstConfiguration cEABurstConfiguration, Response response) {
        boolean bl = false;
        pK pK2 = pK.\u01fe();
        if (cEABurstConfiguration.getFrequency() != null) {
            double d2 = cEABurstConfiguration.getFrequency();
            if (pK2.\u01e8() == vE.C) {
                pK2.t(d2);
            } else {
                lG.e(d2);
            }
            bl = true;
        }
        if (cEABurstConfiguration.getRepeat() != null) {
            pK2.y(cEABurstConfiguration.getRepeat());
        }
        if (bl) {
            return APIResponse.ok(response, "Configuration processed");
        }
        return APIResponse.badRequest(response, "No configuration entries in the request");
    }

    public TwoToneConfiguration getTwoToneConfiguration() {
        return TwoToneConfiguration.builder().type(lG.\u044d().apiName()).customF1(lG.\u0106()).customF2(lG.\u01df()).customRatio(lG.\u01a1()).addDither(lG.\u010a()).ditherBits(lG.\u00fb()).build();
    }

    public APIResponse setTwoToneConfiguration(TwoToneConfiguration twoToneConfiguration, Response response) {
        boolean bl = false;
        pK pK2 = pK.\u01fe();
        if (twoToneConfiguration.getType() != null) {
            TwoToneSignal twoToneSignal = TwoToneSignal.getFromApiName(twoToneConfiguration.getType());
            if (twoToneSignal != null) {
                pK2.B(twoToneSignal);
                bl = true;
            } else {
                ValidValues validValues = ValidValues.builder().message(twoToneConfiguration.getType() + " is not a valid dual tone type").validValues(GeneratorService.getTwoToneTypes()).build();
                return APIResponse.badRequest(response, validValues);
            }
        }
        if (twoToneConfiguration.getCustomF1() != null) {
            int n2 = twoToneConfiguration.getCustomF1();
            pK2.\u00b5(n2);
            bl = true;
        }
        if (twoToneConfiguration.getCustomF2() != null) {
            int n3 = twoToneConfiguration.getCustomF2();
            pK2.a(n3);
            bl = true;
        }
        if (twoToneConfiguration.getCustomRatio() != null) {
            int n4 = twoToneConfiguration.getCustomRatio();
            if (n4 == 1 || n4 == 4) {
                pK2.\u00ca(n4);
                bl = true;
            } else {
                return APIResponse.badRequest(response, n4 + " is not a valid dual tone F1/F2 ratio, valid values are 1 and 4");
            }
        }
        if (twoToneConfiguration.getAddDither() != null) {
            lG.\u00c1(twoToneConfiguration.getAddDither());
            bl = true;
        }
        if (twoToneConfiguration.getDitherBits() != null) {
            int n5;
            int n6;
            int n7 = twoToneConfiguration.getDitherBits();
            if (n7 < (n6 = MG.B()) | n7 > (n5 = MG.A())) {
                return APIResponse.badRequest(response, "The requested dither bits of " + n7 + " is outside the allowed range of " + n6 + " to " + n5);
            }
            lG.\u00dd(n7);
            bl = true;
        }
        if (bl) {
            return APIResponse.ok(response, "Configuration processed");
        }
        return APIResponse.badRequest(response, "No configuration entries in the request");
    }

    public ThreeToneConfiguration getThreeToneConfiguration() {
        return ThreeToneConfiguration.builder().type(lG.\u01cf().apiName()).customF1(lG.\u03b6()).customF2(lG.\u00ce()).customF3(lG.\u01a6()).addDither(lG.\u02bd()).ditherBits(lG.\u00fb()).build();
    }

    public APIResponse setThreeToneConfiguration(ThreeToneConfiguration threeToneConfiguration, Response response) {
        boolean bl = false;
        pK pK2 = pK.\u01fe();
        if (threeToneConfiguration.getType() != null) {
            ThreeToneSignal threeToneSignal = ThreeToneSignal.getFromApiName(threeToneConfiguration.getType());
            if (threeToneSignal != null) {
                pK2.B(threeToneSignal);
                bl = true;
            } else {
                ValidValues validValues = ValidValues.builder().message(threeToneConfiguration.getType() + " is not a valid dual tone type").validValues(GeneratorService.getThreeToneTypes()).build();
                return APIResponse.badRequest(response, validValues);
            }
        }
        if (threeToneConfiguration.getCustomF1() != null) {
            int n2 = threeToneConfiguration.getCustomF1();
            pK2.\u00c3(n2);
            bl = true;
        }
        if (threeToneConfiguration.getCustomF2() != null) {
            int n3 = threeToneConfiguration.getCustomF2();
            pK2.k(n3);
            bl = true;
        }
        if (threeToneConfiguration.getCustomF3() != null) {
            int n4 = threeToneConfiguration.getCustomF3();
            pK2.\u00a4(n4);
            bl = true;
        }
        if (threeToneConfiguration.getAddDither() != null) {
            lG.\u00d6(threeToneConfiguration.getAddDither());
            bl = true;
        }
        if (threeToneConfiguration.getDitherBits() != null) {
            int n5;
            int n6;
            int n7 = threeToneConfiguration.getDitherBits();
            if (n7 < (n6 = MG.B()) | n7 > (n5 = MG.A())) {
                return APIResponse.badRequest(response, "The requested dither bits of " + n7 + " is outside the allowed range of " + n6 + " to " + n5);
            }
            lG.\u00dd(n7);
            bl = true;
        }
        if (bl) {
            return APIResponse.ok(response, "Configuration processed");
        }
        return APIResponse.badRequest(response, "No configuration entries in the request");
    }

    public FourToneConfiguration getFourToneConfiguration() {
        return FourToneConfiguration.builder().type(lG.\u0142().apiName()).f1(lG.\u0392()).f2(lG.r()).f3(lG.\u017f()).f4(lG.\u0287()).addDither(lG.\u01cb()).ditherBits(lG.\u00fb()).build();
    }

    public APIResponse setFourToneConfiguration(FourToneConfiguration fourToneConfiguration, Response response) {
        boolean bl = false;
        pK pK2 = pK.\u01fe();
        if (fourToneConfiguration.getType() != null) {
            FourToneSignal fourToneSignal = FourToneSignal.getFromApiName(fourToneConfiguration.getType());
            if (fourToneSignal != null) {
                pK2.B(fourToneSignal);
                bl = true;
            } else {
                ValidValues validValues = ValidValues.builder().message(fourToneConfiguration.getType() + " is not a valid dual tone type").validValues(GeneratorService.getFourToneTypes()).build();
                return APIResponse.badRequest(response, validValues);
            }
        }
        if (fourToneConfiguration.getF1() != null) {
            int n2 = fourToneConfiguration.getF1();
            pK2.t(n2);
            bl = true;
        }
        if (fourToneConfiguration.getF2() != null) {
            int n3 = fourToneConfiguration.getF2();
            pK2.\u00c5(n3);
            bl = true;
        }
        if (fourToneConfiguration.getF3() != null) {
            int n4 = fourToneConfiguration.getF3();
            pK2.i(n4);
            bl = true;
        }
        if (fourToneConfiguration.getF4() != null) {
            int n5 = fourToneConfiguration.getF4();
            pK2.w(n5);
            bl = true;
        }
        if (fourToneConfiguration.getAddDither() != null) {
            lG.\u00aa(fourToneConfiguration.getAddDither());
            bl = true;
        }
        if (fourToneConfiguration.getDitherBits() != null) {
            int n6;
            int n7;
            int n8 = fourToneConfiguration.getDitherBits();
            if (n8 < (n7 = MG.B()) | n8 > (n6 = MG.A())) {
                return APIResponse.badRequest(response, "The requested dither bits of " + n8 + " is outside the allowed range of " + n7 + " to " + n6);
            }
            lG.\u00dd(n8);
            bl = true;
        }
        if (bl) {
            return APIResponse.ok(response, "Configuration processed");
        }
        return APIResponse.badRequest(response, "No configuration entries in the request");
    }

    public MultitoneConfiguration getMultitoneConfiguration() {
        return MultitoneConfiguration.builder().startFreq(lG.\u0279()).endFreq(lG.p()).sequenceLength(ZK.B(lG.\u0213()).A()).spectrum(lG.\u00f3().apiName()).spacing(lG.\u0431().apiName()).linearSpacingHz(lG.\u03bd()).octaveSpacing(lG.\u018b().apiName()).decadeSpacing(lG.\u03bf().apiName()).minimiseCrestFactor(lG.\u0410()).addDither(lG.\u01b4()).ditherBits(lG.\u00fb()).build();
    }

    public MultitoneDetails getMultitoneDetails() {
        pK pK2 = pK.\u01fe();
        return MultitoneDetails.builder().firstFreq(pK2.\u025c()).lastFreq(pK2.\u0210()).numTones(pK2.\u01df()).crestFactordB(pK2.\u0200()).kurtosis(pK2.\u02b5()).build();
    }

    public APIResponse setMultitoneConfiguration(MultitoneConfiguration multitoneConfiguration, Response response) {
        Enum enum_;
        boolean bl = false;
        pK pK2 = pK.\u01fe();
        if (multitoneConfiguration.getStartFreq() != null) {
            pK2.\u00cd(multitoneConfiguration.getStartFreq());
            bl = true;
        }
        if (multitoneConfiguration.getEndFreq() != null) {
            pK2.m(multitoneConfiguration.getEndFreq());
            bl = true;
        }
        if (multitoneConfiguration.getSequenceLength() != null) {
            enum_ = ZK.A(multitoneConfiguration.getSequenceLength());
            if (enum_ == null || !Arrays.asList(pK.\u01ed()).contains(enum_)) {
                ValidValues validValues = ValidValues.builder().message(multitoneConfiguration.getSequenceLength() + " is not a valid multitone sequence length").validValues(GeneratorService.getMultitoneLengths()).build();
                return APIResponse.badRequest(response, validValues);
            }
            pK2.C((ZK)enum_);
            bl = true;
        }
        if (multitoneConfiguration.getSpectrum() != null) {
            enum_ = PeriodicNoiseSpectrum.getFromApiName(multitoneConfiguration.getSpectrum());
            if (enum_ != null) {
                pK2.A((PeriodicNoiseSpectrum)enum_);
                bl = true;
            } else {
                ValidValues validValues = ValidValues.builder().message(multitoneConfiguration.getSpectrum() + " is not a valid multitone spectrum setting").validValues(GeneratorService.getSpectrumTypes()).build();
                return APIResponse.badRequest(response, validValues);
            }
        }
        if (multitoneConfiguration.getSpacing() != null) {
            enum_ = MultitoneSpacing.getFromApiName(multitoneConfiguration.getSpacing());
            if (enum_ != null) {
                pK2.B((MultitoneSpacing)enum_);
                bl = true;
            } else {
                ValidValues validValues = ValidValues.builder().message(multitoneConfiguration.getSpacing() + " is not a valid multitone spacing").validValues(GeneratorService.getMultitoneSpacings()).build();
                return APIResponse.badRequest(response, validValues);
            }
        }
        if (multitoneConfiguration.getLinearSpacingHz() != null) {
            pK2.g(multitoneConfiguration.getLinearSpacingHz());
            bl = true;
        }
        if (multitoneConfiguration.getOctaveSpacing() != null) {
            enum_ = OctaveFraction.getFromApiName(multitoneConfiguration.getOctaveSpacing());
            if (enum_ != null) {
                pK2.A((OctaveFraction)enum_);
                bl = true;
            } else {
                ValidValues validValues = ValidValues.builder().message(multitoneConfiguration.getOctaveSpacing() + " is not a valid multitone octave spacing").validValues(GeneratorService.getOctaveFractions()).build();
                return APIResponse.badRequest(response, validValues);
            }
        }
        if (multitoneConfiguration.getDecadeSpacing() != null) {
            enum_ = DecadeFraction.getFromApiName(multitoneConfiguration.getDecadeSpacing());
            if (enum_ != null) {
                pK2.A((DecadeFraction)enum_);
                bl = true;
            } else {
                ValidValues validValues = ValidValues.builder().message(multitoneConfiguration.getDecadeSpacing() + " is not a valid multitone octave spacing").validValues(GeneratorService.getDecadeFractions()).build();
                return APIResponse.badRequest(response, validValues);
            }
        }
        if (multitoneConfiguration.getMinimiseCrestFactor() != null) {
            lG.\u00e8(multitoneConfiguration.getMinimiseCrestFactor());
            bl = true;
        }
        if (multitoneConfiguration.getAddDither() != null) {
            lG.\u00f5(multitoneConfiguration.getAddDither());
            bl = true;
        }
        if (multitoneConfiguration.getDitherBits() != null) {
            int n2;
            int n3;
            int n4 = multitoneConfiguration.getDitherBits();
            if (n4 < (n3 = MG.B()) | n4 > (n2 = MG.A())) {
                return APIResponse.badRequest(response, "The requested dither bits of " + n4 + " is outside the allowed range of " + n3 + " to " + n2);
            }
            lG.\u00dd(n4);
            bl = true;
        }
        if (bl) {
            return APIResponse.ok(response, "Configuration processed");
        }
        return APIResponse.badRequest(response, "No configuration entries in the request");
    }

    public LinearSweepConfiguration getLinearSweepConfiguration() {
        return LinearSweepConfiguration.builder().startFrequency(lG.\u0115()).endFrequency(lG.\u00d1()).fadeInMilliseconds(lG.\u0165()).fadeOutMilliseconds(lG.\u0389()).durationSeconds(lG.\u0216()).loop(lG.\u00ba()).build();
    }

    public APIResponse setLinearSweepConfiguration(LinearSweepConfiguration linearSweepConfiguration, Response response) {
        boolean bl = false;
        pK pK2 = pK.\u01fe();
        if (linearSweepConfiguration.getStartFrequency() != null) {
            pK2.r(linearSweepConfiguration.getStartFrequency().doubleValue());
            bl = true;
        }
        if (linearSweepConfiguration.getEndFrequency() != null) {
            pK2.w(linearSweepConfiguration.getEndFrequency().doubleValue());
            bl = true;
        }
        if (linearSweepConfiguration.getFadeInMilliseconds() != null) {
            pK2.\u00a2(linearSweepConfiguration.getFadeInMilliseconds());
            bl = true;
        }
        if (linearSweepConfiguration.getFadeOutMilliseconds() != null) {
            pK2.z(linearSweepConfiguration.getFadeOutMilliseconds());
            bl = true;
        }
        if (linearSweepConfiguration.getDurationSeconds() != null) {
            pK2.g(linearSweepConfiguration.getDurationSeconds());
            bl = true;
        }
        if (linearSweepConfiguration.getLoop() != null) {
            lG.V(linearSweepConfiguration.getLoop());
            bl = true;
        }
        if (bl) {
            return APIResponse.ok(response, "Configuration processed");
        }
        return APIResponse.badRequest(response, "No configuration entries in the request");
    }

    public LogSweepConfiguration getLogSweepConfiguration() {
        return LogSweepConfiguration.builder().startFrequency(lG.\u03ca()).endFrequency(lG.\u03b8()).fadeInFraction(lG.\u03be().apiName()).fadeOutFraction(lG.\u0413().apiName()).durationSeconds(lG.u()).loop(lG.\u015a()).build();
    }

    public APIResponse setLogSweepConfiguration(LogSweepConfiguration logSweepConfiguration, Response response) {
        FadeFraction fadeFraction;
        boolean bl = false;
        pK pK2 = pK.\u01fe();
        if (logSweepConfiguration.getStartFrequency() != null) {
            pK2.i(logSweepConfiguration.getStartFrequency().doubleValue());
            bl = true;
        }
        if (logSweepConfiguration.getEndFrequency() != null) {
            pK2.z(logSweepConfiguration.getEndFrequency().doubleValue());
            bl = true;
        }
        if (logSweepConfiguration.getFadeInFraction() != null) {
            fadeFraction = FadeFraction.getFromApiName(logSweepConfiguration.getFadeInFraction());
            if (fadeFraction == null) {
                ValidValues validValues = ValidValues.builder().message(logSweepConfiguration.getFadeInFraction() + " is not a valid fade fraction").validValues(GeneratorService.getFadeFractions()).build();
                return APIResponse.badRequest(response, validValues);
            }
            pK2.B(fadeFraction);
            bl = true;
        }
        if (logSweepConfiguration.getFadeOutFraction() != null) {
            fadeFraction = FadeFraction.getFromApiName(logSweepConfiguration.getFadeOutFraction());
            if (fadeFraction == null) {
                ValidValues validValues = ValidValues.builder().message(logSweepConfiguration.getFadeOutFraction() + " is not a valid fade fraction").validValues(GeneratorService.getFadeFractions()).build();
                return APIResponse.badRequest(response, validValues);
            }
            pK2.A(FadeFraction.getFromApiName(logSweepConfiguration.getFadeOutFraction()));
            bl = true;
        }
        if (logSweepConfiguration.getDurationSeconds() != null) {
            pK2.l(logSweepConfiguration.getDurationSeconds());
            bl = true;
        }
        if (logSweepConfiguration.getLoop() != null) {
            lG.\u00d4(logSweepConfiguration.getLoop());
            bl = true;
        }
        if (bl) {
            return APIResponse.ok(response, "Configuration processed");
        }
        return APIResponse.badRequest(response, "No configuration entries in the request");
    }

    public static MeasSweepConfiguration getMeasSweepConfiguration() {
        MJ mJ2 = RoomEQ_Wizard.v;
        return MeasSweepConfiguration.builder().startFrequency(mJ2.O()).endFrequency(mJ2.J()).length(uB.B(mJ2.E()).D()).fillSilenceWithDither(lG.\u0156()).build();
    }

    public static APIResponse setMeasSweepConfiguration(final MeasSweepConfiguration measSweepConfiguration, Response response) {
        boolean bl = false;
        final MJ mJ2 = RoomEQ_Wizard.v;
        if (measSweepConfiguration.getStartFrequency() != null) {
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        mJ2.B(measSweepConfiguration.getStartFrequency());
                    }
                });
            }
            catch (InterruptedException | InvocationTargetException exception) {
                // empty catch block
            }
            bl = true;
        }
        if (measSweepConfiguration.getEndFrequency() != null) {
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        mJ2.C(measSweepConfiguration.getEndFrequency());
                    }
                });
            }
            catch (InterruptedException | InvocationTargetException exception) {
                // empty catch block
            }
            bl = true;
        }
        if (measSweepConfiguration.getLength() != null) {
            final uB uB2 = uB.A(measSweepConfiguration.getLength());
            if (uB2 == null) {
                ValidValues validValues = ValidValues.builder().message(measSweepConfiguration.getLength() + " is not a valid meas sweep length").validValues(GeneratorService.getSweepLengths()).build();
                return APIResponse.badRequest(response, validValues);
            }
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        mJ2.D(uB2.E());
                    }
                });
            }
            catch (InterruptedException | InvocationTargetException exception) {
                // empty catch block
            }
            bl = true;
        }
        if (measSweepConfiguration.getFillSilenceWithDither() != null) {
            lG.C(measSweepConfiguration.getFillSilenceWithDither());
            bl = true;
        }
        if (bl) {
            return APIResponse.ok(response, "Configuration processed");
        }
        return APIResponse.badRequest(response, "No configuration entries in the request");
    }

    public Object getCurrentSignalConfiguration() {
        pK pK2 = pK.\u01fe();
        return this.getSignalConfiguration(pK2.\u01e8());
    }

    public APIResponse setSignal(Signal signal, Response response) {
        if (signal.getSignal() == null) {
            ValidValues validValues = ValidValues.builder().message("No signal in request").validValues(GeneratorService.getSignals()).build();
            return APIResponse.badRequest(response, validValues);
        }
        vE vE2 = vE.A(signal.getSignal());
        if (vE2 == null) {
            ValidValues validValues = ValidValues.builder().message(signal.getSignal() + " is not a valid signal").validValues(GeneratorService.getSignals()).build();
            return APIResponse.badRequest(response, validValues);
        }
        pK pK2 = pK.\u01fe();
        pK2.C(vE2);
        return APIResponse.ok(response, signal.getSignal() + " selected");
    }

    public Boolean getInvertSecondOutput() {
        return lG.\u0268();
    }

    public APIResponse setInvertSecondOutput(Boolean bl, Response response) {
        if (bl == null) {
            return APIResponse.badRequest(response, "No setting in request");
        }
        lG.i(bl);
        return APIResponse.ok(response, "Choice set");
    }
}

