/*
 * Decompiled with CFR 0.152.
 */
package roomeqwizard.api;

import java.awt.EventQueue;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import roomeqwizard.Equaliser;
import roomeqwizard.FB;
import roomeqwizard.PE;
import roomeqwizard.RoomEQ_Wizard;
import roomeqwizard.TG;
import roomeqwizard.TargetShape;
import roomeqwizard.XG;
import roomeqwizard.XOverChoice;
import roomeqwizard.XOverSlope;
import roomeqwizard.api.APIResponse;
import roomeqwizard.api.Publisher;
import roomeqwizard.api.model.ActionResult;
import roomeqwizard.api.model.EqualiserEntry;
import roomeqwizard.api.model.MatchTargetSettings;
import roomeqwizard.api.model.RoomCurveSettings;
import roomeqwizard.api.model.Subscriber;
import roomeqwizard.api.model.SubscriptionType;
import roomeqwizard.api.model.TargetSettings;
import roomeqwizard.api.model.ValidRange;
import roomeqwizard.api.model.ValidValues;
import roomeqwizard.eG;
import roomeqwizard.gI;
import roomeqwizard.iA;
import roomeqwizard.lG;
import spark.Request;
import spark.Response;

public class EQService
extends Publisher {
    private static final String MANUFACTURER_KEY = "manufacturer";
    private static List<String> manufacturers;
    private static List<String> targetShapes;
    private static List<String> crossoverTypes;
    private static List<Integer> slopes;
    private static List<EqualiserEntry> equalisers;
    private iA eqPanel;

    public EQService() {
        try {
            EventQueue.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    XG.K();
                    EQService.this.eqPanel = iA.\u01d1();
                }
            });
        }
        catch (InterruptedException | InvocationTargetException exception) {
            // empty catch block
        }
    }

    public static String getManufacturerKey() {
        return MANUFACTURER_KEY;
    }

    public static List<String> getTargetShapes() {
        if (targetShapes == null) {
            targetShapes = new ArrayList<String>();
            for (TargetShape targetShape : TargetShape.values()) {
                targetShapes.add(targetShape.apiName());
            }
        }
        return targetShapes;
    }

    public static List<String> getCrossoverTypes() {
        if (crossoverTypes == null) {
            crossoverTypes = new ArrayList<String>();
            for (XOverChoice xOverChoice : XOverChoice.values()) {
                if (xOverChoice == XOverChoice.BRICKWALL) continue;
                crossoverTypes.add(xOverChoice.apiName());
            }
        }
        return crossoverTypes;
    }

    public static List<Integer> getSlopes() {
        if (slopes == null) {
            slopes = new ArrayList<Integer>();
            for (XOverSlope xOverSlope : XOverSlope.values()) {
                slopes.add(xOverSlope.getSlopedB());
            }
        }
        return slopes;
    }

    public static List<String> getManufacturers() {
        if (manufacturers == null) {
            manufacturers = new ArrayList<String>();
            for (PE pE2 : PE.values()) {
                manufacturers.add(pE2.A());
            }
        }
        return manufacturers;
    }

    public static List<EqualiserEntry> getEqualisers(Request request, Response response) {
        String string = request.queryParamOrDefault(MANUFACTURER_KEY, "");
        if (string.isEmpty()) {
            return APIResponse.ok(response, EQService.getAllEqualisers());
        }
        PE pE2 = PE.A(string);
        if (pE2 != null) {
            return EQService.getEqualisers(pE2);
        }
        return Collections.emptyList();
    }

    public static List<EqualiserEntry> getAllEqualisers() {
        if (equalisers == null) {
            equalisers = new ArrayList<EqualiserEntry>();
            for (PE pE2 : PE.values()) {
                List<Equaliser> list = FB.A(pE2);
                for (Equaliser equaliser : list) {
                    EqualiserEntry equaliserEntry = EqualiserEntry.builder().manufacturer(pE2.A()).model(equaliser.getModel()).build();
                    equalisers.add(equaliserEntry);
                }
            }
        }
        return equalisers;
    }

    public static List<EqualiserEntry> getEqualisers(PE pE2) {
        ArrayList<EqualiserEntry> arrayList = new ArrayList<EqualiserEntry>();
        List<Equaliser> list = FB.A(pE2);
        for (Equaliser equaliser : list) {
            EqualiserEntry equaliserEntry = EqualiserEntry.builder().manufacturer(pE2.A()).model(equaliser.getModel()).build();
            arrayList.add(equaliserEntry);
        }
        return arrayList;
    }

    public static EqualiserEntry getDefaultEqualiser() {
        Equaliser equaliser = RoomEQ_Wizard.l;
        EqualiserEntry equaliserEntry = EqualiserEntry.builder().manufacturer(equaliser.getManufacturer().A()).model(equaliser.getModel()).build();
        return equaliserEntry;
    }

    public static APIResponse setDefaultEqualiser(EqualiserEntry equaliserEntry, Response response) {
        if (equaliserEntry.getManufacturer() != null) {
            PE pE2 = PE.A(equaliserEntry.getManufacturer());
            if (pE2 == null) {
                ValidValues validValues = ValidValues.builder().message(equaliserEntry.getManufacturer() + " is not a valid manufacturer").validValues(EQService.getManufacturers()).build();
                return APIResponse.badRequest(response, validValues);
            }
            if (equaliserEntry.getModel() != null) {
                List<Equaliser> list = FB.A(pE2);
                for (Equaliser equaliser : list) {
                    if (!equaliser.getModel().equalsIgnoreCase(equaliserEntry.getModel())) continue;
                    FB.B(equaliser);
                    return APIResponse.ok(response, "Default equaliser changed");
                }
                return APIResponse.badRequest(response, equaliserEntry.getModel() + " is not a recognised model for " + pE2.A());
            }
        }
        return APIResponse.badRequest(response, "No equaliser entry in the request");
    }

    public static TargetSettings getDefaultTargetSettings() {
        TargetSettings targetSettings = TargetSettings.builder().shape(lG.\u0452().apiName()).bassManagementSlopedBPerOctave(lG.\u01b2().getSlopedB()).bassManagementCutoffHz((int)Math.round(lG.\u03c7())).lowFreqSlopedBPerOctave(lG.\u02b6().getSlopedB()).lowFreqCutoffHz((int)Math.round(lG.f())).lowPassCrossoverType(lG.\u0439().apiName()).lowPassCutoffHz((int)Math.round(lG.\u026c())).highPassCrossoverType(lG.\u00e6().apiName()).highPassCutoffHz((int)Math.round(lG.\u010f())).build();
        return targetSettings;
    }

    public static APIResponse setDefaultTargetSettings(TargetSettings targetSettings, Response response) {
        Enum enum_;
        boolean bl = false;
        if (targetSettings.getShape() != null) {
            enum_ = TargetShape.getFromApiName(targetSettings.getShape());
            if (enum_ == null) {
                ValidValues validValues = ValidValues.builder().message(targetSettings.getShape() + " is not a valid target shape").validValues(EQService.getTargetShapes()).build();
                return APIResponse.badRequest(response, validValues);
            }
            lG.A((TargetShape)enum_);
            bl = true;
        }
        if (targetSettings.getBassManagementSlopedBPerOctave() != null) {
            enum_ = XOverSlope.getSlopeFromdBPerOctave(targetSettings.getBassManagementSlopedBPerOctave());
            if (enum_ == null) {
                ValidValues validValues = ValidValues.builder().message(targetSettings.getBassManagementSlopedBPerOctave() + " is not a valid slope").validValues(EQService.getSlopes()).build();
                return APIResponse.badRequest(response, validValues);
            }
            lG.A((XOverSlope)enum_);
            bl = true;
        }
        if (targetSettings.getBassManagementCutoffHz() != null) {
            int n2 = targetSettings.getBassManagementCutoffHz();
            if (!EQService.cutoffIsValid(n2, eG.c())) {
                return APIResponse.badRequest(response, EQService.validCutoffValues(eG.c()));
            }
            lG.c((double)n2);
            bl = true;
        }
        if (targetSettings.getLowFreqSlopedBPerOctave() != null) {
            XOverSlope xOverSlope = XOverSlope.getSlopeFromdBPerOctave(targetSettings.getLowFreqSlopedBPerOctave());
            if (xOverSlope == null) {
                ValidValues validValues = ValidValues.builder().message(targetSettings.getLowFreqSlopedBPerOctave() + " is not a valid slope").validValues(EQService.getSlopes()).build();
                return APIResponse.badRequest(response, validValues);
            }
            lG.B(xOverSlope);
            bl = true;
        }
        if (targetSettings.getLowFreqCutoffHz() != null) {
            int n3 = targetSettings.getLowFreqCutoffHz();
            if (!EQService.cutoffIsValid(n3, eG.d())) {
                return APIResponse.badRequest(response, EQService.validCutoffValues(eG.d()));
            }
            lG.\u00ca((double)n3);
            bl = true;
        }
        if (targetSettings.getLowPassCrossoverType() != null) {
            XOverChoice xOverChoice = XOverChoice.getFromApiName(targetSettings.getLowPassCrossoverType());
            if (xOverChoice == null) {
                ValidValues validValues = ValidValues.builder().message(targetSettings.getShape() + " is not a valid crossover type").validValues(EQService.getCrossoverTypes()).build();
                return APIResponse.badRequest(response, validValues);
            }
            lG.D(xOverChoice);
            bl = true;
        }
        if (targetSettings.getHighPassCrossoverType() != null) {
            XOverChoice xOverChoice = XOverChoice.getFromApiName(targetSettings.getHighPassCrossoverType());
            if (xOverChoice == null) {
                ValidValues validValues = ValidValues.builder().message(targetSettings.getShape() + " is not a valid crossover type").validValues(EQService.getCrossoverTypes()).build();
                return APIResponse.badRequest(response, validValues);
            }
            lG.F(xOverChoice);
            bl = true;
        }
        if (targetSettings.getLowPassCutoffHz() != null) {
            int n4 = targetSettings.getLowPassCutoffHz();
            if (!EQService.cutoffIsValid(n4, eG.c())) {
                return APIResponse.badRequest(response, EQService.validCutoffValues(eG.c()));
            }
            lG.\u00c7((double)n4);
            bl = true;
        }
        if (targetSettings.getHighPassCutoffHz() != null) {
            int n5 = targetSettings.getHighPassCutoffHz();
            if (!EQService.cutoffIsValid(n5, eG.c())) {
                return APIResponse.badRequest(response, EQService.validCutoffValues(eG.c()));
            }
            lG.\u00aa((double)n5);
            bl = true;
        }
        if (!bl) {
            return APIResponse.badRequest(response, "Nothing to update in the request");
        }
        return APIResponse.ok(response, "Update processed");
    }

    public static boolean cutoffIsValid(int n2, int n3) {
        return n2 >= n3 && n2 <= eG.f();
    }

    public static String validCutoffValues(int n2) {
        return "The cutoff must be between " + n2 + " and " + eG.f() + " Hz";
    }

    public static RoomCurveSettings getDefaultRoomCurveSettings() {
        RoomCurveSettings roomCurveSettings = RoomCurveSettings.builder().addRoomCurve(lG.\u01b5()).lowFreqRiseStartHz(lG.\u01b1()).lowFreqRiseEndHz(lG.m()).lowFreqRiseSlopedBPerOctave(lG.\u01ad()).highFreqFallStartHz(lG.k()).highFreqFallSlopedBPerOctave(lG.\u016d()).build();
        return roomCurveSettings;
    }

    public static APIResponse setDefaultRoomCurveSettings(RoomCurveSettings roomCurveSettings, Response response) {
        int n2;
        boolean bl = false;
        if (roomCurveSettings.getAddRoomCurve() != null) {
            lG.J(roomCurveSettings.getAddRoomCurve());
            bl = true;
        }
        if (roomCurveSettings.getLowFreqRiseStartHz() != null) {
            n2 = roomCurveSettings.getLowFreqRiseStartHz();
            if (n2 < eG.o() || n2 > eG.X()) {
                return APIResponse.badRequest(response, "The low freq rise start must be between " + eG.o() + " and " + eG.X() + " Hz");
            }
            lG.\u00c7(n2);
            bl = true;
        }
        if (roomCurveSettings.getLowFreqRiseEndHz() != null) {
            n2 = roomCurveSettings.getLowFreqRiseEndHz();
            if (n2 < eG.g() || n2 > eG.n()) {
                return APIResponse.badRequest(response, "The low freq rise end must be between " + eG.g() + " and " + eG.n() + " Hz");
            }
            lG.s(n2);
            bl = true;
        }
        if (roomCurveSettings.getLowFreqRiseSlopedBPerOctave() != null) {
            double d2 = roomCurveSettings.getLowFreqRiseSlopedBPerOctave();
            if (d2 < eG.i() || d2 > eG.p()) {
                return APIResponse.badRequest(response, "The slope must be between " + eG.i() + " and " + eG.p() + " dB per octave");
            }
            lG.u(d2);
            bl = true;
        }
        if (roomCurveSettings.getHighFreqFallStartHz() != null) {
            int n3 = roomCurveSettings.getHighFreqFallStartHz();
            if (n3 < eG.r() || n3 > eG._()) {
                return APIResponse.badRequest(response, "The high freq fall start must be between " + eG.r() + " and " + eG._() + " Hz");
            }
            lG.\u00f4(n3);
            bl = true;
        }
        if (roomCurveSettings.getHighFreqFallSlopedBPerOctave() != null) {
            double d3 = roomCurveSettings.getHighFreqFallSlopedBPerOctave();
            if (d3 < eG.i() || d3 > eG.p()) {
                return APIResponse.badRequest(response, "The slope must be between " + eG.i() + " and " + eG.p() + " dB per octave");
            }
            lG.\u00ce(d3);
            bl = true;
        }
        if (!bl) {
            return APIResponse.badRequest(response, "Nothing to update in the request");
        }
        return APIResponse.ok(response, "Update processed");
    }

    public double getTargetLevel() {
        return lG.\u00ee();
    }

    public APIResponse setTargetLevel(Double d2, Response response) {
        if (d2 == null) {
            return APIResponse.badRequest(response, "No setting in request");
        }
        lG.S(d2);
        return APIResponse.ok(response, "Target level set");
    }

    public String getHouseCurvePath() {
        return RoomEQ_Wizard.Y.getSourcePath();
    }

    public APIResponse clearHouseCurvePath(Response response) {
        this.eqPanel.\u01d6();
        return APIResponse.ok(response, "House curve cleared");
    }

    public APIResponse setHouseCurvePath(String string, Response response) {
        if (string == null) {
            return APIResponse.badRequest(response, "No house curve path in request");
        }
        if (string.trim().isEmpty()) {
            return this.clearHouseCurvePath(response);
        }
        String string2 = string;
        File file = new File(string2);
        if (!file.isDirectory() && !file.exists()) {
            return APIResponse.badRequest(response, "File " + string2 + " not found");
        }
        if (string2.toLowerCase().endsWith(".mdat")) {
            return APIResponse.badRequest(response, "Cal files should be in text format, not mdat files");
        }
        if (!file.isFile()) {
            return APIResponse.badRequest(response, string2 + " is not a file");
        }
        try {
            ActionResult actionResult = RoomEQ_Wizard.Y.calFileLoader(file, null, null, true);
            if (!actionResult.isSuccess()) {
                return APIResponse.badRequest(response, "Failed to load " + string2 + ": " + actionResult.getApiMessage());
            }
            this.eqPanel.P(string2);
            return APIResponse.ok(response, "House curve set");
        }
        catch (IOException iOException) {
            return APIResponse.badRequest(response, "IO Exception trying to open file " + iOException.getMessage());
        }
    }

    public static MatchTargetSettings getMatchTargetSettings() {
        MatchTargetSettings matchTargetSettings = MatchTargetSettings.builder().startFrequency(lG.\u00de()).endFrequency(lG.\u018a()).individualMaxBoostdB(lG.\u0186()).overallMaxBoostdB(lG.\u0284()).flatnessTargetdB(lG.\u013b()).allowNarrowFiltersBelow200Hz(lG.\u0267()).varyQAbove200Hz(lG.\u0139()).allowLowShelf(lG.\u02e4()).allowHighShelf(lG.\u040f()).lowShelfMin(lG.g()).lowShelfMax(lG.\u03c0()).highShelfMin(lG.j()).highShelfMax(lG.\u03c5()).build();
        return matchTargetSettings;
    }

    public static APIResponse setMatchTargetSettings(MatchTargetSettings matchTargetSettings, Response response) {
        ValidRange validRange;
        Integer n2;
        boolean bl = false;
        if (matchTargetSettings.getStartFrequency() != null) {
            lG.\u00fa(matchTargetSettings.getStartFrequency());
            bl = true;
        }
        if (matchTargetSettings.getEndFrequency() != null) {
            lG.\u010b(matchTargetSettings.getEndFrequency());
            bl = true;
        }
        if (matchTargetSettings.getIndividualMaxBoostdB() != null) {
            n2 = matchTargetSettings.getIndividualMaxBoostdB();
            validRange = TG.A(gI.D, n2);
            if (validRange != null) {
                return APIResponse.badRequest(response, validRange);
            }
            lG.\u00a4(n2);
            bl = true;
        }
        if (matchTargetSettings.getOverallMaxBoostdB() != null) {
            n2 = matchTargetSettings.getOverallMaxBoostdB();
            validRange = TG.A(gI.C, n2);
            if (validRange != null) {
                return APIResponse.badRequest(response, validRange);
            }
            lG.v(n2);
            bl = true;
        }
        if (matchTargetSettings.getFlatnessTargetdB() != null) {
            n2 = matchTargetSettings.getFlatnessTargetdB();
            validRange = TG.A(gI.G, n2);
            if (validRange != null) {
                return APIResponse.badRequest(response, validRange);
            }
            lG.\u00d1(n2);
            bl = true;
        }
        if (matchTargetSettings.getAllowNarrowFiltersBelow200Hz() != null) {
            lG.\u00a3(matchTargetSettings.getAllowNarrowFiltersBelow200Hz());
            bl = true;
        }
        if (matchTargetSettings.getVaryQAbove200Hz() != null) {
            lG.\u00a2(matchTargetSettings.getVaryQAbove200Hz());
            bl = true;
        }
        if (matchTargetSettings.getAllowLowShelf() != null) {
            lG.Q(matchTargetSettings.getAllowLowShelf());
            bl = true;
        }
        if (matchTargetSettings.getAllowHighShelf() != null) {
            lG.\u00f8(matchTargetSettings.getAllowHighShelf());
            bl = true;
        }
        if (matchTargetSettings.getLowShelfMin() != null) {
            n2 = matchTargetSettings.getLowShelfMin();
            validRange = TG.A(gI.H, n2);
            if (validRange != null) {
                return APIResponse.badRequest(response, validRange);
            }
            lG.\u010a(n2);
            bl = true;
        }
        if (matchTargetSettings.getLowShelfMax() != null) {
            n2 = matchTargetSettings.getLowShelfMax();
            validRange = TG.A(gI.B, n2);
            if (validRange != null) {
                return APIResponse.badRequest(response, validRange);
            }
            lG.\u011b(n2);
            bl = true;
        }
        if (matchTargetSettings.getHighShelfMin() != null) {
            n2 = matchTargetSettings.getHighShelfMin();
            validRange = TG.A(gI.A, n2);
            if (validRange != null) {
                return APIResponse.badRequest(response, validRange);
            }
            lG.t(n2);
        }
        if (matchTargetSettings.getHighShelfMax() != null) {
            n2 = matchTargetSettings.getHighShelfMax();
            validRange = TG.A(gI.F, n2);
            if (validRange != null) {
                return APIResponse.badRequest(response, validRange);
            }
            lG.\u00cb(n2);
        }
        if (!bl) {
            return APIResponse.badRequest(response, "Nothing to update in the request");
        }
        return APIResponse.ok(response, "Update processed");
    }

    @Override
    public void addSubscriptionToSource(SubscriptionType subscriptionType) {
        this.eqPanel.G(subscriptionType, this);
    }

    @Override
    public void removeSubscriptionFromSource(SubscriptionType subscriptionType) {
        this.eqPanel.H(subscriptionType, this);
    }

    @Override
    public ValidValues checkSubscriptionParameters(SubscriptionType subscriptionType, Subscriber subscriber) {
        switch (subscriptionType) {
            case EQ_PROGRESS: {
                break;
            }
            default: {
                assert (false) : "Unhandled enum type " + (Object)((Object)subscriptionType);
                break;
            }
        }
        return null;
    }
}

