/*
 * Decompiled with CFR 0.152.
 */
package roomeqwizard.api;

import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import roomeqwizard.AL;
import roomeqwizard.CalData;
import roomeqwizard.CalParamType;
import roomeqwizard.F;
import roomeqwizard.L;
import roomeqwizard.LD;
import roomeqwizard.RoomEQ_Wizard;
import roomeqwizard.SampleRates;
import roomeqwizard.Y;
import roomeqwizard.api.APIResponse;
import roomeqwizard.api.model.ASIOCommand;
import roomeqwizard.api.model.ActionResult;
import roomeqwizard.api.model.AudioConfiguration;
import roomeqwizard.api.model.AudioStatus;
import roomeqwizard.api.model.Command;
import roomeqwizard.api.model.Device;
import roomeqwizard.api.model.Driver;
import roomeqwizard.api.model.Enable;
import roomeqwizard.api.model.Input;
import roomeqwizard.api.model.InputCalConfiguration;
import roomeqwizard.api.model.InputCalData;
import roomeqwizard.api.model.InputChannel;
import roomeqwizard.api.model.InputOptions;
import roomeqwizard.api.model.Output;
import roomeqwizard.api.model.OutputCalConfiguration;
import roomeqwizard.api.model.OutputCalData;
import roomeqwizard.api.model.OutputChannel;
import roomeqwizard.api.model.OutputChannelMapping;
import roomeqwizard.api.model.OutputChannelMappingList;
import roomeqwizard.api.model.OutputOptions;
import roomeqwizard.api.model.ValidValues;
import roomeqwizard.api.model.Value;
import roomeqwizard.cE;
import roomeqwizard.iK;
import roomeqwizard.lG;
import roomeqwizard.oI;
import spark.Filter;
import spark.Response;
import spark.Spark;

public class AudioService {
    private static ArrayList<String> asioCommands;
    public static Filter checkAudioAvailability;
    public static Filter checkAudioDriverMatch;

    public static boolean ready() {
        return F.\u00e9();
    }

    public static boolean enabled() {
        return !RoomEQ_Wizard.D();
    }

    public AudioStatus getStatus() {
        return new AudioStatus();
    }

    public AudioConfiguration getAudioConfiguration() {
        return AudioConfiguration.builder().treat32Bitas24Bit(lG.\u0214()).build();
    }

    public APIResponse setAudioConfiguration(AudioConfiguration audioConfiguration, Response response) {
        if (audioConfiguration.getTreat32Bitas24Bit() != null) {
            lG.h(audioConfiguration.getTreat32Bitas24Bit());
            return APIResponse.ok(response, "Set treat 32-bit as 24-bit " + audioConfiguration.getTreat32Bitas24Bit());
        }
        return APIResponse.badRequest(response, "No configuartion options in request");
    }

    public List<String> getDriverTypes() {
        return oI.\u0442();
    }

    public InputCalConfiguration getInputCalConfiguration() {
        double d2;
        Y y2 = RoomEQ_Wizard.D.A(F.Q(), F.j(), true);
        InputCalData inputCalData = null;
        TreeMap<String, InputCalData> treeMap = null;
        double d3 = d2 = lG.\u017d ? 3.0103 : 0.0;
        if (y2.A()) {
            treeMap = new TreeMap<String, InputCalData>();
            String[] stringArray = y2.J();
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                String string = stringArray[i2];
                Double d4 = null;
                if (!L.A(y2, string)) {
                    d4 = y2.E(i2);
                }
                InputCalData inputCalData2 = InputCalData.builder().calFilePath(y2.F(string)).dBFSAt94dBSPL(94.0 - y2.B(i2) + d2).fullScalSineVrms(d4).build();
                treeMap.put(string, inputCalData2);
            }
        } else {
            Double d5 = null;
            if (!L.A(y2, "")) {
                d5 = y2.K();
            }
            inputCalData = InputCalData.builder().calFilePath(y2.B()).dBFSAt94dBSPL(94.0 - y2.I() + d2).fullScalSineVrms(d5).build();
        }
        return InputCalConfiguration.builder().currentInputSelection(y2.Q()).separateCalFileForEachInput(y2.A()).inputDeviceIsCWeighted(y2.S()).calDataAllInputs(inputCalData).perInputCalData(treeMap).build();
    }

    public APIResponse setInputCalConfiguration(InputCalConfiguration inputCalConfiguration, Response response) {
        InputCalConfiguration inputCalConfiguration2 = this.getInputCalConfiguration();
        if (inputCalConfiguration.getCurrentInputSelection() != null && !inputCalConfiguration2.getCurrentInputSelection().equalsIgnoreCase(inputCalConfiguration.getCurrentInputSelection())) {
            String string = "The request specifies input " + inputCalConfiguration.getCurrentInputSelection() + " but the current selection is " + inputCalConfiguration2.getCurrentInputSelection();
            return APIResponse.badRequest(response, string);
        }
        Y y2 = RoomEQ_Wizard.D.A(F.Q(), F.j(), true);
        double d2 = lG.\u017d ? 3.0103 : 0.0;
        boolean bl = false;
        if (inputCalConfiguration.getInputDeviceIsCWeighted() != null) {
            y2.F(inputCalConfiguration.getInputDeviceIsCWeighted());
            bl = true;
        }
        if (inputCalConfiguration.getSeparateCalFileForEachInput() != null) {
            y2.E(inputCalConfiguration.getSeparateCalFileForEachInput());
            bl = true;
        }
        if (y2.A()) {
            Map map = inputCalConfiguration.getPerInputCalData();
            if (map != null && !map.isEmpty()) {
                for (String string : map.keySet()) {
                    InputCalData inputCalData = (InputCalData)map.get(string);
                    if (inputCalData == null) continue;
                    int n2 = y2.O().indexOf(string);
                    if (n2 < 0) {
                        return APIResponse.badRequest(response, string + " is not one of the inputs for " + y2.Q());
                    }
                    if (inputCalData.getCalFilePath() != null) {
                        String string2 = inputCalData.getCalFilePath();
                        if (string2.isEmpty()) {
                            y2.A(string);
                            bl = true;
                        } else {
                            ActionResult actionResult = y2.A(string2, string);
                            if (!actionResult.isSuccess()) {
                                return APIResponse.badRequest(response, "Failed to load " + string2 + " for " + string + " on " + y2.Q() + ": " + actionResult.getApiMessage());
                            }
                            bl = true;
                        }
                    }
                    if (inputCalData.getDBFSAt94dBSPL() != null) {
                        if (L.A(y2, string)) {
                            return APIResponse.badRequest(response, "dBFS at 94 dB SPL cannot be set manually for USB mics, it is determined from the cal file ");
                        }
                        y2.A(94.0 - inputCalData.getDBFSAt94dBSPL() + d2, n2);
                        bl = true;
                    }
                    if (inputCalData.getFullScalSineVrms() == null) continue;
                    if (L.A(y2, "")) {
                        return APIResponse.badRequest(response, "Full scale sine Vrms cannot be set for USB mics ");
                    }
                    if (inputCalData.getFullScalSineVrms() <= 0.0) {
                        return APIResponse.badRequest(response, "Full scale sine Vrms must be greater than zero ");
                    }
                    y2.B(inputCalData.getFullScalSineVrms(), n2);
                    bl = true;
                }
            }
        } else if (inputCalConfiguration.getCalDataAllInputs() != null) {
            InputCalData inputCalData = inputCalConfiguration.getCalDataAllInputs();
            if (inputCalData.getCalFilePath() != null) {
                String string = inputCalData.getCalFilePath();
                if (string.isEmpty()) {
                    y2.F();
                    bl = true;
                } else {
                    ActionResult actionResult = y2.C(string);
                    if (!actionResult.isSuccess()) {
                        return APIResponse.badRequest(response, "Failed to load " + string + ": " + actionResult.getApiMessage());
                    }
                    bl = true;
                }
            }
            if (inputCalData.getDBFSAt94dBSPL() != null) {
                if (L.A(y2, "")) {
                    return APIResponse.badRequest(response, "dBFS at 94 dB SPL cannot be set manually for USB mics, it is determined from the cal file ");
                }
                y2.B(94.0 - inputCalData.getDBFSAt94dBSPL() + d2);
                bl = true;
            }
            if (inputCalData.getFullScalSineVrms() != null) {
                if (L.A(y2, "")) {
                    return APIResponse.badRequest(response, "Full scale sine Vrms cannot be set for USB mics ");
                }
                if (inputCalData.getFullScalSineVrms() <= 0.0) {
                    return APIResponse.badRequest(response, "Full scale sine Vrms must be greater than zero ");
                }
                y2.C(inputCalData.getFullScalSineVrms());
                bl = true;
            }
        }
        if (bl) {
            return APIResponse.ok(response, "Input cal processed");
        }
        return APIResponse.badRequest(response, "No cal entries in the request");
    }

    public OutputCalConfiguration getOutputCalConfiguration() {
        Y y2 = RoomEQ_Wizard.k.A(F.\u00a4(), CalParamType.SAMPLERATE, true);
        SampleRates sampleRates = SampleRates.getRateEnum(F.h());
        CalData calData = y2.C(sampleRates);
        OutputCalData outputCalData = OutputCalData.builder().calFilePath(calData.getSourcePath()).sampleRate(Value.builder().value(sampleRates.doubleValue()).unit("Hz").build()).build();
        return OutputCalConfiguration.builder().currentOutputSelection(y2.Q()).calData(outputCalData).build();
    }

    public APIResponse setOutputCalConfiguration(OutputCalConfiguration outputCalConfiguration, Response response) {
        OutputCalConfiguration outputCalConfiguration2 = this.getOutputCalConfiguration();
        if (outputCalConfiguration.getCurrentOutputSelection() != null && !outputCalConfiguration2.getCurrentOutputSelection().equalsIgnoreCase(outputCalConfiguration.getCurrentOutputSelection())) {
            String string = "The request specifies output " + outputCalConfiguration.getCurrentOutputSelection() + " but the current selection is " + outputCalConfiguration2.getCurrentOutputSelection();
            return APIResponse.badRequest(response, string);
        }
        Y y2 = RoomEQ_Wizard.k.A(F.\u00a4(), CalParamType.SAMPLERATE, true);
        boolean bl = false;
        if (outputCalConfiguration.getCalData() != null) {
            Object object;
            OutputCalData outputCalData = outputCalConfiguration.getCalData();
            Value value = outputCalData.getSampleRate();
            if (value == null) {
                return APIResponse.badRequest(response, "Output cal must include a sample rate at which it is applied");
            }
            int n2 = 1;
            if (value.getUnit() != null && ((String)(object = value.getUnit())).equalsIgnoreCase("kHz")) {
                n2 = 1000;
            }
            if ((object = value.getValue()) == null) {
                return APIResponse.badRequest(response, "Output cal must include a sample rate at which it is applied");
            }
            double d2 = (Double)object * (double)n2;
            SampleRates sampleRates = SampleRates.getRateEnumNoFallback((float)d2);
            if (sampleRates == null || !oI.\u0420().\u043f().contains((Object)sampleRates)) {
                ValidValues validValues = ValidValues.builder().message("The requested rate " + d2 + " is not available for selection").validValues(this.getSampleRates()).build();
                return APIResponse.badRequest(response, validValues);
            }
            if (outputCalData.getCalFilePath() != null) {
                String string = outputCalData.getCalFilePath();
                if (string.isEmpty()) {
                    y2.A(sampleRates);
                    bl = true;
                } else {
                    ActionResult actionResult = y2.A(string, sampleRates);
                    if (!actionResult.isSuccess()) {
                        return APIResponse.badRequest(response, "Failed to load " + string + ": " + actionResult.getApiMessage());
                    }
                    bl = true;
                }
            }
        }
        if (bl) {
            return APIResponse.ok(response, "Output cal processed");
        }
        return APIResponse.badRequest(response, "No cal entries in the request");
    }

    public Driver getDriver() {
        return Driver.builder().driver(oI.\u0420().\u03eb().A()).build();
    }

    public APIResponse setDriver(Driver driver, Response response) {
        if (driver.getDriver() == null) {
            ValidValues validValues = ValidValues.builder().message("No driver setting in request").validValues(this.getDriverTypes()).build();
            return APIResponse.badRequest(response, validValues);
        }
        cE cE2 = cE.A(driver.getDriver());
        if (cE2 == null) {
            ValidValues validValues = ValidValues.builder().message("No valid driver setting in request").validValues(this.getDriverTypes()).build();
            return APIResponse.badRequest(response, validValues);
        }
        oI.\u0420().A(cE2);
        return APIResponse.accepted(response, "Selecting " + driver.getDriver());
    }

    public static List<String> getASIOCommands() {
        if (asioCommands == null) {
            asioCommands = new ArrayList();
            for (ASIOCommand aSIOCommand : ASIOCommand.values()) {
                asioCommands.add(aSIOCommand.commandName());
            }
        }
        return asioCommands;
    }

    public APIResponse runASIOCommand(Command command, Response response) {
        if (command.getCommand() == null) {
            return APIResponse.badRequest(response, "No command in the request");
        }
        String string = command.getCommand();
        ASIOCommand aSIOCommand = ASIOCommand.getFromCommandName(string);
        if (aSIOCommand == null) {
            ValidValues validValues = ValidValues.builder().message(string + " is not a recognised command").validValues(AudioService.getASIOCommands()).build();
            return APIResponse.badRequest(response, validValues);
        }
        switch (aSIOCommand) {
            case RELOAD: {
                oI.\u0420().\u0421();
                return APIResponse.accepted(response, "Reloading ASIO driver");
            }
        }
        assert (false) : "Unhandled enum type";
        return APIResponse.notImplemented(response, string + " is not implemented yet");
    }

    public List<String> getSampleRates() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (SampleRates sampleRates : oI.\u0420().\u043f()) {
            arrayList.add(sampleRates.toString());
        }
        return arrayList;
    }

    public List<Value> getSampleRateValues() {
        ArrayList<Value> arrayList = new ArrayList<Value>();
        for (SampleRates sampleRates : oI.\u0420().\u043f()) {
            arrayList.add(Value.builder().value(sampleRates.doubleValue()).unit("Hz").build());
        }
        return arrayList;
    }

    public Value getSampleRate() {
        return Value.builder().value(oI.\u0420().\u0443().doubleValue()).unit("Hz").build();
    }

    public APIResponse setSampleRate(Value value, Response response) {
        Object object;
        double d2 = 1.0;
        if (value.getUnit() != null && ((String)(object = value.getUnit())).equalsIgnoreCase("kHz")) {
            d2 = 1000.0;
        }
        if ((object = value.getValue()) == null) {
            return APIResponse.badRequest(response, "No value in request");
        }
        double d3 = (Double)object * d2;
        SampleRates sampleRates = SampleRates.getRateEnumNoFallback((float)d3);
        if (sampleRates == null || !oI.\u0420().\u043f().contains((Object)sampleRates)) {
            ValidValues validValues = ValidValues.builder().message("The requested rate " + d3 + " is not available for selection").validValues(this.getSampleRates()).build();
            return APIResponse.badRequest(response, validValues);
        }
        oI.\u0420().B(sampleRates);
        return APIResponse.accepted(response, "Selecting " + sampleRates.getDescription());
    }

    public InputOptions getInputOptions() {
        return InputOptions.builder().invert(lG.\u016a()).highPass(lG.\u01e4()).virtualBalanced(lG.\u0408()).multipleInputs(lG.\u043f()).build();
    }

    public APIResponse setInputOptions(InputOptions inputOptions, Response response) {
        boolean bl;
        boolean bl2 = false;
        if (inputOptions.getInvert() != null) {
            lG.a(inputOptions.getInvert());
            bl2 = true;
        }
        if (inputOptions.getHighPass() != null) {
            lG._(inputOptions.getHighPass());
            bl2 = true;
        }
        if (inputOptions.getMultipleInputs() != null) {
            bl = inputOptions.getMultipleInputs();
            if (bl && !iK.B()) {
                return APIResponse.badRequest(response, "A Pro upgrade license is required to enable multi-input capture");
            }
            lG.\u00d2(bl);
            bl2 = true;
        }
        if (inputOptions.getVirtualBalanced() != null) {
            bl = inputOptions.getVirtualBalanced();
            if (bl && lG.\u043f()) {
                return APIResponse.badRequest(response, "Virtual balanced input mode cannot be used when multiple inputs are being captured");
            }
            lG.\u00ca(bl);
            bl2 = true;
        }
        if (bl2) {
            return APIResponse.ok(response, "Input options processed");
        }
        return APIResponse.badRequest(response, "No option entries in the request");
    }

    public OutputOptions getOutputOptions() {
        return OutputOptions.builder().invertSecond(lG.\u0268()).build();
    }

    public APIResponse setOutputOptions(OutputOptions outputOptions, Response response) {
        boolean bl = false;
        if (outputOptions.getInvertSecond() != null) {
            lG.i(outputOptions.getInvertSecond());
            bl = true;
        }
        if (bl) {
            return APIResponse.ok(response, "Output options processed");
        }
        return APIResponse.badRequest(response, "No option entries in the request");
    }

    public Enable getStereoOnly() {
        return Enable.builder().enable(lG.\u03dc()).build();
    }

    public APIResponse setStereoOnly(Enable enable, Response response) {
        if (enable.getEnable() == null) {
            return APIResponse.badRequest(response, "No setting in request");
        }
        lG.G(enable.getEnable());
        return APIResponse.ok(response, "Set stereo only " + enable.getEnable());
    }

    public List<String> getASIODevices() {
        return oI.\u0420().\u040b();
    }

    public Device getASIODevice() {
        return Device.builder().device(oI.\u0420().\u0416()).build();
    }

    public APIResponse setASIODevice(Device device, Response response) {
        if (device.getDevice() == null) {
            ValidValues validValues = ValidValues.builder().message("No device setting in request").validValues(this.getASIODevices()).build();
            return APIResponse.badRequest(response, validValues);
        }
        if (oI.\u0420().Y(device.getDevice())) {
            return APIResponse.accepted(response, "Selecting " + device.getDevice());
        }
        String string = this.getASIOErrorStringIfAny();
        ValidValues validValues = ValidValues.builder().message("No valid device setting in request or device driver cannot be loaded. " + string).validValues(this.getASIODevices()).build();
        return APIResponse.badRequest(response, validValues);
    }

    public List<String> getASIOInputs() {
        return oI.\u0420().\u03f3();
    }

    public Input getASIOInput() {
        return Input.builder().input(oI.\u0420().\u0407()).build();
    }

    public APIResponse setASIOInput(Input input, Response response) {
        if (input.getInput() == null) {
            ValidValues validValues = ValidValues.builder().message("No input setting in request").validValues(this.getASIOInputs()).build();
            return APIResponse.badRequest(response, validValues);
        }
        if (oI.\u0420().f(input.getInput())) {
            return APIResponse.ok(response, "Selected " + input.getInput());
        }
        String string = this.getASIOErrorStringIfAny();
        ValidValues validValues = ValidValues.builder().message("No valid input setting in request or device error. " + string).validValues(this.getASIOInputs()).build();
        return APIResponse.badRequest(response, validValues);
    }

    public Input getASIORefInput() {
        return Input.builder().input(oI.\u0420().\u0441()).build();
    }

    public APIResponse setASIORefInput(Input input, Response response) {
        if (input.getInput() == null) {
            ValidValues validValues = ValidValues.builder().message("No input setting in request").validValues(this.getASIOInputs()).build();
            return APIResponse.badRequest(response, validValues);
        }
        if (oI.\u0420().d(input.getInput())) {
            return APIResponse.ok(response, "Selected " + input.getInput());
        }
        String string = this.getASIOErrorStringIfAny();
        ValidValues validValues = ValidValues.builder().message("No valid input setting in request or device error. " + string).validValues(this.getASIOInputs()).build();
        return APIResponse.badRequest(response, validValues);
    }

    public Input getASIOLastInput() {
        return Input.builder().input(oI.\u0420().\u0402()).build();
    }

    public APIResponse setASIOLastInput(Input input, Response response) {
        if (!iK.B()) {
            return APIResponse.badRequest(response, "A Pro upgrade license is required to configure multi-input capture");
        }
        if (input.getInput() == null) {
            ValidValues validValues = ValidValues.builder().message("No input setting in request").validValues(this.getASIOInputs()).build();
            return APIResponse.badRequest(response, validValues);
        }
        if (oI.\u0420()._(input.getInput())) {
            return APIResponse.ok(response, "Selected " + input.getInput());
        }
        String string = this.getASIOErrorStringIfAny();
        ValidValues validValues = ValidValues.builder().message("No valid input setting in request or device error. " + string).validValues(this.getASIOInputs()).build();
        return APIResponse.badRequest(response, validValues);
    }

    public List<String> getASIOOutputs() {
        return oI.\u0420().\u041c();
    }

    public Output getASIOOutput() {
        return Output.builder().output(oI.\u0420().\u0444()).build();
    }

    public APIResponse setASIOOutput(Output output, Response response) {
        if (output.getOutput() == null) {
            ValidValues validValues = ValidValues.builder().message("No output setting in request").validValues(this.getASIOOutputs()).build();
            return APIResponse.badRequest(response, validValues);
        }
        if (oI.\u0420().i(output.getOutput())) {
            return APIResponse.ok(response, "Selected " + output.getOutput());
        }
        String string = this.getASIOErrorStringIfAny();
        ValidValues validValues = ValidValues.builder().message("No valid output setting in request or device error. " + string).validValues(this.getASIOOutputs()).build();
        return APIResponse.badRequest(response, validValues);
    }

    public Output getASIORefOutput() {
        return Output.builder().output(oI.\u0420().\u0458()).build();
    }

    public APIResponse setASIORefOutput(Output output, Response response) {
        if (output.getOutput() == null) {
            ValidValues validValues = ValidValues.builder().message("No output setting in request").validValues(this.getASIOOutputs()).build();
            return APIResponse.badRequest(response, validValues);
        }
        if (oI.\u0420().g(output.getOutput())) {
            return APIResponse.ok(response, "Selected " + output.getOutput());
        }
        String string = this.getASIOErrorStringIfAny();
        ValidValues validValues = ValidValues.builder().message("No valid output setting in request or device error. " + string).validValues(this.getASIOOutputs()).build();
        return APIResponse.badRequest(response, validValues);
    }

    public Output getASIOSecondaryOutput() {
        return Output.builder().output(oI.\u0420().\u043b()).build();
    }

    public APIResponse setASIOSecondaryOutput(Output output, Response response) {
        if (output.getOutput() == null) {
            ValidValues validValues = ValidValues.builder().message("No output setting in request").validValues(this.getASIOOutputs()).build();
            return APIResponse.badRequest(response, validValues);
        }
        if (oI.\u0420().X(output.getOutput())) {
            return APIResponse.ok(response, "Selected " + output.getOutput());
        }
        String string = this.getASIOErrorStringIfAny();
        ValidValues validValues = ValidValues.builder().message("No valid output setting in request or device error. " + string).validValues(this.getASIOOutputs()).build();
        return APIResponse.badRequest(response, validValues);
    }

    public Enable getSecondaryOutputEnable() {
        return Enable.builder().enable(lG.\u00c6()).build();
    }

    public APIResponse setSecondaryOutputEnable(Enable enable, Response response) {
        if (enable.getEnable() == null) {
            return APIResponse.badRequest(response, "No setting in request");
        }
        lG.O(enable.getEnable());
        return APIResponse.ok(response, "Set secondary output enable " + enable.getEnable());
    }

    private String getASIOErrorStringIfAny() {
        LocalTime localTime;
        AL aL = F.\u00a5();
        String string = "";
        if (aL != null && ChronoUnit.SECONDS.between(localTime = aL.A(), LocalTime.now()) < 2L) {
            String string2 = aL.C().replaceAll("\n", " ");
            string = "Last ASIO error at " + localTime.format(DateTimeFormatter.ofPattern("HH:mm:ss")) + ": " + string2;
        }
        return string;
    }

    public List<String> getInputDevices() {
        return oI.\u0420().\u0438();
    }

    public Device getInputDevice() {
        return Device.builder().device(oI.\u0420().\u0425()).build();
    }

    public APIResponse setInputDevice(Device device, Response response) {
        if (device.getDevice() == null) {
            ValidValues validValues = ValidValues.builder().message("No device setting in request").validValues(this.getInputDevices()).build();
            return APIResponse.badRequest(response, validValues);
        }
        if (oI.\u0420().Z(device.getDevice())) {
            return APIResponse.accepted(response, "Selecting " + device.getDevice());
        }
        ValidValues validValues = ValidValues.builder().message("No valid device setting in request").validValues(this.getInputDevices()).build();
        return APIResponse.badRequest(response, validValues);
    }

    public List<String> getOutputDevices() {
        return oI.\u0420().\u0455();
    }

    public Device getOutputDevice() {
        return Device.builder().device(oI.\u0420().\u0430()).build();
    }

    public APIResponse setOutputDevice(Device device, Response response) {
        if (device.getDevice() == null) {
            ValidValues validValues = ValidValues.builder().message("No device setting in request").validValues(this.getOutputDevices()).build();
            return APIResponse.badRequest(response, validValues);
        }
        if (oI.\u0420().V(device.getDevice())) {
            return APIResponse.accepted(response, "Selecting " + device.getDevice());
        }
        ValidValues validValues = ValidValues.builder().message("No valid device setting in request").validValues(this.getOutputDevices()).build();
        return APIResponse.badRequest(response, validValues);
    }

    public OutputChannelMappingList getOutputChannelMapping() {
        ArrayList<OutputChannelMapping> arrayList = new ArrayList<OutputChannelMapping>();
        int n2 = oI.\u0420().\u0461();
        for (int i2 = 0; i2 < n2; ++i2) {
            LD lD2 = LD.A(i2);
            OutputChannelMapping outputChannelMapping = OutputChannelMapping.builder().index(i2 + 1).hardwareChannel(lD2.B() + 1).channelLabel(lD2.C()).build();
            arrayList.add(outputChannelMapping);
        }
        return OutputChannelMappingList.builder().mapping(arrayList).build();
    }

    public APIResponse setOutputChannelMapping(OutputChannelMappingList outputChannelMappingList, Response response) {
        if (outputChannelMappingList == null || outputChannelMappingList.getMapping() == null) {
            return APIResponse.badRequest(response, "No output channel mapping in request");
        }
        List<OutputChannelMapping> list = outputChannelMappingList.getMapping();
        if (list.isEmpty()) {
            return APIResponse.badRequest(response, "No output channel mapping in request");
        }
        int n2 = oI.\u0420().\u0461();
        int n3 = 0;
        for (OutputChannelMapping outputChannelMapping : list) {
            if (outputChannelMapping.getIndex() > n2) {
                ++n3;
                continue;
            }
            LD lD2 = LD.A(outputChannelMapping.getIndex() - 1);
            Integer n4 = outputChannelMapping.getHardwareChannel();
            if (n4 != null) {
                if (n4 <= 0) {
                    return APIResponse.badRequest(response, n4 + " is not a valid hardware channel, channels start from 1");
                }
                lD2.B(n4 - 1);
            }
            if (outputChannelMapping.getChannelLabel() == null) continue;
            String string = outputChannelMapping.getChannelLabel().trim();
            if (string.isEmpty()) {
                lD2.A("" + (lD2.B() + 1));
                continue;
            }
            lD2.A(string);
        }
        if (RoomEQ_Wizard.s()) {
            oI.\u0420().\u00e9(n2);
        }
        oI.\u0420().\u0452();
        Object object = "Mapping processed";
        if (n3 > 0) {
            object = (String)object + ", " + n3 + " entries outside the maximum channel range of " + n2 + " ignored";
        }
        return APIResponse.ok(response, (String)object);
    }

    public List<String> getInputs() {
        return oI.\u0420().\u040e();
    }

    public Input getInput() {
        return Input.builder().input(oI.\u0420().\u041e()).build();
    }

    public APIResponse setInput(Input input, Response response) {
        if (input.getInput() == null) {
            ValidValues validValues = ValidValues.builder().message("No input setting in request").validValues(this.getInputs()).build();
            return APIResponse.badRequest(response, validValues);
        }
        if (oI.\u0420().h(input.getInput())) {
            return APIResponse.ok(response, "Selected " + input.getInput());
        }
        ValidValues validValues = ValidValues.builder().message("No valid input setting in request").validValues(this.getInputs()).build();
        return APIResponse.badRequest(response, validValues);
    }

    public List<String> getOutputs() {
        return oI.\u0420().\u0432();
    }

    public Output getOutput() {
        return Output.builder().output(oI.\u0420().\u041b()).build();
    }

    public APIResponse setOutput(Output output, Response response) {
        if (output.getOutput() == null) {
            ValidValues validValues = ValidValues.builder().message("No output setting in request").validValues(this.getOutputs()).build();
            return APIResponse.badRequest(response, validValues);
        }
        if (oI.\u0420().e(output.getOutput())) {
            return APIResponse.ok(response, "Selected " + output.getOutput());
        }
        ValidValues validValues = ValidValues.builder().message("No valid output setting in request").validValues(this.getOutputs()).build();
        return APIResponse.badRequest(response, validValues);
    }

    public static int getNumInputDeviceChannels() {
        return F.s();
    }

    public static int getNumOutputDeviceChannels() {
        return F.v();
    }

    public static int getNumInputChannels() {
        return F.\u00f9();
    }

    public InputChannel getInputChannel() {
        return InputChannel.builder().channel(oI.\u0420().\u0424()).build();
    }

    public APIResponse setInputChannel(InputChannel inputChannel, Response response) {
        if (inputChannel.getChannel() == null) {
            return APIResponse.badRequest(response, "No channel in request");
        }
        int n2 = inputChannel.getChannel();
        int n3 = F.s();
        if (n2 > 0 && n2 <= n3) {
            oI.\u0420().\u00e7(n2);
            return APIResponse.ok(response, "Selected input channel " + n2);
        }
        return APIResponse.badRequest(response, n2 + " is not a valid channel number, the valid range is between 1 and " + n3);
    }

    public InputChannel getRefInputChannel() {
        return InputChannel.builder().channel(oI.\u0420().\u044d()).build();
    }

    public APIResponse setRefInputChannel(InputChannel inputChannel, Response response) {
        if (inputChannel.getChannel() == null) {
            return APIResponse.badRequest(response, "No channel in request");
        }
        int n2 = inputChannel.getChannel();
        int n3 = F.s();
        if (n2 > 0 && n2 <= n3) {
            oI.\u0420().\u00f1(n2);
            return APIResponse.ok(response, "Selected ref input channel " + n2);
        }
        return APIResponse.badRequest(response, n2 + " is not a valid channel number, the valid range is between 1 and " + n3);
    }

    public InputChannel getLastInputChannel() {
        return InputChannel.builder().channel(oI.\u0420().\u0406()).build();
    }

    public APIResponse setLastInputChannel(InputChannel inputChannel, Response response) {
        if (!iK.B()) {
            return APIResponse.badRequest(response, "A Pro upgrade license is required to configure multi-input capture");
        }
        if (inputChannel.getChannel() == null) {
            return APIResponse.badRequest(response, "No channel in request");
        }
        int n2 = inputChannel.getChannel();
        int n3 = F.\u00f9();
        if (n2 > 0 && n2 <= n3) {
            oI.\u0420().\u00ed(n2);
            return APIResponse.ok(response, "Selected last input channel " + n2);
        }
        return APIResponse.badRequest(response, n2 + " is not a valid channel number, the valid range is between 1 and " + n3);
    }

    public List<String> getOutputChannels() {
        return oI.\u0420().\u042e();
    }

    public OutputChannel getOutputChannel() {
        return OutputChannel.builder().channel(oI.\u0420().\u0433()).build();
    }

    public APIResponse setOutputChannel(OutputChannel outputChannel, Response response) {
        if (outputChannel.getChannel() == null) {
            ValidValues validValues = ValidValues.builder().message("No channel setting in request").validValues(this.getOutputChannels()).build();
            return APIResponse.badRequest(response, validValues);
        }
        String string = null;
        for (String string2 : oI.\u0420().\u042e()) {
            if (!outputChannel.getChannel().equalsIgnoreCase(string2)) continue;
            string = string2;
        }
        if (string != null) {
            oI.\u0420().W(string);
            return APIResponse.ok(response, "Selected channel " + string);
        }
        ValidValues validValues = ValidValues.builder().message("No valid channel in request").validValues(this.getOutputChannels()).build();
        return APIResponse.badRequest(response, validValues);
    }

    public List<String> getRefOutputChannels() {
        return oI.\u0420().\u042a();
    }

    public OutputChannel getRefOutputChannel() {
        return OutputChannel.builder().channel(oI.\u0420().\u045b()).build();
    }

    public APIResponse setRefOutputChannel(OutputChannel outputChannel, Response response) {
        if (outputChannel.getChannel() == null) {
            ValidValues validValues = ValidValues.builder().message("No channel setting in request").validValues(this.getOutputChannels()).build();
            return APIResponse.badRequest(response, validValues);
        }
        String string = null;
        for (String string2 : oI.\u0420().\u042a()) {
            if (!outputChannel.getChannel().equalsIgnoreCase(string2)) continue;
            string = string2;
        }
        if (string != null) {
            oI.\u0420().c(string);
            return APIResponse.ok(response, "Selected channel " + string);
        }
        ValidValues validValues = ValidValues.builder().message("No valid channel in request").validValues(this.getRefOutputChannels()).build();
        return APIResponse.badRequest(response, validValues);
    }

    static {
        checkAudioAvailability = (request, response) -> {
            if (!AudioService.enabled()) {
                Spark.halt((int)405, (String)"REW was started with the -noaudio switch");
            } else if (!AudioService.ready()) {
                Spark.halt((int)405, (String)"The audio endpoints are not ready yet");
            }
        };
        checkAudioDriverMatch = (request, response) -> {
            String string = request.pathInfo();
            if (string.startsWith("/audio/java") && oI.\u0420().\u03eb() == cE.A) {
                Spark.halt((int)400, (String)"The ASIO driver is being used, Java driver endpoints are not available. Use /audio/driver to change driver.");
            } else if (string.startsWith("/audio/asio") && oI.\u0420().\u03eb() == cE.D) {
                Spark.halt((int)400, (String)"The Java driver is being used, ASIO driver endpoints are not available. Use /audio/driver to change driver.");
            }
        };
    }
}

