/*
 * Decompiled with CFR 0.152.
 */
package roomeqwizard.api;

import java.util.ArrayList;
import java.util.List;
import roomeqwizard.RoomEQ_Wizard;
import roomeqwizard.XE;
import roomeqwizard.api.API;
import roomeqwizard.api.APIResponse;
import roomeqwizard.api.Publisher;
import roomeqwizard.api.model.ApplicationCommand;
import roomeqwizard.api.model.Command;
import roomeqwizard.api.model.ErrorMessage;
import roomeqwizard.api.model.Subscriber;
import roomeqwizard.api.model.SubscriptionType;
import roomeqwizard.api.model.ValidValues;
import roomeqwizard.api.model.WarningMessage;
import spark.Request;
import spark.Response;

public class ApplicationService
extends Publisher {
    private static List<String> commands;

    public static List<String> getCommands() {
        if (commands == null) {
            commands = new ArrayList<String>();
            for (ApplicationCommand applicationCommand : ApplicationCommand.values()) {
                commands.add(applicationCommand.commandName());
            }
        }
        return commands;
    }

    public APIResponse runCommand(Command command, Response response) {
        if (command.getCommand() == null) {
            return APIResponse.badRequest(response, "No command in the request");
        }
        String string = command.getCommand();
        ApplicationCommand applicationCommand = ApplicationCommand.getFromCommandName(string);
        if (applicationCommand == null) {
            ValidValues validValues = ValidValues.builder().message(string + " is not a recognised command").validValues(ApplicationService.getCommands()).build();
            return APIResponse.badRequest(response, validValues);
        }
        switch (applicationCommand) {
            case SHUTDOWN: {
                XE.A(1000);
                return APIResponse.accepted(response, "Shutting down in 1 second");
            }
            case CLEAR: {
                if (API.runningACommand()) {
                    String string2 = API.getRunningCommand();
                    API.clearCommand();
                    return APIResponse.ok(response, string2 + " in progress cleared");
                }
                return APIResponse.ok(response, "No API command in progress");
            }
        }
        assert (false) : "Unhandled enum type";
        return APIResponse.notImplemented(response, string + " is not implemented yet");
    }

    public ErrorMessage getLastError(Request request, Response response) {
        return RoomEQ_Wizard.V();
    }

    public List<ErrorMessage> getErrors(Request request, Response response) {
        return RoomEQ_Wizard.\u00a4();
    }

    public WarningMessage getLastWarning(Request request, Response response) {
        return RoomEQ_Wizard.E();
    }

    public List<WarningMessage> getWarnings(Request request, Response response) {
        return RoomEQ_Wizard.\u00a3();
    }

    @Override
    public ValidValues checkSubscriptionParameters(SubscriptionType subscriptionType, Subscriber subscriber) {
        return null;
    }

    @Override
    public void addSubscriptionToSource(SubscriptionType subscriptionType) {
        RoomEQ_Wizard.A(subscriptionType, this);
    }

    @Override
    public void removeSubscriptionFromSource(SubscriptionType subscriptionType) {
        RoomEQ_Wizard.B(subscriptionType, this);
    }
}

