/*
 * Decompiled with CFR 0.152.
 */
package roomeqwizard.api;

import java.awt.EventQueue;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import roomeqwizard.$B;
import roomeqwizard.AK;
import roomeqwizard.AlignmentMode;
import roomeqwizard.MeasData;
import roomeqwizard.RoomEQ_Wizard;
import roomeqwizard.SD;
import roomeqwizard.SampledData;
import roomeqwizard.api.API;
import roomeqwizard.api.APIResponse;
import roomeqwizard.api.MeasurementsService;
import roomeqwizard.api.Publisher;
import roomeqwizard.api.model.AlignmentCommand;
import roomeqwizard.api.model.AlignmentToolCommand;
import roomeqwizard.api.model.FrequencyResponse;
import roomeqwizard.api.model.ImpulseResponse;
import roomeqwizard.api.model.ProcessResult;
import roomeqwizard.api.model.Subscriber;
import roomeqwizard.api.model.SubscriptionType;
import roomeqwizard.api.model.ValidValues;
import roomeqwizard.g;
import roomeqwizard.kJ;
import roomeqwizard.tF;
import spark.Request;
import spark.Response;

public class AlignmentToolService
extends Publisher
implements tF {
    private static List<String> commands;
    private static List<String> modes;
    private static AlignmentToolService instance;
    private static AK allSPL;
    private static ProcessResult processResult;
    private static URL processResultUrl;
    private double alignmentFrequency = 80.0;

    private AlignmentToolService() {
        instance = this;
        allSPL = g.getGraphPanel().\u01af();
        if (allSPL.Y() == null) {
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        allSPL.\u00d8();
                    }
                });
            }
            catch (InterruptedException | InvocationTargetException exception) {
                // empty catch block
            }
        }
    }

    public static AlignmentToolService getInstance() {
        if (instance == null) {
            instance = new AlignmentToolService();
        }
        return instance;
    }

    public List<String> getModes() {
        if (modes == null) {
            modes = new ArrayList<String>();
            for (AlignmentMode alignmentMode : AlignmentMode.values()) {
                modes.add(alignmentMode.apiName());
            }
        }
        return modes;
    }

    public List<String> getCommands() {
        if (commands == null) {
            commands = new ArrayList<String>();
            for (AlignmentToolCommand alignmentToolCommand : AlignmentToolCommand.values()) {
                commands.add(alignmentToolCommand.commandName());
            }
        }
        return commands;
    }

    public APIResponse runCommand(AlignmentCommand alignmentCommand, Response response) {
        if (alignmentCommand.getCommand() == null) {
            return APIResponse.badRequest(response, "No command in the request");
        }
        final String string = alignmentCommand.getCommand();
        AlignmentToolCommand alignmentToolCommand = AlignmentToolCommand.getFromCommandName(string);
        if (alignmentToolCommand == null) {
            ValidValues validValues = ValidValues.builder().message(string + " is not a recognised command").validValues(this.getCommands()).build();
            return APIResponse.badRequest(response, validValues);
        }
        if (alignmentToolCommand.requiresFrequency() && alignmentCommand.getFrequency() == null) {
            return APIResponse.badRequest(response, string + " requires a frequency to be specified");
        }
        if (alignmentCommand.getFrequency() != null) {
            this.alignmentFrequency = alignmentCommand.getFrequency();
        }
        processResultUrl = null;
        processResult = null;
        String string2 = alignmentCommand.getResultUrl();
        if (string2 != null && !string2.isEmpty()) {
            try {
                processResultUrl = new URL(URLDecoder.decode(alignmentCommand.getResultUrl(), StandardCharsets.UTF_8.toString()));
            }
            catch (UnsupportedEncodingException | MalformedURLException iOException) {
                return APIResponse.badRequest(response, string2 + " is not a properly formatted URL");
            }
        }
        if (API.runningACommand()) {
            return APIResponse.badRequest(response, API.getRunningCommand() + " is running, it must complete before " + string + " can run");
        }
        switch (alignmentToolCommand) {
            case RESET: {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        allSPL.E(AlignmentToolService.this, string);
                    }
                });
                return API.commandAccepted(response, alignmentToolCommand.commandName());
            }
            case LEVEL_PHASE: {
                if (allSPL.\u0260() != AlignmentMode.PHASE) {
                    return APIResponse.badRequest(response, "This command is only valid for " + AlignmentMode.PHASE.apiName() + " mode");
                }
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        allSPL.E(AlignmentToolService.this.alignmentFrequency, AlignmentToolService.this, string);
                    }
                });
                return API.commandAccepted(response, alignmentToolCommand.commandName());
            }
            case UNDO_LEVEL_PHASE: {
                if (allSPL.\u0260() != AlignmentMode.PHASE) {
                    return APIResponse.badRequest(response, "This command is only valid for " + AlignmentMode.PHASE.apiName() + " mode");
                }
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        allSPL.A(AlignmentToolService.this, string);
                    }
                });
                return API.commandAccepted(response, alignmentToolCommand.commandName());
            }
            case ALIGN_PHASE_SLOPES: {
                if (allSPL.\u0260() != AlignmentMode.PHASE) {
                    return APIResponse.badRequest(response, "This command is only valid for " + AlignmentMode.PHASE.apiName() + " mode");
                }
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        allSPL.B(AlignmentToolService.this.alignmentFrequency, AlignmentToolService.this, string);
                    }
                });
                return API.commandAccepted(response, alignmentToolCommand.commandName());
            }
            case ALIGN_PHASE: {
                if (allSPL.\u0260() != AlignmentMode.PHASE) {
                    return APIResponse.badRequest(response, "This command is only valid for " + AlignmentMode.PHASE.apiName() + " mode");
                }
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        allSPL.D(AlignmentToolService.this.alignmentFrequency, AlignmentToolService.this, string);
                    }
                });
                return API.commandAccepted(response, alignmentToolCommand.commandName());
            }
            case FILTER_IRS: {
                if (allSPL.\u0260() != AlignmentMode.IMPULSE) {
                    return APIResponse.badRequest(response, "This command is only valid for " + AlignmentMode.IMPULSE.apiName() + " mode");
                }
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        allSPL.C(AlignmentToolService.this.alignmentFrequency, AlignmentToolService.this, string);
                    }
                });
                return API.commandAccepted(response, alignmentToolCommand.commandName());
            }
            case ALIGN_IRS: {
                if (allSPL.\u0260() != AlignmentMode.IMPULSE) {
                    return APIResponse.badRequest(response, "This command is only valid for " + AlignmentMode.IMPULSE.apiName() + " mode");
                }
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        allSPL.A(AlignmentToolService.this.alignmentFrequency, (tF)AlignmentToolService.this, string);
                    }
                });
                return API.commandAccepted(response, alignmentToolCommand.commandName());
            }
            case CLEAR_FILTER: {
                if (allSPL.\u0260() != AlignmentMode.IMPULSE) {
                    return APIResponse.badRequest(response, "This command is only valid for " + AlignmentMode.IMPULSE.apiName() + " mode");
                }
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        allSPL.D(AlignmentToolService.this, string);
                    }
                });
                return API.commandAccepted(response, alignmentToolCommand.commandName());
            }
            case ALIGNED_COPY_A: {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        allSPL.C(AlignmentToolService.this, string);
                    }
                });
                return API.commandAccepted(response, alignmentToolCommand.commandName());
            }
            case ALIGNED_COPY_B: {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        allSPL.F(AlignmentToolService.this, string);
                    }
                });
                return API.commandAccepted(response, alignmentToolCommand.commandName());
            }
            case ALIGNED_SUM: {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        allSPL.B(AlignmentToolService.this, string);
                    }
                });
                return API.commandAccepted(response, alignmentToolCommand.commandName());
            }
        }
        assert (false) : "Unhandled enum type";
        return APIResponse.notImplemented(response, string + " is not implemented yet");
    }

    private void setCompletedProcessResults(String string, Map<Integer, Map<String, String>> map) {
        AlignmentToolCommand alignmentToolCommand;
        API.clearCommand();
        if (map == null && (alignmentToolCommand = AlignmentToolCommand.getFromCommandName(string)) != null && alignmentToolCommand.producesResult()) {
            map = new TreeMap<Integer, Map<String, String>>();
            TreeMap<String, String> treeMap = new TreeMap<String, String>();
            treeMap.put("Alignment frequency", "" + this.alignmentFrequency);
            treeMap.put("Gain A dB", this.getGainAdB().toString());
            treeMap.put("Invert A", this.getInvertA().toString());
            treeMap.put("Gain B dB", this.getGainBdB().toString());
            treeMap.put("Delay B ms", this.getDelayBms().toString());
            treeMap.put("Invert B", this.getInvertB().toString());
            map.put(0, treeMap);
        }
        processResult = ProcessResult.builder().processName(string).message("Completed").results(map).build();
        this.publishProcessResultIfRequired();
    }

    private void publishProcessResultIfRequired() {
        if (processResultUrl != null) {
            Subscriber subscriber = Subscriber.builder().url(processResultUrl.toString()).build();
            Publisher.postToSubscriber(subscriber, processResult);
        }
    }

    @Override
    public void taskCompleted(String string, Map<Integer, Map<String, String>> map) {
        this.setCompletedProcessResults(string, map);
    }

    @Override
    public ValidValues checkSubscriptionParameters(SubscriptionType subscriptionType, Subscriber subscriber) {
        return null;
    }

    @Override
    public void addSubscriptionToSource(SubscriptionType subscriptionType) {
    }

    @Override
    public void removeSubscriptionFromSource(SubscriptionType subscriptionType) {
    }

    public String getAlignmentMode() {
        return allSPL.\u0260().apiName();
    }

    public APIResponse setAlignmentMode(String string, Response response) {
        if (string == null) {
            return APIResponse.badRequest(response, "No value in request");
        }
        final AlignmentMode alignmentMode = AlignmentMode.getFromApiName(string);
        if (alignmentMode == null) {
            ValidValues validValues = ValidValues.builder().message((Object)((Object)alignmentMode) + " is not a recognised alignment mode").validValues(this.getModes()).build();
            return APIResponse.badRequest(response, validValues);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                allSPL.A(alignmentMode);
            }
        });
        return APIResponse.ok(response, "Mode set");
    }

    public Double getAlignmentFrequency() {
        return this.alignmentFrequency;
    }

    public Integer getIndexA() {
        return allSPL.\u0261() + 1;
    }

    public APIResponse setIndexA(Integer n2, Response response) {
        if (n2 == null) {
            return APIResponse.badRequest(response, "No value in request");
        }
        SD sD2 = RoomEQ_Wizard.w();
        if (n2 < 1 || n2 > sD2.K()) {
            return APIResponse.badRequest(response, "There is no measurement at index " + n2);
        }
        final int n3 = n2 - 1;
        MeasData measData = sD2.D(n3);
        if (!allSPL.e(measData)) {
            return APIResponse.badRequest(response, "The measurement at index " + n2 + " (" + measData.getTitle() + ") cannot be aligned");
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                allSPL.\u00a5(n3);
            }
        });
        return APIResponse.ok(response, measData.getTitle() + " at index " + n2 + " selected as measurement A");
    }

    public Integer getIndexB() {
        return allSPL.\u0259() + 1;
    }

    public APIResponse setIndexB(Integer n2, Response response) {
        if (n2 == null) {
            return APIResponse.badRequest(response, "No value in request");
        }
        SD sD2 = RoomEQ_Wizard.w();
        if (n2 < 1 || n2 > sD2.K()) {
            return APIResponse.badRequest(response, "There is no measurement at index " + n2);
        }
        final int n3 = n2 - 1;
        MeasData measData = sD2.D(n3);
        if (!allSPL.e(measData)) {
            return APIResponse.badRequest(response, "The measurement at index " + n2 + " (" + measData.getTitle() + ") cannot be aligned");
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                allSPL.\u00a4(n3);
            }
        });
        return APIResponse.ok(response, measData.getTitle() + " at index " + n2 + " selected as measurement B");
    }

    public Double getGainAdB() {
        return allSPL.\u0211();
    }

    public APIResponse setGainAdB(final Double d2, Response response) {
        if (d2 == null) {
            return APIResponse.badRequest(response, "No value in request");
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                allSPL.s(d2);
            }
        });
        return APIResponse.ok(response, "Value set");
    }

    public Double getGainBdB() {
        return allSPL.\u0258();
    }

    public APIResponse setGainBdB(final Double d2, Response response) {
        if (d2 == null) {
            return APIResponse.badRequest(response, "No value in request");
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                allSPL.r(d2);
            }
        });
        return APIResponse.ok(response, "Value set");
    }

    public Double getDelayBms() {
        return allSPL.\u0254();
    }

    public APIResponse setDelayBms(final Double d2, Response response) {
        if (d2 == null) {
            return APIResponse.badRequest(response, "No value in request");
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                allSPL.n(d2);
            }
        });
        return APIResponse.ok(response, "Value set");
    }

    public Boolean getInvertA() {
        return allSPL.\u0262();
    }

    public APIResponse setInvertA(final Boolean bl, Response response) {
        if (bl == null) {
            return APIResponse.badRequest(response, "No value in request");
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                allSPL.p(bl);
            }
        });
        return APIResponse.ok(response, "Value set");
    }

    public Boolean getInvertB() {
        return allSPL.\u0269();
    }

    public APIResponse setInvertB(final Boolean bl, Response response) {
        if (bl == null) {
            return APIResponse.badRequest(response, "No value in request");
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                allSPL.o(bl);
            }
        });
        return APIResponse.ok(response, "Value set");
    }

    public FrequencyResponse getAlignedFrequencyResponse(Request request, Response response) {
        String string;
        kJ kJ2;
        MeasData measData = allSPL.\u0268();
        if (measData == null) {
            return FrequencyResponse.builder().message("There is no aligned result").build();
        }
        response.header("Content-Encoding", "gzip");
        String string2 = request.queryParamOrDefault(MeasurementsService.getAXIS_UNIT_KEY(), MeasData.getDefaultAxis(measData).C());
        $B $B = $B.B(string2);
        String string3 = null;
        if ($B == null || !MeasurementsService.supportsFrequencyResponseAxisType(measData, $B)) {
            $B = MeasData.getDefaultAxis(measData);
            string3 = string2 + " is not a valid axis unit, returning " + MeasData.getDefaultAxis(measData).C() + " data. ";
        }
        if ((kJ2 = kJ.A(string = request.queryParamOrDefault(MeasurementsService.getSMOOTHING_KEY(), kJ.B(measData.getOctaveFrac()).A()))) == null) {
            kJ2 = kJ.B(measData.getOctaveFrac());
            if (string3 == null) {
                string3 = "";
            }
            string3 = string3 + string + " is not a valid smoothing, returning " + kJ2.A() + " data. ";
        }
        Integer n2 = null;
        String string4 = request.queryParamOrDefault(MeasurementsService.getPPO_KEY(), "");
        if (!string4.isEmpty()) {
            try {
                n2 = Integer.valueOf(string4.trim());
            }
            catch (NumberFormatException numberFormatException) {
                if (string3 == null) {
                    string3 = "";
                }
                string3 = string3 + string4 + " is not a valid ppo value, returning 96 PPO data. ";
                n2 = 96;
            }
        }
        if (n2 != null && (n2 <= 0 || 96.0 / (double)n2.intValue() != (double)(96 / n2))) {
            if (string3 == null) {
                string3 = "";
            }
            string3 = string3 + string4 + " is not a valid ppo value, ppo must be > 0  and a factor of 96, returning 96 PPO data. ";
            n2 = 96;
        }
        double d2 = measData.getOctaveFrac();
        if (kJ2.C() != measData.getOctaveFrac()) {
            measData.smooth(kJ2.C(), true);
        }
        FrequencyResponse frequencyResponse = measData.getFrequencyResponse($B, string3, n2);
        measData.smooth(d2, true);
        return frequencyResponse;
    }

    public ImpulseResponse getFilteredImpulseResponseA(Request request, Response response) {
        SampledData sampledData = allSPL.\u0271();
        return this.getImpulseResponse(request, response, sampledData);
    }

    public ImpulseResponse getFilteredImpulseResponseB(Request request, Response response) {
        SampledData sampledData = allSPL.\u025b();
        return this.getImpulseResponse(request, response, sampledData);
    }

    public ImpulseResponse getImpulseResponse(Request request, Response response, SampledData sampledData) {
        if (sampledData == null) {
            return ImpulseResponse.builder().message("There is no filtered impulse response").build();
        }
        response.header("Content-Encoding", "gzip");
        String string = request.queryParamOrDefault(MeasurementsService.getAXIS_UNIT_KEY(), MeasurementsService.getDefaultImpulseResponseAxis().C());
        $B $B = $B.B(string);
        String string2 = null;
        if ($B == null || !MeasurementsService.getImpulseResponseUnits().contains($B.C())) {
            $B = MeasurementsService.getDefaultImpulseResponseAxis();
            string2 = string + " is not a valid axis unit, returning " + MeasurementsService.getDefaultImpulseResponseAxis().C() + " data";
        }
        float[] fArray = (float[])sampledData.getNormData().clone();
        switch ($B) {
            case d: {
                int n2;
                for (n2 = 0; n2 < fArray.length; ++n2) {
                    fArray[n2] = 100.0f * fArray[n2];
                }
                break;
            }
            case c: {
                int n2;
                for (n2 = 0; n2 < fArray.length; ++n2) {
                    fArray[n2] = (float)(20.0 * Math.log10(Math.max((double)Math.abs(fArray[n2]), 1.0E-12)));
                }
                break;
            }
            default: {
                assert (false) : "Unhandled enum type";
                break;
            }
        }
        String string3 = API.encodeArray(fArray);
        ImpulseResponse impulseResponse = ImpulseResponse.builder().message(string2).unit($B.C()).startTime(sampledData.getStartTime()).sampleInterval(sampledData.getT()).sampleRate((double)Math.round(1024.0 / sampledData.getT()) / 1024.0).data(string3).build();
        return impulseResponse;
    }
}

