/*
 * Decompiled with CFR 0.152.
 */
package roomeqwizard.api;

import java.util.List;
import roomeqwizard.api.API;
import roomeqwizard.api.model.ValidRange;
import roomeqwizard.api.model.ValidValues;
import spark.Response;

public class APIResponse {
    private String message;
    private List<String> validValues;

    public APIResponse(Response response) {
        this.message = response.body();
    }

    public APIResponse(String string, List<String> list) {
        this.message = string;
        this.validValues = list;
    }

    public static APIResponse okNoContent(Response response) {
        response.status(204);
        return new APIResponse(response);
    }

    public static APIResponse ok(Response response, String string) {
        response.status(200);
        response.body(string);
        return new APIResponse(response);
    }

    public static <R> R ok(Response response, R r2) {
        response.status(200);
        return r2;
    }

    public static APIResponse accepted(Response response, String string) {
        response.status(API.convertAcceptedToOK() ? 200 : 202);
        response.body(string);
        return new APIResponse(response);
    }

    public static APIResponse error(Response response) {
        response.status(500);
        response.body("Error while processing request");
        return new APIResponse(response);
    }

    public static APIResponse error(Response response, String string) {
        response.status(500);
        response.body(string);
        return new APIResponse(response);
    }

    public static APIResponse badRequest(Response response, String string) {
        response.status(400);
        response.body(string);
        return new APIResponse(response);
    }

    public static APIResponse badRequest(Response response, ValidValues validValues) {
        response.status(400);
        return new APIResponse(validValues.getMessage(), validValues.getValidValues());
    }

    public static APIResponse badRequest(Response response, ValidRange validRange) {
        response.status(400);
        response.body(validRange.getMessage() + ", the valid range is " + validRange.getMin() + " to " + validRange.getMax());
        return new APIResponse(response);
    }

    public static APIResponse notFound(Response response, String string) {
        response.status(404);
        response.body(string);
        return new APIResponse(response);
    }

    public static APIResponse notImplemented(Response response) {
        response.status(501);
        response.body("Request service not implemented yet");
        return new APIResponse(response);
    }

    public static APIResponse notImplemented(Response response, String string) {
        response.status(501);
        response.body(string);
        return new APIResponse(response);
    }
}

