/*
 * Decompiled with CFR 0.152.
 */
package roomeqwizard.api;

import java.io.UnsupportedEncodingException;
import java.util.logging.Level;
import javax.servlet.http.HttpServletResponse;
import roomeqwizard.RoomEQ_Wizard;
import roomeqwizard.WizardLogger;
import roomeqwizard.api.API;
import roomeqwizard.iK;
import spark.Filter;
import spark.Request;
import spark.Response;
import spark.Spark;

public class APIFilters {
    public static Filter salt = (request, response) -> {
        String string = request.pathInfo();
        if (string.equals("/salt")) {
            Spark.halt((int)200, (String)iK.F());
        }
    };
    public static Filter checkRestrictions = (request, response) -> {
        String string = request.requestMethod().toLowerCase();
        if ((string.equals("post") || string.equals("put")) && API.isRestricted(request.pathInfo()) && !iK.A(request)) {
            String string2 = request.headers("key");
            if (string2 != null) {
                Spark.halt((int)401, (String)(string2 + " is not a valid API key, salt " + iK.D()));
            } else {
                Spark.halt((int)401, (String)"A Pro upgrade license is required for this action");
            }
        }
    };
    public static Filter stripTrailingSlashes = (request, response) -> {
        String string = request.pathInfo();
        if (string.endsWith("/") && string.length() > 1) {
            response.redirect(string.substring(0, string.length() - 1));
        }
    };
    public static Filter addTrailingSlashesAndLog = (request, response) -> {
        if (!request.pathInfo().endsWith("/")) {
            response.redirect(request.pathInfo() + "/");
        }
        WizardLogger.getLogger().log(Level.INFO, APIFilters.requestAndResponseInfoToString(request, response));
    };
    public static Filter handleLocaleChange = (request, response) -> {
        if (request.queryParams("locale") != null) {
            request.session().attribute("locale", (Object)request.queryParams("locale"));
            response.redirect(request.pathInfo());
        }
    };
    public static Filter addGzipHeader = (request, response) -> response.header("Content-Encoding", "gzip");
    public static Filter contentTypeJson = (request, response) -> response.type("application/json");
    public static Filter logAllExchanges = (request, response) -> System.out.println(RoomEQ_Wizard.\u00a2() + ": " + APIFilters.requestAndResponseInfoToString(request, response));

    private static String requestAndResponseInfoToString(Request request, Response response) {
        StringBuilder stringBuilder;
        block5: {
            stringBuilder = new StringBuilder();
            stringBuilder.append(request.requestMethod());
            stringBuilder.append(" ").append(request.url());
            stringBuilder.append(" ").append(request.body());
            HttpServletResponse httpServletResponse = response.raw();
            stringBuilder.append(" Response: ").append(httpServletResponse.getStatus());
            String string = httpServletResponse.getHeader("content-type");
            String string2 = string != null ? string : "no content-type";
            stringBuilder.append(" ").append(string2);
            String string3 = response.body();
            int n2 = response.status();
            if (string3 != null) {
                try {
                    if (n2 >= 200 && n2 <= 299) {
                        stringBuilder.append(" body size in bytes: ").append(string3.getBytes(httpServletResponse.getCharacterEncoding()).length);
                        break block5;
                    }
                    stringBuilder.append("body: ").append(string3);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {}
            } else {
                stringBuilder.append(" no body");
            }
        }
        return stringBuilder.toString();
    }
}

