/*
 * Decompiled with CFR 0.152.
 */
package roomeqwizard.api;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import io.github.manusant.ss.SparkSwagger;
import io.github.manusant.ss.conf.Options;
import io.github.manusant.ss.rest.Endpoint;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.logging.Level;
import roomeqwizard.HE;
import roomeqwizard.RoomEQ_Wizard;
import roomeqwizard.WizardLogger;
import roomeqwizard.api.APIFilters;
import roomeqwizard.api.APIResponse;
import roomeqwizard.api.AudioService;
import roomeqwizard.api.endpoint.AlignmentToolEndpoint;
import roomeqwizard.api.endpoint.ApplicationEndpoint;
import roomeqwizard.api.endpoint.AudioEndpoint;
import roomeqwizard.api.endpoint.EQEndpoint;
import roomeqwizard.api.endpoint.GeneratorEndpoint;
import roomeqwizard.api.endpoint.ImportEndpoint;
import roomeqwizard.api.endpoint.InputLevelsEndpoint;
import roomeqwizard.api.endpoint.MeasureEndpoint;
import roomeqwizard.api.endpoint.MeasurementsEndpoint;
import roomeqwizard.api.endpoint.RTAEndpoint;
import roomeqwizard.api.endpoint.RoomSimEndpoint;
import roomeqwizard.api.endpoint.SPLMeterEndpoint;
import roomeqwizard.api.endpoint.SteppedEndpoint;
import roomeqwizard.api.endpoint.VersionEndpoint;
import roomeqwizard.api.model.ErrorMessage;
import roomeqwizard.api.model.FrequencyResponse;
import roomeqwizard.api.model.InputLevels;
import roomeqwizard.api.model.MeasurementsListChange;
import roomeqwizard.api.model.ProcessResult;
import roomeqwizard.api.model.RTADistortion;
import roomeqwizard.api.model.RTALevel;
import roomeqwizard.api.model.RTAStatus;
import roomeqwizard.api.model.SPLValues;
import roomeqwizard.api.model.SteppedProgress;
import roomeqwizard.api.model.Value;
import roomeqwizard.api.model.WarningMessage;
import roomeqwizard.lH;
import spark.Response;
import spark.Service;

public class API {
    private static volatile boolean running = false;
    private static Integer runningPort;
    private static Service spark;
    private static String currentCommandExecuting;
    private static final boolean MONITOR_SUBSCRIPTIONS = false;

    public static void init(int n2) {
        try {
            Object object;
            Object object2 = "spark-swagger.conf";
            if (RoomEQ_Wizard.l() && Files.exists(Paths.get((String)(object = "C:\\Users\\johnm\\OneDrive\\Documents\\GitHub\\REW\\Releases\\standalonejarfiles\\spark-swagger.conf"), new String[0]), new LinkOption[0])) {
                object2 = object;
            }
            object = Options.defaultOptions().confPath((String)object2).port(n2).version(RoomEQ_Wizard.\u00c0()).build();
            spark = Service.ignite().ipAddress("localhost").port(n2);
            Consumer<Exception> consumer = new Consumer<Exception>(){

                @Override
                public void accept(Exception exception) {
                    String string = exception.getCause() != null ? " due to " + exception.getCause().toString() : "";
                    String string2 = exception.toString();
                    WizardLogger.getLogger().log(Level.SEVERE, "Spark initialisation exception {0}{1}", new Object[]{string2, string});
                }
            };
            spark.initExceptionHandler((Consumer)consumer);
            SparkSwagger.of(spark, (Options)object).endpoints(() -> API.getEndpoints()).generateDoc();
            running = true;
            runningPort = spark.port();
            RoomEQ_Wizard.n();
            spark.before(APIFilters.checkRestrictions);
            spark.before(APIFilters.salt);
            spark.before(APIFilters.stripTrailingSlashes);
            spark.before("/audio/*", AudioService.checkAudioAvailability);
            spark.before("/audio/*", AudioService.checkAudioDriverMatch);
        }
        catch (IOException iOException) {
            WizardLogger.getLogger().log(Level.SEVERE, "SparkSwagger doc generation ", iOException);
        }
    }

    private static void setUpSubscriptionMonitor() {
        Service service = Service.ignite().ipAddress("localhost").port(5374);
        service.post("/rta-status", (request, response) -> {
            response.type("application/json");
            RTAStatus rTAStatus = (RTAStatus)new Gson().fromJson(request.body(), RTAStatus.class);
            System.out.println("RTA enabled " + rTAStatus.getEnabled() + " running " + rTAStatus.getRunning());
            return "RTA status received";
        });
        service.post("/levels", (request, response) -> {
            response.type("application/json");
            Type type = new TypeToken<ArrayList<RTALevel>>(){}.getType();
            List list = (List)new Gson().fromJson(request.body(), type);
            System.out.println("Got " + list.size() + " levels, " + HE.K.format(((RTALevel)list.get(0)).getRmsLevel().getValue()) + " " + ((RTALevel)list.get(0)).getRmsLevel().getUnit());
            return "Levels received";
        });
        service.post("/current", (request, response) -> {
            response.type("application/json");
            FrequencyResponse frequencyResponse = (FrequencyResponse)new Gson().fromJson(request.body(), FrequencyResponse.class);
            float[] fArray = API.decodeArray(frequencyResponse.getMagnitude());
            System.out.println("Got current at " + frequencyResponse.getNanotime());
            lH.A(fArray, HE.U);
            return "Data received";
        });
        service.post("/peak", (request, response) -> {
            response.type("application/json");
            FrequencyResponse frequencyResponse = (FrequencyResponse)new Gson().fromJson(request.body(), FrequencyResponse.class);
            float[] fArray = API.decodeArray(frequencyResponse.getMagnitude());
            System.out.println("Got peak at " + frequencyResponse.getNanotime());
            lH.A(fArray, HE.U);
            return "Data received";
        });
        service.post("/errors", (request, response) -> {
            response.type("application/json");
            ErrorMessage errorMessage = (ErrorMessage)new Gson().fromJson(request.body(), ErrorMessage.class);
            System.out.println(errorMessage.getTitle() + " at " + errorMessage.getTime() + ", " + errorMessage.getMessage());
            return "Error received";
        });
        service.post("/warnings", (request, response) -> {
            response.type("application/json");
            WarningMessage warningMessage = (WarningMessage)new Gson().fromJson(request.body(), WarningMessage.class);
            System.out.println(warningMessage.getTitle() + " at " + warningMessage.getTime() + ", " + warningMessage.getMessage());
            return "Warning received";
        });
        service.post("/measurements", (request, response) -> {
            response.type("application/json");
            MeasurementsListChange measurementsListChange = (MeasurementsListChange)new Gson().fromJson(request.body(), MeasurementsListChange.class);
            System.out.println(measurementsListChange.getChangeDescription() + " affecting " + measurementsListChange.getFirstIndex() + " to " + measurementsListChange.getLastIndex());
            return "Measurements list change";
        });
        service.post("/distortion", (request, response) -> {
            response.type("application/json");
            Type type = new TypeToken<ArrayList<RTADistortion>>(){}.getType();
            List list = (List)new Gson().fromJson(request.body(), type);
            System.out.println("Got " + list.size() + " distortion blocks");
            for (RTADistortion rTADistortion : list) {
                if (rTADistortion == null || rTADistortion.getThd() == null) continue;
                Value value = rTADistortion.getFundamentalLevel();
                System.out.println("Fund: " + HE.K.format(value.getValue()) + " " + value.getUnit() + " at " + HE.A(((RTADistortion)list.get(0)).getFundamentalFrequency()));
                Value value2 = rTADistortion.getThd();
                System.out.println("THD: " + HE.K.format(value2.getValue()) + " " + value2.getUnit());
            }
            return "Distortion received";
        });
        service.post("/progress", (request, response) -> {
            response.type("application/json");
            String string = (String)new Gson().fromJson(request.body(), String.class);
            System.out.println("Progress " + string);
            return "Progress received";
        });
        service.post("/input-levels", (request, response) -> {
            response.type("application/json");
            InputLevels inputLevels = (InputLevels)new Gson().fromJson(request.body(), InputLevels.class);
            System.out.println(inputLevels.getUnit() + " over " + HE.U.format(1000.0 * inputLevels.getTimeSpanSeconds()) + " ms");
            lH.A(inputLevels.getRms(), HE.U);
            lH.A(inputLevels.getPeak(), HE.U);
            return "Input levels received";
        });
        service.post("/alignment", (request, response) -> {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(request.requestMethod());
            stringBuilder.append(" ").append(request.url());
            stringBuilder.append(" ").append(request.body());
            System.out.println(stringBuilder.toString());
            return "Alignment result received";
        });
        service.post("/import", (request, response) -> {
            response.type("application/json");
            String string = (String)new Gson().fromJson(request.body(), String.class);
            System.out.println("Import result " + string);
            return "Import subscription message received";
        });
        service.post("/spl", (request, response) -> {
            response.type("application/json");
            SPLValues sPLValues = (SPLValues)new Gson().fromJson(request.body(), SPLValues.class);
            System.out.println("SPL " + sPLValues.getMeterNumber() + ": " + sPLValues.getSpl());
            return "SPL meter subscription message received";
        });
        service.post("/stepped-progress", (request, response) -> {
            response.type("application/json");
            SteppedProgress steppedProgress = (SteppedProgress)new Gson().fromJson(request.body(), SteppedProgress.class);
            System.out.println(steppedProgress.getPoint() + "/" + steppedProgress.getPoints());
            if (steppedProgress.getMessage() != null && !steppedProgress.getMessage().isEmpty()) {
                System.out.println(steppedProgress.getMessage());
            }
            if (steppedProgress.getTimeRemainingSeconds() != null) {
                System.out.println(steppedProgress.getTimeRemainingSeconds() + " seconds remaining");
            }
            return "Progress received";
        });
        service.post("/process-result", (request, response) -> {
            response.type("application/json");
            ProcessResult processResult = (ProcessResult)new Gson().fromJson(request.body(), ProcessResult.class);
            System.out.println("Result for " + processResult.getProcessName() + ": " + processResult.getMessage());
            Map<Integer, Map<String, String>> map = processResult.getResults();
            if (map != null) {
                for (Integer n2 : map.keySet()) {
                    System.out.println(n2 + ": ");
                    Map<String, String> map2 = map.get(n2);
                    for (String string : map2.keySet()) {
                        System.out.println(string + ": " + map2.get(string));
                    }
                }
            }
            return "Process result received";
        });
    }

    public static List<Endpoint> getEndpoints() {
        return Arrays.asList(new ApplicationEndpoint(), new VersionEndpoint(), new AudioEndpoint(), new InputLevelsEndpoint(), new GeneratorEndpoint(), new SPLMeterEndpoint(), new MeasurementsEndpoint(), new MeasureEndpoint(), new RTAEndpoint(), new SteppedEndpoint(), new EQEndpoint(), new AlignmentToolEndpoint(), new ImportEndpoint(), new RoomSimEndpoint());
    }

    public static boolean isRunning() {
        return running;
    }

    public static Integer runningPort() {
        return runningPort;
    }

    public static boolean isRestricted(String string) {
        return string.toLowerCase().contains(MeasureEndpoint.getNameSpace().toLowerCase());
    }

    public static void stopServer() {
        spark.stop();
        spark.awaitStop();
        running = false;
        RoomEQ_Wizard.\u00c8();
    }

    public static String helpUrl(String string) {
        String string2 = string.substring(1);
        return "https://www.roomeqwizard.com/help/help_en-GB/html/api.html#" + string2;
    }

    public static String toKebabCase(String string) {
        return string.toLowerCase().replaceAll(" ", "-");
    }

    public static String encodeArray(float[] fArray) {
        return Base64.getEncoder().encodeToString(API.floatToByteArray(fArray));
    }

    private static byte[] floatToByteArray(float[] fArray) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(4 * fArray.length);
        byteBuffer.asFloatBuffer().put(fArray);
        return byteBuffer.array();
    }

    public static float[] decodeArray(String string) {
        return API.byteToFloatArray(Base64.getDecoder().decode(string));
    }

    private static float[] byteToFloatArray(byte[] byArray) {
        FloatBuffer floatBuffer = ByteBuffer.wrap(byArray).asFloatBuffer();
        float[] fArray = new float[floatBuffer.limit()];
        floatBuffer.get(fArray);
        return fArray;
    }

    public static Double getFrequency(String string) {
        String string2 = "Hz";
        String string3 = string.trim().toLowerCase();
        if (string3.endsWith(string2.toLowerCase())) {
            string3 = string3.substring(0, string3.length() - string2.length()).trim();
        }
        int n2 = 1;
        if (string3.endsWith("k")) {
            n2 = 1000;
            string3 = string3.substring(0, string3.length() - 1).trim();
        }
        try {
            Double d2 = Double.valueOf(string3);
            return d2 * (double)n2;
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public static Integer getInt(String string) {
        try {
            Integer n2 = Integer.valueOf(string);
            return n2;
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public static ArrayList<String> checkForMissingParameters(Map<String, String> map, String ... stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (map == null || map.isEmpty()) {
            arrayList.addAll(Arrays.asList(stringArray));
            return arrayList;
        }
        for (String string : stringArray) {
            if (map.containsKey(string)) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public static ArrayList<String> checkForMissingParameters(Map<String, String> map, ArrayList<String> arrayList) {
        ArrayList<String> arrayList2 = new ArrayList<String>();
        if (map == null || map.isEmpty()) {
            arrayList2.addAll(arrayList);
            return arrayList2;
        }
        for (String string : arrayList) {
            if (map.containsKey(string)) continue;
            arrayList2.add(string);
        }
        return arrayList2;
    }

    public static APIResponse handleMissingParameters(ArrayList<String> arrayList, Response response) {
        String string = arrayList.size() == 1 ? "parameter: " : "parameters: ";
        return APIResponse.badRequest(response, "The request is missing " + string + String.join((CharSequence)", ", arrayList));
    }

    public static String filenameParameter() {
        return "filename";
    }

    public static boolean convertAcceptedToOK() {
        return false;
    }

    public static APIResponse commandAccepted(Response response, String string) {
        currentCommandExecuting = string;
        return APIResponse.accepted(response, string + " in progress");
    }

    public static void clearCommand() {
        currentCommandExecuting = "";
    }

    public static boolean runningACommand() {
        return currentCommandExecuting != null && !currentCommandExecuting.isEmpty();
    }

    public static String getRunningCommand() {
        return currentCommandExecuting;
    }

    static {
        currentCommandExecuting = "";
    }
}

