/*
 * Decompiled with CFR 0.152.
 */
package roomeqwizard;

import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.swing.JOptionPane;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.representer.Representer;
import roomeqwizard.CamillaFilter;
import roomeqwizard.CamillaFilterSet;
import roomeqwizard.CamillaParameters;
import roomeqwizard.CamillaPipelineItem;
import roomeqwizard.EG;
import roomeqwizard.Equaliser;
import roomeqwizard.FilterGroup;
import roomeqwizard.FilterSet;
import roomeqwizard.HK;
import roomeqwizard.MeasData;
import roomeqwizard.PE;
import roomeqwizard.SampleRates;
import roomeqwizard.WizardLogger;
import roomeqwizard.XE;
import roomeqwizard.XOverFilter;
import roomeqwizard.XOverShape;
import roomeqwizard.XOverSlope;
import roomeqwizard.YH;
import roomeqwizard.eC;
import roomeqwizard.fC;
import roomeqwizard.g;
import roomeqwizard.lG;

class aB
extends Equaliser {
    private Component \u00a3;
    private String z = "filter";
    private String y = "0";
    private int \u00a2 = 0;

    aB() {
        super(fC.A().A(0).B(20).A(10.0).K(22000.0).G(0.01).I(-120.0).F(30.0).L(0.1).D(0.1).B(50.0).H(0.001).E(0.1).C(50.0).J(0.01).A(SampleRates.RATE96K).A());
        this.sendFiltersLabel = "Save filter settings to YAML file";
        this.readFiltersLabel = "Load filter settings from YAML file";
        this.filterTypes.clear();
        this.filterGroups = new ArrayList();
        this.filterGroups.add(FilterGroup.NONE);
        this.filterGroups.add(FilterGroup.PEAKING);
        this.filterGroups.add(FilterGroup.MODAL);
        this.filterGroups.add(FilterGroup.LPQ);
        this.filterGroups.add(FilterGroup.HPQ);
        this.filterGroups.add(FilterGroup.LSQ);
        this.filterGroups.add(FilterGroup.HSQ);
        this.filterGroups.add(FilterGroup.NOTCHQ);
        this.filterGroups.add(FilterGroup.ALLPASS);
        this.filterGroups.add(FilterGroup.LINKWITZT);
        this.filterGroups.add(FilterGroup.LOWPASS);
        this.filterGroups.add(FilterGroup.HIGHPASS);
        this.lpShapes = new ArrayList();
        this.lpShapes.add(XOverShape.BUTTERWORTH);
        this.lpShapes.add(XOverShape.LINKWITZ_RILEY);
        this.hpShapes = new ArrayList();
        this.hpShapes.add(XOverShape.BUTTERWORTH);
        this.hpShapes.add(XOverShape.LINKWITZ_RILEY);
        ArrayList<XOverSlope> arrayList = new ArrayList<XOverSlope>();
        arrayList.add(XOverSlope.SLOPE_6DB);
        arrayList.add(XOverSlope.SLOPE_12DB);
        arrayList.add(XOverSlope.SLOPE_18DB);
        arrayList.add(XOverSlope.SLOPE_24DB);
        arrayList.add(XOverSlope.SLOPE_30DB);
        arrayList.add(XOverSlope.SLOPE_36DB);
        arrayList.add(XOverSlope.SLOPE_42DB);
        arrayList.add(XOverSlope.SLOPE_48DB);
        ArrayList<XOverSlope> arrayList2 = new ArrayList<XOverSlope>();
        arrayList2.add(XOverSlope.SLOPE_12DB);
        arrayList2.add(XOverSlope.SLOPE_24DB);
        arrayList2.add(XOverSlope.SLOPE_36DB);
        arrayList2.add(XOverSlope.SLOPE_48DB);
        this.lpShapeSlopes = new HashMap();
        this.lpShapeSlopes.put(XOverShape.BUTTERWORTH, arrayList);
        this.lpShapeSlopes.put(XOverShape.LINKWITZ_RILEY, arrayList2);
        this.hpShapeSlopes = new HashMap();
        this.hpShapeSlopes.put(XOverShape.BUTTERWORTH, arrayList);
        this.hpShapeSlopes.put(XOverShape.LINKWITZ_RILEY, arrayList2);
        this.shelfSlopes = new ArrayList();
        this.shelfSlopes.add(XOverSlope.SLOPE_6DB);
        this.shelfSlopes.add(XOverSlope.SLOPE_12DB);
    }

    @Override
    String getEqualiserName() {
        return "CamillaDSP";
    }

    @Override
    public PE getManufacturer() {
        return PE.a;
    }

    @Override
    public String getModel() {
        return "Filters";
    }

    @Override
    boolean runsAtResponseRate() {
        return true;
    }

    @Override
    boolean supportsSendFilters() {
        return true;
    }

    @Override
    boolean supportsReadFilters() {
        return true;
    }

    @Override
    boolean supportsFileRead() {
        return true;
    }

    @Override
    boolean supportsFileWrite() {
        return true;
    }

    @Override
    void saveFilters(FilterSet filterSet, MeasData measData) {
        this.sendFilters(filterSet, measData);
    }

    @Override
    void loadFilters(FilterSet filterSet, MeasData measData) {
        this.readFilters(filterSet, measData);
    }

    @Override
    boolean supportsSmoothParamVariation() {
        return true;
    }

    @Override
    void sendFilters(FilterSet filterSet, MeasData measData) {
        block20: {
            Component component = g.getDialogParent();
            String string = JOptionPane.showInputDialog(component, "Enter the label to use for each filter, the \nfilter number will be appended to the label", this.z);
            if (string == null) {
                return;
            }
            String string2 = JOptionPane.showInputDialog(component, "Enter the channel number for the pipeline entry", this.y);
            if (string2 == null) {
                return;
            }
            try {
                this.\u00a2 = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                JOptionPane.showMessageDialog(component, "The channel must be a number", "Invalid channel", 0);
                return;
            }
            int n2 = XE.D("Choose the file to overwrite or enter a new filename", lG.\u01e3(), "", XE.H, component);
            if (n2 == 0) {
                try {
                    String string3 = XE.W();
                    string3 = XE.A(string3, XE.H);
                    if (!XE.A(string3, component, false)) break block20;
                    this.z = string.replaceAll("[\n\r\t\u0000\f]", "_");
                    if (this.z.isEmpty()) {
                        this.z = "filter";
                    }
                    try (PrintWriter printWriter = new PrintWriter(new FileOutputStream(string3));){
                        CamillaFilterSet camillaFilterSet = new CamillaFilterSet();
                        this.A(camillaFilterSet, filterSet);
                        DumperOptions dumperOptions = new DumperOptions();
                        dumperOptions.setIndent(2);
                        dumperOptions.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
                        dumperOptions.setIndicatorIndent(2);
                        dumperOptions.setIndentWithIndicator(true);
                        EG eG2 = new EG(dumperOptions);
                        HK hK2 = new HK();
                        eG2.setPropertyUtils(hK2);
                        Yaml yaml = new Yaml((Representer)eG2, dumperOptions);
                        String string4 = yaml.dumpAsMap((Object)camillaFilterSet);
                        printWriter.print(string4);
                    }
                    lG.\u00ba(string3);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    JOptionPane.showMessageDialog(component, "Unable to write filter settings:\n" + fileNotFoundException.getMessage(), "Export filter settings error", 0);
                }
            }
        }
    }

    private void A(CamillaFilterSet camillaFilterSet, FilterSet filterSet) {
        Object object;
        LinkedHashMap<String, CamillaFilter> linkedHashMap = camillaFilterSet.getFilters();
        int n2 = filterSet.getNumXOverFilters();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i2 = 0; i2 < n2; ++i2) {
            object = filterSet.getXOverFilters()[i2];
            CamillaFilter camillaFilter = new CamillaFilter();
            CamillaParameters camillaParameters = new CamillaParameters();
            camillaFilter.setParameters(camillaParameters);
            String string = this.z + "_" + (i2 + 1);
            if (!((XOverFilter)object).isEnabled() || ((XOverFilter)object).getFilterGroup() == FilterGroup.NONE) continue;
            block0 : switch (((XOverFilter)object).getFilterGroup()) {
                case PEAKING: {
                    camillaFilter.setType("Biquad");
                    camillaParameters.setType("Peaking");
                    camillaParameters.setFreq(((XOverFilter)object).getFilterFc());
                    camillaParameters.setQ(((XOverFilter)object).getFilterQ());
                    camillaParameters.setGain(((XOverFilter)object).getFilterGain());
                    break;
                }
                case MODAL: {
                    camillaFilter.setType("Biquad");
                    camillaParameters.setType("Peaking");
                    camillaParameters.setFreq(((XOverFilter)object).getFilterFc());
                    camillaParameters.setQ(((XOverFilter)object).getFilterQ());
                    camillaParameters.setGain(((XOverFilter)object).getFilterGain());
                    break;
                }
                case HPQ: {
                    camillaFilter.setType("Biquad");
                    camillaParameters.setType("Highpass");
                    camillaParameters.setFreq(((XOverFilter)object).getFilterFc());
                    camillaParameters.setQ(((XOverFilter)object).getFilterQ());
                    break;
                }
                case LPQ: {
                    camillaFilter.setType("Biquad");
                    camillaParameters.setType("Lowpass");
                    camillaParameters.setFreq(((XOverFilter)object).getFilterFc());
                    camillaParameters.setQ(((XOverFilter)object).getFilterQ());
                    break;
                }
                case HSQ: {
                    camillaFilter.setType("Biquad");
                    camillaParameters.setType("Highshelf");
                    camillaParameters.setFreq(((XOverFilter)object).getFilterFc());
                    camillaParameters.setQ(((XOverFilter)object).getFilterQ());
                    camillaParameters.setGain(((XOverFilter)object).getFilterGain());
                    break;
                }
                case LSQ: {
                    camillaFilter.setType("Biquad");
                    camillaParameters.setType("Lowshelf");
                    camillaParameters.setFreq(((XOverFilter)object).getFilterFc());
                    camillaParameters.setQ(((XOverFilter)object).getFilterQ());
                    camillaParameters.setGain(((XOverFilter)object).getFilterGain());
                    break;
                }
                case NOTCHQ: {
                    camillaFilter.setType("Biquad");
                    camillaParameters.setType("Notch");
                    camillaParameters.setFreq(((XOverFilter)object).getFilterFc());
                    camillaParameters.setQ(((XOverFilter)object).getFilterQ());
                    break;
                }
                case ALLPASS: {
                    camillaFilter.setType("Biquad");
                    camillaParameters.setType("Allpass");
                    camillaParameters.setFreq(((XOverFilter)object).getFilterFc());
                    camillaParameters.setQ(((XOverFilter)object).getFilterQ());
                    break;
                }
                case LINKWITZT: {
                    camillaFilter.setType("Biquad");
                    camillaParameters.setType("LinkwitzTransform");
                    camillaParameters.setFreq_act(((XOverFilter)object).getFilterFc());
                    camillaParameters.setQ_act(((XOverFilter)object).getFilterQ());
                    camillaParameters.setFreq_target(((XOverFilter)object).getFilterFc2());
                    camillaParameters.setQ_target(((XOverFilter)object).getFilterQ2());
                    break;
                }
                case HIGHPASS: {
                    camillaFilter.setType("BiquadCombo");
                    switch (((XOverFilter)object).getFilterShape()) {
                        case BUTTERWORTH: {
                            camillaParameters.setType("ButterworthHighpass");
                            camillaParameters.setFreq(((XOverFilter)object).getFilterFc());
                            camillaParameters.setOrder(((XOverFilter)object).getFilterSlope().getOrder());
                            break block0;
                        }
                        case LINKWITZ_RILEY: {
                            camillaParameters.setType("LinkwitzRileyHighpass");
                            camillaParameters.setFreq(((XOverFilter)object).getFilterFc());
                            camillaParameters.setOrder(((XOverFilter)object).getFilterSlope().getOrder());
                            break block0;
                        }
                    }
                    assert (false) : "Unhandled enum type";
                    break;
                }
                case LOWPASS: {
                    camillaFilter.setType("BiquadCombo");
                    switch (((XOverFilter)object).getFilterShape()) {
                        case BUTTERWORTH: {
                            camillaParameters.setType("ButterworthLowpass");
                            camillaParameters.setFreq(((XOverFilter)object).getFilterFc());
                            camillaParameters.setOrder(((XOverFilter)object).getFilterSlope().getOrder());
                            break block0;
                        }
                        case LINKWITZ_RILEY: {
                            camillaParameters.setType("LinkwitzRileyLowpass");
                            camillaParameters.setFreq(((XOverFilter)object).getFilterFc());
                            camillaParameters.setOrder(((XOverFilter)object).getFilterSlope().getOrder());
                            break block0;
                        }
                    }
                    assert (false) : "Unhandled enum type";
                    break;
                }
                default: {
                    assert (false) : "Unhandled enum type";
                    break;
                }
            }
            linkedHashMap.put(string, camillaFilter);
            arrayList.add(string);
        }
        ArrayList<CamillaPipelineItem> arrayList2 = new ArrayList<CamillaPipelineItem>();
        object = new CamillaPipelineItem();
        ((CamillaPipelineItem)object).setType("Filter");
        ((CamillaPipelineItem)object).setChannel(this.\u00a2);
        ((CamillaPipelineItem)object).setNames(arrayList);
        arrayList2.add((CamillaPipelineItem)object);
        camillaFilterSet.setPipeline(arrayList2);
    }

    @Override
    void readFilters(FilterSet filterSet, MeasData measData) {
        this.\u00a3 = g.getDialogParent();
        int n2 = XE.A(filterSet, this.\u00a3);
        if (n2 == 0) {
            String string;
            if (eC.C()) {
                eC.I();
            }
            if ((n2 = XE.A("Choose the filter settings file", string = lG.\u01e3(), string, XE.H, this.\u00a3, false)) == 0) {
                String string2 = XE.W();
                string2 = XE.A(string2, XE.H);
                File file = new File(string2);
                this.A(file, filterSet, measData);
                lG.\u00ba(string2);
            }
        }
    }

    private int A(String string, int n2) {
        String string2;
        String string3 = string.toLowerCase();
        if (string3.startsWith(string2 = "filter_")) {
            String string4 = string3.substring(string2.length());
            try {
                int n3 = Integer.parseInt(string4);
                if (n3 >= 1 && n3 <= this.getNumXOverFilters()) {
                    return n3 - 1;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n2 + 1;
    }

    private void A(File file, FilterSet filterSet, MeasData measData) {
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            Yaml yaml = new Yaml((BaseConstructor)new Constructor(CamillaFilterSet.class));
            CamillaFilterSet camillaFilterSet = (CamillaFilterSet)yaml.load((InputStream)fileInputStream);
            int n2 = -1;
            for (XOverFilter object : filterSet.getXOverFilters()) {
                object.setFilterGroup(FilterGroup.NONE);
                object.setEnabled(true);
            }
            block22: for (Map.Entry entry : camillaFilterSet.getFilters().entrySet()) {
                String string = (String)entry.getKey();
                n2 = this.A(string, n2);
                CamillaFilter camillaFilter = (CamillaFilter)entry.getValue();
                String string2 = camillaFilter.getType();
                CamillaParameters camillaParameters = camillaFilter.getParameters();
                XOverFilter xOverFilter = filterSet.getXOverFilters()[n2];
                switch (string2) {
                    case "Biquad": {
                        this.A(camillaParameters, xOverFilter, string);
                        continue block22;
                    }
                    case "BiquadCombo": {
                        this.A(xOverFilter, camillaParameters, string);
                        continue block22;
                    }
                }
                JOptionPane.showMessageDialog(this.\u00a3, "Unrecognised filter category: " + string2 + " in " + string + "\nthat filter entry has been skipped", "Unrecognised filter category", 2);
            }
            if (measData != null) {
                YH.\u0164().D(measData);
                measData.applyFiltersImmediate(true);
            }
            if (YH.\u0161()) {
                YH.\u0164().C(measData);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            JOptionPane.showMessageDialog(this.\u00a3, "File " + file.getName() + " not found\n", "Read filters error", 0);
        }
        catch (IOException iOException) {
            WizardLogger.getLogger().log(Level.SEVERE, "Exception reading filter data from file: {0}", iOException.getMessage());
            iOException.printStackTrace(System.err);
            JOptionPane.showMessageDialog(g.getDialogParent(), "Unable to read filter data:\n" + iOException.getMessage(), "Read filters error", 0);
        }
        catch (Exception exception) {
            WizardLogger.getLogger().log(Level.SEVERE, "Exception parsing filter data from file: {0}", exception.getMessage());
            exception.printStackTrace(System.err);
            JOptionPane.showMessageDialog(g.getDialogParent(), "Unable to parse filter data from " + file.getName(), "Read filters error", 0);
        }
    }

    private void A(CamillaParameters camillaParameters, XOverFilter xOverFilter, String string) {
        String string2;
        switch (string2 = camillaParameters.getType()) {
            case "Peaking": {
                xOverFilter.setFilterGroup(FilterGroup.PEAKING);
                xOverFilter.setFilterFc(camillaParameters.getFreq());
                if (camillaParameters.getBandwidth() != null) {
                    double d2 = camillaParameters.getBandwidth();
                    double d3 = Math.PI * 2 * camillaParameters.getFreq() / (double)xOverFilter.getSampleRate();
                    double d4 = 2.0 * Math.sinh(0.5 * Math.log(2.0) * d2 * d3 / Math.sin(d3));
                    xOverFilter.setFilterQ(1.0 / d4);
                } else {
                    xOverFilter.setFilterQ(camillaParameters.getQ());
                }
                xOverFilter.setFilterGain(camillaParameters.getGain());
                break;
            }
            case "Highpass": {
                xOverFilter.setFilterGroup(FilterGroup.HPQ);
                xOverFilter.setFilterFc(camillaParameters.getFreq());
                xOverFilter.setFilterQ(camillaParameters.getQ());
                break;
            }
            case "HighpassFO": {
                xOverFilter.setFilterGroup(FilterGroup.HIGHPASS);
                xOverFilter.setFilterShape(XOverShape.BUTTERWORTH);
                xOverFilter.setFilterSlope(XOverSlope.SLOPE_6DB);
                xOverFilter.setFilterFc(camillaParameters.getFreq());
                break;
            }
            case "Lowpass": {
                xOverFilter.setFilterGroup(FilterGroup.LPQ);
                xOverFilter.setFilterFc(camillaParameters.getFreq());
                xOverFilter.setFilterQ(camillaParameters.getQ());
                break;
            }
            case "LowpassFO": {
                xOverFilter.setFilterGroup(FilterGroup.LOWPASS);
                xOverFilter.setFilterShape(XOverShape.BUTTERWORTH);
                xOverFilter.setFilterSlope(XOverSlope.SLOPE_6DB);
                xOverFilter.setFilterFc(camillaParameters.getFreq());
                break;
            }
            case "Highshelf": {
                xOverFilter.setFilterGroup(FilterGroup.HSQ);
                xOverFilter.setFilterFc(camillaParameters.getFreq());
                if (camillaParameters.getSlope() != null) {
                    double d5 = camillaParameters.getSlope() / 12.0;
                    double d6 = Math.pow(10.0, camillaParameters.getGain() / 40.0);
                    double d7 = 1.0 / Math.sqrt((d6 + 1.0 / d6) * (1.0 / d5 - 1.0) + 2.0);
                    xOverFilter.setFilterQ(d7);
                } else {
                    xOverFilter.setFilterQ(camillaParameters.getQ());
                }
                xOverFilter.setFilterGain(camillaParameters.getGain());
                break;
            }
            case "Lowshelf": {
                xOverFilter.setFilterGroup(FilterGroup.LSQ);
                xOverFilter.setFilterFc(camillaParameters.getFreq());
                if (camillaParameters.getSlope() != null) {
                    double d8 = camillaParameters.getSlope() / 12.0;
                    double d9 = Math.pow(10.0, camillaParameters.getGain() / 40.0);
                    double d10 = 1.0 / Math.sqrt((d9 + 1.0 / d9) * (1.0 / d8 - 1.0) + 2.0);
                    xOverFilter.setFilterQ(d10);
                } else {
                    xOverFilter.setFilterQ(camillaParameters.getQ());
                }
                xOverFilter.setFilterGain(camillaParameters.getGain());
                break;
            }
            case "Notch": {
                xOverFilter.setFilterGroup(FilterGroup.NOTCHQ);
                xOverFilter.setFilterFc(camillaParameters.getFreq());
                if (camillaParameters.getBandwidth() != null) {
                    double d11 = camillaParameters.getBandwidth();
                    double d12 = Math.PI * 2 * camillaParameters.getFreq() / (double)xOverFilter.getSampleRate();
                    double d13 = 2.0 * Math.sinh(0.5 * Math.log(2.0) * d11 * d12 / Math.sin(d12));
                    xOverFilter.setFilterQ(1.0 / d13);
                    break;
                }
                xOverFilter.setFilterQ(camillaParameters.getQ());
                break;
            }
            case "Allpass": {
                xOverFilter.setFilterGroup(FilterGroup.ALLPASS);
                xOverFilter.setFilterFc(camillaParameters.getFreq());
                if (camillaParameters.getBandwidth() != null) {
                    double d14 = camillaParameters.getBandwidth();
                    double d15 = Math.PI * 2 * camillaParameters.getFreq() / (double)xOverFilter.getSampleRate();
                    double d16 = 2.0 * Math.sinh(0.5 * Math.log(2.0) * d14 * d15 / Math.sin(d15));
                    xOverFilter.setFilterQ(1.0 / d16);
                    break;
                }
                xOverFilter.setFilterQ(camillaParameters.getQ());
                break;
            }
            case "LinkwitzTransform": {
                xOverFilter.setFilterGroup(FilterGroup.LINKWITZT);
                xOverFilter.setFilterFc(camillaParameters.getFreq_act());
                xOverFilter.setFilterQ(camillaParameters.getQ_act());
                xOverFilter.setFilterFc2(camillaParameters.getFreq_target());
                xOverFilter.setFilterQ2(camillaParameters.getQ_target());
                break;
            }
            default: {
                JOptionPane.showMessageDialog(this.\u00a3, "Unrecognised Biquad type: " + string2 + " in " + string + "\nthat filter entry has been skipped", "Unrecognised filter", 2);
            }
        }
    }

    private void A(XOverFilter xOverFilter, CamillaParameters camillaParameters, String string) {
        String string2;
        switch (string2 = camillaParameters.getType()) {
            case "ButterworthHighpass": {
                xOverFilter.setFilterGroup(FilterGroup.HIGHPASS);
                xOverFilter.setFilterShape(XOverShape.BUTTERWORTH);
                xOverFilter.setFilterSlope(XOverSlope.getSlopeForOrder(camillaParameters.getOrder()));
                xOverFilter.setFilterFc(camillaParameters.getFreq());
                break;
            }
            case "ButterworthLowpass": {
                xOverFilter.setFilterGroup(FilterGroup.LOWPASS);
                xOverFilter.setFilterShape(XOverShape.BUTTERWORTH);
                xOverFilter.setFilterSlope(XOverSlope.getSlopeForOrder(camillaParameters.getOrder()));
                xOverFilter.setFilterFc(camillaParameters.getFreq());
                break;
            }
            case "LinkwitzRileyHighpass": {
                xOverFilter.setFilterGroup(FilterGroup.HIGHPASS);
                xOverFilter.setFilterShape(XOverShape.LINKWITZ_RILEY);
                xOverFilter.setFilterSlope(XOverSlope.getSlopeForOrder(camillaParameters.getOrder()));
                xOverFilter.setFilterFc(camillaParameters.getFreq());
                break;
            }
            case "LinkwitzRileyLowpass": {
                xOverFilter.setFilterGroup(FilterGroup.LOWPASS);
                xOverFilter.setFilterShape(XOverShape.LINKWITZ_RILEY);
                xOverFilter.setFilterSlope(XOverSlope.getSlopeForOrder(camillaParameters.getOrder()));
                xOverFilter.setFilterFc(camillaParameters.getFreq());
                break;
            }
            default: {
                JOptionPane.showMessageDialog(this.\u00a3, "Unrecognised BiquadCombo type: " + string2 + " in " + string + "\nthat filter entry has been skipped", "Unrecognised filter", 2);
            }
        }
    }
}

