/*
 * Decompiled with CFR 0.152.
 */
package roomeqwizard;

import java.awt.Color;
import java.beans.PropertyChangeListener;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.event.SwingPropertyChangeSupport;
import roomeqwizard.DA;
import roomeqwizard.Equaliser;
import roomeqwizard.Filter;
import roomeqwizard.FilterGroup;
import roomeqwizard.FilterResponse;
import roomeqwizard.HE;
import roomeqwizard.XOverChoice;
import roomeqwizard.XOverShape;
import roomeqwizard.XOverSlope;
import roomeqwizard.XOverType;

class XOverFilter
implements Comparable,
Serializable,
FilterResponse {
    static final long serialVersionUID = -987654321987654321L;
    private static final double[][] BesselQValues = new double[][]{{0.5770852828490117}, {0.6910154863916338, -0.5}, {0.5219329722870685, 0.8055299528207014}, {0.5635347999677949, 0.9164707658376264, -0.5}, {0.5103173968120757, 0.6111952783651023, 1.0233583548134582}, {0.5323561380211806, 0.6608319784908856, 1.1262449587088492, -0.5}, {0.5059915400402725, 1.2257649282840775, 0.7108625721672684, 0.5596517009453353}};
    private static final double[][] BesselFreqFactors = new double[][]{{1.2753584750963158}, {1.4523763492979358, 1.327}, {1.4192401382429964, 1.5912438688020136}, {1.5611041028707855, 1.760723635327248, 1.5069}, {1.6059688477676022, 1.6912995742919112, 1.9071306300303605}, {1.7173809012563288, 1.8234997614477495, 2.0506668208170726, 1.6853}, {1.7838225752579766, 2.1953449865567825, 1.9591372488929917, 1.8377842555642923}};
    static final int NUM_FILTERS = 4;
    private Filter[] filters;
    private int indexOffset;
    private int activeBiquads;
    @Deprecated
    private XOverChoice xOverChoice;
    @Deprecated
    private XOverType xOverType;
    private double fc;
    private double fc2;
    private FilterGroup group = FilterGroup.NONE;
    private Filter filter;
    private double gain;
    private double q;
    private double q2;
    private double t60;
    private XOverSlope slope;
    private XOverSlope slope2;
    private XOverShape shape;
    private transient Color color;
    private transient SwingPropertyChangeSupport pcs = new SwingPropertyChangeSupport(this);
    private transient boolean highlighted = false;
    private transient int index;

    void setUpFrom(Filter filter) {
        assert (filter != null);
        Filter.FilterTypes filterTypes = filter.getFilterType();
        if (filterTypes == Filter.FilterTypes.NONE) {
            this.clearFilter();
            return;
        }
        FilterGroup filterGroup = FilterGroup.typeToGroup(filterTypes);
        if (filterGroup != null) {
            this.setFilterGroup(filterGroup);
            this.setFilterFc(filter.getFilterFc());
            this.setFilterFc2(filter.getFilterFc2());
            this.setFilterGain(filter.getFilterGain());
            this.setFilterQ(filter.getFilterQ());
            this.setFilterQ2(filter.getFilterQ2());
            this.setFilterT60Target(filter.getFilterT60Target());
            this.setAutomatic(filter.isAutomatic());
            this.setAssignedForMatch(filter.wasAssignedForMatch());
            this.setEnabled(filter.isEnabled());
        } else if (FilterGroup.canConvert(filter)) {
            switch (filterTypes) {
                case LP: {
                    this.setLPHPFilter(FilterGroup.LOWPASS, XOverShape.BUTTERWORTH, XOverSlope.SLOPE_12DB, filter.getFilterFc());
                    break;
                }
                case HP: {
                    this.setLPHPFilter(FilterGroup.HIGHPASS, XOverShape.BUTTERWORTH, XOverSlope.SLOPE_12DB, filter.getFilterFc());
                    break;
                }
                case LP1: {
                    this.setLPHPFilter(FilterGroup.LOWPASS, XOverShape.BUTTERWORTH, XOverSlope.SLOPE_6DB, filter.getFilterFc());
                    break;
                }
                case HP1: {
                    this.setLPHPFilter(FilterGroup.HIGHPASS, XOverShape.BUTTERWORTH, XOverSlope.SLOPE_6DB, filter.getFilterFc());
                    break;
                }
                case LS6: {
                    this.setLowShelf(XOverSlope.SLOPE_6DB, filter.getFilterFc(), filter.getFilterGain());
                    break;
                }
                case LS12: {
                    this.setLowShelf(XOverSlope.SLOPE_12DB, filter.getFilterFc(), filter.getFilterGain());
                    break;
                }
                case HS6: {
                    this.setHighShelf(XOverSlope.SLOPE_6DB, filter.getFilterFc(), filter.getFilterGain());
                    break;
                }
                case HS12: {
                    this.setHighShelf(XOverSlope.SLOPE_12DB, filter.getFilterFc(), filter.getFilterGain());
                    break;
                }
                default: {
                    assert (false) : "Unhandled enum";
                    break;
                }
            }
        }
    }

    Filter.FilterTypes canBeConvertedTo() {
        Filter.FilterTypes filterTypes = this.group.toFilterType();
        if (filterTypes != null) {
            return filterTypes;
        }
        switch (this.group) {
            case LOWPASS: {
                if (this.shape != XOverShape.BUTTERWORTH) break;
                if (this.slope == XOverSlope.SLOPE_12DB) {
                    filterTypes = Filter.FilterTypes.LP;
                    break;
                }
                if (this.slope != XOverSlope.SLOPE_6DB) break;
                filterTypes = Filter.FilterTypes.LP1;
                break;
            }
            case HIGHPASS: {
                if (this.shape != XOverShape.BUTTERWORTH) break;
                if (this.slope == XOverSlope.SLOPE_12DB) {
                    filterTypes = Filter.FilterTypes.HP;
                    break;
                }
                if (this.slope != XOverSlope.SLOPE_6DB) break;
                filterTypes = Filter.FilterTypes.HP1;
                break;
            }
            case LOWSHELF: {
                if (this.slope == XOverSlope.SLOPE_12DB) {
                    filterTypes = Filter.FilterTypes.LS12;
                    break;
                }
                if (this.slope != XOverSlope.SLOPE_6DB) break;
                filterTypes = Filter.FilterTypes.LS6;
                break;
            }
            case HIGHSHELF: {
                if (this.slope == XOverSlope.SLOPE_12DB) {
                    filterTypes = Filter.FilterTypes.HS12;
                    break;
                }
                if (this.slope != XOverSlope.SLOPE_6DB) break;
                filterTypes = Filter.FilterTypes.HS6;
            }
        }
        return filterTypes;
    }

    Filter getConvertedFilter() {
        Filter.FilterTypes filterTypes = this.group.toFilterType();
        Filter filter = null;
        if (filterTypes != null) {
            filter = Filter.copy(this.filters[this.indexOffset]);
            filter.setGroup(null);
        } else {
            switch (this.group) {
                case LOWPASS: {
                    if (this.shape != XOverShape.BUTTERWORTH) break;
                    if (this.slope == XOverSlope.SLOPE_12DB) {
                        filter = new Filter(Filter.FilterTypes.LP, this.getSampleRate());
                        break;
                    }
                    if (this.slope != XOverSlope.SLOPE_6DB) break;
                    filter = new Filter(Filter.FilterTypes.LP1, this.getSampleRate());
                    break;
                }
                case HIGHPASS: {
                    if (this.shape != XOverShape.BUTTERWORTH) break;
                    if (this.slope == XOverSlope.SLOPE_12DB) {
                        filter = new Filter(Filter.FilterTypes.HP, this.getSampleRate());
                        break;
                    }
                    if (this.slope != XOverSlope.SLOPE_6DB) break;
                    filter = new Filter(Filter.FilterTypes.HP1, this.getSampleRate());
                    break;
                }
                case LOWSHELF: {
                    if (this.slope == XOverSlope.SLOPE_12DB) {
                        filter = new Filter(Filter.FilterTypes.LS12, this.getSampleRate());
                        break;
                    }
                    if (this.slope != XOverSlope.SLOPE_6DB) break;
                    filter = new Filter(Filter.FilterTypes.LS6, this.getSampleRate());
                    break;
                }
                case HIGHSHELF: {
                    if (this.slope == XOverSlope.SLOPE_12DB) {
                        filter = new Filter(Filter.FilterTypes.HS12, this.getSampleRate());
                        break;
                    }
                    if (this.slope != XOverSlope.SLOPE_6DB) break;
                    filter = new Filter(Filter.FilterTypes.HS6, this.getSampleRate());
                }
            }
            if (filter != null) {
                filter.setFilterFc(this.fc);
                if (filter.getFilterType().hasGain()) {
                    filter.setFilterGain(this.gain);
                }
            }
        }
        return filter;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        boolean bl = false;
        for (PropertyChangeListener propertyChangeListener2 : this.pcs.getPropertyChangeListeners()) {
            if (!propertyChangeListener2.equals(propertyChangeListener)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            this.pcs.addPropertyChangeListener(propertyChangeListener);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(string, propertyChangeListener);
    }

    public void removeAllPropertyChangeListeners() {
        for (PropertyChangeListener propertyChangeListener : this.pcs.getPropertyChangeListeners()) {
            this.pcs.removePropertyChangeListener(propertyChangeListener);
        }
    }

    XOverFilter() {
        this(new Filter[4], 0);
    }

    XOverFilter(Filter[] filterArray, int n2) {
        this.filters = filterArray;
        this.indexOffset = n2;
        this.group = FilterGroup.NONE;
        if (filterArray[n2] == null) {
            for (int i2 = 0; i2 < 4; ++i2) {
                filterArray[n2 + i2] = new Filter();
            }
            this.clearFilter();
        } else {
            if (filterArray[n2].getGroup() == null) {
                XOverFilter.updateToFilterGroup(filterArray[n2]);
            }
            this.group = filterArray[n2].getGroup();
            this.fc = filterArray[n2].getFilterFc();
            this.fc2 = filterArray[n2].getFilterFc2();
            this.shape = filterArray[n2].getShape();
            this.slope = filterArray[n2].getSlope();
            this.slope2 = filterArray[n2].getSlope2();
            this.gain = filterArray[n2].getXOverGain();
            this.q = filterArray[n2].getFilterQ();
            this.t60 = filterArray[n2].getFilterT60Target();
        }
    }

    void clearFilter() {
        this.resetConstituentFilters();
        this.group = FilterGroup.NONE;
        this.gain = 0.0;
        this.filters[this.indexOffset].setXOverGain(this.gain);
        this.shape = XOverShape.BUTTERWORTH;
        this.slope = XOverSlope.SLOPE_12DB;
        this.slope2 = XOverSlope.SLOPE_12DB;
        this.fc = 1000.0;
        this.fc2 = 2000.0;
        this.q = 10.0;
        this.q2 = Filter.HPLP_DEFAULT_Q;
        this.t60 = 0.3;
        this.activeBiquads = 0;
    }

    private void resetConstituentFilters() {
        for (int i2 = 0; i2 < 4; ++i2) {
            this.filters[this.indexOffset + i2].setFilterType(Filter.FilterTypes.NONE);
            this.filters[this.indexOffset + i2].setGroup(FilterGroup.NONE);
            this.filters[this.indexOffset + i2].setXOverIndex(i2);
            if (i2 <= 0) continue;
            this.filters[this.indexOffset + i2].setAutomatic(false);
        }
    }

    static void updateToFilterGroup(Filter filter) {
        if (filter.getGroup() == null) {
            FilterGroup filterGroup = FilterGroup.NONE;
            XOverChoice xOverChoice = filter.getXOverChoice();
            if (xOverChoice != null && xOverChoice != XOverChoice.NONE) {
                filter.setSlope(xOverChoice.getSlope());
                filter.setShape(xOverChoice.getShape());
                XOverType xOverType = filter.getXOverType();
                if (xOverType != null) {
                    if (xOverType == XOverType.LP) {
                        filterGroup = FilterGroup.LOWPASS;
                    } else if (xOverType == XOverType.HP) {
                        filterGroup = FilterGroup.HIGHPASS;
                    }
                }
            } else {
                filter.setSlope(XOverSlope.SLOPE_12DB);
                filter.setShape(XOverShape.BUTTERWORTH);
            }
            filter.setGroup(filterGroup);
            filter.setFilterFc2(2000.0);
            filter.setSlope2(XOverSlope.SLOPE_12DB);
            filter.setXOverGain(0.0);
            filter.setFilterT60Target(0.3);
            filter.setFilterQ(10.0);
        }
    }

    static void updateToFilterGroup(XOverFilter xOverFilter) {
        if (xOverFilter.group == null) {
            Filter filter = xOverFilter.getFilters()[xOverFilter.indexOffset];
            XOverFilter.updateToFilterGroup(filter);
            xOverFilter.slope = filter.getSlope();
            xOverFilter.shape = filter.getShape();
            xOverFilter.group = filter.getGroup();
            xOverFilter.fc2 = filter.getFilterFc2();
            xOverFilter.q2 = filter.getFilterQ2();
            xOverFilter.slope2 = filter.getSlope2();
            xOverFilter.gain = filter.getXOverGain();
            xOverFilter.t60 = filter.getFilterT60Target();
            xOverFilter.q = filter.getFilterQ();
        }
    }

    void copyXOverFilterSettings(Filter filter) {
        this.fc = filter.getFilterFc();
        this.gain = filter.getXOverGain();
        this.q = filter.getFilterQ();
        this.t60 = filter.getFilterT60Target();
        if (filter.getGroup() == null) {
            XOverFilter.updateToFilterGroup(filter);
        }
        this.fc2 = filter.getFilterFc2();
        this.q2 = filter.getFilterQ2();
        this.shape = filter.getShape();
        this.slope = filter.getSlope();
        this.slope2 = filter.getSlope2();
        this.setFilterGroup(filter.getGroup());
        this.setFilterGain(this.gain);
        this.setEnabled(filter.isEnabled());
    }

    static String getDescription(Filter filter) {
        FilterGroup filterGroup = filter.getGroup();
        if (filterGroup != null) {
            String string = filterGroup.toShortString();
            if (filterGroup.hasFreq()) {
                string = string + " " + HE.A(filter.getFilterFc());
            }
            if (filterGroup.hasGain()) {
                string = string + " gain " + HE.K.format(filter.getXOverGain()) + " dB";
            }
            if (filterGroup.isPK() || filterGroup.hasQNonPK()) {
                string = string + " Q " + HE.K.format(filter.getFilterQ());
            }
            if (filterGroup.hasShape()) {
                string = string + " " + filter.getShape().getShortName();
            }
            if (filterGroup.hasSlope()) {
                string = string + " " + filter.getSlope().toString();
            }
            if (filterGroup.hasFreq2()) {
                string = string + " f2 " + HE.A(filter.getFilterFc2());
            }
            if (filterGroup.hasSlope2()) {
                string = string + " " + filter.getSlope2().toString();
            }
            return string;
        }
        if (filter.getXOverChoice() != null) {
            return filter.getXOverChoice().getShortName() + " " + filter.getXOverType().getShortName() + " " + HE.A(filter.getFilterFc());
        }
        return "Unkown compound filter";
    }

    static boolean isXOverFilter(Filter filter) {
        return filter.getGroup() != null || filter.getXOverChoice() != null;
    }

    public Object readResolve() throws ObjectStreamException {
        this.pcs = new SwingPropertyChangeSupport(this);
        if (this.group == null) {
            this.updateToFilterGroup();
        }
        return this;
    }

    void updateToFilterGroup() {
        if (this.group == null) {
            if (this.xOverType == null || this.xOverChoice == XOverChoice.NONE) {
                this.group = FilterGroup.NONE;
            } else {
                switch (this.xOverType) {
                    case LP: {
                        this.group = FilterGroup.LOWPASS;
                        this.xOverType = null;
                        break;
                    }
                    case HP: {
                        this.group = FilterGroup.HIGHPASS;
                        this.xOverType = null;
                        break;
                    }
                    default: {
                        assert (false) : "Unhandled enum type";
                        break;
                    }
                }
                this.shape = this.xOverChoice.getShape();
                this.slope = this.xOverChoice.getSlope();
                this.slope2 = XOverSlope.SLOPE_12DB;
                this.gain = 0.0;
                this.fc2 = 2000.0;
                this.q2 = Filter.HPLP_DEFAULT_Q;
                this.xOverChoice = null;
            }
        }
    }

    public int getActiveBiquads() {
        return this.activeBiquads;
    }

    public int getIndexOffset() {
        return this.indexOffset;
    }

    Filter[] getFilters() {
        return this.filters;
    }

    void setLPHPFilter(FilterGroup filterGroup, XOverShape xOverShape, XOverSlope xOverSlope, double d2) {
        this.group = filterGroup;
        this.shape = xOverShape;
        this.slope = xOverSlope;
        this.fc = d2;
        double[] dArray = null;
        double[] dArray2 = null;
        if (xOverSlope != null && xOverShape != null) {
            switch (xOverShape) {
                case BUTTERWORTH: {
                    dArray = XOverFilter.butterworthQValues(xOverSlope.getOrder());
                    dArray2 = new double[dArray.length];
                    Arrays.fill(dArray2, 1.0);
                    break;
                }
                case BESSEL: {
                    dArray = XOverFilter.besselQValues(xOverSlope.getOrder());
                    dArray2 = XOverFilter.besselFreqFactors(xOverSlope.getOrder());
                    break;
                }
                case LINKWITZ_RILEY: {
                    dArray = XOverFilter.linkwitzRileyQValues(xOverSlope.getOrder());
                    dArray2 = new double[dArray.length];
                    Arrays.fill(dArray2, 1.0);
                    break;
                }
                case NONE: {
                    break;
                }
                default: {
                    assert (false) : "Unhandled enum type";
                    break;
                }
            }
            if (dArray == null) {
                this.clearFilter();
            } else {
                this.configureLPHPFilters(filterGroup, dArray, dArray2, d2);
            }
        }
    }

    void setFilter(XOverFilter xOverFilter) {
        if (xOverFilter.group == null) {
            XOverFilter.updateToFilterGroup(xOverFilter);
        }
        this.shape = xOverFilter.shape;
        this.slope = xOverFilter.slope;
        this.slope2 = xOverFilter.slope2;
        double d2 = xOverFilter.gain;
        this.fc = xOverFilter.fc;
        this.fc2 = xOverFilter.fc2;
        this.q2 = xOverFilter.q2;
        double d3 = xOverFilter.q;
        this.t60 = xOverFilter.t60;
        this.setFilterGroup(xOverFilter.getFilterGroup());
        if (this.group.hasGain()) {
            this.setFilterGain(d2);
        }
        if (this.group.isPK() || this.group.hasQNonPK()) {
            this.setFilterQ(d3);
        }
        this.setAutomatic(xOverFilter.isAutomatic());
        this.setEnabled(xOverFilter.isEnabled());
        this.setAssignedForMatch(xOverFilter.wasAssignedForMatch());
        this.setColor(xOverFilter.getColor());
    }

    boolean isAutomatic() {
        if (this.filter != null) {
            return this.filter.isAutomatic();
        }
        return this.filters[this.indexOffset].isAutomatic();
    }

    boolean showAsAutomatic() {
        if (this.filter != null) {
            return this.filter.showAsAutomatic();
        }
        return this.group.allowsAutomatic() && this.filters[this.indexOffset].showAsAutomatic();
    }

    boolean useForMatch() {
        if (this.filter != null) {
            return this.filter.useForMatch();
        }
        return this.isEnabled() && this.group.allowsAutomatic() && this.filters[this.indexOffset].isAutomatic();
    }

    void setAutomatic(boolean bl) {
        if (this.filter != null) {
            this.filter.setAutomatic(bl);
        } else {
            this.filters[this.indexOffset].setAutomatic(bl);
        }
    }

    void setAssignedForMatch(boolean bl) {
        if (this.filter != null) {
            this.filter.setAssignedForMatch(bl);
        }
    }

    boolean wasAssignedForMatch() {
        if (this.filter != null) {
            return this.filter.wasAssignedForMatch();
        }
        return false;
    }

    @Override
    public double getFilterFc() {
        return this.filter != null ? this.filter.getFilterFc() : this.fc;
    }

    @Override
    public boolean plotFullSpan() {
        switch (this.group) {
            case ASYMMETRIC: {
                return true;
            }
        }
        return false;
    }

    void setFilterFc(double d2) {
        this.fc = d2;
        if (this.filter != null) {
            this.filter.setFilterFc(d2);
        } else {
            switch (this.group) {
                case NONE: {
                    break;
                }
                case LOWPASS: 
                case HIGHPASS: {
                    if (this.shape == null || this.slope == null) break;
                    this.setLPHPFilter(this.group, this.shape, this.slope, this.fc);
                    break;
                }
                case LOWSHELF: {
                    if (this.slope == null) break;
                    this.setLowShelf(this.slope, this.fc, this.gain);
                    break;
                }
                case HIGHSHELF: {
                    if (this.slope == null) break;
                    this.setHighShelf(this.slope, this.fc, this.gain);
                    break;
                }
                case ASYMMETRIC: {
                    if (this.slope == null || this.slope2 == null || this.fc2 == 0.0) break;
                    this.setTwinShelfFilter(this.slope, this.fc, this.slope2, this.fc2, this.gain);
                    break;
                }
                default: {
                    assert (false) : "Unhandled enum type";
                    break;
                }
            }
        }
    }

    double getFilterFc2() {
        return this.filter != null ? this.filter.getFilterFc2() : this.fc2;
    }

    void setFilterFc2(double d2) {
        this.fc2 = d2;
        if (this.filter != null) {
            this.filter.setFilterFc2(d2);
        } else {
            switch (this.group) {
                case ASYMMETRIC: {
                    if (this.slope == null || this.slope2 == null) break;
                    this.setTwinShelfFilter(this.slope, this.fc, this.slope2, this.fc2, this.gain);
                    break;
                }
            }
        }
    }

    @Override
    public double getFilterQ() {
        return this.filter != null ? this.filter.getFilterQ() : this.q;
    }

    void setFilterQ(double d2) {
        this.q = d2;
        if (this.filter != null) {
            this.filter.setFilterQ(d2);
        }
    }

    double getFilterQ2() {
        return this.filter != null ? this.filter.getFilterQ2() : this.q2;
    }

    void setFilterQ2(double d2) {
        this.q2 = d2;
        if (this.filter != null) {
            this.filter.setFilterQ2(d2);
        }
    }

    double getFilterT60Target() {
        return this.filter != null ? this.filter.getFilterT60Target() : this.t60;
    }

    void setFilterT60Target(double d2) {
        this.t60 = d2;
        if (this.filter != null) {
            this.filter.setFilterT60Target(d2);
        }
    }

    @Override
    public double getFilterGain() {
        return this.filter != null ? this.filter.getFilterGain() : this.gain;
    }

    void setFilterGain(double d2) {
        this.gain = d2;
        this.filters[this.indexOffset].setXOverGain(d2);
        if (this.filter != null) {
            this.filter.setFilterGain(d2);
        } else {
            switch (this.group) {
                case NONE: {
                    break;
                }
                case LOWSHELF: {
                    if (this.slope == null) break;
                    this.setLowShelf(this.slope, this.fc, this.gain);
                    break;
                }
                case HIGHSHELF: {
                    if (this.slope == null) break;
                    this.setHighShelf(this.slope, this.fc, this.gain);
                    break;
                }
                case ASYMMETRIC: {
                    if (this.slope == null || this.slope2 == null || this.fc2 == 0.0) break;
                    this.setTwinShelfFilter(this.slope, this.fc, this.slope2, this.fc2, this.gain);
                }
            }
        }
    }

    DA getPoleZero(double d2) {
        return this.filter.getPoleZero(d2);
    }

    private static double[] butterworthQValues(int n2) {
        assert (n2 <= 8) : "BU order not valid: " + n2;
        double[] dArray = new double[(n2 + 1) / 2];
        for (int i2 = 0; i2 < n2 / 2; ++i2) {
            double d2 = (double)(2 * i2 + 1) * Math.PI / (double)(2 * n2);
            dArray[i2] = 0.5 / Math.sin(d2);
        }
        if (n2 % 2 == 1) {
            dArray[n2 / 2] = -0.5;
        }
        return dArray;
    }

    private static double[] linkwitzRileyQValues(int n2) {
        assert (n2 % 2 == 0 && n2 <= 8) : "LR order not valid: " + n2;
        if (n2 > 2) {
            double[] dArray = XOverFilter.butterworthQValues(n2 / 2);
            double[] dArray2 = new double[2 * dArray.length];
            System.arraycopy(dArray, 0, dArray2, 0, dArray.length);
            System.arraycopy(dArray, 0, dArray2, dArray.length, dArray.length);
            return dArray2;
        }
        return new double[]{0.5};
    }

    private static double[] besselQValues(int n2) {
        assert (n2 <= 8) : "BE order not valid: " + n2;
        assert (n2 >= 2) : "BE order not valid: " + n2;
        int n3 = n2 - 2;
        return BesselQValues[n3];
    }

    private static double[] besselFreqFactors(int n2) {
        assert (n2 <= 8) : "BE order not valid: " + n2;
        int n3 = n2 - 2;
        return BesselFreqFactors[n3];
    }

    private void configureLPHPFilters(FilterGroup filterGroup, double[] dArray, double[] dArray2, double d2) {
        int n2;
        assert (dArray.length <= 4) : "Too many filters!";
        this.fc = d2;
        for (n2 = 0; n2 < dArray.length; ++n2) {
            double d3 = dArray[n2];
            Filter.FilterTypes filterTypes = d3 < 0.0 ? this.firstOrderType() : this.secondOrderType();
            this.filters[this.indexOffset + n2].setFilterType(filterTypes);
            double d4 = filterGroup == FilterGroup.LOWPASS ? dArray2[n2] : 1.0 / dArray2[n2];
            this.filters[this.indexOffset + n2].setFilterFc(d2 * d4);
            this.filters[this.indexOffset + n2].setFilterQ(Math.abs(d3));
            this.filters[this.indexOffset + n2].setGroup(filterGroup);
            this.filters[this.indexOffset + n2].setSlope(this.slope);
            this.filters[this.indexOffset + n2].setShape(this.shape);
            this.filters[this.indexOffset + n2].setXOverIndex(n2);
            if (n2 <= 0) continue;
            this.filters[this.indexOffset + n2].setAutomatic(false);
        }
        this.activeBiquads = dArray.length;
        for (n2 = dArray.length; n2 < 4; ++n2) {
            this.filters[this.indexOffset + n2].setFilterType(Filter.FilterTypes.NONE);
            this.filters[this.indexOffset + n2].setGroup(filterGroup);
            this.filters[this.indexOffset + n2].setSlope(this.slope);
            this.filters[this.indexOffset + n2].setShape(this.shape);
            this.filters[this.indexOffset + n2].setXOverIndex(n2);
            this.filters[this.indexOffset + n2].setAutomatic(false);
        }
    }

    Filter.FilterTypes secondOrderType() {
        switch (this.group) {
            case LOWPASS: {
                return Filter.FilterTypes.LPQ;
            }
            case HIGHPASS: {
                return Filter.FilterTypes.HPQ;
            }
        }
        assert (false) : "unhandled group";
        return Filter.FilterTypes.LPQ;
    }

    Filter.FilterTypes firstOrderType() {
        switch (this.group) {
            case LOWPASS: {
                return Filter.FilterTypes.LP1;
            }
            case HIGHPASS: {
                return Filter.FilterTypes.HP1;
            }
        }
        assert (false) : "unhandled group";
        return Filter.FilterTypes.LP1;
    }

    XOverSlope getFilterSlope() {
        return this.slope;
    }

    void setFilterSlope(XOverSlope xOverSlope) {
        this.slope = xOverSlope;
        switch (this.group) {
            case NONE: {
                break;
            }
            case LOWPASS: 
            case HIGHPASS: {
                if (this.shape == null) break;
                this.setLPHPFilter(this.group, this.shape, this.slope, this.fc);
                break;
            }
            case LOWSHELF: {
                this.setLowShelf(this.slope, this.fc, this.gain);
                break;
            }
            case HIGHSHELF: {
                this.setHighShelf(this.slope, this.fc, this.gain);
                break;
            }
            case ASYMMETRIC: {
                if (this.slope2 == null || this.fc2 == 0.0) break;
                this.setTwinShelfFilter(this.slope, this.fc, this.slope2, this.fc2, this.gain);
                break;
            }
        }
    }

    XOverSlope getFilterSlope2() {
        return this.slope2;
    }

    void setFilterSlope2(XOverSlope xOverSlope) {
        this.slope2 = xOverSlope;
        switch (this.group) {
            case NONE: {
                break;
            }
            case ASYMMETRIC: {
                if (this.slope == null || this.fc2 == 0.0) break;
                this.setTwinShelfFilter(this.slope, this.fc, this.slope2, this.fc2, this.gain);
                break;
            }
        }
    }

    XOverShape getFilterShape() {
        return this.shape;
    }

    void setFilterShape(XOverShape xOverShape) {
        this.shape = xOverShape;
        switch (this.group) {
            case NONE: {
                break;
            }
            case LOWPASS: 
            case HIGHPASS: {
                this.setLPHPFilter(this.group, this.shape, this.slope, this.fc);
                break;
            }
        }
    }

    FilterGroup getFilterGroup() {
        return this.group;
    }

    void setFilterGroup(FilterGroup filterGroup) {
        this.group = filterGroup;
        this.filter = null;
        Filter.FilterTypes filterTypes = filterGroup == FilterGroup.NONE ? Filter.FilterTypes.NONE : filterGroup.toFilterType();
        if (filterTypes != null) {
            this.setSingleBiquadFilter(filterTypes);
        } else {
            switch (filterGroup) {
                case NONE: {
                    this.clearFilter();
                    break;
                }
                case LOWPASS: 
                case HIGHPASS: {
                    if (this.slope == null || this.shape == null) break;
                    this.setLPHPFilter(filterGroup, this.shape, this.slope, this.fc);
                    break;
                }
                case LOWSHELF: {
                    if (this.slope == null) break;
                    this.setLowShelf(this.slope, this.fc, this.gain);
                    break;
                }
                case HIGHSHELF: {
                    if (this.slope == null) break;
                    this.setHighShelf(this.slope, this.fc, this.gain);
                    break;
                }
                case ASYMMETRIC: {
                    if (this.slope == null || this.slope2 == null || this.fc2 == 0.0) break;
                    this.setTwinShelfFilter(this.slope, this.fc, this.slope2, this.fc2, this.gain);
                    break;
                }
                default: {
                    System.out.println(filterGroup.name() + " not yet implemented");
                }
            }
        }
    }

    private void setLowShelf(XOverSlope xOverSlope, double d2, double d3) {
        int n2;
        int n3;
        this.group = FilterGroup.LOWSHELF;
        this.fc = d2;
        this.slope = xOverSlope;
        this.gain = d3;
        this.filters[this.indexOffset].setXOverGain(d3);
        this.activeBiquads = 0;
        for (n3 = 0; n3 < 4; ++n3) {
            this.filters[this.indexOffset + n3].setGroup(this.group);
            this.filters[this.indexOffset + n3].setSlope(xOverSlope);
            this.filters[this.indexOffset + n3].setXOverIndex(n3);
            if (n3 <= 0) continue;
            this.filters[this.indexOffset + n3].setAutomatic(false);
        }
        n3 = xOverSlope.getOrder();
        if ((n3 & 1) == 1) {
            this.filters[this.indexOffset].setFilterType(Filter.FilterTypes.LSODD);
            this.filters[this.indexOffset].setShelfParams(d2, d3, n3, 1.0);
            ++this.activeBiquads;
        }
        for (n2 = 1; n2 <= n3 / 2; ++n2) {
            this.filters[this.indexOffset + this.activeBiquads].setFilterType(Filter.FilterTypes.LSEVEN);
            this.filters[this.indexOffset + this.activeBiquads].setShelfParams(d2, d3, n3, n2);
            ++this.activeBiquads;
        }
        if (this.activeBiquads < 4) {
            for (n2 = this.activeBiquads; n2 < 4; ++n2) {
                this.filters[this.indexOffset + n2].setFilterType(Filter.FilterTypes.NONE);
            }
        }
    }

    private void setHighShelf(XOverSlope xOverSlope, double d2, double d3) {
        int n2;
        int n3;
        this.group = FilterGroup.HIGHSHELF;
        this.fc = d2;
        this.slope = xOverSlope;
        this.gain = d3;
        this.filters[this.indexOffset].setXOverGain(d3);
        this.activeBiquads = 0;
        for (n3 = 0; n3 < 4; ++n3) {
            this.filters[this.indexOffset + n3].setGroup(this.group);
            this.filters[this.indexOffset + n3].setSlope(xOverSlope);
            this.filters[this.indexOffset + n3].setXOverIndex(n3);
            if (n3 <= 0) continue;
            this.filters[this.indexOffset + n3].setAutomatic(false);
        }
        n3 = xOverSlope.getOrder();
        if ((n3 & 1) == 1) {
            this.filters[this.indexOffset].setFilterType(Filter.FilterTypes.HSODD);
            this.filters[this.indexOffset].setShelfParams(d2, d3, n3, 1.0);
            ++this.activeBiquads;
        }
        for (n2 = 1; n2 <= n3 / 2; ++n2) {
            this.filters[this.indexOffset + this.activeBiquads].setFilterType(Filter.FilterTypes.HSEVEN);
            this.filters[this.indexOffset + this.activeBiquads].setShelfParams(d2, d3, n3, n2);
            ++this.activeBiquads;
        }
        if (this.activeBiquads < 4) {
            for (n2 = this.activeBiquads; n2 < 4; ++n2) {
                this.filters[this.indexOffset + n2].setFilterType(Filter.FilterTypes.NONE);
            }
        }
    }

    private void setTwinShelfFilter(XOverSlope xOverSlope, double d2, XOverSlope xOverSlope2, double d3, double d4) {
        int n2;
        int n3;
        int n4;
        this.fc = d2;
        this.fc2 = d3;
        this.slope = xOverSlope;
        this.slope2 = xOverSlope2;
        this.gain = d4;
        this.filters[this.indexOffset].setXOverGain(d4);
        this.activeBiquads = 0;
        for (n4 = 0; n4 < 4; ++n4) {
            this.filters[this.indexOffset + n4].setGroup(this.group);
            this.filters[this.indexOffset + n4].setSlope(xOverSlope);
            this.filters[this.indexOffset + n4].setSlope2(xOverSlope2);
            this.filters[this.indexOffset + n4].setShape(this.shape);
            this.filters[this.indexOffset + n4].setXOverIndex(n4);
            if (n4 <= 0) continue;
            this.filters[this.indexOffset + n4].setAutomatic(false);
        }
        n4 = xOverSlope.getOrder();
        if (n4 > 4) {
            throw new IllegalArgumentException("Asymmetric filter cannot have slope greater than 24 dB/octave");
        }
        if ((n4 & 1) == 1) {
            this.filters[this.indexOffset].setFilterType(Filter.FilterTypes.HSODD);
            this.filters[this.indexOffset].setShelfParams(d2, d4, n4, 1.0);
            ++this.activeBiquads;
        }
        for (n3 = 1; n3 <= n4 / 2; ++n3) {
            this.filters[this.indexOffset + this.activeBiquads].setFilterType(Filter.FilterTypes.HSEVEN);
            this.filters[this.indexOffset + this.activeBiquads].setShelfParams(d2, d4, n4, n3);
            ++this.activeBiquads;
        }
        n3 = xOverSlope2.getOrder();
        if (n3 > 4) {
            throw new IllegalArgumentException("Asymmetric filter cannot have slope greater than 24 dB/octave");
        }
        if ((n3 & 1) == 1) {
            this.filters[this.indexOffset + this.activeBiquads].setFilterType(Filter.FilterTypes.HS2ODD);
            this.filters[this.indexOffset + this.activeBiquads].setShelfParams(d3, -d4, n3, 1.0);
            ++this.activeBiquads;
        }
        for (n2 = 1; n2 <= n3 / 2; ++n2) {
            this.filters[this.indexOffset + this.activeBiquads].setFilterType(Filter.FilterTypes.HS2EVEN);
            this.filters[this.indexOffset + this.activeBiquads].setShelfParams(d3, -d4, n3, n2);
            ++this.activeBiquads;
        }
        if (this.activeBiquads < 4) {
            for (n2 = this.activeBiquads; n2 < 4; ++n2) {
                this.filters[this.indexOffset + n2].setFilterType(Filter.FilterTypes.NONE);
            }
        }
    }

    private void setSingleBiquadFilter(Filter.FilterTypes filterTypes) {
        int n2;
        this.resetConstituentFilters();
        this.filters[this.indexOffset].setFilterType(filterTypes);
        for (n2 = 0; n2 < 4; ++n2) {
            this.filters[this.indexOffset + n2].setGroup(this.group);
        }
        this.filter = this.filters[this.indexOffset];
        this.filter.setFilterFc(this.fc);
        this.filter.setFilterGain(this.gain);
        this.filter.setFilterQ(this.q);
        this.filter.setFilterFc2(this.fc2);
        this.filter.setFilterQ2(this.q2);
        this.filter.setFilterT60Target(this.t60);
        this.filter.setAutomatic(this.isAutomatic());
        this.filter.setEnabled(this.isEnabled());
        this.activeBiquads = 1;
        for (n2 = 1; n2 < 4; ++n2) {
            this.filters[this.indexOffset + n2].setFilterType(Filter.FilterTypes.NONE);
            this.filters[this.indexOffset + n2].setAutomatic(false);
        }
    }

    static void sort(XOverFilter[] xOverFilterArray, int n2, int n3, Filter[] filterArray) {
        for (int i2 = n2; i2 < n3; ++i2) {
            for (int i3 = i2; i3 > n2 && xOverFilterArray[i3 - 1].compareTo(xOverFilterArray[i3]) > 0; --i3) {
                XOverFilter.swap(xOverFilterArray, i3, i3 - 1, filterArray);
            }
        }
    }

    private static void swap(XOverFilter[] xOverFilterArray, int n2, int n3, Filter[] filterArray) {
        int n4;
        XOverFilter xOverFilter = xOverFilterArray[n2];
        xOverFilterArray[n2] = xOverFilterArray[n3];
        xOverFilterArray[n3] = xOverFilter;
        int n5 = xOverFilterArray[n2].getIndexOffset();
        int n6 = xOverFilterArray[n3].getIndexOffset();
        assert (n6 % 4 == 0);
        for (n4 = 0; n4 < 4; ++n4) {
            Filter filter = filterArray[n6 + n4];
            filterArray[n6 + n4] = filterArray[n5 + n4];
            filterArray[n5 + n4] = filter;
        }
        n4 = xOverFilterArray[n2].indexOffset;
        xOverFilterArray[n2].indexOffset = xOverFilterArray[n3].indexOffset;
        xOverFilterArray[n3].indexOffset = n4;
        if (xOverFilterArray[n2].filter != null) {
            xOverFilterArray[n2].filter = xOverFilterArray[n2].filters[xOverFilterArray[n2].indexOffset];
        }
        if (xOverFilterArray[n3].filter != null) {
            xOverFilterArray[n3].filter = xOverFilterArray[n3].filters[xOverFilterArray[n3].indexOffset];
        }
    }

    void setSampleRate(double d2) {
        for (int i2 = 0; i2 < 4; ++i2) {
            this.filters[this.indexOffset + i2].setSampleRate(d2);
        }
    }

    @Override
    public int getSampleRate() {
        if (this.filters != null && this.filters[0] != null) {
            return this.filters[0].getSampleRate();
        }
        assert (false);
        return 96000;
    }

    void setEnabled(boolean bl) {
        for (int i2 = 0; i2 < 4; ++i2) {
            this.filters[this.indexOffset + i2].setEnabled(bl);
        }
        this.pcs.firePropertyChange("Filter.enabled", !bl, bl);
    }

    @Override
    public boolean isEnabled() {
        return this.filters[this.indexOffset].isEnabled();
    }

    @Override
    public float getFilterMagnSq(float f2, float f3) {
        float f4 = 1.0f;
        for (int i2 = 0; i2 < 4; ++i2) {
            f4 *= this.filters[this.indexOffset + i2].getFilterMagnSq(f2, f3);
        }
        return f4;
    }

    @Override
    public float getFilterDisabledMagnSq(float f2, float f3) {
        float f4 = 1.0f;
        for (int i2 = 0; i2 < 4; ++i2) {
            f4 *= this.filters[this.indexOffset + i2].getFilterDisabledMagnSq(f2, f3);
        }
        return f4;
    }

    @Override
    public boolean isActive() {
        return this.isEnabled() && this.group != FilterGroup.NONE;
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public void setIndex(int n2) {
        this.index = n2;
    }

    @Override
    public boolean hasGain() {
        return this.group.hasGain();
    }

    @Override
    public boolean hasAdjustableQ() {
        return this.group.hasAdjustableQ();
    }

    @Override
    public boolean isPk() {
        return this.group.isPK();
    }

    void setColor(Color color) {
        this.color = color;
    }

    float dB(float f2) {
        float f3 = this.getFilterMagnSq(f2, 0.0f);
        return (float)(10.0 * Math.log10(Math.max(f3, Float.MIN_VALUE)));
    }

    public int compareTo(Object object) {
        XOverFilter xOverFilter = (XOverFilter)object;
        if (xOverFilter.group == FilterGroup.NONE) {
            return -1;
        }
        if (this.group == FilterGroup.NONE) {
            return 1;
        }
        switch (xOverFilter.group) {
            case PEAKING: 
            case MODAL: {
                if (this.group == FilterGroup.PEAKING || this.group == FilterGroup.MODAL) {
                    switch (Filter.getSortKey()) {
                        case 0: {
                            if (xOverFilter.fc < this.fc) {
                                return Filter.getSortDirn();
                            }
                            if (xOverFilter.fc == this.fc) {
                                return 0;
                            }
                            return -Filter.getSortDirn();
                        }
                        case 2: {
                            if (xOverFilter.q < this.q) {
                                return Filter.getSortDirn();
                            }
                            if (xOverFilter.q == this.q) {
                                return 0;
                            }
                            return -Filter.getSortDirn();
                        }
                        case 3: {
                            if (xOverFilter.fc / xOverFilter.q < this.fc / this.q) {
                                return Filter.getSortDirn();
                            }
                            if (xOverFilter.fc / xOverFilter.q == this.fc / this.q) {
                                return 0;
                            }
                            return -Filter.getSortDirn();
                        }
                        case 4: {
                            if (Math.abs(xOverFilter.gain / xOverFilter.q) < Math.abs(this.gain / this.q)) {
                                return Filter.getSortDirn();
                            }
                            if (Math.abs(xOverFilter.gain / xOverFilter.q) == Math.abs(this.gain / this.q)) {
                                return 0;
                            }
                            return -Filter.getSortDirn();
                        }
                    }
                    if (xOverFilter.gain < this.gain) {
                        return Filter.getSortDirn();
                    }
                    if (xOverFilter.gain == this.gain) {
                        return 0;
                    }
                    return -Filter.getSortDirn();
                }
                switch (Filter.getSortKey()) {
                    case 0: {
                        if (xOverFilter.fc < this.fc) {
                            return Filter.getSortDirn();
                        }
                        if (xOverFilter.fc == this.fc) {
                            return 0;
                        }
                        return -Filter.getSortDirn();
                    }
                    case 1: {
                        if (this.group.hasGain()) {
                            if (xOverFilter.gain < this.gain) {
                                return Filter.getSortDirn();
                            }
                            if (xOverFilter.gain == this.gain) {
                                return 0;
                            }
                            return -Filter.getSortDirn();
                        }
                        return 1;
                    }
                }
                return 1;
            }
        }
        if (this.group == FilterGroup.PEAKING || this.group == FilterGroup.MODAL) {
            switch (Filter.getSortKey()) {
                case 0: {
                    if (xOverFilter.fc < this.fc) {
                        return Filter.getSortDirn();
                    }
                    if (xOverFilter.fc == this.fc) {
                        return 0;
                    }
                    return -Filter.getSortDirn();
                }
                case 1: {
                    if (xOverFilter.group.hasGain()) {
                        if (xOverFilter.gain < this.gain) {
                            return Filter.getSortDirn();
                        }
                        if (xOverFilter.gain == this.gain) {
                            return 0;
                        }
                        return -Filter.getSortDirn();
                    }
                    return -1;
                }
                case 2: {
                    if (xOverFilter.group.isPK() || this.group.hasQNonPK()) {
                        if (xOverFilter.q < this.q) {
                            return Filter.getSortDirn();
                        }
                        if (xOverFilter.q == this.q) {
                            return 0;
                        }
                        return -Filter.getSortDirn();
                    }
                    return -1;
                }
            }
            return -1;
        }
        switch (Filter.getSortKey()) {
            case 1: {
                if (xOverFilter.group.hasGain() && this.group.hasGain()) {
                    if (xOverFilter.gain < this.gain) {
                        return Filter.getSortDirn();
                    }
                    if (xOverFilter.gain == this.gain) {
                        return 0;
                    }
                    return -Filter.getSortDirn();
                }
                if (xOverFilter.group.hasGain()) {
                    return 1;
                }
                if (xOverFilter.fc < this.fc) {
                    return Filter.getSortDirn();
                }
                if (xOverFilter.fc == this.fc) {
                    return 0;
                }
                return -Filter.getSortDirn();
            }
            case 2: {
                if ((xOverFilter.group.isPK() || xOverFilter.group.hasQNonPK()) && (this.group.isPK() || this.group.hasQNonPK())) {
                    if (xOverFilter.q < this.q) {
                        return Filter.getSortDirn();
                    }
                    if (xOverFilter.q == this.q) {
                        return 0;
                    }
                    return -Filter.getSortDirn();
                }
                if (xOverFilter.group.isPK() || xOverFilter.group.hasQNonPK()) {
                    return 1;
                }
                if (xOverFilter.fc < this.fc) {
                    return Filter.getSortDirn();
                }
                if (xOverFilter.fc == this.fc) {
                    return 0;
                }
                return -Filter.getSortDirn();
            }
        }
        if (xOverFilter.fc < this.fc) {
            return Filter.getSortDirn();
        }
        if (xOverFilter.fc == this.fc) {
            return 0;
        }
        return -Filter.getSortDirn();
    }

    boolean hasNoEffect() {
        if (!this.isEnabled() || this.group == FilterGroup.NONE) {
            return true;
        }
        Filter.FilterTypes filterTypes = this.group.toFilterType();
        if (filterTypes != null && this.filter != null) {
            return this.filter.hasNoEffect();
        }
        switch (this.group) {
            case LOWSHELF: 
            case HIGHSHELF: 
            case ASYMMETRIC: 
            case PEAKING: 
            case MODAL: {
                return this.gain != 0.0;
            }
        }
        return false;
    }

    private String format(double d2, int n2) {
        switch (n2) {
            case 3: {
                return HE.B.format(d2);
            }
            case 2: {
                return HE.L.format(d2);
            }
            case 1: {
                return HE.T.format(d2);
            }
            case 0: {
                return HE.H.format(d2);
            }
        }
        return HE.L.format(d2);
    }

    public ArrayList<String> toStringTokens(Equaliser equaliser) {
        String string;
        ArrayList<String> arrayList = new ArrayList<String>();
        Filter.FilterTypes filterTypes = this.group.toFilterType();
        if (filterTypes != null && this.filter != null) {
            return this.filter.toStringTokens(equaliser);
        }
        arrayList.add(this.showAsAutomatic() ? "Auto" : "Manual");
        String string2 = this.group.toShortString();
        arrayList.add(string2);
        if (this.group.hasFreq()) {
            string = this.format(this.fc, equaliser.getMaxFreqDP());
            arrayList.add(string);
        }
        switch (this.group) {
            case LOWPASS: 
            case HIGHPASS: {
                arrayList.add("");
                arrayList.add("");
                arrayList.add("");
                arrayList.add("");
                arrayList.add(this.shape.getShortName());
                arrayList.add("" + this.slope.getSlopedB());
                break;
            }
            case LOWSHELF: 
            case HIGHSHELF: {
                arrayList.add(HE.L.format(this.gain));
                arrayList.add("");
                arrayList.add("");
                arrayList.add("");
                arrayList.add("");
                arrayList.add("" + this.slope.getSlopedB());
                break;
            }
            case ASYMMETRIC: {
                arrayList.add(HE.L.format(this.gain));
                arrayList.add("");
                arrayList.add("");
                arrayList.add("");
                arrayList.add("");
                arrayList.add("" + this.slope.getSlopedB());
                string = this.format(this.fc2, equaliser.getMaxFreqDP());
                arrayList.add(string);
                arrayList.add("");
                arrayList.add("" + this.slope2.getSlopedB());
                break;
            }
            case LSQ: 
            case HSQ: {
                arrayList.add(this.format(this.gain, equaliser.getMaxGainDP()));
                arrayList.add(this.format(this.q, equaliser.getMaxQNonPKDP()));
                break;
            }
            case LINKWITZT: {
                arrayList.add("");
                arrayList.add(this.format(this.q, equaliser.getMaxQNonPKDP()));
                arrayList.add("");
                arrayList.add("");
                arrayList.add("");
                arrayList.add("");
                string = this.format(this.fc2, equaliser.getMaxFreqDP());
                arrayList.add(string);
                arrayList.add(this.format(this.q2, equaliser.getMaxQNonPKDP()));
            }
        }
        return arrayList;
    }

    public ArrayList<String> toStringTokens() {
        String string;
        ArrayList<String> arrayList = new ArrayList<String>();
        Filter.FilterTypes filterTypes = this.group.toFilterType();
        if (filterTypes != null && this.filter != null) {
            return this.filter.toStringTokens();
        }
        arrayList.add(this.showAsAutomatic() ? "Auto" : "Manual");
        String string2 = this.group.toShortString();
        arrayList.add(string2);
        if (this.group.hasFreq()) {
            string = this.fc < 99.995 ? HE.L.format(this.fc) : (this.fc < 999.95 ? HE.T.format(this.fc) : HE.H.format(this.fc));
            arrayList.add(string);
        }
        switch (this.group) {
            case LOWPASS: 
            case HIGHPASS: {
                arrayList.add("");
                arrayList.add("");
                arrayList.add("");
                arrayList.add("");
                arrayList.add(this.shape.getShortName());
                arrayList.add("" + this.slope.getSlopedB());
                break;
            }
            case LOWSHELF: 
            case HIGHSHELF: {
                arrayList.add(HE.L.format(this.gain));
                arrayList.add("");
                arrayList.add("");
                arrayList.add("");
                arrayList.add("");
                arrayList.add("" + this.slope.getSlopedB());
                break;
            }
            case ASYMMETRIC: {
                arrayList.add(HE.L.format(this.gain));
                arrayList.add("");
                arrayList.add("");
                arrayList.add("");
                arrayList.add("");
                arrayList.add("" + this.slope.getSlopedB());
                string = HE.H.format(this.fc2);
                arrayList.add(string);
                arrayList.add("");
                arrayList.add("" + this.slope2.getSlopedB());
                break;
            }
            case LSQ: 
            case HSQ: {
                arrayList.add(HE.L.format(this.gain));
                arrayList.add(Filter.filterQFormat(this.q));
                break;
            }
            case LINKWITZT: {
                arrayList.add("");
                arrayList.add(HE.L.format(this.q));
                arrayList.add("");
                arrayList.add("");
                arrayList.add("");
                arrayList.add("");
                string = HE.H.format(this.fc2);
                arrayList.add(string);
                arrayList.add(HE.L.format(this.q2));
            }
        }
        return arrayList;
    }

    public String toFormattedString(Equaliser equaliser) {
        String string;
        Filter.FilterTypes filterTypes = this.group.toFilterType();
        if (filterTypes != null && this.filter != null) {
            return this.filter.toFormattedString(equaliser);
        }
        if (this.group.equals((Object)FilterGroup.NONE)) {
            return this.group.toFixedWidthSt();
        }
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = this.group.toFixedWidthSt();
        if (this.group.hasFreq()) {
            stringBuilder.append(string2).append("  Fc ");
            string = this.paddedFC(this.fc, equaliser);
            stringBuilder.append(string).append(" Hz ");
        }
        switch (this.group) {
            case LOWPASS: 
            case HIGHPASS: {
                stringBuilder.append(" Shape ");
                stringBuilder.append(this.shape.getShortName()).append(" ");
                stringBuilder.append(" Slope ").append(this.paddedSlopedB(this.slope)).append(" dB/oct ");
                break;
            }
            case LOWSHELF: 
            case HIGHSHELF: {
                stringBuilder.append(" Gain ");
                stringBuilder.append(this.paddedGain(equaliser)).append(" dB");
                stringBuilder.append("          ");
                stringBuilder.append(" Slope ").append(this.paddedSlopedB(this.slope)).append(" dB/oct ");
                break;
            }
            case ASYMMETRIC: {
                stringBuilder.append(" Gain ");
                stringBuilder.append(this.paddedGain(equaliser)).append(" dB");
                stringBuilder.append("          ");
                stringBuilder.append(" Slope ").append(this.paddedSlopedB(this.slope)).append(" dB/oct ");
                stringBuilder.append(string2).append(" Fc2 ");
                string = this.paddedFC(this.fc2, equaliser);
                stringBuilder.append(string).append(" Hz ");
                stringBuilder.append(" Slope2 ").append(this.paddedSlopedB(this.slope2)).append(" dB/oct ");
                break;
            }
            default: {
                assert (false) : "unhandled filter type: " + (Object)((Object)this.group);
                break;
            }
        }
        return stringBuilder.toString();
    }

    public String toFormattedString() {
        String string;
        Filter.FilterTypes filterTypes = this.group.toFilterType();
        if (filterTypes != null && this.filter != null) {
            return this.filter.toFormattedString();
        }
        if (this.group.equals((Object)FilterGroup.NONE)) {
            return this.group.toFixedWidthSt();
        }
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = this.group.toFixedWidthSt();
        if (this.group.hasFreq()) {
            stringBuilder.append(string2).append("  Fc ");
            string = this.fc < 99.995 ? this.paddedFC2dp(this.fc) : (this.fc < 999.95 ? this.paddedFC1dp(this.fc) : this.paddedFC(this.fc));
            stringBuilder.append(string).append(" Hz ");
        }
        switch (this.group) {
            case LOWPASS: 
            case HIGHPASS: {
                stringBuilder.append(" Shape ");
                stringBuilder.append(this.shape.getShortName()).append(" ");
                stringBuilder.append(" Slope ").append(this.paddedSlopedB(this.slope)).append(" dB/oct ");
                break;
            }
            case LOWSHELF: 
            case HIGHSHELF: {
                stringBuilder.append(" Gain ");
                stringBuilder.append(this.paddedGain()).append(" dB");
                stringBuilder.append("          ");
                stringBuilder.append(" Slope ").append(this.paddedSlopedB(this.slope)).append(" dB/oct ");
                break;
            }
            case ASYMMETRIC: {
                stringBuilder.append(" Gain ");
                stringBuilder.append(this.paddedGain()).append(" dB");
                stringBuilder.append("          ");
                stringBuilder.append(" Slope ").append(this.paddedSlopedB(this.slope)).append(" dB/oct ");
                stringBuilder.append(string2).append(" Fc2 ");
                string = this.fc2 < 99.995 ? this.paddedFC2dp(this.fc2) : (this.fc2 < 999.95 ? this.paddedFC1dp(this.fc2) : this.paddedFC(this.fc2));
                stringBuilder.append(string).append(" Hz ");
                stringBuilder.append(" Slope2 ").append(this.paddedSlopedB(this.slope2)).append(" dB/oct ");
                break;
            }
            default: {
                assert (false) : "unhandled filter type: " + (Object)((Object)this.group);
                break;
            }
        }
        return stringBuilder.toString();
    }

    String paddedSlopedB(XOverSlope xOverSlope) {
        int n2 = xOverSlope.getSlopedB();
        if (n2 == 6) {
            return " " + n2;
        }
        return "" + n2;
    }

    String paddedGain() {
        String string = HE.L.format(this.gain);
        switch (string.length()) {
            case 3: {
                return "   " + string;
            }
            case 4: {
                return "  " + string;
            }
            case 5: {
                return " " + string;
            }
        }
        return string;
    }

    String paddedGain(Equaliser equaliser) {
        String string = this.format(this.gain, equaliser.getMaxGainDP());
        switch (string.length()) {
            case 3: {
                return "   " + string;
            }
            case 4: {
                return "  " + string;
            }
            case 5: {
                return " " + string;
            }
        }
        return string;
    }

    String paddedFC(double d2, Equaliser equaliser) {
        String string = this.format(d2, equaliser.getMaxFreqDP());
        switch (string.length()) {
            case 2: {
                return "     " + string;
            }
            case 3: {
                return "    " + string;
            }
            case 4: {
                return "   " + string;
            }
            case 5: {
                return "  " + string;
            }
            case 6: {
                return " " + string;
            }
        }
        return string;
    }

    String paddedFC(double d2) {
        String string = HE.H.format(d2);
        switch (string.length()) {
            case 2: {
                return "     " + string;
            }
            case 3: {
                return "    " + string;
            }
            case 4: {
                return "   " + string;
            }
            case 5: {
                return "  " + string;
            }
            case 6: {
                return " " + string;
            }
        }
        return string;
    }

    String paddedFC1dp(double d2) {
        String string = HE.T.format(d2);
        switch (string.length()) {
            case 4: {
                return "   " + string;
            }
            case 5: {
                return "  " + string;
            }
            case 6: {
                return " " + string;
            }
        }
        return string;
    }

    String paddedFC2dp(double d2) {
        String string = HE.L.format(d2);
        switch (string.length()) {
            case 3: {
                return "    " + string;
            }
            case 4: {
                return "   " + string;
            }
            case 5: {
                return "  " + string;
            }
            case 6: {
                return " " + string;
            }
        }
        return string;
    }

    public String toString() {
        String string;
        Filter.FilterTypes filterTypes = this.group.toFilterType();
        if (filterTypes != null && this.filter != null) {
            return this.filter.toString();
        }
        if (this.group.equals((Object)FilterGroup.NONE)) {
            return this.group.toString();
        }
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = this.group.toString();
        if (this.group.hasFreq()) {
            stringBuilder.append(string2).append(" Fc ");
            string = this.fc < 99.995 ? HE.L.format(this.fc) : (this.fc < 999.95 ? HE.T.format(this.fc) : HE.H.format(this.fc));
            stringBuilder.append(string).append(" Hz ");
        }
        switch (this.group) {
            case LOWPASS: 
            case HIGHPASS: {
                stringBuilder.append("Shape ");
                stringBuilder.append(this.shape.getShortName()).append(" ");
                stringBuilder.append("Slope ").append(this.slope.getSlopedB()).append(" dB/oct ");
                break;
            }
            case LOWSHELF: 
            case HIGHSHELF: {
                stringBuilder.append("Gain ");
                stringBuilder.append(HE.L.format(this.gain)).append(" dB ");
                stringBuilder.append("Slope ").append(this.slope.getSlopedB()).append(" dB/oct ");
                break;
            }
            case ASYMMETRIC: {
                stringBuilder.append("Gain ");
                stringBuilder.append(HE.L.format(this.gain)).append(" dB ");
                stringBuilder.append("Slope ").append(this.slope.getSlopedB()).append(" dB/oct ");
                stringBuilder.append(string2).append(" Fc2 ");
                string = this.fc2 < 99.995 ? HE.L.format(this.fc2) : (this.fc2 < 999.95 ? HE.T.format(this.fc2) : HE.H.format(this.fc2));
                stringBuilder.append(string).append(" Hz ");
                stringBuilder.append("Slope2 ").append(this.slope2.getSlopedB()).append(" dB/oct ");
                break;
            }
            default: {
                assert (false) : "unhandled filter type: " + (Object)((Object)this.group);
                break;
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public void setHighlighted(boolean bl) {
        this.highlighted = bl;
    }

    @Override
    public boolean isHighlighted() {
        return this.highlighted;
    }
}

