/*
 * Decompiled with CFR 0.152.
 */
package roomeqwizard;

import roomeqwizard.XOverShape;
import roomeqwizard.XOverSlope;

public final class XOverChoice
extends Enum<XOverChoice> {
    public static final /* enum */ XOverChoice NONE = new XOverChoice(XOverShape.NONE, 0);
    public static final /* enum */ XOverChoice BE2 = new XOverChoice(XOverShape.BESSEL, 2);
    public static final /* enum */ XOverChoice BE3 = new XOverChoice(XOverShape.BESSEL, 3);
    public static final /* enum */ XOverChoice BE4 = new XOverChoice(XOverShape.BESSEL, 4);
    public static final /* enum */ XOverChoice BE5 = new XOverChoice(XOverShape.BESSEL, 5);
    public static final /* enum */ XOverChoice BE6 = new XOverChoice(XOverShape.BESSEL, 6);
    public static final /* enum */ XOverChoice BE7 = new XOverChoice(XOverShape.BESSEL, 7);
    public static final /* enum */ XOverChoice BE8 = new XOverChoice(XOverShape.BESSEL, 8);
    public static final /* enum */ XOverChoice BU1 = new XOverChoice(XOverShape.BUTTERWORTH, 1);
    public static final /* enum */ XOverChoice BU2 = new XOverChoice(XOverShape.BUTTERWORTH, 2);
    public static final /* enum */ XOverChoice BU3 = new XOverChoice(XOverShape.BUTTERWORTH, 3);
    public static final /* enum */ XOverChoice BU4 = new XOverChoice(XOverShape.BUTTERWORTH, 4);
    public static final /* enum */ XOverChoice BU5 = new XOverChoice(XOverShape.BUTTERWORTH, 5);
    public static final /* enum */ XOverChoice BU6 = new XOverChoice(XOverShape.BUTTERWORTH, 6);
    public static final /* enum */ XOverChoice BU7 = new XOverChoice(XOverShape.BUTTERWORTH, 7);
    public static final /* enum */ XOverChoice BU8 = new XOverChoice(XOverShape.BUTTERWORTH, 8);
    public static final /* enum */ XOverChoice LR2 = new XOverChoice(XOverShape.LINKWITZ_RILEY, 2);
    public static final /* enum */ XOverChoice LR4 = new XOverChoice(XOverShape.LINKWITZ_RILEY, 4);
    public static final /* enum */ XOverChoice LR6 = new XOverChoice(XOverShape.LINKWITZ_RILEY, 6);
    public static final /* enum */ XOverChoice LR8 = new XOverChoice(XOverShape.LINKWITZ_RILEY, 8);
    public static final /* enum */ XOverChoice BRICKWALL = new XOverChoice(XOverShape.BRICKWALL, 0);
    private final XOverShape shape;
    private final int order;
    private static final /* synthetic */ XOverChoice[] $VALUES;

    public static XOverChoice[] values() {
        return (XOverChoice[])$VALUES.clone();
    }

    public static XOverChoice valueOf(String string) {
        return Enum.valueOf(XOverChoice.class, string);
    }

    private XOverChoice(XOverShape xOverShape, int n3) {
        this.shape = xOverShape;
        this.order = n3;
    }

    public XOverShape getShape() {
        return this.shape;
    }

    public XOverSlope getSlope() {
        switch (this.order) {
            case 0: {
                return XOverSlope.SLOPE_12DB;
            }
            case 1: {
                return XOverSlope.SLOPE_6DB;
            }
            case 2: {
                return XOverSlope.SLOPE_12DB;
            }
            case 3: {
                return XOverSlope.SLOPE_18DB;
            }
            case 4: {
                return XOverSlope.SLOPE_24DB;
            }
            case 5: {
                return XOverSlope.SLOPE_30DB;
            }
            case 6: {
                return XOverSlope.SLOPE_36DB;
            }
            case 7: {
                return XOverSlope.SLOPE_42DB;
            }
            case 8: {
                return XOverSlope.SLOPE_48DB;
            }
        }
        assert (false) : "Unhandled order " + this.order;
        return XOverSlope.SLOPE_12DB;
    }

    public int getOrder() {
        return this.order;
    }

    public String getShortName() {
        String string = this.shape.getShortName();
        if (this.order > 0) {
            string = string + this.order;
        }
        return string;
    }

    public String apiName() {
        return this.getShortName();
    }

    public String getLongName() {
        String string = this.shape.getLongName();
        if (this.order > 0) {
            string = string + " " + this.order * 6 + " dB/octave";
        }
        return string;
    }

    public int biquadsReqd() {
        if (this.order > 0) {
            return (this.order + 1) / 2;
        }
        return 1;
    }

    public String toString() {
        return this.getShortName();
    }

    public static XOverChoice getChoice(XOverShape xOverShape, XOverSlope xOverSlope) {
        int n2 = xOverSlope.getOrder();
        for (XOverChoice xOverChoice : XOverChoice.values()) {
            if (xOverChoice.shape != xOverShape || xOverChoice.order != n2) continue;
            return xOverChoice;
        }
        assert (false) : "Failed to find choice for " + (Object)((Object)xOverShape) + " and " + n2;
        return NONE;
    }

    public static XOverChoice getEnum(String string) {
        for (XOverChoice xOverChoice : XOverChoice.values()) {
            if (!xOverChoice.name().equalsIgnoreCase(string)) continue;
            return xOverChoice;
        }
        return LR2;
    }

    public static XOverChoice getFromApiName(String string) {
        for (XOverChoice xOverChoice : XOverChoice.values()) {
            if (!xOverChoice.apiName().equalsIgnoreCase(string)) continue;
            return xOverChoice;
        }
        return null;
    }

    public static XOverChoice[] nonBrickWallSet() {
        XOverChoice[] xOverChoiceArray = XOverChoice.values();
        XOverChoice[] xOverChoiceArray2 = new XOverChoice[xOverChoiceArray.length - 1];
        System.arraycopy(xOverChoiceArray, 0, xOverChoiceArray2, 0, xOverChoiceArray2.length);
        return xOverChoiceArray2;
    }

    static {
        $VALUES = new XOverChoice[]{NONE, BE2, BE3, BE4, BE5, BE6, BE7, BE8, BU1, BU2, BU3, BU4, BU5, BU6, BU7, BU8, LR2, LR4, LR6, LR8, BRICKWALL};
    }
}

