/*
 * Decompiled with CFR 0.152.
 */
package roomeqwizard;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.text.DateFormat;
import java.util.Date;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import org.jdesktop.swingx.util.OS;
import roomeqwizard.RoomEQ_Wizard;

public class WizardLogger {
    private static WizardLogger instance;
    private static final Logger logger;
    private static String rewLogFolder;

    WizardLogger() {
        try {
            Logger.getLogger("").setLevel(Level.INFO);
            File file = new File(rewLogFolder);
            if (!file.exists()) {
                file.mkdir();
            }
            FileHandler fileHandler = new FileHandler(WizardLogger.getLogFilesPath(), 100000, WizardLogger.getLogRotationCount());
            fileHandler.setFormatter(new SimpleFormatter());
            Logger.getLogger("").addHandler(fileHandler);
            if (!RoomEQ_Wizard.l()) {
                File file2 = new File(WizardLogger.getOutputFilePath());
                boolean bl = true;
                if (file2.exists() && file2.length() > 1000000L) {
                    bl = false;
                }
                PrintStream printStream = new PrintStream(new FileOutputStream(file2, bl));
                System.setErr(printStream);
                System.setOut(printStream);
            }
            System.out.println("");
            System.out.print("REW V" + RoomEQ_Wizard.j() + " startup on ");
            System.out.println(DateFormat.getDateTimeInstance().format(new Date(System.currentTimeMillis())) + " " + RoomEQ_Wizard.x());
        }
        catch (IOException iOException) {
            logger.log(Level.SEVERE, "Cannot create log file handler " + iOException, iOException);
        }
        logger.setLevel(Level.INFO);
    }

    public static Logger getLogger() {
        if (instance == null) {
            instance = new WizardLogger();
        }
        return logger;
    }

    static String getRewLogFolder() {
        return rewLogFolder;
    }

    static String getOutputFilePath() {
        return rewLogFolder + File.separator + "rew_output.txt";
    }

    static String getLogFilesPath() {
        return rewLogFolder + File.separator + "roomeq_wizard%g.log.txt";
    }

    static final int getLogRotationCount() {
        return 10;
    }

    static {
        logger = Logger.getLogger("roomeq_wizard");
        rewLogFolder = System.getProperty("user.home") + (OS.isMacOSX() ? "/Library/logs" : "") + File.separator + "REW";
    }
}

