/*
 * Decompiled with CFR 0.152.
 */
package roomeqwizard;

import java.io.ObjectStreamException;
import java.io.Serializable;
import roomeqwizard.HE;
import roomeqwizard.SampledData;
import roomeqwizard.Window;

public class WindowSettings
implements Serializable {
    static final long serialVersionUID = 1L;
    static Window.Types preWindowTypeDefault = Window.Types.TUKEY;
    static Window.Types postWindowTypeDefault = Window.Types.TUKEY;
    static final double POST_IMPULSE_DURN_DEFAULT = 0.5;
    static final double PRE_IMPULSE_DURN_DEFAULT = 0.125;
    @Deprecated
    private Window postWindow;
    @Deprecated
    private Window preWindow;
    private double winRefTime;
    private int winRefIndex;
    private double preImpulseDurn;
    private double postImpulseDurn;
    private int preImpulseIndex;
    private int postImpulseIndex;
    private double T;
    private double startTime;
    private int n;
    private Window.Types postType;
    private Window.Types preType;
    private int preLength;
    private int postLength;

    public Object readResolve() throws ObjectStreamException {
        if (this.preType == null && this.preWindow != null) {
            this.preType = this.preWindow.type;
            this.preLength = this.preWindow.n;
            this.preWindow = null;
        }
        if (this.postType == null && this.postWindow != null) {
            this.postType = this.postWindow.type;
            this.postLength = this.postWindow.n;
            this.postWindow = null;
        }
        return this;
    }

    WindowSettings() {
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Left window: ").append(this.preType.toString()).append(" ").append(HE.I(this.getPreImpulseDurn())).append("s");
        stringBuilder.append(", right window: ").append(this.postType.toString()).append(" ").append(HE.I(this.getPostImpulseDurn())).append("s");
        stringBuilder.append(", ref time: ").append(HE.I(this.getWinRefTime())).append("s");
        return stringBuilder.toString();
    }

    public WindowSettings(SampledData sampledData, Window.Types types, double d2, Window.Types types2, double d3, double d4) {
        this.n = sampledData.getN();
        this.T = sampledData.getT();
        this.startTime = sampledData.getStartTime();
        if (d4 < this.startTime) {
            d4 = this.startTime;
        } else if (d4 > this.startTime + (double)(this.n - 1) * this.T) {
            d4 = this.startTime + (double)(this.n - 1) * this.T;
        }
        this.winRefTime = d4;
        this.winRefIndex = (int)Math.max(Math.min(Math.round((this.winRefTime - this.startTime) / this.T), (long)(this.n - 1)), 0L);
        this.postImpulseIndex = (int)Math.min((long)this.winRefIndex + Math.round(d3 / this.T), (long)(this.n - 1));
        this.postImpulseDurn = this.T * (double)(this.postImpulseIndex - this.winRefIndex);
        this.preImpulseIndex = (int)Math.max((long)this.winRefIndex - Math.round(d2 / this.T), 0L);
        this.preImpulseDurn = this.T * (double)(this.winRefIndex - this.preImpulseIndex);
        this.preType = types;
        this.postType = types2;
        this.preLength = Math.max(this.winRefIndex - this.preImpulseIndex + 1, (int)Math.round(d2 / this.T) + 1);
        this.postLength = this.postImpulseIndex - this.winRefIndex + 1;
    }

    public WindowSettings copy() {
        WindowSettings windowSettings = new WindowSettings();
        windowSettings.winRefTime = this.winRefTime;
        windowSettings.winRefIndex = this.winRefIndex;
        windowSettings.preType = this.preType;
        windowSettings.preLength = this.preLength;
        windowSettings.postType = this.postType;
        windowSettings.postLength = this.postLength;
        windowSettings.preImpulseDurn = this.preImpulseDurn;
        windowSettings.postImpulseDurn = this.postImpulseDurn;
        windowSettings.preImpulseIndex = this.preImpulseIndex;
        windowSettings.postImpulseIndex = this.postImpulseIndex;
        windowSettings.n = this.n;
        windowSettings.T = this.T;
        windowSettings.startTime = this.startTime;
        return windowSettings;
    }

    double windowAmpl(double d2) {
        if (d2 < Math.floor((this.winRefTime - this.preImpulseDurn) / this.T) * this.T || d2 > Math.ceil((this.winRefTime + this.postImpulseDurn) / this.T) * this.T) {
            return 0.0;
        }
        int n2 = (int)Math.max(Math.floor((d2 - this.startTime) / this.T), 0.0);
        double d3 = (d2 - this.startTime) / this.T - (double)n2;
        int n3 = n2 - this.winRefIndex;
        if (n3 < 0) {
            int n4 = this.preLength - 1 + n3;
            if (n4 >= 0) {
                return this.preType.leftWindowVal(((double)n4 + d3) / (double)(this.preLength - 1));
            }
            return 0.0;
        }
        if (n3 <= this.postLength - 1) {
            return this.postType.rightWindowVal(((double)n3 + d3) / (double)(this.postLength - 1));
        }
        return 0.0;
    }

    double windowAmpl(int n2) {
        if (n2 < this.preImpulseIndex || n2 > this.postImpulseIndex) {
            return 0.0;
        }
        if (n2 < this.winRefIndex) {
            return this.preType.leftWindowVal((double)(this.preLength - 1 + n2 - this.winRefIndex) / (double)(this.preLength - 1));
        }
        return this.postType.rightWindowVal((double)(n2 - this.winRefIndex) / (double)(this.postLength - 1));
    }

    float[] apply(float[] fArray) {
        int n2;
        int n3 = this.getWindowedSpan();
        float[] fArray2 = new float[n3];
        for (n2 = this.preImpulseIndex; n2 < this.winRefIndex; ++n2) {
            fArray2[n2 - this.preImpulseIndex] = fArray[n2] * (float)this.preType.leftWindowVal((double)(this.preLength - 1 + n2 - this.winRefIndex) / (double)(this.preLength - 1));
        }
        for (n2 = this.winRefIndex; n2 <= this.postImpulseIndex; ++n2) {
            fArray2[n2 - this.preImpulseIndex] = fArray[n2] * (float)this.postType.rightWindowVal((double)(n2 - this.winRefIndex) / (double)(this.postLength - 1));
        }
        return fArray2;
    }

    double windowedData(float[] fArray, int n2) {
        if (n2 < this.preImpulseIndex || n2 > this.postImpulseIndex) {
            return 0.0;
        }
        if (n2 < this.winRefIndex) {
            return (double)fArray[n2] * this.preType.leftWindowVal((double)(this.preLength - 1 + n2 - this.winRefIndex) / (double)(this.preLength - 1));
        }
        return (double)fArray[n2] * this.postType.rightWindowVal((double)(n2 - this.winRefIndex) / (double)(this.postLength - 1));
    }

    public int getWinRefIndex() {
        return this.winRefIndex;
    }

    public double getWinRefTime() {
        return this.winRefTime;
    }

    public double getWinRefIndexTime() {
        return (double)this.winRefIndex * this.T + this.startTime;
    }

    public boolean isValidRef(double d2) {
        return d2 >= this.startTime && d2 <= this.startTime + this.T * (double)(this.n - 1);
    }

    public double getStartTime() {
        return this.startTime;
    }

    public double getEndTime() {
        return this.startTime + this.T * (double)(this.n - 1);
    }

    public void setWinRefTime(double d2) {
        if (d2 < this.startTime) {
            d2 = this.startTime;
        }
        if (d2 > this.startTime + this.T * (double)(this.n - 1)) {
            d2 = this.startTime + this.T * (double)(this.n - 1);
        }
        this.winRefTime = d2;
        this.winRefIndex = (int)Math.max(Math.min(Math.round((this.winRefTime - this.startTime) / this.T), (long)(this.n - 1)), 0L);
        this.setPreWindowDurn(this.preImpulseDurn);
        this.setPostWindowDurn(this.postImpulseDurn);
    }

    public void setPreWindowDurn(double d2) {
        this.preImpulseIndex = (int)Math.max((long)this.winRefIndex - Math.round(d2 / this.T), 0L);
        this.preImpulseDurn = this.T * (double)(this.winRefIndex - this.preImpulseIndex);
        this.preLength = Math.max(this.winRefIndex - this.preImpulseIndex + 1, (int)Math.round(this.preImpulseDurn / this.T) + 1);
    }

    public void setPostWindowDurn(double d2) {
        this.postImpulseIndex = (int)Math.min((long)this.winRefIndex + Math.round(d2 / this.T), (long)(this.n - 1));
        this.postImpulseDurn = this.T * (double)(this.postImpulseIndex - this.winRefIndex);
        this.postLength = this.postImpulseIndex - this.winRefIndex + 1;
    }

    public double getPreImpulseDurn() {
        return this.preImpulseDurn;
    }

    public double getPostImpulseDurn() {
        return this.postImpulseDurn;
    }

    public int getPreImpulseIndex() {
        return this.preImpulseIndex;
    }

    public int getPostImpulseIndex() {
        return this.postImpulseIndex;
    }

    public int getPreLength() {
        return this.preLength;
    }

    public int getPostLength() {
        return this.postLength;
    }

    public int getWindowedSpan() {
        return this.postImpulseIndex - this.preImpulseIndex + 1;
    }

    public double getWindowedDurn() {
        return this.postImpulseDurn + this.preImpulseDurn;
    }

    void setStartTime(double d2) {
        this.startTime = d2;
    }

    public Window.Types getPreWindowType() {
        return this.preType;
    }

    public Window.Types getPostWindowType() {
        return this.postType;
    }

    public void setPreWindowType(Window.Types types) {
        this.preType = types;
    }

    public void setPostWindowType(Window.Types types) {
        this.postType = types;
    }
}

