/*
 * Decompiled with CFR 0.152.
 */
package roomeqwizard;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.logging.Level;
import org.jtransforms.fft.DoubleFFT_1D;
import roomeqwizard.SweepAnalyser;
import roomeqwizard.WizardLogger;
import roomeqwizard.lH;

public class Window
implements Serializable {
    static final long serialVersionUID = -1234567890000000001L;
    private double[] data;
    int n;
    Types type;
    double sigmaW;
    double sigmaWSq;
    double sigmaWNorm;
    double sigmaWNormSq;
    double a0;
    @Deprecated
    private double[] normData;
    private transient Sides side;
    private int N;
    private boolean periodic;

    public Object readResolve() throws ObjectStreamException {
        if (this.normData != null) {
            this.normData = null;
        }
        return this;
    }

    Window(Types types, Sides sides, int n2, boolean bl) {
        int n3;
        int n4;
        int n5;
        this.type = types;
        this.side = sides;
        this.N = n2;
        this.periodic = bl;
        switch (sides) {
            case LEFT: {
                this.n = n2;
                n5 = 2 * this.n - 1;
                n4 = n5 - 1;
                n3 = 1;
                break;
            }
            case RIGHT: {
                this.n = n2;
                n5 = 2 * this.n - 1;
                n4 = n5 - 1;
                n3 = this.n;
                break;
            }
            default: {
                n3 = 1;
                if (bl) {
                    n4 = this.n = (n2 & 1) == 0 ? n2 : n2 + 1;
                } else {
                    this.n = (n2 & 1) == 0 ? n2 + 1 : n2;
                    n4 = this.n - 1;
                }
                n5 = this.n;
            }
        }
        this.data = new double[this.n];
        switch (types) {
            case BLACKMAN_NUTTALL: {
                this.calcBlackmanNuttall(n4, n3);
                break;
            }
            case BLACKMAN_HARRIS: {
                this.calcBlackmanHarris(n4, n3);
                break;
            }
            case BLACKMAN_HARRIS_7: {
                this.calcBlackmanHarris7(n4, n3);
                break;
            }
            case BLACKMAN: {
                this.calcBlackman(n4, n3);
                break;
            }
            case TUKEY: {
                this.calcTukey(n4, n3, n5, 0.25);
                break;
            }
            case TUKEY50: {
                this.calcTukey(n4, n3, n5, 0.5);
                break;
            }
            case TUKEY75: {
                this.calcTukey(n4, n3, n5, 0.75);
                break;
            }
            case TUKEY10: {
                this.calcTukey(n4, n3, n5, 0.01);
                break;
            }
            case HAMMING: {
                this.calcHamming(n4, n3);
                break;
            }
            case HANNING: {
                this.calcHann(n4, n3);
                break;
            }
            case COSINE: {
                this.calcCosine(n4, n3);
                break;
            }
            case FLAT_TOP: {
                this.calcFlatTop(n4, n3);
                break;
            }
            case GAUSSIAN: {
                this.calcGaussian(n4, n3, sides);
                break;
            }
            case DOLPH150: {
                this.calcDolphChebyshev(7.5);
                break;
            }
            case DOLPH200: {
                this.calcDolphChebyshev(10.0);
                break;
            }
            case COSINESUM9: {
                this.calcCosineSum9(n4, n3);
                break;
            }
            default: {
                this.a0 = 1.0;
                Arrays.fill(this.data, 1.0);
            }
        }
        this.calcCoefficientSums(sides);
        if (this.a0 == 0.0) {
            this.a0 = this.sigmaW / (double)this.n;
        }
        this.normaliseData();
        this.calcNormCoefficientSums(sides);
    }

    private void normaliseData() {
        int n2 = 0;
        while (n2 < this.data.length) {
            int n3 = n2++;
            this.data[n3] = this.data[n3] / this.a0;
        }
    }

    double getNormData(int n2) {
        return this.data[n2];
    }

    private void calcDolphChebyshev(double d2) {
        if (!lH.A(this.n) || !this.side.equals((Object)Sides.BOTH)) {
            WizardLogger.getLogger().log(Level.SEVERE, "DolphChebyshev is only valid for a full window with power of 2 length, not {0}, {1}", new Object[]{this.side, this.n});
            Arrays.fill(this.data, 1.0);
        } else {
            int n2;
            double d3 = Math.cosh(Window.acosh(Math.pow(10.0, d2)) / (double)this.N);
            double[] dArray = new double[this.N];
            for (int i2 = 0; i2 < this.N; ++i2) {
                dArray[i2] = Math.abs(d3 * Math.cos(Math.PI * (double)i2 / (double)this.N));
            }
            double[] dArray2 = new double[this.N];
            for (n2 = 0; n2 < this.N; ++n2) {
                dArray2[n2] = Math.abs(dArray[n2]) > 1.0 ? Math.pow(-1.0, n2) * Math.cosh((double)this.N * Window.acosh(dArray[n2])) : Math.pow(-1.0, n2) * Math.cos((double)this.N * Math.acos(dArray[n2]));
            }
            this.data[0] = dArray2[0];
            this.data[1] = dArray2[this.N / 2];
            for (n2 = 1; n2 < this.N / 2; ++n2) {
                this.data[2 * n2] = dArray2[n2];
            }
            DoubleFFT_1D doubleFFT_1D = SweepAnalyser.A(this.N);
            doubleFFT_1D.realInverse(this.data, true);
            this.data[0] = this.data[0] / 2.0;
            double d4 = 1.0 / this.data[this.N / 2];
            int n3 = 0;
            while (n3 < this.N) {
                int n4 = n3++;
                this.data[n4] = this.data[n4] * d4;
            }
        }
    }

    public static double acosh(double d2) {
        if (d2 < 1.0) {
            throw new IllegalArgumentException("acosh real number argument (" + d2 + ") must be >= 1");
        }
        return Math.log(d2 + Math.sqrt(d2 * d2 - 1.0));
    }

    private void calcHamming(int n2, int n3) {
        double d2 = Math.PI * 2 / (double)n2;
        this.a0 = 0.53836;
        for (int i2 = 0; i2 < this.n; ++i2) {
            this.data[i2] = this.a0 - 0.46164 * Math.cos(d2 * (double)(n3 - 1));
            ++n3;
        }
    }

    private void calcBlackmanNuttall(int n2, int n3) {
        double d2 = Math.PI * 2 / (double)n2;
        this.a0 = 0.3635819;
        for (int i2 = 0; i2 < this.n; ++i2) {
            this.data[i2] = this.a0 - 0.4891775 * Math.cos(d2 * (double)(n3 - 1)) + 0.1365995 * Math.cos(2.0 * d2 * (double)(n3 - 1)) - 0.0106411 * Math.cos(3.0 * d2 * (double)(n3 - 1));
            ++n3;
        }
    }

    private void calcBlackmanHarris(int n2, int n3) {
        double d2 = Math.PI * 2 / (double)n2;
        this.a0 = 0.35875;
        for (int i2 = 0; i2 < this.n; ++i2) {
            this.data[i2] = this.a0 - 0.48829 * Math.cos(d2 * (double)(n3 - 1)) + 0.14128 * Math.cos(2.0 * d2 * (double)(n3 - 1)) - 0.01168 * Math.cos(3.0 * d2 * (double)(n3 - 1));
            ++n3;
        }
    }

    private void calcBlackmanHarris7(int n2, int n3) {
        double d2 = Math.PI * 2 / (double)n2;
        this.a0 = 0.27105140069342415;
        for (int i2 = 0; i2 < this.n; ++i2) {
            this.data[i2] = this.a0 - 0.43329793923448606 * Math.cos(d2 * (double)(n3 - 1)) + 0.21812299954311062 * Math.cos(2.0 * d2 * (double)(n3 - 1)) - 0.0659254463880309 * Math.cos(3.0 * d2 * (double)(n3 - 1)) + 0.010811742098372268 * Math.cos(4.0 * d2 * (double)(n3 - 1)) - 7.765848252250934E-4 * Math.cos(5.0 * d2 * (double)(n3 - 1)) + 1.3887217350903198E-5 * Math.cos(6.0 * d2 * (double)(n3 - 1));
            ++n3;
        }
    }

    private void calcCosineSum9(int n2, int n3) {
        double d2 = 1.0 / (double)n2;
        for (int i2 = 0; i2 < this.n; ++i2) {
            this.data[i2] = Window.cosineSum9(d2 * (double)n3);
            ++n3;
        }
    }

    private void calcBlackman(int n2, int n3) {
        double d2 = Math.PI * 2 / (double)n2;
        this.a0 = 0.42;
        for (int i2 = 0; i2 < this.n; ++i2) {
            this.data[i2] = this.a0 - 0.5 * Math.cos(d2 * (double)(n3 - 1)) + 0.08 * Math.cos(2.0 * d2 * (double)(n3 - 1));
            ++n3;
        }
    }

    private void calcTukey(int n2, int n3, int n4, double d2) {
        double d3 = Math.PI * 2 / d2;
        double d4 = d3 / (double)n2;
        this.a0 = 1.0 - d2 / 2.0;
        int n5 = (int)Math.round(d2 / 2.0 * (double)n2);
        int n6 = (n4 & 1) == 0 ? n4 : n4 - 1;
        for (int i2 = 0; i2 < this.n; ++i2) {
            this.data[i2] = n3 <= n5 + 1 ? 0.5 * (1.0 + Math.cos(d4 * (double)(n3 - 1) - Math.PI)) : (n3 <= n6 - n5 ? 1.0 : 0.5 * (1.0 + Math.cos(d3 - d4 * (double)(n3 - 1) - Math.PI)));
            ++n3;
        }
    }

    private void calcHann(int n2, int n3) {
        double d2 = Math.PI * 2 / (double)n2;
        this.a0 = 0.5;
        for (int i2 = 0; i2 < this.n; ++i2) {
            this.data[i2] = this.a0 * (1.0 - Math.cos(d2 * (double)(n3 - 1)));
            ++n3;
        }
    }

    private void calcCosine(int n2, int n3) {
        double d2 = Math.PI / (double)n2;
        for (int i2 = 0; i2 < this.n; ++i2) {
            this.data[i2] = Math.sin(d2 * ((double)n3 - 0.5));
            ++n3;
        }
    }

    private void calcFlatTop(int n2, int n3) {
        double d2 = Math.PI * 2 / (double)n2;
        this.a0 = 0.215578948;
        for (int i2 = 0; i2 < this.n; ++i2) {
            this.data[i2] = this.a0 - 0.41663158 * Math.cos(d2 * (double)(n3 - 1)) + 0.277263158 * Math.cos(d2 * 2.0 * (double)(n3 - 1)) - 0.083578947 * Math.cos(d2 * 3.0 * (double)(n3 - 1)) + 0.006947368 * Math.cos(d2 * 4.0 * (double)(n3 - 1));
            ++n3;
        }
    }

    private void calcGaussian(int n2, int n3, Sides sides) {
        switch (sides) {
            case LEFT: {
                n3 = -(this.n - 1);
                break;
            }
            case RIGHT: {
                n3 = 0;
                break;
            }
            default: {
                n3 = (this.n & 1) == 0 ? -this.n / 2 : -(this.n - 1) / 2;
            }
        }
        this.a0 = 0.3371642148825775;
        double d2 = 0.0181;
        double d3 = (double)n2 * Math.sqrt(2.0 * d2);
        for (int i2 = 0; i2 < this.n; ++i2) {
            double d4 = (double)n3 / d3;
            this.data[i2] = Math.exp(-d4 * d4);
            ++n3;
        }
    }

    private void calcCoefficientSums(Sides sides) {
        this.sigmaW = 0.0;
        this.sigmaWSq = 0.0;
        switch (sides) {
            case LEFT: {
                for (int i2 = 0; i2 < this.n; ++i2) {
                    this.sigmaW += this.data[i2];
                    this.sigmaWSq += this.data[i2] * this.data[i2];
                }
                break;
            }
            case RIGHT: {
                for (int i3 = this.n - 1; i3 >= 0; --i3) {
                    this.sigmaW += this.data[i3];
                    this.sigmaWSq += this.data[i3] * this.data[i3];
                }
                break;
            }
            default: {
                for (int i4 = 0; i4 < this.n / 2; ++i4) {
                    this.sigmaW += this.data[i4] + this.data[this.n - 1 - i4];
                    this.sigmaWSq += this.data[i4] * this.data[i4] + this.data[this.n - 1 - i4] * this.data[this.n - 1 - i4];
                }
            }
        }
    }

    private void calcNormCoefficientSums(Sides sides) {
        this.sigmaWNorm = 0.0;
        this.sigmaWNormSq = 0.0;
        switch (sides) {
            case LEFT: {
                for (int i2 = 0; i2 < this.n; ++i2) {
                    double d2 = this.data[i2];
                    this.sigmaWNorm += d2;
                    this.sigmaWNormSq += d2 * d2;
                }
                break;
            }
            case RIGHT: {
                for (int i3 = this.n - 1; i3 >= 0; --i3) {
                    double d3 = this.data[i3];
                    this.sigmaWNorm += d3;
                    this.sigmaWNormSq += d3 * d3;
                }
                break;
            }
            default: {
                for (int i4 = 0; i4 < this.n / 2; ++i4) {
                    double d4 = this.data[i4];
                    double d5 = this.data[this.n - 1 - i4];
                    this.sigmaWNorm += d4 + d5;
                    this.sigmaWNormSq += d4 * d4 + d5 * d5;
                }
            }
        }
    }

    Window copy() {
        if (this.side == null) {
            this.side = Sides.LEFT;
            WizardLogger.getLogger().log(Level.WARNING, "Copying window with null side");
        }
        return new Window(this.type, this.side, this.N, this.periodic);
    }

    double ENBW() {
        return (double)this.n * this.sigmaWSq / (this.sigmaW * this.sigmaW);
    }

    double coherentGain() {
        return this.sigmaW / (double)this.n;
    }

    Sides getSide() {
        return this.side;
    }

    void setSide(Sides sides) {
        this.side = sides;
    }

    static double tukey(double d2, double d3) {
        double d4 = d2 / 2.0;
        if (d3 < 0.0) {
            return 0.0;
        }
        if (d3 < d4) {
            return 0.5 * (1.0 - Math.cos(2.0 / d2 * Math.PI * d3));
        }
        if (d3 < 1.0 - d4) {
            return 1.0;
        }
        if (d3 < 1.0) {
            return 0.5 * (1.0 - Math.cos(2.0 / d2 * Math.PI * (d3 - (1.0 - d2))));
        }
        return 0.0;
    }

    static double hann(double d2) {
        if (d2 < 0.0) {
            return 0.0;
        }
        if (d2 > 1.0) {
            return 0.0;
        }
        return 0.5 * (1.0 - Math.cos(Math.PI * 2 * d2));
    }

    static double cosine(double d2) {
        if (d2 < 0.0) {
            return 0.0;
        }
        if (d2 > 1.0) {
            return 0.0;
        }
        return Math.sin(Math.PI * d2);
    }

    static double hamming(double d2) {
        if (d2 < 0.0) {
            return 0.0;
        }
        if (d2 > 1.0) {
            return 0.0;
        }
        return 0.53836 - 0.46164 * Math.cos(Math.PI * 2 * d2);
    }

    static double blackman(double d2) {
        if (d2 < 0.0) {
            return 0.0;
        }
        if (d2 > 1.0) {
            return 0.0;
        }
        return 0.42 - 0.5 * Math.cos(Math.PI * 2 * d2) + 0.08 * Math.cos(Math.PI * 4 * d2);
    }

    static double blackmanHarris(double d2) {
        if (d2 < 0.0) {
            return 0.0;
        }
        if (d2 > 1.0) {
            return 0.0;
        }
        return 0.35875 - 0.48829 * Math.cos(Math.PI * 2 * d2) + 0.14128 * Math.cos(Math.PI * 4 * d2) - 0.01168 * Math.cos(Math.PI * 6 * d2);
    }

    static double blackmanNuttall(double d2) {
        if (d2 < 0.0) {
            return 0.0;
        }
        if (d2 > 1.0) {
            return 0.0;
        }
        return 0.3635819 - 0.4891775 * Math.cos(Math.PI * 2 * d2) + 0.1365995 * Math.cos(Math.PI * 4 * d2) - 0.0106411 * Math.cos(Math.PI * 6 * d2);
    }

    static double blackmanHarris7(double d2) {
        if (d2 < 0.0) {
            return 0.0;
        }
        if (d2 > 1.0) {
            return 0.0;
        }
        return 0.27105140069342415 - 0.43329793923448606 * Math.cos(Math.PI * 2 * d2) + 0.21812299954311062 * Math.cos(Math.PI * 4 * d2) - 0.0659254463880309 * Math.cos(Math.PI * 6 * d2) + 0.010811742098372268 * Math.cos(Math.PI * 8 * d2) - 7.765848252250934E-4 * Math.cos(Math.PI * 10 * d2) + 1.3887217350903198E-5 * Math.cos(37.69911184307752 * d2);
    }

    static double cosineSum5(double d2) {
        if (d2 < 0.0) {
            return 0.0;
        }
        if (d2 > 1.0) {
            return 0.0;
        }
        double d3 = 0.3232153788877343;
        double d4 = 0.471492143957626;
        double d5 = 0.1755341299601972;
        double d6 = 0.02849699010614994;
        double d7 = 0.001261357088292677;
        return 0.3232153788877343 - 0.471492143957626 * Math.cos(Math.PI * 2 * d2) + 0.1755341299601972 * Math.cos(Math.PI * 4 * d2) - 0.02849699010614994 * Math.cos(Math.PI * 6 * d2) + 0.001261357088292677 * Math.cos(Math.PI * 8 * d2);
    }

    static double cosineSum6(double d2) {
        if (d2 < 0.0) {
            return 0.0;
        }
        if (d2 > 1.0) {
            return 0.0;
        }
        double d3 = 0.2935578950102797;
        double d4 = 0.4519357723474506;
        double d5 = 0.2014164714263962;
        double d6 = 0.04792610922105837;
        double d7 = 0.005026196426859393;
        double d8 = 1.375555679558877E-4;
        return 0.2935578950102797 - 0.4519357723474506 * Math.cos(Math.PI * 2 * d2) + 0.2014164714263962 * Math.cos(Math.PI * 4 * d2) - 0.04792610922105837 * Math.cos(Math.PI * 6 * d2) + 0.005026196426859393 * Math.cos(Math.PI * 8 * d2) - 1.375555679558877E-4 * Math.cos(Math.PI * 10 * d2);
    }

    static double cosineSum7(double d2) {
        if (d2 < 0.0) {
            return 0.0;
        }
        if (d2 > 1.0) {
            return 0.0;
        }
        double d3 = 0.2712203605850388;
        double d4 = 0.4334446123274422;
        double d5 = 0.2180041228929303;
        double d6 = 0.06578534329560609;
        double d7 = 0.01076186730534183;
        double d8 = 7.700127105808265E-4;
        double d9 = 1.368088305992921E-5;
        return 0.2712203605850388 - 0.4334446123274422 * Math.cos(Math.PI * 2 * d2) + 0.2180041228929303 * Math.cos(Math.PI * 4 * d2) - 0.06578534329560609 * Math.cos(Math.PI * 6 * d2) + 0.01076186730534183 * Math.cos(Math.PI * 8 * d2) - 7.700127105808265E-4 * Math.cos(Math.PI * 10 * d2) + 1.368088305992921E-5 * Math.cos(37.69911184307752 * d2);
    }

    static double cosineSum8(double d2) {
        if (d2 < 0.0) {
            return 0.0;
        }
        if (d2 > 1.0) {
            return 0.0;
        }
        double d3 = 0.2533176817029088;
        double d4 = 0.4163269305810218;
        double d5 = 0.2288396213719708;
        double d6 = 0.08157508425925879;
        double d7 = 0.01773592450349622;
        double d8 = 0.002096702749032688;
        double d9 = 1.067741302205525E-4;
        double d10 = 1.280702090361482E-6;
        return 0.2533176817029088 - 0.4163269305810218 * Math.cos(Math.PI * 2 * d2) + 0.2288396213719708 * Math.cos(Math.PI * 4 * d2) - 0.08157508425925879 * Math.cos(Math.PI * 6 * d2) + 0.01773592450349622 * Math.cos(Math.PI * 8 * d2) - 0.002096702749032688 * Math.cos(Math.PI * 10 * d2) + 1.067741302205525E-4 * Math.cos(37.69911184307752 * d2) - 1.280702090361482E-6 * Math.cos(43.982297150257104 * d2);
    }

    static double cosineSum9(double d2) {
        if (d2 < 0.0) {
            return 0.0;
        }
        if (d2 > 1.0) {
            return 0.0;
        }
        double d3 = 0.2384331152777942;
        double d4 = 0.400554534864382;
        double d5 = 0.2358242530472107;
        double d6 = 0.09527918858383112;
        double d7 = 0.02537395516617152;
        double d8 = 0.004152432907505835;
        double d9 = 3.68560416329818E-4;
        double d10 = 1.38435559391703E-5;
        double d11 = 1.161808358932861E-7;
        return 0.2384331152777942 - 0.400554534864382 * Math.cos(Math.PI * 2 * d2) + 0.2358242530472107 * Math.cos(Math.PI * 4 * d2) - 0.09527918858383112 * Math.cos(Math.PI * 6 * d2) + 0.02537395516617152 * Math.cos(Math.PI * 8 * d2) - 0.004152432907505835 * Math.cos(Math.PI * 10 * d2) + 3.68560416329818E-4 * Math.cos(37.69911184307752 * d2) - 1.38435559391703E-5 * Math.cos(43.982297150257104 * d2) + 1.161808358932861E-7 * Math.cos(50.26548245743669 * d2);
    }

    static double cosineSum10(double d2) {
        if (d2 < 0.0) {
            return 0.0;
        }
        if (d2 > 1.0) {
            return 0.0;
        }
        double d3 = 0.2257345387130214;
        double d4 = 0.3860122949150963;
        double d5 = 0.2401294214106057;
        double d6 = 0.1070542338664613;
        double d7 = 0.03325916184016952;
        double d8 = 0.006873374952321475;
        double d9 = 8.75167323803516E-4;
        double d10 = 6.008598932721187E-5;
        double d11 = 1.710716472110202E-6;
        double d12 = 1.027272130265191E-8;
        return 0.2257345387130214 - 0.3860122949150963 * Math.cos(Math.PI * 2 * d2) + 0.2401294214106057 * Math.cos(Math.PI * 4 * d2) - 0.1070542338664613 * Math.cos(Math.PI * 6 * d2) + 0.03325916184016952 * Math.cos(Math.PI * 8 * d2) - 0.006873374952321475 * Math.cos(Math.PI * 10 * d2) + 8.75167323803516E-4 * Math.cos(37.69911184307752 * d2) - 6.008598932721187E-5 * Math.cos(43.982297150257104 * d2) + 1.710716472110202E-6 * Math.cos(50.26548245743669 * d2) - 1.027272130265191E-8 * Math.cos(56.548667764616276 * d2);
    }

    static double cosineSum11(double d2) {
        if (d2 < 0.0) {
            return 0.0;
        }
        if (d2 > 1.0) {
            return 0.0;
        }
        double d3 = 0.2151527506679809;
        double d4 = 0.3731348357785249;
        double d5 = 0.242424335844666;
        double d6 = 0.1166907592689211;
        double d7 = 0.04077422105878731;
        double d8 = 0.01000904500852923;
        double d9 = 0.001639806917362033;
        double d10 = 1.651660820997142E-4;
        double d11 = 8.88466316854148E-6;
        double d12 = 1.938617116029048E-7;
        double d13 = 8.48248559933047E-10;
        return 0.2151527506679809 - 0.3731348357785249 * Math.cos(Math.PI * 2 * d2) + 0.242424335844666 * Math.cos(Math.PI * 4 * d2) - 0.1166907592689211 * Math.cos(Math.PI * 6 * d2) + 0.04077422105878731 * Math.cos(Math.PI * 8 * d2) - 0.01000904500852923 * Math.cos(Math.PI * 10 * d2) + 0.001639806917362033 * Math.cos(37.69911184307752 * d2) - 1.651660820997142E-4 * Math.cos(43.982297150257104 * d2) + 8.88466316854148E-6 * Math.cos(50.26548245743669 * d2) - 1.938617116029048E-7 * Math.cos(56.548667764616276 * d2) + 8.48248559933047E-10 * Math.cos(62.83185307179586 * d2);
    }

    static double flatTop(double d2) {
        if (d2 < 0.0) {
            return 0.0;
        }
        if (d2 > 1.0) {
            return 0.0;
        }
        return 0.215578948 - 0.41663158 * Math.cos(Math.PI * 2 * d2) + 0.277263158 * Math.cos(Math.PI * 4 * d2) - 0.083578947 * Math.cos(Math.PI * 6 * d2) + 0.006947368 * Math.cos(Math.PI * 8 * d2);
    }

    static double gaussian(double d2) {
        if (d2 < 0.0) {
            return 0.0;
        }
        if (d2 > 1.0) {
            return 0.0;
        }
        double d3 = 0.0181;
        double d4 = (d2 - 0.5) / Math.sqrt(2.0 * d3);
        return Math.exp(-d4 * d4);
    }

    public static enum Sides {
        LEFT,
        RIGHT,
        BOTH;

    }

    public static final class Types
    extends Enum<Types> {
        public static final /* enum */ Types RECTANGULAR = new Types("Rectangular");
        public static final /* enum */ Types HANNING = new Types("Hann");
        public static final /* enum */ Types HAMMING = new Types("Hamming");
        public static final /* enum */ Types COSINE = new Types("Cosine");
        public static final /* enum */ Types TUKEY10 = new Types("Tukey 0.01");
        public static final /* enum */ Types TUKEY = new Types("Tukey 0.25");
        public static final /* enum */ Types TUKEY50 = new Types("Tukey 0.5");
        public static final /* enum */ Types TUKEY75 = new Types("Tukey 0.75");
        public static final /* enum */ Types BLACKMAN = new Types("Blackman");
        public static final /* enum */ Types BLACKMAN_HARRIS = new Types("Blackman-Harris 4");
        public static final /* enum */ Types BLACKMAN_NUTTALL = new Types("Blackman-Nuttall");
        public static final /* enum */ Types BLACKMAN_HARRIS_7 = new Types("Blackman-Harris 7");
        public static final /* enum */ Types FLAT_TOP = new Types("Flat-Top");
        public static final /* enum */ Types GAUSSIAN = new Types("Gaussian");
        public static final /* enum */ Types DOLPH150 = new Types("Dolph-Chebyshev 150");
        public static final /* enum */ Types DOLPH200 = new Types("Dolph-Chebyshev 200");
        public static final /* enum */ Types COSINESUM9 = new Types("Cosine sum 9-235");
        private final String description;
        private static final /* synthetic */ Types[] $VALUES;

        public static Types[] values() {
            return (Types[])$VALUES.clone();
        }

        public static Types valueOf(String string) {
            return Enum.valueOf(Types.class, string);
        }

        private Types(String string2) {
            this.description = string2;
        }

        public String toString() {
            return this.description;
        }

        public String apiName() {
            return this.description;
        }

        public static Types getEnum(String string) {
            for (Types types : Types.values()) {
                if (!types.name().equalsIgnoreCase(string)) continue;
                return types;
            }
            return TUKEY;
        }

        public static Types getTypeFromDescription(String string) {
            for (Types types : Types.values()) {
                if (!types.description.equalsIgnoreCase(string)) continue;
                return types;
            }
            return null;
        }

        public double noiseBW() {
            switch (this) {
                case RECTANGULAR: {
                    return 1.0;
                }
                case HANNING: {
                    return 1.5;
                }
                case HAMMING: {
                    return 1.367626;
                }
                case TUKEY: {
                    return 1.10204;
                }
                case TUKEY50: {
                    return 1.22;
                }
                case TUKEY75: {
                    return 1.36;
                }
                case TUKEY10: {
                    return 1.0;
                }
                case COSINE: {
                    return 1.2337;
                }
                case BLACKMAN: {
                    return 1.726757;
                }
                case BLACKMAN_HARRIS: {
                    return 2.0043529;
                }
                case BLACKMAN_HARRIS_7: {
                    return 2.631905;
                }
                case BLACKMAN_NUTTALL: {
                    return 1.9761092851647786;
                }
                case FLAT_TOP: {
                    return 3.770246506303;
                }
                case GAUSSIAN: {
                    return 2.09764;
                }
                case DOLPH150: {
                    return 2.3659789677950367;
                }
                case DOLPH200: {
                    return 2.725858111789938;
                }
                case COSINESUM9: {
                    return 2.98588;
                }
            }
            return 1.0;
        }

        public double coherentGain() {
            switch (this) {
                case RECTANGULAR: {
                    return 1.0;
                }
                case HANNING: {
                    return 0.5;
                }
                case HAMMING: {
                    return 0.53836;
                }
                case TUKEY: {
                    return 0.875;
                }
                case TUKEY50: {
                    return 0.75;
                }
                case TUKEY75: {
                    return 0.625;
                }
                case TUKEY10: {
                    return 0.995;
                }
                case COSINE: {
                    return 0.6366;
                }
                case BLACKMAN: {
                    return 0.42;
                }
                case BLACKMAN_HARRIS: {
                    return 0.35875;
                }
                case BLACKMAN_HARRIS_7: {
                    return 0.27105140069342415;
                }
                case BLACKMAN_NUTTALL: {
                    return 0.3635819;
                }
                case FLAT_TOP: {
                    return 0.215578948;
                }
                case GAUSSIAN: {
                    return 0.3371642148825775;
                }
                case DOLPH150: {
                    return 0.3021401449730172;
                }
                case DOLPH200: {
                    return 0.26153415236461813;
                }
                case COSINESUM9: {
                    return 0.2384331152777942;
                }
            }
            return 1.0;
        }

        public int spreadingSpan() {
            switch (this) {
                case RECTANGULAR: {
                    return 2;
                }
                case HANNING: {
                    return 3;
                }
                case COSINE: {
                    return 3;
                }
                case BLACKMAN_HARRIS: {
                    return 5;
                }
                case BLACKMAN_HARRIS_7: {
                    return 6;
                }
                case FLAT_TOP: {
                    return 4;
                }
                case DOLPH150: {
                    return 6;
                }
                case DOLPH200: {
                    return 8;
                }
                case COSINESUM9: {
                    return 8;
                }
            }
            return 3;
        }

        public boolean isFullOnly() {
            switch (this) {
                case DOLPH150: 
                case DOLPH200: 
                case COSINESUM9: {
                    return true;
                }
            }
            return false;
        }

        public double fullWindowVal(double d2) {
            switch (this) {
                case RECTANGULAR: {
                    if (d2 < 0.0) {
                        return 0.0;
                    }
                    if (d2 > 1.0) {
                        return 0.0;
                    }
                    return 1.0;
                }
                case TUKEY: {
                    return Window.tukey(0.25, d2);
                }
                case TUKEY50: {
                    return Window.tukey(0.5, d2);
                }
                case TUKEY75: {
                    return Window.tukey(0.75, d2);
                }
                case TUKEY10: {
                    return Window.tukey(0.01, d2);
                }
                case HANNING: {
                    return Window.hann(d2);
                }
                case COSINE: {
                    return Window.cosine(d2);
                }
                case HAMMING: {
                    return Window.hamming(d2);
                }
                case BLACKMAN: {
                    return Window.blackman(d2);
                }
                case BLACKMAN_HARRIS: {
                    return Window.blackmanHarris(d2);
                }
                case BLACKMAN_NUTTALL: {
                    return Window.blackmanNuttall(d2);
                }
                case BLACKMAN_HARRIS_7: {
                    return Window.blackmanHarris7(d2);
                }
                case FLAT_TOP: {
                    return Window.flatTop(d2);
                }
                case GAUSSIAN: {
                    return Window.gaussian(d2);
                }
                case COSINESUM9: {
                    return Window.cosineSum9(d2);
                }
            }
            assert (false) : "Window function not implemented " + this.name();
            return 1.0;
        }

        public double leftWindowVal(double d2) {
            return this.fullWindowVal(d2 *= 0.5);
        }

        public double rightWindowVal(double d2) {
            d2 = 0.5 * (d2 + 1.0);
            return this.fullWindowVal(d2);
        }

        public static Types[] leftRightSet() {
            Types[] typesArray = new Types[Types.values().length];
            int n2 = 0;
            for (Types types : Types.values()) {
                if (types.isFullOnly()) continue;
                typesArray[n2++] = types;
            }
            Types[] typesArray2 = new Types[n2];
            System.arraycopy(typesArray, 0, typesArray2, 0, n2);
            return typesArray2;
        }

        static {
            $VALUES = new Types[]{RECTANGULAR, HANNING, HAMMING, COSINE, TUKEY10, TUKEY, TUKEY50, TUKEY75, BLACKMAN, BLACKMAN_HARRIS, BLACKMAN_NUTTALL, BLACKMAN_HARRIS_7, FLAT_TOP, GAUSSIAN, DOLPH150, DOLPH200, COSINESUM9};
        }
    }
}

