/*
 * Decompiled with CFR 0.152.
 */
package roomeqwizard;

import roomeqwizard.HE;
import roomeqwizard.api.API;
import roomeqwizard.lG;

public enum TwoToneSignal {
    SMPTE("SMPTE (60 Hz & 7 kHz 4:1)", "SMPTE_ 60_7k_4_1", "SMPTE", 60.0, 7000.0, 4.0),
    DIN("DIN (250 Hz & 8 kHz 4:1)", "DIN_250_8k_4_1", "DIN", 250.0, 8000.0, 4.0),
    CCIF("CCIF (19 kHz & 20 kHz 1:1)", "CCIF_19k_20k_1_1", "CCIF", 19000.0, 20000.0, 1.0),
    AES17MD("AES-17 MD (41 Hz & 7993 Hz 4:1)", "AES17_41_7993_4_1", "AES17 MD", 41.0, 7993.0, 4.0),
    AES17DFD("AES-17 DFD (18 kHz & 20 kHz 1:1)", "AES17_18k_20k_1_1", "AES17 DFD", 18000.0, 20000.0, 1.0),
    TDFD_BASS("TDFD Bass (41 Hz & 89 Hz 1:1)", "TDFD_41_89_1_1", "TDFD Bass", 41.0, 89.0, 1.0),
    TDFD_AKL("TDFD akl (13586 Hz & 19841 Hz 1:1)", "TDFD_13586_19841_1_1", "TDFD akl", 13586.0, 19841.0, 1.0),
    TDFD_PHONO("TDFD Phono (3005 Hz & 4462 Hz 1:1)", "TDFD_3005_4462_1_1", "TDFD phono", 3005.0, 4462.0, 1.0),
    CUSTOM("Custom", "Dual_13k_14k_1_1", "Custom", 13000.0, 14000.0, 1.0);

    private final String description;
    private String shortDescription;
    private final String typeDescription;
    private double f1;
    private double f2;
    private double ratio;

    private TwoToneSignal(String string2, String string3, String string4, double d2, double d3, double d4) {
        this.description = string2;
        this.shortDescription = string3;
        this.typeDescription = string4;
        this.f1 = d2;
        this.f2 = d3;
        this.ratio = d4;
    }

    public String toString() {
        return this.description;
    }

    public String description() {
        return this.description;
    }

    public String shortDescription() {
        return this.shortDescription;
    }

    public String typeDescription() {
        return this.typeDescription;
    }

    public String apiName() {
        return API.toKebabCase(this.typeDescription);
    }

    public double getF1() {
        return this.f1;
    }

    public double getF2() {
        return this.f2;
    }

    public double getRatio() {
        return this.ratio;
    }

    public void setF1(double d2) {
        this.f1 = d2;
        this.updateShortDesc();
    }

    public void setF2(double d2) {
        this.f2 = d2;
        this.updateShortDesc();
    }

    public void setRatio(double d2) {
        this.ratio = d2;
        this.updateShortDesc();
    }

    private void updateShortDesc() {
        this.shortDescription = "Dual_" + HE.H.format(lG.\u0106()) + "_" + HE.H.format(lG.\u01df()) + "_" + HE.H.format(lG.\u01a1()) + "_1";
    }

    public static TwoToneSignal getEnum(String string) {
        for (TwoToneSignal twoToneSignal : TwoToneSignal.values()) {
            if (!twoToneSignal.name().equalsIgnoreCase(string)) continue;
            return twoToneSignal;
        }
        return SMPTE;
    }

    public static TwoToneSignal getFromApiName(String string) {
        for (TwoToneSignal twoToneSignal : TwoToneSignal.values()) {
            if (!twoToneSignal.apiName().equalsIgnoreCase(string)) continue;
            return twoToneSignal;
        }
        return null;
    }
}

