/*
 * Decompiled with CFR 0.152.
 */
package roomeqwizard;

public enum TimingReference {
    NONE("with no timing reference", "No timing reference", "No timing reference", "None"),
    LOOPBACK("using a loopback as a timing reference", "Loopback", "Use loopback as timing reference", "Loopback"),
    LOOPBACK_CAL("using a loopback as calibration and timing reference", "Loopback as cal ref", "Use loopback as cal and timing reference", "Loopback cal"),
    ACOUSTIC("using an acoustic timing reference", "Acoustic reference", "Use acoustic timing reference", "Acoustic"),
    WIRED("using a wired timing reference", "Wired reference", "Use wired timing reference", "Wired");

    private final String description;
    private final String shortDesc;
    private final String optionSt;
    private final String apiName;

    private TimingReference(String string2, String string3, String string4, String string5) {
        this.description = string2;
        this.shortDesc = string3;
        this.optionSt = string4;
        this.apiName = string5;
    }

    public String toString() {
        return this.optionSt;
    }

    public String apiName() {
        return this.apiName;
    }

    public String description() {
        return this.description;
    }

    public String shortDescription() {
        return this.shortDesc;
    }

    public static TimingReference getEnum(String string) {
        for (TimingReference timingReference : TimingReference.values()) {
            if (!timingReference.name().equalsIgnoreCase(string)) continue;
            return timingReference;
        }
        return NONE;
    }

    public static TimingReference getFromApiName(String string) {
        for (TimingReference timingReference : TimingReference.values()) {
            if (!timingReference.apiName().equalsIgnoreCase(string)) continue;
            return timingReference;
        }
        return null;
    }

    public boolean usesLoopback() {
        return this == LOOPBACK || this == LOOPBACK_CAL;
    }

    public boolean usesRefInput() {
        return this == LOOPBACK || this == LOOPBACK_CAL || this == WIRED;
    }

    public boolean allowsMultipleSweeps() {
        return this != ACOUSTIC && this != WIRED;
    }

    public boolean usesTimingSignal() {
        return this == ACOUSTIC || this == WIRED;
    }
}

