/*
 * Decompiled with CFR 0.152.
 */
package roomeqwizard;

import java.util.ArrayList;
import java.util.Arrays;
import roomeqwizard.HE;
import roomeqwizard.api.API;

public enum ThreeToneSignal {
    BOR("Borberly (9, 19, 20 kHz)", "Triple_9k_19k_20k", "Borberly", 9000.0, 19030.0, 20000.0),
    MIM("Cordell (9, 10, 20 kHz)", "Triple_9k_10k_20k", "Cordell", 9000.0, 10050.0, 20000.0),
    TRI_AKL("Klingelnberg (10.5, 19, 20 kHz)", "Triple_10k5_19k_20k", "Klingelnberg", 10504.0, 19027.0, 19997.0),
    CUSTOM("Custom", "Triple_10k5_19k_20k", "Custom", 10504.0, 19027.0, 19997.0);

    private final String description;
    private String shortDescription;
    private final String typeDescription;
    private double f1;
    private double f2;
    private double f3;
    private double d2Freq;
    private double d3Freq;

    private ThreeToneSignal(String string2, String string3, String string4, double d2, double d3, double d4) {
        this.description = string2;
        this.shortDescription = string3;
        this.typeDescription = string4;
        this.f1 = d2;
        this.f2 = d3;
        this.f3 = d4;
        this.calculateD2D3();
    }

    public String description() {
        return this.description;
    }

    public String shortDescription() {
        return this.shortDescription;
    }

    public String apiName() {
        return API.toKebabCase(this.typeDescription);
    }

    public double getF1() {
        return this.f1;
    }

    public double getF2() {
        return this.f2;
    }

    public double getF3() {
        return this.f3;
    }

    public double getLowestFreq() {
        return Math.min(this.f1, Math.min(this.f3, this.f2));
    }

    public void setF1(double d2) {
        this.f1 = d2;
        this.updateShortDesc();
        this.calculateD2D3();
    }

    public void setF2(double d2) {
        this.f2 = d2;
        this.updateShortDesc();
        this.calculateD2D3();
    }

    public void setF3(double d2) {
        this.f3 = d2;
        this.updateShortDesc();
        this.calculateD2D3();
    }

    public double getD2Freq() {
        return this.d2Freq;
    }

    public double getD3Freq() {
        return this.d3Freq;
    }

    private void calculateD2D3() {
        double[] dArray;
        double[] dArray2 = new double[]{this.f1, this.f2, this.f3};
        Arrays.sort(dArray2);
        ArrayList<Double> arrayList = new ArrayList<Double>();
        ArrayList<Double> arrayList2 = new ArrayList<Double>();
        double d2 = 1000.0;
        double d3 = 100.0;
        double[] dArray3 = dArray = new double[]{this.f3 - this.f2, this.f2 - this.f1, this.f3 - this.f1};
        int n2 = dArray3.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            double d4 = dArray3[i2];
            if (!(Math.abs(d4 - d2) < d3)) continue;
            arrayList.add(d4);
        }
        this.d2Freq = !arrayList.isEmpty() ? (Double)arrayList.get(0) : 0.0;
        for (double d5 : dArray3 = new double[]{Math.abs(2.0 * this.f1 - this.f2), Math.abs(2.0 * this.f1 - this.f3), Math.abs(this.f3 - this.f2 - this.f1)}) {
            if (!(Math.abs(d5 - d2) < d3)) continue;
            arrayList2.add(d5);
        }
        this.d3Freq = !arrayList2.isEmpty() ? (Double)arrayList2.get(0) : 0.0;
    }

    private void updateShortDesc() {
        this.shortDescription = "Triple_" + HE.H.format(this.f1) + "_" + HE.H.format(this.f2) + "_" + HE.H.format(this.f3);
    }

    public static ThreeToneSignal getEnum(String string) {
        for (ThreeToneSignal threeToneSignal : ThreeToneSignal.values()) {
            if (!threeToneSignal.name().equalsIgnoreCase(string)) continue;
            return threeToneSignal;
        }
        return TRI_AKL;
    }

    public static ThreeToneSignal getFromApiName(String string) {
        for (ThreeToneSignal threeToneSignal : ThreeToneSignal.values()) {
            if (!threeToneSignal.apiName().equalsIgnoreCase(string)) continue;
            return threeToneSignal;
        }
        return null;
    }
}

