/*
 * Decompiled with CFR 0.152.
 */
package roomeqwizard;

import roomeqwizard.FilterGroup;
import roomeqwizard.TargetShape;
import roomeqwizard.XOverChoice;
import roomeqwizard.XOverFilter;
import roomeqwizard.XOverShape;
import roomeqwizard.XOverSlope;
import roomeqwizard.lG;

public class Target
implements Cloneable {
    static final int DEFAULT_SAMPLE_RATE = 96000;
    private XOverFilter lpFilt = new XOverFilter();
    private XOverFilter hpFilt = new XOverFilter();
    private TargetShape shape;
    private double cutoff;
    private double lpCutoff;
    private double hpCutoff;
    private double subLFCutoff;
    private XOverChoice lpChoice;
    private XOverChoice hpChoice;
    private XOverSlope xOverSlope;
    private XOverSlope subLFSlope;
    private XOverShape xOverShape;

    public Target() {
        this.xOverSlope = lG.\u01b2();
        this.cutoff = lG.\u03c7();
        this.subLFSlope = lG.\u02b6();
        this.subLFCutoff = lG.f();
        this.lpChoice = lG.\u0439();
        this.lpCutoff = lG.\u026c();
        this.hpChoice = lG.\u00e6();
        this.hpCutoff = lG.\u010f();
        this.setSampleRate(96000);
        this.setTargetShape(lG.\u0452());
    }

    public Target(Target target) {
        this.xOverSlope = target.getBassMgmtSlope();
        this.cutoff = target.getBassMgmtCutoff();
        this.subLFSlope = target.getSubLFSlope();
        this.subLFCutoff = target.getSubLFCutoff();
        this.lpChoice = target.getXOverLPChoice();
        this.lpCutoff = target.getXOverLPCutoff();
        this.hpChoice = target.getXOverHPChoice();
        this.hpCutoff = target.getXOverHPCutoff();
        this.setSampleRate(target.lpFilt.getSampleRate());
        this.setTargetShape(target.getTargetShape());
    }

    public Object clone() {
        Target target = new Target(this);
        return target;
    }

    public void setSampleRate(int n2) {
        this.lpFilt.setSampleRate(n2);
        this.hpFilt.setSampleRate(n2);
    }

    public void setTargetShape(TargetShape targetShape) {
        this.shape = targetShape;
        switch (this.shape) {
            case SUBWOOFER: {
                this.lpFilt.setLPHPFilter(FilterGroup.LOWPASS, this.cutoffChoice(this.xOverSlope).getShape(), this.xOverSlope, this.cutoff);
                this.setHPFiltForSubLFCutoff();
                break;
            }
            case BASS_LIMITED: {
                this.lpFilt.clearFilter();
                this.hpFilt.setLPHPFilter(FilterGroup.HIGHPASS, this.cutoffChoice(this.xOverSlope).getShape(), this.xOverSlope, this.cutoff);
                break;
            }
            case FULL_RANGE: {
                this.lpFilt.clearFilter();
                this.setHPFiltForSubLFCutoff();
                break;
            }
            case DRIVER: {
                this.lpFilt.setLPHPFilter(FilterGroup.LOWPASS, this.lpChoice.getShape(), this.lpChoice.getSlope(), this.lpCutoff);
                this.hpFilt.setLPHPFilter(FilterGroup.HIGHPASS, this.hpChoice.getShape(), this.hpChoice.getSlope(), this.hpCutoff);
                break;
            }
            default: {
                this.lpFilt.clearFilter();
                this.hpFilt.clearFilter();
            }
        }
    }

    private void setHPFiltForSubLFCutoff() {
        if (this.subLFCutoff == 0.0) {
            this.hpFilt.clearFilter();
        } else {
            this.hpFilt.setLPHPFilter(FilterGroup.HIGHPASS, this.getSubLFChoice(this.subLFSlope).getShape(), this.subLFSlope, this.subLFCutoff);
        }
    }

    private XOverChoice cutoffChoice(XOverSlope xOverSlope) {
        switch (xOverSlope) {
            case SLOPE_6DB: {
                return XOverChoice.BU1;
            }
            case SLOPE_12DB: {
                return XOverChoice.BU2;
            }
            case SLOPE_18DB: {
                return XOverChoice.BU3;
            }
            case SLOPE_24DB: {
                return XOverChoice.BU4;
            }
            case SLOPE_30DB: {
                return XOverChoice.BU5;
            }
            case SLOPE_36DB: {
                return XOverChoice.BU6;
            }
            case SLOPE_42DB: {
                return XOverChoice.BU7;
            }
            case SLOPE_48DB: {
                return XOverChoice.BU8;
            }
        }
        return XOverChoice.BU2;
    }

    private XOverChoice getSubLFChoice(XOverSlope xOverSlope) {
        switch (xOverSlope) {
            case SLOPE_6DB: {
                return XOverChoice.BU1;
            }
            case SLOPE_12DB: {
                return XOverChoice.BU2;
            }
            case SLOPE_18DB: {
                return XOverChoice.BU3;
            }
            case SLOPE_24DB: {
                return XOverChoice.BU4;
            }
            case SLOPE_30DB: {
                return XOverChoice.BU5;
            }
            case SLOPE_36DB: {
                return XOverChoice.BU6;
            }
            case SLOPE_42DB: {
                return XOverChoice.BU7;
            }
            case SLOPE_48DB: {
                return XOverChoice.BU8;
            }
        }
        return XOverChoice.BU2;
    }

    public void setBassMgmtCutoff(double d2) {
        switch (this.shape) {
            case SUBWOOFER: {
                this.setBassMgmtLPCutoff(d2);
                break;
            }
            case BASS_LIMITED: {
                this.setBassMgmtHPCutoff(d2);
            }
        }
    }

    public void setBassMgmtLPCutoff(double d2) {
        this.cutoff = d2;
        this.lpFilt.setFilterFc(d2);
    }

    public void setBassMgmtHPCutoff(double d2) {
        this.cutoff = d2;
        this.hpFilt.setFilterFc(d2);
    }

    public double getXOverLPCutoff() {
        return this.lpCutoff;
    }

    public double getXOverHPCutoff() {
        return this.hpCutoff;
    }

    public void setXOverLPCutoff(double d2) {
        if (this.shape == TargetShape.DRIVER) {
            this.lpCutoff = d2;
            this.lpFilt.setFilterFc(d2);
        }
    }

    public void setXOverHPCutoff(double d2) {
        if (this.shape == TargetShape.DRIVER) {
            this.hpCutoff = d2;
            this.hpFilt.setFilterFc(d2);
        }
    }

    public XOverChoice getXOverLPChoice() {
        return this.lpChoice;
    }

    public XOverChoice getXOverHPChoice() {
        return this.hpChoice;
    }

    public void setXOverLPChoice(XOverChoice xOverChoice) {
        if (this.shape == TargetShape.DRIVER) {
            this.lpChoice = xOverChoice;
            this.lpFilt.setLPHPFilter(FilterGroup.LOWPASS, xOverChoice.getShape(), xOverChoice.getSlope(), this.lpCutoff);
        }
    }

    public void setXOverHPChoice(XOverChoice xOverChoice) {
        if (this.shape == TargetShape.DRIVER) {
            this.hpChoice = xOverChoice;
            this.hpFilt.setLPHPFilter(FilterGroup.HIGHPASS, xOverChoice.getShape(), xOverChoice.getSlope(), this.hpCutoff);
        }
    }

    public void setBassMgmtSlope(XOverSlope xOverSlope) {
        this.xOverSlope = xOverSlope;
        this.setTargetShape(this.shape);
    }

    public XOverSlope getBassMgmtSlope() {
        return this.xOverSlope;
    }

    public XOverSlope getSubLFSlope() {
        return this.subLFSlope;
    }

    public void setSubLFSlope(XOverSlope xOverSlope) {
        this.subLFSlope = xOverSlope;
        if (this.shape == TargetShape.SUBWOOFER || this.shape == TargetShape.FULL_RANGE) {
            this.setTargetShape(this.shape);
        }
    }

    public void setSubLFCutoff(double d2) {
        this.subLFCutoff = d2;
        this.setTargetShape(this.shape);
    }

    public TargetShape getTargetShape() {
        return this.shape;
    }

    public XOverShape getBassMgmtXOverShape() {
        return this.xOverShape;
    }

    public double getBassMgmtCutoff() {
        return this.cutoff;
    }

    public double getSubLFCutoff() {
        return this.subLFCutoff;
    }

    public float dB(float f2) {
        return this.lpFilt.dB(f2) + this.hpFilt.dB(f2);
    }
}

