/*
 * Decompiled with CFR 0.152.
 */
package roomeqwizard;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.ObjectStreamException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.logging.Level;
import javax.swing.JOptionPane;
import roomeqwizard.CC;
import roomeqwizard.CF;
import roomeqwizard.DH;
import roomeqwizard.EK;
import roomeqwizard.HD;
import roomeqwizard.HE;
import roomeqwizard.LOGModel;
import roomeqwizard.LinearDataSet;
import roomeqwizard.LogDataSet;
import roomeqwizard.LossyInductor;
import roomeqwizard.MeasData;
import roomeqwizard.ModelParameter;
import roomeqwizard.MotionalImpedance;
import roomeqwizard.MotionalImpedanceModel;
import roomeqwizard.Ritter3PCModel;
import roomeqwizard.RoomEQ_Wizard;
import roomeqwizard.SI;
import roomeqwizard.SILOGModel;
import roomeqwizard.TJ;
import roomeqwizard.TSMethod;
import roomeqwizard.V;
import roomeqwizard.WizardLogger;
import roomeqwizard.ZB;
import roomeqwizard.ZJ;
import roomeqwizard.bF;
import roomeqwizard.g;
import roomeqwizard.lG;
import roomeqwizard.lH;
import roomeqwizard.qD;

class TSParams
implements Serializable,
TJ,
qD {
    static final long serialVersionUID = -122222222222222222L;
    static final double RES_MAX = 1000000.0;
    private static final boolean LOG_DEBUG = false;
    private static final boolean SHOW_DEBUG = false;
    private static final int DIFF_HALFLEN = 4;
    private static final int MAXF_FOR_FIT = 10000;
    private static final int MINF_FOR_FIT = 10;
    private static final int SIGNIFICANT_DIGITS = -1;
    private static final double MOTIONAL_FIT_PEAK_FACTOR = 0.5;
    private MotionalImpedance motionalImpedance;
    double ZmaxMeas;
    double ZminMeas;
    double ZminFreq;
    private double RDC;
    private double RE;
    double MMS;
    double CMS;
    double VAS;
    double Bl;
    double RMS;
    double Lp;
    double ETA;
    double diam;
    double addedMass;
    double addedMass2;
    double S;
    double VB;
    double T;
    double p;
    double phi;
    double c;
    double rho;
    double Ql;
    float f3;
    private double factorPara;
    private double faPara;
    private double hfFitStart;
    private int measMaxIndex;
    private int measMinIndex;
    private LossyInductor voiceCoil;
    private LossyInductor simpleModelVC;
    private boolean isPrimary;
    private TSMethod method;
    DH ZMstarReal;
    DH ZMstarImag;
    DH Bldata;
    private double BlSlope;
    private double BlOffset;
    @Deprecated
    private boolean addedMassMethod;
    @Deprecated
    private double RAMS;
    @Deprecated
    double QMS;
    @Deprecated
    double QES;
    @Deprecated
    double QTS;
    @Deprecated
    private double RES;
    @Deprecated
    private double LCES;
    @Deprecated
    private double CMES;
    @Deprecated
    private double GLES;
    @Deprecated
    private double GLESR;
    @Deprecated
    private double lambda;
    @Deprecated
    double omegaS;
    @Deprecated
    double omegaSSq;
    MeasData meas;
    String secMeasName = "";
    String mass2MeasName = "";
    private transient double[] omegaVals;
    private transient double[] reals;
    private transient double[] imags;
    private transient double[] weighting;
    private transient double[] savedOmegaVals;
    private transient double[] savedReals;
    private transient double[] savedImags;
    private transient double[] savedWeighting;
    private transient ZB parabolicFit;
    private transient HD[] conversions;
    private transient CC optTarget;
    private transient boolean hfWarningShown = false;
    private transient boolean fixLCES = false;
    private transient TSParams mass1TS;
    private transient TSParams mass2TS;

    TSParams(MeasData measData) {
        TSParams tSParams;
        this.meas = measData;
        if (measData.hasTSParams() && (tSParams = measData.getTSParams()).hasZMstar()) {
            this.ZMstarReal = tSParams.ZMstarReal.clone();
            this.ZMstarImag = tSParams.ZMstarImag.clone();
        }
        this.motionalImpedance = this.makeMotionalImpedance(lG.\u042a());
        this.voiceCoil = new LossyInductor(bF.d());
        this.simpleModelVC = new LossyInductor(LossyInductor.Models.LR4);
        this.analyseResponse();
    }

    void updateMotionalModel(MotionalImpedanceModel motionalImpedanceModel) {
        this.motionalImpedance = this.makeMotionalImpedance(motionalImpedanceModel);
    }

    private MotionalImpedance makeMotionalImpedance(MotionalImpedanceModel motionalImpedanceModel) {
        switch (motionalImpedanceModel) {
            case FDD: 
            case SILOG: 
            case SILOGR: {
                return new SILOGModel(this, motionalImpedanceModel);
            }
            case LOG: {
                return new LOGModel(this);
            }
            case RITTER3PC: {
                return new Ritter3PCModel(this);
            }
        }
        assert (false) : "Unhandled enum type";
        return null;
    }

    MotionalImpedance getMotionalImpedance() {
        return this.motionalImpedance;
    }

    void setPrimary(boolean bl) {
        this.isPrimary = bl;
        this.motionalImpedance.setPrimary(bl);
    }

    boolean isPrimary() {
        return this.isPrimary;
    }

    void setPrimaryValues(TSParams tSParams) {
        this.motionalImpedance.setPrimaryValues(tSParams.getMotionalImpedance());
    }

    double getOmegaS() {
        return this.motionalImpedance.getOmegaS();
    }

    double getFs() {
        return this.motionalImpedance.getOmegaS() / (Math.PI * 2);
    }

    void calcCommonTSParams() {
        double d2 = this.S * this.S;
        if (this.method != TSMethod.DUAL_ADDED_MASS) {
            this.Bl = Math.sqrt(this.MMS / this.getCMES());
        }
        this.RMS = this.getOmegaS() * this.MMS / this.getQMS();
        this.ETA = this.rho * d2 * this.Bl * this.Bl / (Math.PI * 2 * this.c * this.getRE() * this.MMS * this.MMS);
        this.Lp = 10.0 * Math.log10(this.rho * this.c * 0.5 / Math.PI) - 20.0 * Math.log10(2.0E-5) + 10.0 * Math.log10(this.ETA);
    }

    void calcAddedMassParams(TSParams tSParams) {
        double d2 = this.S * this.S;
        double d3 = this.getCMES();
        double d4 = tSParams.getCMES() - d3;
        this.MMS = this.method != TSMethod.DUAL_ADDED_MASS ? 0.001 * tSParams.addedMass * d3 / d4 : this.getCMES() * this.Bl * this.Bl;
        this.CMS = 1.0 / (this.MMS * this.getOmegaS() * this.getOmegaS());
        this.VAS = this.rho * this.c * this.c * d2 * this.CMS;
    }

    void calcSealedBoxParams(TSParams tSParams, boolean bl, boolean bl2) {
        double d2 = this.S * this.S;
        double d3 = tSParams.getFs();
        if (bl) {
            double d4 = this.getFs() * tSParams.getQES() / (d3 * this.getQES());
            d3 /= Math.sqrt(d4);
        }
        this.calcLeakageLossAndVAS(tSParams, d3, bl2);
        this.CMS = this.VAS / (this.rho * this.c * this.c * d2);
        this.MMS = 1.0 / (this.CMS * this.getOmegaS() * this.getOmegaS());
    }

    private void calcLeakageLossAndVAS(TSParams tSParams, double d2, boolean bl) {
        double d3 = this.S * this.S;
        double d4 = this.getResEquiv();
        double d5 = this.getLCES();
        double d6 = tSParams.getResEquiv();
        double d7 = d2 * d2 / (this.getFs() * this.getFs()) - 1.0;
        double d8 = 1.0 / d6 - 1.0 / d4;
        double d9 = Math.PI * 2 * d2 * d5 / d7;
        double d10 = d5 / d7 * (1.0 / (1.0 + d8 * d8 * d9 * d9));
        double d11 = d8 * d9 * 2.0 * Math.PI * d2 * d10;
        double d12 = 0.001 * this.VB / (this.rho * this.c * this.c * d3);
        this.Ql = d11 * d12 * d2;
        this.VAS = bl ? 0.001 * this.VB * this.getLCES() / d10 : 0.001 * this.VB * (d2 * tSParams.getQES() / (this.getFs() * this.getQES()) - 1.0);
    }

    public Object readResolve() throws ObjectStreamException {
        if (this.GLES == 0.0 && this.RAMS != 0.0) {
            this.GLES = this.LCES * this.LCES / this.RAMS;
            this.LCES = 1.0 / (this.omegaSSq * this.CMES);
        }
        if (!this.isPrimary && this.diam != 0.0) {
            this.isPrimary = true;
        }
        if (this.motionalImpedance == null) {
            this.motionalImpedance = this.makeMotionalImpedance(lG.\u042a());
            this.motionalImpedance.setParam(ModelParameter.RES, this.RES);
            this.motionalImpedance.setParam(ModelParameter.CMES, this.CMES);
            this.motionalImpedance.setParam(ModelParameter.LCES, this.LCES);
            this.motionalImpedance.setPrimary(this.isPrimary);
            this.motionalImpedance.setOmegaS(this.omegaS);
            this.motionalImpedance.setQES(this.QES);
            this.motionalImpedance.setQTS(this.QTS);
            this.motionalImpedance.setQMS(this.QMS);
        }
        this.disposeOptTargetArrays();
        this.weighting = null;
        this.parabolicFit = null;
        this.hfWarningShown = false;
        this.fixLCES = false;
        return this;
    }

    boolean needsRecalc(double d2) {
        if (d2 != this.RDC) {
            return true;
        }
        if (this.voiceCoil.isZeroValued()) {
            return true;
        }
        return true;
    }

    private int findResonantPeak() {
        this.meas.smooth(3.0, true);
        float[] fArray = this.meas.getLinearSpacedData();
        this.meas.smooth(0.0, true);
        float[] fArray2 = this.differentiate(fArray);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        this.findMaxAndMinIndices(fArray2, arrayList, arrayList2, 4);
        return this.findLargestPeak(arrayList, arrayList2);
    }

    private int findLargestPeak(ArrayList<Integer> arrayList, ArrayList<Integer> arrayList2) {
        int n2 = 0;
        float f2 = 0.0f;
        if (arrayList.size() >= 1 && arrayList2.size() >= 1) {
            for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                int n3 = arrayList.get(i2);
                int n4 = -1;
                for (int i3 = i2; i3 < arrayList2.size() && (n4 = arrayList2.get(i3).intValue()) < n3; ++i3) {
                }
                if (n4 < n3) break;
                float f3 = this.meas.indexToFreq(n3);
                float f4 = this.meas.indexToFreq(n4);
                float f5 = this.meas.splRaw(f3) - this.meas.splRaw(f4);
                if (!(f5 > f2)) continue;
                n2 = n3;
                f2 = f5;
            }
        }
        return n2;
    }

    private void findMaxAndMinIndices(float[] fArray, ArrayList<Integer> arrayList, ArrayList<Integer> arrayList2, int n2) {
        for (int i2 = n2; i2 < fArray.length - n2 - 1; ++i2) {
            float f2 = fArray[i2];
            if (f2 >= 0.0f && fArray[i2 + 1] < 0.0f) {
                arrayList.add(this.getMeasIndex(i2));
                continue;
            }
            if (!(f2 <= 0.0f) || !(fArray[i2 + 1] > 0.0f)) continue;
            arrayList2.add(this.getMeasIndex(i2));
        }
    }

    private int getMeasIndex(int n2) {
        if (this.meas.isLogSpaced) {
            return (int)Math.round(this.meas.freqToIndex(this.meas.startFreq + this.meas.freqStep * (float)n2));
        }
        return n2;
    }

    float[] differentiate(float[] fArray) {
        int n2 = 9;
        int n3 = fArray.length;
        float[] fArray2 = new float[n3];
        float[] fArray3 = new float[9];
        this.initDiffFiltCoefficients(fArray3);
        for (int i2 = 4; i2 <= n3 - 1 - 4; ++i2) {
            float f2 = 0.0f;
            for (int i3 = 0; i3 < 9; ++i3) {
                f2 += fArray[i2 - 4 + i3] * fArray3[i3];
            }
            fArray2[i2] = f2;
        }
        return fArray2;
    }

    private void initDiffFiltCoefficients(float[] fArray) {
        fArray[0] = 0.0f;
        fArray[1] = 0.0f;
        fArray[2] = 1.0f / (12.0f * this.meas.freqStep);
        fArray[3] = -8.0f / (12.0f * this.meas.freqStep);
        fArray[4] = 0.0f;
        fArray[5] = -fArray[3];
        fArray[6] = -fArray[2];
        fArray[7] = -fArray[1];
        fArray[8] = -fArray[0];
    }

    private int findMinPostPeak(int n2, double d2) {
        float[] fArray = this.meas.getRawData();
        int n3 = n2;
        float f2 = Float.MAX_VALUE;
        int n4 = (int)Math.min((double)(this.meas.dataLength - 2), this.meas.freqToIndex(10000.0));
        for (int i2 = n2; i2 < n4; ++i2) {
            if (fArray[i2] < f2) {
                f2 = fArray[i2];
                n3 = i2;
            }
            if ((double)f2 < d2 / 2.0 && (double)fArray[i2] > d2) break;
        }
        return n3;
    }

    private float findF3(int n2, double d2) {
        float[] fArray = this.meas.getRawData();
        float f2 = (float)(Math.sqrt(2.0) * d2);
        for (int i2 = n2; i2 < this.meas.dataLength - 2; ++i2) {
            if (!(fArray[i2] > f2)) continue;
            float f3 = fArray[i2 - 1];
            float f4 = fArray[i2];
            float f5 = (float)i2 + (f2 - f3) / (f4 - f3);
            return this.meas.indexToFreq(f5);
        }
        return this.meas.endFreq;
    }

    private void analyseResponse() {
        if (this.parabolicFit == null || this.measMaxIndex == 0) {
            this.makeParabolicFit();
        }
        this.ZmaxMeas = this.parabolicFit.B();
        this.measMinIndex = this.findMinPostPeak(this.measMaxIndex, this.ZmaxMeas);
        this.ZminMeas = this.meas.splUnsmoothed(this.measMinIndex);
        this.ZminFreq = this.meas.indexToFreq(this.measMinIndex);
        this.f3 = this.findF3(this.measMinIndex, this.ZminMeas);
    }

    private void makeParabolicFit() {
        this.measMaxIndex = this.findResonantPeak();
        int n2 = this.measMaxIndex - 2;
        int n3 = this.measMaxIndex + 2;
        int n4 = n3 - n2 + 1;
        double[] dArray = new double[n4];
        double[] dArray2 = new double[n4];
        for (int i2 = 0; i2 < n4; ++i2) {
            dArray[i2] = this.meas.indexToFreq(n2 + i2);
            dArray2[i2] = this.meas.splUnsmoothed(n2 + i2);
        }
        this.parabolicFit = new ZB(dArray, dArray2);
    }

    double zParabolic(double d2) {
        if (this.parabolicFit == null || this.measMaxIndex == 0) {
            this.makeParabolicFit();
        }
        return this.parabolicFit.B(d2);
    }

    private boolean generateInitialEstimates(boolean bl) {
        this.generateInitialParamEstimates(this.parabolicFit.A());
        if (!bl) {
            if (this.hfFitStart > 0.0) {
                this.setupVoiceCoilInitialValues();
            } else {
                this.voiceCoil.clearValues();
                this.simpleModelVC.clearValues();
            }
        }
        return true;
    }

    private void generateInitialParamEstimates(double d2) {
        float f2 = (float)((this.ZmaxMeas - this.ZminMeas) * Math.sqrt(2.0) / 2.0 + this.ZminMeas);
        double d3 = this.meas.findLowerFractionalIndexOfZ(f2, this.measMaxIndex);
        double d4 = this.meas.findHigherFractionalIndexOfZ(f2, this.measMaxIndex);
        float f3 = this.meas.indexToFreq(d3);
        float f4 = this.meas.indexToFreq(d4);
        this.hfFitStart = this.checkHFFitPossible(this.ZminFreq, this.meas.endFreq);
        this.RE = this.RDC;
        this.motionalImpedance.initialise(d2, f2, f3, f4, this.RE, this.ZmaxMeas, this.isPrimary);
    }

    private void setupVoiceCoilInitialValues() {
        float f2 = Math.min(this.meas.endFreq - 1.0f, 20000.0f);
        double d2 = (double)(f2 * 2.0f) * Math.PI;
        double d3 = this.meas.splUnsmoothed(f2, 0.0f);
        double d4 = this.meas.phaseUnsmoothed(f2, 0.0f);
        double d5 = d4 * Math.PI / 180.0;
        double d6 = d3 * Math.cos(d5);
        double d7 = d3 * Math.sin(d5);
        double d8 = d6 - this.RE;
        double d9 = d7 / d2;
        switch (this.voiceCoil.getModel()) {
            case LR2: 
            case LR4: {
                this.voiceCoil.setLE(d9);
                float f3 = 1000.0f;
                if (this.meas.endFreq > f3) {
                    double d10 = (double)(f3 * 2.0f) * Math.PI;
                    double d11 = this.meas.splUnsmoothed(f3, 0.0f);
                    double d12 = (double)this.meas.phaseUnsmoothed(f3, 0.0f) * Math.PI / 180.0;
                    double d13 = d11 * Math.sin(d12) / d10 - d9;
                    this.voiceCoil.initRL(d8, d13);
                    break;
                }
                this.voiceCoil.initRL(d8, 2.0 * d9);
                break;
            }
            case TF: {
                this.voiceCoil.setdR((this.ZminMeas - this.RDC) / 20000.0);
                this.voiceCoil.setLeb(d9 / 2.0);
                this.voiceCoil.setLETF(5.0 * d9);
                this.voiceCoil.setRss(100.0 * d8);
                this.voiceCoil.setKe(200.0 * d9);
                if (this.voiceCoil.getdR() < 0.1) {
                    this.voiceCoil.setdR(0.1);
                }
                if (this.voiceCoil.getLeb() < 1.0E-6) {
                    this.voiceCoil.setLeb(1.0E-4);
                }
                if (this.voiceCoil.getLETF() < 1.0E-6) {
                    this.voiceCoil.setLETF(0.001);
                }
                if (this.voiceCoil.getKe() < 1.0E-4) {
                    this.voiceCoil.setKe(0.1);
                }
                if (!(this.voiceCoil.getRss() < 0.1)) break;
                this.voiceCoil.setRss(500.0);
                break;
            }
            case Leach: {
                this.voiceCoil.setN(0.65);
                this.voiceCoil.setK(0.03);
                break;
            }
            default: {
                assert (false) : "Unhandled optTarget in generateInitialEstimates";
                break;
            }
        }
    }

    private double checkHFFitPossible(double d2, double d3) {
        double d4 = d3 / d2;
        double d5 = d2;
        double d6 = 4.0;
        double d7 = 16.0;
        if (d4 < 4.0 && !this.hfWarningShown) {
            d5 = 0.0;
            JOptionPane.showMessageDialog(g.getDialogParent(), "There is not enough high frequency data to\n estimate the blocked impedance parameters,\nneed data to at least " + HE.I.format(d2 * 4.0) + " Hz, ideally\nbeyond " + HE.I.format(d2 * 16.0) + " Hz for accurate results.\n\nOnly the main resonance parameters will be\ncalculated (RES, LCES, CMES, RAMS)", "Insufficient HF data", 2);
            this.hfWarningShown = true;
        } else if (d4 < 16.0 && d2 < 1250.0 && !this.hfWarningShown) {
            JOptionPane.showMessageDialog(g.getDialogParent(), "There is not enough high frequency data to\n accurately estimate the blocked impedance\nparameters, measure to at least " + HE.I.format(d2 * 16.0) + " Hz for\naccurate results", "Insufficient HF data", 2);
            this.hfWarningShown = true;
        }
        return d5;
    }

    void generateSimpleModelEstimates() {
        float f2 = Math.min(this.meas.endFreq - 1.0f, 20000.0f);
        double d2 = (double)(f2 * 2.0f) * Math.PI;
        double d3 = this.meas.splUnsmoothed(f2, 0.0f);
        double d4 = this.meas.phaseUnsmoothed(f2, 0.0f);
        double d5 = d4 * Math.PI / 180.0;
        double d6 = d3 * Math.cos(d5);
        double d7 = d3 * Math.sin(d5);
        double d8 = d6 - this.RE;
        double d9 = d7 / d2;
        switch (this.simpleModelVC.getModel()) {
            case LR2: 
            case LR4: {
                this.simpleModelVC.setLE(d9);
                float f3 = 1000.0f;
                if (this.meas.endFreq > f3) {
                    double d10 = (double)(f3 * 2.0f) * Math.PI;
                    double d11 = this.meas.splUnsmoothed(f3, 0.0f);
                    double d12 = (double)this.meas.phaseUnsmoothed(f3, 0.0f) * Math.PI / 180.0;
                    double d13 = Math.max(d11 * Math.sin(d12) / d10 - d9, d9 / 10.0);
                    this.simpleModelVC.initRL(d8, d13);
                    break;
                }
                this.simpleModelVC.initRL(d8, 2.0 * d9);
                break;
            }
            case TF: {
                this.simpleModelVC.setdR(this.RE / 10.0);
                this.simpleModelVC.setLeb(d9 / 2.0);
                this.simpleModelVC.setLETF(5.0 * d9);
                this.simpleModelVC.setRss(100.0 * d8);
                this.simpleModelVC.setKe(200.0 * d9);
                break;
            }
            default: {
                assert (false) : "Unhandled model type in generateSimpleModelEstimates";
                break;
            }
        }
    }

    void optimiseSimpleModelParams() {
        if (this.hfFitStart > 0.0) {
            this.generateSimpleModelEstimates();
            this.optTarget = CC.G;
            this.initOptTarget(this.optTarget);
            int n2 = this.simpleModelVC.getParamCount();
            this.conversions = new HD[n2];
            Arrays.fill((Object[])this.conversions, (Object)HD.A);
            double[] dArray = new double[n2];
            Arrays.fill(dArray, 1.0);
            double[] dArray2 = new double[n2];
            double[] dArray3 = new double[2];
            double[] dArray4 = new double[n2];
            int[] nArray = CF.A(n2, dArray, this, false, dArray2, dArray3, dArray4, 150, -1);
            this.optimiseCompletion(this.optTarget, dArray2, false, false, true);
        }
    }

    void checkPeakFit() {
        float f2 = (float)(this.ZminMeas + (this.ZmaxMeas - this.ZminMeas) * 0.5);
        float f3 = this.meas.indexToFreq(this.meas.findFractionalIndexOfZ(f2, this.measMaxIndex, false));
        float f4 = this.meas.indexToFreq(this.meas.findFractionalIndexOfZ(f2, this.measMaxIndex, true));
        this.checkMotionalImpedanceFit(f3, f4);
    }

    private EK checkMotionalImpedanceFit(double d2, double d3) {
        Object object;
        double d4 = Math.min((double)this.meas.endFreq, d3);
        double d5 = Math.max((double)this.meas.startFreq, d2);
        int n2 = 48;
        double d6 = Math.pow(2.0, 0.020833333333333332);
        double d7 = 0.0;
        double d8 = 0.0;
        int n3 = 0;
        for (double d9 = d5; d9 <= d4; d9 *= d6) {
            object = this.zMeas(d9);
            double d10 = d9 * 2.0 * Math.PI;
            EK eK2 = this.getVoiceCoil().Z(d10);
            ((EK)object).B -= eK2.B + this.RDC;
            ((EK)object).A -= eK2.A;
            ((EK)object).C(this.ZM(d10));
            double d11 = EK.H((EK)object);
            d7 += d11;
            d8 += d11 * d11;
            ++n3;
        }
        EK eK3 = new EK(d7 / (double)n3, Math.sqrt(d8 / (double)n3));
        String string = " ohm";
        object = this.meas.getTitle() + (this.isPrimary ? " free air " : " ");
        System.out.println("Checked " + (String)object + this.motionalImpedance.getModel().title() + " fit over " + HE.U.format(d2) + " to " + HE.U.format(d3) + " Hz, mean abs error " + HE.A.format(eK3.B) + string + ", rms error " + HE.A.format(eK3.A) + string);
        return eK3;
    }

    void optimiseParams(TSParams tSParams, TSParams tSParams2) {
        boolean bl = false;
        if (this.generateInitialEstimates(false)) {
            double d2;
            double d3;
            boolean bl2;
            float f2 = this.meas.phase((float)this.parabolicFit.A(), 0.0f);
            float f3 = 145.0f;
            boolean bl3 = bl2 = f2 > 145.0f || f2 < -145.0f;
            if (bl2) {
                JOptionPane.showMessageDialog(g.getDialogParent(), "The phase at resonance for:\n" + this.meas.getTitle() + "\nis close to 180 degrees (" + HE.I.format(f2) + " degrees),\nthe input channels may be swapped.", "Input channels may be swapped", 2);
            }
            if (this.method == TSMethod.DUAL_ADDED_MASS) {
                this.dualAddedMassFit(tSParams, tSParams2);
            } else {
                switch (this.voiceCoil.getModel()) {
                    case Leach: {
                        this.voiceCoil.fitLeach(this, this.hfFitStart);
                        this.optTarget = CC.E;
                        this.initOptTarget(this.optTarget);
                        this.optimiseMotionalImpedanceFit(true, true);
                        break;
                    }
                    default: {
                        this.lsqminAllParams(true);
                    }
                }
            }
            this.optimiseSimpleModelParams();
            if (tSParams != null) {
                tSParams.setSimpleModelVC(this.getSimpleModelVC());
                tSParams.setRE(this.getRE());
            }
            if (tSParams2 != null) {
                tSParams2.setSimpleModelVC(this.getSimpleModelVC());
                tSParams2.setRE(this.getRE());
            }
            if ((d3 = Math.abs(1.0 - (d2 = this.motionalImpedance.getOmegaS() / (Math.PI * 2)) / this.parabolicFit.A())) > 0.2 && !bl2) {
                JOptionPane.showMessageDialog(g.getDialogParent(), "The curve fit resonant peak is far from the\ninitial estimate, results may not be valid.", "Results may not be valid", 2);
            }
            if (this.isPrimary) {
                // empty if block
            }
        }
    }

    void optimiseSecondaryFit(TSParams tSParams, boolean bl) {
        if (this.getMethod() == TSMethod.ADDED_MASS) {
            this.addedMassFit(tSParams);
        } else {
            tSParams.optimiseResonanceParams(this, bl);
        }
    }

    private void addedMassFit(TSParams tSParams) {
        this.mass1TS = tSParams;
        tSParams.analyseResponse();
        tSParams.generateInitialParamEstimates(tSParams.parabolicFit.A());
        this.addedMass = tSParams.addedMass;
        this.initOptTarget(CC.E);
        tSParams.optTarget = CC.E;
        tSParams.initOptTarget(tSParams.optTarget);
        this.optimiseMotionalImpedanceFits(tSParams, null);
        this.saveOptTargetArrays();
        this.optimiseVoiceCoilAnddR();
        this.restoreOptTargetArrays();
        this.optimiseMotionalImpedanceFits(tSParams, null);
        this.calcAddedMassParams(tSParams);
        this.calcCommonTSParams();
        tSParams.setVoiceCoil(this.getVoiceCoil());
        tSParams.setPrimaryValues(this);
        tSParams.getMotionalImpedance().recalcParams(this.getRE());
        tSParams.meas.setTSParams(tSParams, true);
        this.meas.setTSParams(this, false);
        this.disposeSavedOptTargetArrays();
        this.disposeOptTargetArrays();
    }

    private void dualAddedMassFit(TSParams tSParams, TSParams tSParams2) {
        double d2;
        Object object;
        int n2;
        this.mass1TS = tSParams;
        this.mass2TS = tSParams2;
        MeasData measData = tSParams.meas;
        MeasData measData2 = tSParams2.meas;
        tSParams.analyseResponse();
        tSParams.generateInitialParamEstimates(tSParams.parabolicFit.A());
        tSParams2.analyseResponse();
        tSParams2.generateInitialParamEstimates(tSParams2.parabolicFit.A());
        float f2 = Math.max(Math.max(this.meas.startFreq, measData.startFreq), measData2.startFreq);
        float f3 = Math.min(Math.max(this.meas.endFreq, measData.endFreq), measData2.endFreq);
        int n3 = (int)Math.max(this.meas.freqToIndex(f2), 0.0);
        int n4 = (int)this.meas.freqToIndex(f3);
        int n5 = n4 - n3 + 1;
        EK[] eKArray = new EK[n5];
        double[] dArray = new double[n5];
        double[] dArray2 = new double[n5];
        double[] dArray3 = new double[n5];
        this.addedMass = tSParams.addedMass;
        this.addedMass2 = tSParams2.addedMass;
        double d3 = this.addedMass2 / this.addedMass;
        double[] dArray4 = new double[n5];
        double d4 = Math.sqrt(this.addedMass * 0.001);
        for (int i2 = 0; i2 < n5; ++i2) {
            n2 = n3 + i2;
            EK eK2 = this.zMeasIndexed(n2);
            double d5 = this.meas.indexToFreq(n2);
            dArray4[i2] = d5 * 2.0 * Math.PI;
            object = EK.A(eK2, this.zMeas(measData, d5));
            EK eK3 = EK.A(eK2, this.zMeas(measData2, d5));
            eKArray[i2] = EK.A(EK.C((EK)object, eK3), 1.0 - d3).B(EK.A(eK3, EK.A((EK)object, d3)));
            dArray[i2] = eKArray[i2].B;
            dArray2[i2] = eKArray[i2].A;
            EK eK4 = EK.A(eKArray[i2], 0.0, Math.PI * 2 * d5).A(EK.A(eKArray[i2], (EK)object)).B((EK)object);
            d2 = Math.abs(eK4.B);
            dArray3[i2] = d2 > 0.0 ? Math.sqrt(d2) * d4 : 0.0;
        }
        if (this.meas.isLogSpaced) {
            this.ZMstarReal = new LogDataSet(this.meas.indexToFreq(n3), this.meas.ppo, dArray, Double.NaN);
            this.ZMstarImag = new LogDataSet(this.meas.indexToFreq(n3), this.meas.ppo, dArray2, Double.NaN);
            this.Bldata = new LogDataSet(this.meas.indexToFreq(n3), this.meas.ppo, dArray3, Double.NaN);
        } else {
            this.ZMstarReal = new LinearDataSet(this.meas.indexToFreq(n3), this.meas.freqStep, dArray, Double.NaN);
            this.ZMstarImag = new LinearDataSet(this.meas.indexToFreq(n3), this.meas.freqStep, dArray2, Double.NaN);
            this.Bldata = new LinearDataSet(this.meas.indexToFreq(n3), this.meas.freqStep, dArray3, Double.NaN);
        }
        int[] nArray = this.indicesForZmaxFactor(0.8, false);
        n2 = nArray[0];
        int n6 = nArray[1];
        int n7 = Math.max(n2 - n3, 0);
        int n8 = Math.min(n6 - n3, n5);
        object = lH.A(lH.A(dArray4, n7, n8), lH.A(dArray3, n7, n8));
        this.BlSlope = (double)object[1];
        this.BlOffset = (double)object[0];
        double d6 = this.parabolicFit.A();
        d2 = d6 * 2.0 * Math.PI;
        double d7 = this.BlSlope * d2 + this.BlOffset;
        int[] nArray2 = this.indicesForZmaxFactor(0.5, false);
        int n9 = nArray2[0];
        int n10 = nArray2[1];
        int n11 = n10 - n9 + 1;
        this.omegaVals = new double[n11];
        this.reals = new double[n11];
        this.imags = new double[n11];
        double[] dArray5 = new double[n5];
        this.weighting = new double[n11];
        Arrays.fill(this.weighting, 1.0);
        System.arraycopy(dArray4, n9 - n3, this.omegaVals, 0, n11);
        System.arraycopy(dArray, n9 - n3, this.reals, 0, n11);
        System.arraycopy(dArray2, n9 - n3, this.imags, 0, n11);
        int n12 = 0;
        double d8 = 0.0;
        for (int i3 = 0; i3 < n11; ++i3) {
            dArray5[i3] = lH.A(this.reals[i3], this.imags[i3]);
            if (!(dArray5[i3] > d8)) continue;
            d8 = dArray5[i3];
            n12 = i3;
        }
        if (n12 > 2 && n12 < n5 - 2) {
            ZB zB2 = new ZB(lH.A(this.omegaVals, n12 - 2, n12 + 2), lH.A(dArray5, n12 - 2, n12 + 2));
            double d9 = zB2.B();
            double d10 = zB2.A();
            this.motionalImpedance.setPeakOmega(d10);
        }
        this.saveOptTargetArrays();
        this.optTarget = CC.E;
        double[] dArray6 = new double[1];
        double[] dArray7 = this.motionalImpedance.fMinLimits(this.fixLCES);
        dArray6[0] = V.A(dArray7[0], dArray7[1], this, 1.0E-6);
        this.scaleParams(dArray6, null);
        double d11 = this.motionalImpedance.getOmegaS();
        this.Bl = this.BlSlope * d11 + this.BlOffset;
        this.MMS = this.getCMES() * this.Bl * this.Bl;
        this.optimiseVoiceCoilCalculateddR();
        this.restoreOptTargetArrays();
        this.optimiseMotionalImpedanceFits(tSParams, tSParams2);
        this.optimiseVoiceCoilAnddR();
        this.restoreOptTargetArrays();
        this.optimiseMotionalImpedanceFits(tSParams, tSParams2);
        this.calcAddedMassParams(tSParams);
        this.calcCommonTSParams();
        tSParams.setVoiceCoil(this.getVoiceCoil());
        tSParams.setPrimaryValues(this);
        tSParams.getMotionalImpedance().recalcParams(this.getRE());
        tSParams.meas.setTSParams(tSParams, true);
        tSParams2.setVoiceCoil(this.getVoiceCoil());
        tSParams2.setPrimaryValues(this);
        tSParams2.getMotionalImpedance().recalcParams(this.getRE());
        tSParams2.meas.setTSParams(tSParams2, true);
        this.meas.setTSParams(this, false);
        d11 = this.motionalImpedance.getOmegaS();
        this.Bl = this.BlSlope * d11 + this.BlOffset;
        this.MMS = this.getCMES() * this.Bl * this.Bl;
        this.disposeSavedOptTargetArrays();
        this.disposeOptTargetArrays();
    }

    private void disposeOptTargetArrays() {
        this.omegaVals = null;
        this.reals = null;
        this.imags = null;
    }

    private void optimiseMotionalImpedanceFits(TSParams tSParams, TSParams tSParams2) {
        tSParams.setVoiceCoil(this.getVoiceCoil());
        tSParams.setPrimaryValues(this);
        tSParams.initOptTarget(CC.E);
        tSParams.fixLCES = true;
        if (tSParams2 != null) {
            tSParams.getMotionalImpedance().setParam(ModelParameter.CMES, (this.MMS + 0.001 * tSParams.addedMass) / (this.Bl * this.Bl));
            tSParams2.setVoiceCoil(this.getVoiceCoil());
            tSParams2.setPrimaryValues(this);
            tSParams2.initOptTarget(CC.E);
            tSParams2.getMotionalImpedance().setParam(ModelParameter.CMES, (this.MMS + 0.001 * tSParams2.addedMass) / (this.Bl * this.Bl));
            tSParams2.fixLCES = true;
        }
        this.optTarget = CC.D;
        double d2 = this.motionalImpedance.getParam(ModelParameter.BETA);
        double[] dArray = new double[]{V.A(d2 * 0.9, d2 * 1.1, this, 1.0E-6)};
        this.scaleParams(dArray, null);
        if (tSParams2 != null) {
            this.MMS = this.getCMES() * this.Bl * this.Bl;
            tSParams.getMotionalImpedance().setParam(ModelParameter.CMES, (this.MMS + 0.001 * tSParams.addedMass) / (this.Bl * this.Bl));
            tSParams2.getMotionalImpedance().setParam(ModelParameter.CMES, (this.MMS + 0.001 * tSParams2.addedMass) / (this.Bl * this.Bl));
        }
    }

    private void saveOptTargetArrays() {
        this.savedOmegaVals = Arrays.copyOf(this.omegaVals, this.omegaVals.length);
        this.savedReals = Arrays.copyOf(this.reals, this.omegaVals.length);
        this.savedImags = Arrays.copyOf(this.imags, this.omegaVals.length);
        this.savedWeighting = Arrays.copyOf(this.weighting, this.omegaVals.length);
    }

    private void restoreOptTargetArrays() {
        this.omegaVals = this.savedOmegaVals;
        this.reals = this.savedReals;
        this.imags = this.savedImags;
        this.weighting = this.savedWeighting;
    }

    private void disposeSavedOptTargetArrays() {
        this.savedOmegaVals = null;
        this.savedReals = null;
        this.savedImags = null;
        this.savedWeighting = null;
    }

    private void optimiseVoiceCoilCalculateddR() {
        boolean bl = false;
        boolean bl2 = true;
        this.getVoiceCoil().forcedRToZero(bl);
        this.getVoiceCoil().calculatedR(bl2);
        int n2 = 20;
        boolean bl3 = true;
        this.optTarget = CC.C;
        this.initOptTarget(this.optTarget);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (bl2 && this.isPrimary) {
                double d2 = this.getVoiceCoil().getdR();
                double d3 = this.calculatedR();
                this.getVoiceCoil().setdR(d3);
                bl3 = Math.abs(d2 - d3) < 0.001;
            }
            this.optimiseVoiceCoilFit(false);
            if (bl3) break;
        }
        double d4 = this.voiceCoil.getdR();
        double d5 = this.voiceCoil.getLETF();
        while (d5 > 0.099) {
            this.voiceCoil.setdR(d4 += 0.01);
            this.voiceCoil.setLETF(0.001);
            this.optimiseVoiceCoilFit(false);
            d5 = this.voiceCoil.getLETF();
        }
        this.disposeOptTargetArrays();
        double d6 = Math.max(this.meas.startFreq, 10.0f);
        double d7 = 2.0 * this.parabolicFit.A();
        this.checkImpedanceFit(d6, d7, false, false);
        this.meas.tsParamsUpdated();
        if (this.isPrimary && !this.getVoiceCoil().dRIsForcedToZero()) {
            this.checkDCR();
        }
    }

    private void optimiseVoiceCoilAnddR() {
        double d2;
        double d3;
        this.getVoiceCoil().forcedRToZero(false);
        this.getVoiceCoil().calculatedR(false);
        this.optTarget = CC.C;
        this.initOptTarget(this.optTarget);
        this.optimiseVoiceCoilFit(false);
        if (!this.getVoiceCoil().dRIsForcedToZero()) {
            double d4;
            this.getVoiceCoil().calculatedR(true);
            d3 = this.voiceCoil.getdR();
            d2 = this.voiceCoil.getLETF();
            while (d2 > 0.099) {
                this.voiceCoil.setdR(d3 += 0.05);
                this.voiceCoil.setLETF(0.001);
                this.optimiseVoiceCoilFit(false);
                d2 = this.voiceCoil.getLETF();
            }
            SI._A _A2 = new SI._A(){

                @Override
                public double A(double d2) {
                    TSParams.this.voiceCoil.setdR(d2);
                    TSParams.this.optimiseVoiceCoilFit(false);
                    return TSParams.this.voiceCoilLFFit(false);
                }
            };
            double d5 = 0.01;
            this.optimiseVoiceCoilFit(false);
            double d6 = _A2.A(d3 - d5);
            double d7 = _A2.A(d3 + d5);
            double d8 = d4 = _A2.A(d3);
            if (d6 < d4 || d7 < d4) {
                double d9;
                int n2 = d6 < d7 ? -1 : 1;
                double d10 = 0.1;
                do {
                    d9 = d8;
                    d3 = this.voiceCoil.getdR();
                    this.voiceCoil.setdR(d3 + (double)n2 * d10);
                    this.optimiseVoiceCoilFit(false);
                } while ((d8 = this.voiceCoilLFFit(false)) < d9);
                double[] dArray = SI.A(_A2, d3, d3 + (double)n2 * d10, 0.01);
                double d11 = dArray[0];
                double d12 = _A2.A(d11);
                for (double d13 = dArray[0]; d13 <= dArray[1]; d13 += 0.001) {
                    double d14 = _A2.A(d13);
                    if (!(d14 < d12)) continue;
                    d12 = d14;
                    d11 = d13;
                }
                this.voiceCoil.setdR(d11);
            }
        }
        this.disposeOptTargetArrays();
        this.voiceCoilLFFit(false);
        d3 = Math.max(this.meas.startFreq, 10.0f);
        d2 = Math.min(2.0 * this.parabolicFit.A(), (double)this.meas.endFreq);
        this.checkImpedanceFit(d3, d2, false, false);
        this.meas.tsParamsUpdated();
        if (this.isPrimary && !this.getVoiceCoil().dRIsForcedToZero()) {
            this.checkDCR();
        }
    }

    private double voiceCoilLFFit(boolean bl) {
        double d2 = 0.0;
        double d3 = Math.max(this.meas.startFreq, 10.0f);
        double d4 = Math.min(3.0 * this.parabolicFit.A(), (double)this.meas.endFreq);
        double d5 = Math.pow(2.0, 0.010416666666666666);
        int n2 = 0;
        for (double d6 = d3; d6 < d4; d6 *= d5) {
            double d7 = d6 * 2.0 * Math.PI;
            double d8 = EK.H(this.Ztotal(d7).C(this.zMeas(d6)));
            d2 += d8 * d8;
            ++n2;
        }
        if (bl) {
            System.out.println("Average error for dr = " + HE.O.format(this.voiceCoil.getdR()) + " is " + HE.O.format(d2 / (double)n2) + " over " + n2 + " points from " + HE.U.format(d3) + " to " + HE.U.format(d4));
        }
        return d2;
    }

    private int[] indicesForZmaxFactor(double d2, boolean bl) {
        float f2 = (float)(this.ZminMeas + (this.ZmaxMeas - this.ZminMeas) * d2);
        double d3 = this.meas.indexToFreq(this.meas.findFractionalIndexOfZ(f2, this.measMaxIndex, false));
        if (d3 < 10.0) {
            d3 = 10.0;
        }
        int n2 = (int)Math.max(this.meas.freqToIndex(d3), 0.0);
        int n3 = (int)this.meas.findFractionalIndexOfZ(f2, this.measMaxIndex, true);
        d3 = this.meas.indexToFreq(n2);
        double d4 = this.meas.indexToFreq(n3);
        double d5 = this.parabolicFit.A();
        double d6 = d3 / d5;
        double d7 = d4 / d5;
        double d8 = Math.log(d4 / d3) / Math.log(2.0);
        if (bl) {
            System.out.println("For factor " + HE.K.format(d2) + " Z is " + HE.K.format(f2) + " ohm, the range is " + HE.K.format(d3) + " to " + HE.K.format(d4) + " Hz, " + HE.K.format(d6) + " to " + HE.K.format(d7) + " times fs of " + HE.K.format(d5) + " Hz, " + HE.K.format(d8) + " octaves");
        }
        return new int[]{n2, n3};
    }

    void optimiseResonanceParams(TSParams tSParams, boolean bl) {
        this.setVoiceCoil(tSParams.getVoiceCoil());
        if (bl) {
            this.setPrimaryValues(tSParams);
        }
        if (this.generateInitialEstimates(true)) {
            if (bl) {
                for (ModelParameter modelParameter : this.motionalImpedance.getModel().getParams()) {
                    if (modelParameter == ModelParameter.CMES) continue;
                    this.motionalImpedance.setParam(modelParameter, tSParams.getMotionalImpedance().getParam(modelParameter));
                }
            }
            this.fixLCES = bl;
            this.optTarget = CC.E;
            this.initOptTarget(this.optTarget);
            this.optimiseMotionalImpedanceFit(true, true);
        }
    }

    private double optimiseMotionalImpedanceFit(boolean bl, boolean bl2) {
        double d2;
        int n2 = this.motionalImpedance.getOptimiserParamCount();
        double[] dArray = new double[n2];
        if (n2 == 1) {
            double[] dArray2 = this.motionalImpedance.fMinLimits(this.fixLCES);
            dArray[0] = V.A(dArray2[0], dArray2[1], this, 1.0E-6);
            d2 = this.f_to_minimize(dArray[0]);
        } else {
            this.conversions = new HD[n2];
            Arrays.fill((Object[])this.conversions, (Object)HD.A);
            double[] dArray3 = new double[n2];
            Arrays.fill(dArray3, 1.0);
            double[] dArray4 = new double[2];
            double[] dArray5 = new double[n2];
            int[] nArray = CF.A(n2, dArray3, this, false, dArray, dArray4, dArray5, 150, -1);
            d2 = dArray4[0];
        }
        this.optimiseCompletion(this.optTarget, dArray, false, bl, bl2);
        return d2;
    }

    private void optimiseVoiceCoilFit(boolean bl) {
        int n2 = this.voiceCoil.getParamCount();
        this.conversions = new HD[n2];
        Arrays.fill((Object[])this.conversions, (Object)HD.A);
        if (this.voiceCoil.getModel().isTFModel()) {
            this.conversions[3] = HD.E;
        }
        double[] dArray = new double[n2];
        Arrays.fill(dArray, 1.0);
        double[] dArray2 = new double[n2];
        double[] dArray3 = new double[2];
        double[] dArray4 = new double[n2];
        int[] nArray = CF.A(n2, dArray, this, false, dArray2, dArray3, dArray4, 150, -1);
        this.optimiseCompletion(this.optTarget, dArray2, false, bl, false);
    }

    private void lsqminAllParams(boolean bl) {
        boolean bl2 = false;
        boolean bl3 = true;
        this.getVoiceCoil().forcedRToZero(bl2);
        this.getVoiceCoil().calculatedR(bl3);
        int n2 = 20;
        double d2 = 1.0E-4;
        double[] dArray = this.motionalImpedance.paramValues();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (bl) {
                this.optTarget = CC.E;
                this.initOptTarget(this.optTarget);
                this.optimiseMotionalImpedanceFit(false, true);
            }
            double[] dArray2 = this.motionalImpedance.paramValues();
            boolean bl4 = true;
            for (int i3 = 0; i3 < dArray2.length; ++i3) {
                if (dArray2[i3] == 0.0) continue;
                bl4 &= Math.abs(1.0 - dArray[i3] / dArray2[i3]) < 1.0E-4;
            }
            dArray = dArray2;
            if (bl3 && this.isPrimary) {
                double d3 = this.getVoiceCoil().getdR();
                double d4 = this.calculatedR();
                this.getVoiceCoil().setdR(d4);
                bl4 &= Math.abs(d3 - d4) < 0.001;
            }
            this.optTarget = CC.C;
            this.initOptTarget(this.optTarget);
            this.optimiseVoiceCoilFit(false);
            if (bl4) break;
        }
        this.getVoiceCoil().calculatedR(true);
        double d5 = this.voiceCoil.getdR();
        double d6 = this.voiceCoil.getLETF();
        while (d6 > 0.099) {
            this.voiceCoil.setdR(d5 += 0.01);
            this.voiceCoil.setLETF(0.001);
            this.optimiseVoiceCoilFit(false);
            d6 = this.voiceCoil.getLETF();
        }
        this.disposeOptTargetArrays();
        double d7 = Math.max(this.meas.startFreq, 10.0f);
        double d8 = 2.0 * this.parabolicFit.A();
        this.checkImpedanceFit(d7, d8, false, false);
        this.meas.tsParamsUpdated();
        if (this.isPrimary && !this.getVoiceCoil().dRIsForcedToZero()) {
            this.checkDCR();
        }
    }

    private double calculatedR() {
        double d2 = Math.max(this.meas.startFreq, 10.0f);
        int n2 = (int)Math.max(Math.round(this.meas.freqToIndex(d2)), 0L);
        int n3 = (int)Math.round(this.meas.freqToIndex(Math.max(this.parabolicFit.A() / 2.0, d2 * 1.5)));
        int n4 = n3 - n2;
        if (n4 <= 0) {
            return 0.0;
        }
        float f2 = 0.0f;
        for (int i2 = n2; i2 < n3; ++i2) {
            EK eK2 = this.zMeasIndexed(i2);
            double d3 = (double)(this.meas.indexToFreq(i2) * 2.0f) * Math.PI;
            EK eK3 = this.ZM(d3);
            f2 = (float)((double)f2 + (eK2.B - this.RDC - eK3.B));
        }
        return f2 / (float)n4;
    }

    void optimiseCompletion(CC cC2, double[] dArray, boolean bl, boolean bl2, boolean bl3) {
        if (bl3) {
            this.disposeOptTargetArrays();
        }
        switch (cC2) {
            case C: {
                this.getVoiceCoil().scaleParams(dArray, this.conversions);
                this.RE = this.voiceCoil.getModel().isTFModel() ? this.RDC + this.voiceCoil.getdR() : this.RDC;
                this.meas.setTSParams(this, bl2);
                if (!bl || this.getVoiceCoil().dRIsForcedToZero()) break;
                this.checkDCR();
                break;
            }
            case G: {
                this.getSimpleModelVC().scaleParams(dArray, this.conversions);
                this.meas.setTSParams(this, bl2);
                this.meas.tsSimpleParamsUpdated();
                break;
            }
            case E: {
                this.scaleParams(dArray, this.conversions);
                this.meas.setTSParams(this, bl2);
                break;
            }
            case A: {
                this.scaleParams(dArray, this.conversions);
                this.meas.setTSParams(this, bl2);
                break;
            }
            default: {
                assert (false) : "Unhandled OptTargets type in optimiseCompletion: " + (Object)((Object)cC2);
                break;
            }
        }
    }

    private void checkDCR() {
    }

    void scaleParams(double[] dArray, HD[] hDArray) {
        this.RE = this.voiceCoil.getModel().isTFModel() ? this.RDC + this.voiceCoil.getdR() : this.RDC;
        this.motionalImpedance.scaleParams(dArray, hDArray, this.RE, this.fixLCES);
    }

    int getParamCount() {
        return this.motionalImpedance.getOptimiserParamCount() + this.voiceCoil.getParamCount();
    }

    void initOptTarget(CC cC2) {
        double d2;
        double d3;
        int n2;
        double d4;
        boolean bl = false;
        int n3 = 96;
        boolean bl2 = true;
        boolean bl3 = false;
        double d5 = 1.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = Math.min(this.meas.endFreq, 10000.0f);
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 96;
        int n8 = 96;
        double d10 = this.hfFitStart;
        int[] nArray = this.indicesForZmaxFactor(0.9, false);
        int n9 = nArray[0];
        int n10 = nArray[1];
        boolean bl4 = false;
        switch (cC2) {
            case C: 
            case G: {
                float f2 = (float)(this.ZminMeas + (this.ZmaxMeas - this.ZminMeas) * 0.1);
                d4 = this.meas.indexToFreq(this.meas.findFractionalIndexOfZ(f2, this.measMaxIndex, false));
                if (d4 < 10.0) {
                    d4 = 10.0;
                }
                double d11 = Math.log(d9 / d4) / Math.log(2.0);
                n2 = (int)(d11 * 96.0 + 0.5);
                d2 = d3 = Math.pow(2.0, 0.010416666666666666);
                break;
            }
            case E: 
            case A: {
                bl4 = true;
                int[] nArray2 = this.indicesForZmaxFactor(0.5, false);
                n5 = nArray2[0];
                n6 = nArray2[1];
                d4 = this.meas.indexToFreq(n5);
                n2 = n4 = n6 - n5 + 1;
                d2 = Math.pow(2.0, 0.010416666666666666);
                d3 = 0.0;
                break;
            }
            default: {
                assert (false) : "Unhandled OptTargets type in initOptTarget: " + (Object)((Object)cC2);
                n2 = 0;
                d4 = 0.0;
                d3 = 1.0;
                d2 = 1.0;
            }
        }
        this.omegaVals = new double[n2];
        this.reals = new double[n2];
        this.imags = new double[n2];
        this.weighting = new double[n2];
        Arrays.fill(this.weighting, 1.0);
        if (n6 == 0) {
            double d12 = d4;
            for (int i2 = 0; i2 < n2; ++i2) {
                double d13;
                if (i2 == n4) {
                    d12 = d10;
                }
                this.omegaVals[i2] = d13 = d12 * Math.PI * 2.0;
                double d14 = this.meas.splUnsmoothed((float)d12, 0.0f);
                double d15 = this.meas.phaseUnsmoothed((float)d12, 0.0f);
                double d16 = d15 * Math.PI / 180.0;
                this.reals[i2] = d14 * Math.cos(d16);
                this.imags[i2] = d14 * Math.sin(d16);
                if (bl4) {
                    EK eK2 = this.getVoiceCoil().Z(d13);
                    int n11 = i2;
                    this.reals[n11] = this.reals[n11] - (eK2.B + this.RDC);
                    int n12 = i2;
                    this.imags[n12] = this.imags[n12] - eK2.A;
                }
                d12 = d12 >= d10 ? (d12 *= d3) : (d12 *= d2);
                if (!(d12 > d9)) continue;
                d12 = d9;
            }
        } else {
            double d17;
            double d18;
            int n13 = 0;
            for (int i3 = n5; i3 <= n6; ++i3) {
                double d19;
                this.omegaVals[n13] = d19 = (double)this.meas.indexToFreq(i3) * Math.PI * 2.0;
                double d20 = this.meas.splUnsmoothed(i3);
                d18 = this.meas.phaseUnsmoothed(i3);
                d17 = d18 * Math.PI / 180.0;
                this.reals[n13] = d20 * Math.cos(d17);
                this.imags[n13] = d20 * Math.sin(d17);
                if (bl4) {
                    EK eK3 = this.getVoiceCoil().Z(d19);
                    int n14 = n13;
                    this.reals[n14] = this.reals[n14] - (eK3.B + this.RDC);
                    int n15 = n13;
                    this.imags[n15] = this.imags[n15] - eK3.A;
                }
                ++n13;
            }
            Arrays.fill(this.weighting, n9 - n5, n10 - n5, 1.0);
            double d21 = (this.ZmaxMeas - this.ZminMeas) * 0.1;
            double d22 = d6;
            boolean bl5 = false;
            while (n13 < n2) {
                double d23;
                this.omegaVals[n13] = d18 = d22 * Math.PI * 2.0;
                d17 = this.meas.splUnsmoothed((float)d22, 0.0f);
                double d24 = this.meas.phaseUnsmoothed((float)d22, 0.0f);
                double d25 = d24 * Math.PI / 180.0;
                this.reals[n13] = d17 * Math.cos(d25);
                this.imags[n13] = d17 * Math.sin(d25);
                if (bl4) {
                    EK eK4 = this.getVoiceCoil().Z(d18);
                    int n16 = n13;
                    this.reals[n16] = this.reals[n16] - (eK4.B + this.RDC);
                    int n17 = n13;
                    this.imags[n17] = this.imags[n17] - eK4.A;
                }
                if ((d23 = d17 - this.ZminMeas) < 0.0) {
                    d23 = -d23;
                }
                if (d23 > d21) {
                    d23 = d21;
                }
                this.weighting[n13] = 1.0 + 2.0 * (1.0 - d23 / d21);
                if (d22 >= d7 && !bl5) {
                    d22 = d8;
                    bl5 = true;
                } else {
                    d22 *= d3;
                }
                ++n13;
            }
        }
    }

    EK zMeas(MeasData measData, double d2) {
        double d3 = measData.splUnsmoothed((float)d2, 0.0f);
        double d4 = measData.phaseUnsmoothed((float)d2, 0.0f);
        double d5 = d4 * Math.PI / 180.0;
        return new EK(d3 * Math.cos(d5), d3 * Math.sin(d5));
    }

    EK zMeas(double d2) {
        return this.zMeas(this.meas, d2);
    }

    EK zMeasIndexed(int n2) {
        double d2 = this.meas.splUnsmoothed(n2);
        double d3 = this.meas.phaseUnsmoothed(n2);
        double d4 = d3 * Math.PI / 180.0;
        return new EK(d2 * Math.cos(d4), d2 * Math.sin(d4));
    }

    EK checkImpedanceFit(double d2, double d3, boolean bl, boolean bl2) {
        double d4 = Math.min((double)this.meas.endFreq, d3);
        double d5 = Math.max((double)this.meas.startFreq, d2);
        int n2 = 48;
        double d6 = Math.pow(2.0, 0.020833333333333332);
        double d7 = 0.0;
        double d8 = 0.0;
        int n3 = 0;
        for (double d9 = d5; d9 <= d4; d9 *= d6) {
            double d10;
            double d11 = this.meas.splUnsmoothed((float)d9, 0.0f);
            double d12 = EK.H(this.Ztotal(d9 * (Math.PI * 2)));
            double d13 = d10 = bl ? 10.0 * Math.log10(d12 / d11) : d12 - d11;
            if (d10 < 0.0) {
                d10 = -d10;
            }
            d7 += d10;
            d8 += d10 * d10;
            ++n3;
        }
        EK eK2 = new EK(d7 / (double)n3, Math.sqrt(d8 / (double)n3));
        if (bl2) {
            String string = bl ? " dB" : " ohm";
            System.out.println(">>>> Checked fit over " + HE.U.format(d5) + " to " + HE.U.format(d4) + ", " + n3 + " points, mean abs error " + HE.A.format(eK2.B) + string + ", rms error " + HE.A.format(eK2.A) + string);
        }
        return eK2;
    }

    double simpleModelFit(double[] dArray, HD[] hDArray) {
        double d2 = 0.0;
        double[] dArray2 = this.simpleModelVC.getValues();
        this.simpleModelVC.scaleParams(dArray, hDArray);
        int n2 = this.omegaVals.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            EK eK2 = this.simpleModelVC.Z(this.omegaVals[i2]);
            eK2.I(this.ZM(this.omegaVals[i2]));
            eK2.B += this.RE;
            double d3 = this.reals[i2] - eK2.B;
            double d4 = this.imags[i2] - eK2.A;
            d2 += d3 * d3 + d4 * d4;
        }
        this.simpleModelVC.setValues(dArray2);
        return d2;
    }

    @Override
    public double f_to_minimize(double[] dArray) {
        double[] dArray2 = new double[dArray.length - 1];
        System.arraycopy(dArray, 1, dArray2, 0, dArray.length - 1);
        switch (this.optTarget) {
            case C: {
                return this.voiceCoilFit(dArray2, this.conversions);
            }
            case G: {
                return this.simpleModelFit(dArray2, this.conversions);
            }
            case E: {
                return this.modelLFFit(dArray2, this.conversions);
            }
            case A: {
                return this.modelCMESFit(dArray2, this.conversions);
            }
        }
        assert (false) : "Unhandled optTarget in f_to_minimize: " + (Object)((Object)this.optTarget);
        return 0.0;
    }

    @Override
    public double f_to_minimize(double d2) {
        switch (this.optTarget) {
            case E: {
                return this.modelLFFit(d2);
            }
            case A: {
                return this.modelCMESFit(d2);
            }
            case D: {
                double d3 = this.motionalImpedance.fitNewValue(d2, this.RE, this.omegaVals, this.reals, this.imags, this.weighting);
                if (this.mass2TS != null) {
                    d3 += this.copyParamValuesAndCalculateFit(this.mass2TS);
                }
                return d3 += this.copyParamValuesAndCalculateFit(this.mass1TS);
            }
        }
        assert (false) : "Unhandled optTarget in Fmin f_to_minimize: " + (Object)((Object)this.optTarget);
        return 0.0;
    }

    private double copyParamValuesAndCalculateFit(TSParams tSParams) {
        tSParams.setPrimaryValues(this);
        tSParams.getMotionalImpedance().recalcParams(this.getRE());
        if (this.getMethod() == TSMethod.DUAL_ADDED_MASS) {
            return tSParams.modelLFFit((this.getCMES() * this.Bl * this.Bl + 0.001 * tSParams.addedMass) / (this.Bl * this.Bl));
        }
        return tSParams.optimiseMotionalImpedanceFit(false, false);
    }

    @Override
    public void gradient(double[] dArray, double[] dArray2) {
    }

    @Override
    public void hessian(double[] dArray, double[][] dArray2) {
    }

    double voiceCoilFit(double[] dArray, HD[] hDArray) {
        double d2 = 0.0;
        double[] dArray2 = this.voiceCoil.getValues();
        this.voiceCoil.scaleParams(dArray, hDArray);
        int n2 = this.omegaVals.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            EK eK2 = this.voiceCoil.Z(this.omegaVals[i2]);
            eK2.I(this.ZM(this.omegaVals[i2]));
            eK2.B += this.RDC;
            double d3 = this.reals[i2] - eK2.B;
            double d4 = this.imags[i2] - eK2.A;
            d2 += d3 * d3 + d4 * d4;
        }
        this.voiceCoil.setValues(dArray2);
        if (this.voiceCoil.getModel() == LossyInductor.Models.TF && this.voiceCoil.getLETF() > 0.099) {
            d2 *= 10.0;
        }
        return d2;
    }

    double modelLFFit(double[] dArray, HD[] hDArray) {
        this.RE = this.getVoiceCoil().getModel().isTFModel() ? this.RDC + this.getVoiceCoil().getdR() : this.RDC;
        return this.motionalImpedance.modelFit(dArray, hDArray, this.fixLCES, this.RE, this.omegaVals, this.reals, this.imags, this.weighting);
    }

    double modelCMESFit(double[] dArray, HD[] hDArray) {
        this.RE = this.getVoiceCoil().getModel().isTFModel() ? this.RDC + this.getVoiceCoil().getdR() : this.RDC;
        return this.motionalImpedance.modelFit(dArray, hDArray, true, this.RE, this.omegaVals, this.reals, this.imags, this.weighting);
    }

    double modelLFFit(double d2) {
        this.RE = this.getVoiceCoil().getModel().isTFModel() ? this.RDC + this.getVoiceCoil().getdR() : this.RDC;
        return this.motionalImpedance.modelFit(d2, this.fixLCES, this.RE, this.omegaVals, this.reals, this.imags, this.weighting);
    }

    double modelCMESFit(double d2) {
        this.RE = this.getVoiceCoil().getModel().isTFModel() ? this.RDC + this.getVoiceCoil().getdR() : this.RDC;
        return this.motionalImpedance.modelFit(d2, true, this.RE, this.omegaVals, this.reals, this.imags, this.weighting);
    }

    EK Ztotal(double d2) {
        EK eK2 = this.ZE(d2);
        eK2.I(this.ZM(d2));
        return eK2;
    }

    EK ZE(double d2) {
        EK eK2 = new EK(this.RDC, 0.0);
        eK2.I(this.voiceCoil.Z(d2));
        return eK2;
    }

    EK ZM(double d2) {
        return this.motionalImpedance.ZM(d2);
    }

    void print() {
        System.out.println(this.motionalImpedance);
        System.out.println(this.voiceCoil);
    }

    private double[] parabolicFit(int n2, int n3) {
        int n4 = n3 - n2 + 1;
        double[] dArray = new double[n4];
        double[] dArray2 = new double[n4];
        for (int i2 = 0; i2 < n4; ++i2) {
            dArray[i2] = this.meas.indexToFreq(n2 + i2);
            dArray2[i2] = this.meas.splUnsmoothed(n2 + i2);
        }
        this.faPara = dArray[0];
        double d2 = dArray[dArray.length - 1];
        this.factorPara = 1.0 / Math.log(d2 / this.faPara);
        for (int i3 = 0; i3 < n4; ++i3) {
            dArray[i3] = this.factorPara * Math.log(dArray[i3] / this.faPara);
        }
        double d3 = dArray2[0];
        double d4 = 0.0;
        double d5 = 0.0;
        for (int i4 = 1; i4 < n4; ++i4) {
            double d6 = dArray2[i4];
            d3 += d6;
            d4 += (d6 *= dArray[i4]);
            d5 += (d6 *= dArray[i4]);
        }
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        for (int i5 = 1; i5 < n4; ++i5) {
            double d7 = dArray[i5];
            f2 = (float)((double)f2 + d7);
            f3 = (float)((double)f3 + (d7 *= dArray[i5]));
            f4 = (float)((double)f4 + (d7 *= dArray[i5]));
            f5 = (float)((double)f5 + (d7 *= dArray[i5]));
        }
        double[][] dArrayArray = new double[][]{{n4, f2, f3}, {f2, f3, f4}, {f3, f4, f5}};
        ZJ zJ2 = new ZJ(dArrayArray);
        double[] dArray3 = zJ2.A(new double[]{d3, d4, d5});
        return dArray3;
    }

    String formattedSt() {
        double d2 = this.motionalImpedance.getQMS();
        double d3 = this.motionalImpedance.getQES();
        double d4 = this.motionalImpedance.getQTS();
        double d5 = this.motionalImpedance.getOmegaS() / (Math.PI * 2);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<table align=\"left\" valign=\"bottom\" cellpadding=\"2\">");
        stringBuilder.append("<tr>");
        stringBuilder.append("<td>R<sub>E</sub></td><td align=\"center\">").append(HE.A.format(this.RE)).append("</td><td>ohm</td>");
        stringBuilder.append("<td width=\"40\"></td>");
        stringBuilder.append("<td>f<sub>S</sub></td><td align=\"center\">").append(HE.U.format(d5)).append("</td><td>Hz</td>");
        stringBuilder.append("<td width=\"40\"></td>");
        if (this.MMS != 0.0) {
            stringBuilder.append("<<td>M<sub>MS</sub></td><td align=\"center\">").append(HE.K.format(1000.0 * this.MMS)).append("</td><td>g</td>");
        }
        stringBuilder.append("</tr>");
        stringBuilder.append("<tr>");
        stringBuilder.append("<td>Z<sub>min</sub></td><td align=\"center\">").append(HE.A.format(this.ZminMeas)).append("</td><td>ohm</td>");
        stringBuilder.append("<td width=\"40\"></td>");
        stringBuilder.append("<td>Q<sub>MS</sub></td><td align=\"center\">").append(HE.A.format(d2)).append("</td><td></td>");
        stringBuilder.append("<td width=\"40\"></td>");
        if (this.MMS != 0.0) {
            stringBuilder.append("<td>C<sub>MS</sub></td><td align=\"center\">").append(HE.A.format(1000.0 * this.CMS)).append("</td><td>mm/N</td>");
        }
        stringBuilder.append("</tr>");
        stringBuilder.append("<tr>");
        stringBuilder.append("<td>f<sub>min</sub></td><td align=\"center\">").append(HE.I.format(this.ZminFreq)).append("</td><td>Hz</td>");
        stringBuilder.append("<td width=\"40\"></td>");
        stringBuilder.append("<td>Q<sub>ES</sub></td><td align=\"center\">").append(HE.A.format(d3)).append("</td><td></td>");
        stringBuilder.append("<td width=\"40\"></td>");
        if (this.MMS != 0.0) {
            stringBuilder.append("<td>R<sub>MS</sub></td><td align=\"center\">").append(HE.A.format(this.RMS)).append("</td><td>kg/s</td>");
        }
        stringBuilder.append("</tr>");
        stringBuilder.append("<tr>");
        stringBuilder.append("<td>f<sub>3</sub></td><td align=\"center\">").append(HE.I.format(this.f3)).append("</td><td>Hz</td>");
        stringBuilder.append("<td width=\"40\"></td>");
        stringBuilder.append("<td>Q<sub>TS</sub></td><td align=\"center\">").append(HE.A.format(d4)).append("</td><td></td>");
        stringBuilder.append("<td width=\"40\"></td>");
        if (this.MMS != 0.0) {
            stringBuilder.append("<td>V<sub>AS</sub></td><td align=\"center\">").append(HE.K.format(this.VAS * 1000.0)).append("</td><td>litres</td>");
        }
        stringBuilder.append("</tr>");
        stringBuilder.append("<tr>");
        stringBuilder.append("<td>L<sub>E</sub> (f<sub>3</sub>)</td><td align=\"center\">").append(HE.A.format(this.findLEmH(this.f3))).append("</td><td>mH</td>");
        stringBuilder.append("<td width=\"40\"></td>");
        stringBuilder.append("<td>F<sub>TS</sub></td><td align=\"center\">").append(HE.U.format(d5 / d4)).append("</td><td>Hz</td>");
        if (this.MMS != 0.0) {
            stringBuilder.append("<td width=\"40\"></td>");
            stringBuilder.append("<td>B&#8467;</td><td align=\"center\">").append(HE.A.format(this.Bl)).append("</td><td>Tm</td>");
        }
        stringBuilder.append("</tr>");
        if (this.MMS != 0.0) {
            stringBuilder.append("<tr>");
            stringBuilder.append("<td>Dd</td><td align=\"center\">").append(HE.K.format(this.diam)).append("</td><td>cm</td>");
            stringBuilder.append("<td width=\"40\"></td>");
            stringBuilder.append("<td>L<sub>P</sub></td><td align=\"center\">").append(HE.K.format(this.Lp)).append("</td><td>dB (1W/1m)</td>");
            stringBuilder.append("<td width=\"40\"></td>");
            stringBuilder.append("<td>Eta</td><td align=\"center\">").append(HE.K.format(100.0 * this.ETA)).append("</td><td>%</td>");
            stringBuilder.append("</tr>");
            stringBuilder.append("<tr>");
            stringBuilder.append("<td>Sd</td><td align=\"center\">").append(HE.U.format(10000.0 * this.S)).append("</td><td>cm<sup>2</sup></td>");
            stringBuilder.append("<td width=\"40\"></td>");
            switch (this.getMethod()) {
                case ADDED_MASS: {
                    stringBuilder.append("<td>Added mass</td><td align=\"center\">").append(HE.A.format(this.addedMass)).append("</td><td>g</td>");
                    break;
                }
                case DUAL_ADDED_MASS: {
                    stringBuilder.append("<td>m1</td><td align=\"center\">").append(HE.A.format(this.addedMass)).append("</td><td>g</td>");
                    stringBuilder.append("<td width=\"40\"></td>");
                    stringBuilder.append("<td>m2</td><td align=\"center\">").append(HE.A.format(this.addedMass2)).append("</td><td>g</td>");
                    break;
                }
                case SEALED_BOX: {
                    stringBuilder.append("<td>V<sub>B</sub></td><td align=\"center\">").append(HE.A.format(this.VB)).append("</td><td>litres</td>");
                    stringBuilder.append("<td width=\"40\"></td>");
                    stringBuilder.append("<td>Q<sub>l</sub></td><td align=\"center\">").append(HE.A.format(this.Ql)).append("</td><td></td>");
                }
            }
            stringBuilder.append("</tr>");
        }
        stringBuilder.append("</table>");
        if (this.MMS != 0.0) {
            stringBuilder.append("<br>Secondary measurement: ").append(this.secMeasName).append("<br>");
            stringBuilder.append("Air temperature ").append(HE.U.format(this.T - 273.15));
            stringBuilder.append(" C, pressure ").append(HE.K.format(this.p / 100.0)).append(" mbar giving density ");
            stringBuilder.append(HE.O.format(this.rho)).append(" kg/m<sup>3</sup>, c ");
            stringBuilder.append(HE.U.format(this.c)).append(" m/s");
        }
        return stringBuilder.toString();
    }

    void writeToFile(String string) {
        try (PrintWriter printWriter = new PrintWriter(new FileOutputStream(string));){
            printWriter.println("TS Parameters file");
            printWriter.println("Room EQ V" + RoomEQ_Wizard.j());
            printWriter.println("Dated: " + DateFormat.getDateTimeInstance().format(new Date(System.currentTimeMillis())));
            printWriter.println("From measurement " + this.meas.getTitle());
            printWriter.println();
            String string2 = lG.J();
            printWriter.println("Zmin" + string2 + HE.L.format(this.ZminMeas) + string2 + "ohm");
            printWriter.println("fmin" + string2 + HE.H.format(this.ZminFreq) + string2 + "Hz");
            printWriter.println("f3" + string2 + HE.H.format(this.f3) + string2 + "Hz");
            printWriter.println("Le(f3)" + string2 + HE.B.format(this.findLEmH(this.f3)) + string2 + "mH");
            printWriter.println("Motional impedance parameters");
            this.motionalImpedance.exportParameters(printWriter, string2);
            printWriter.println("Blocked impedance parameters");
            printWriter.println("RDC" + string2 + HE.L.format(this.RDC) + string2 + "ohm");
            if (this.voiceCoil.getModel().isTFModel()) {
                printWriter.println("dR" + string2 + HE.L.format(this.voiceCoil.getdR()) + string2 + "ohm");
                printWriter.println("Re" + string2 + HE.L.format(this.RE) + string2 + "ohm");
                printWriter.println("Leb" + string2 + HE.T.format(this.voiceCoil.getLeb() / 1.0E-6) + string2 + "uH");
                printWriter.println("Le" + string2 + HE.B.format(this.voiceCoil.getLETF() / 0.001) + string2 + "mH");
                printWriter.println("Rss" + string2 + HE.T.format(this.voiceCoil.getRss()) + string2 + "ohm");
                printWriter.println("Ke" + string2 + HE.M.format(this.voiceCoil.getKe()) + string2 + "S-H");
            } else {
                printWriter.println(this.voiceCoil.toString());
            }
            printWriter.println("Thiele-Small parameters");
            double d2 = this.motionalImpedance.getOmegaS() / (Math.PI * 2);
            double d3 = this.motionalImpedance.getQMS();
            double d4 = this.motionalImpedance.getQES();
            double d5 = this.motionalImpedance.getQTS();
            printWriter.println("fs" + string2 + HE.T.format(d2) + string2 + "Hz");
            printWriter.println("Qms" + string2 + HE.B.format(d3));
            printWriter.println("Qes" + string2 + HE.B.format(d4));
            printWriter.println("Qts" + string2 + HE.B.format(d5));
            printWriter.println("Fts" + string2 + HE.T.format(d2 / d5));
            if (this.MMS > 0.0) {
                printWriter.println("Mms" + string2 + HE.L.format(1000.0 * this.MMS) + string2 + "g");
                printWriter.println("Cms" + string2 + HE.B.format(1000.0 * this.CMS) + string2 + "mm/N");
                printWriter.println("Rms" + string2 + HE.B.format(this.RMS) + string2 + "kg/s");
                printWriter.println("Vas" + string2 + HE.L.format(this.VAS * 1000.0) + string2 + "litres");
                printWriter.println("Bl" + string2 + HE.B.format(this.Bl) + string2 + "Tm");
                printWriter.println("Eta" + string2 + HE.L.format(100.0 * this.ETA) + string2 + "%");
                printWriter.println("Lp (1W/1m)" + string2 + HE.L.format(this.Lp) + string2 + "dB");
                printWriter.println("Dd" + string2 + HE.L.format(this.diam) + string2 + "cm");
                printWriter.println("Sd" + string2 + HE.T.format(10000.0 * this.S) + string2 + "cm^2");
                switch (this.getMethod()) {
                    case ADDED_MASS: {
                        printWriter.println("Added mass measurement:" + string2 + this.secMeasName + "");
                        printWriter.println("Added mass" + string2 + HE.B.format(this.addedMass) + string2 + "g");
                        break;
                    }
                    case DUAL_ADDED_MASS: {
                        printWriter.println("Added mass 1 measurement:" + string2 + this.secMeasName + "");
                        printWriter.println("Added mass 1" + string2 + HE.B.format(this.addedMass) + string2 + "g");
                        printWriter.println("Added mass 2 measurement:" + string2 + this.mass2MeasName + "");
                        printWriter.println("Added mass 2" + string2 + HE.B.format(this.addedMass2) + string2 + "g");
                        break;
                    }
                    case SEALED_BOX: {
                        printWriter.println("Sealed box measurement:" + string2 + this.secMeasName + "");
                        printWriter.println("Vb" + string2 + HE.B.format(this.VB) + string2 + "litres");
                    }
                }
                printWriter.println("Air temperature" + string2 + HE.T.format(this.T - 273.15) + string2 + "C");
                printWriter.println("Air pressure" + string2 + HE.L.format(this.p / 100.0) + string2 + "mB");
                printWriter.println("Air density" + string2 + HE.M.format(this.rho) + string2 + "kg/m^3");
                printWriter.println("Speed of sound" + string2 + HE.T.format(this.c) + string2 + "m/s");
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            WizardLogger.getLogger().log(Level.SEVERE, null, fileNotFoundException);
            fileNotFoundException.printStackTrace(System.err);
        }
    }

    double findLEmH(double d2) {
        if (d2 == 0.0) {
            return 0.0;
        }
        double d3 = d2 * (Math.PI * 2);
        double d4 = this.meas.splUnsmoothed((float)d2, 0.0f);
        double d5 = this.meas.phaseUnsmoothed((float)d2, 0.0f);
        double d6 = d5 * (Math.PI / 180);
        double d7 = d4 * Math.sin(d6);
        return 1000.0 * d7 / d3;
    }

    String simpleModelSt() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<table align=\"left\" valign=\"bottom\" cellpadding=\"2\">");
        stringBuilder.append("<tr>");
        stringBuilder.append("<td>R<sub>E</sub></td><td align=\"center\">").append(HE.A.format(this.RE)).append("</td><td>ohm</td>");
        stringBuilder.append("<td width=\"40\"></td>");
        stringBuilder.append("<td>L<sub>E</sub></td><td align=\"center\">").append(HE.U.format(this.simpleModelVC.getLE() / 1.0E-6)).append("</td><td>uH</td>");
        stringBuilder.append("</tr>");
        stringBuilder.append("<tr>");
        double d2 = this.getResEquiv();
        stringBuilder.append("<td>R<sub>ES</sub></td><td align=\"center\">").append(HE.K.format(d2)).append("</td><td>ohm</td>");
        stringBuilder.append("<td width=\"40\"></td>");
        stringBuilder.append("<td>R<sub>2</sub></td><td align=\"center\">").append(HE.K.format(this.simpleModelVC.getR2())).append("</td><td>ohm</td>");
        stringBuilder.append("</tr>");
        stringBuilder.append("<tr>");
        double d3 = this.motionalImpedance.getParam(ModelParameter.CMES);
        stringBuilder.append("<td>C<sub>MES</sub></td><td align=\"center\">").append(HE.U.format(d3 / 1.0E-6)).append("</td><td>uF</td>");
        stringBuilder.append("<td width=\"40\"></td>");
        stringBuilder.append("<td>L<sub>2</sub></td><td align=\"center\">").append(HE.U.format(this.simpleModelVC.getL2() / 1.0E-6)).append("</td><td>uH</td>");
        stringBuilder.append("</tr>");
        stringBuilder.append("<tr>");
        double d4 = this.getLcesEquiv();
        stringBuilder.append("<td>L<sub>CES</sub></td><td align=\"center\">").append(HE.K.format(d4 / 0.001)).append("</td><td>mH</td>");
        stringBuilder.append("<td width=\"40\"></td>");
        if (this.simpleModelVC.getModel().equals((Object)LossyInductor.Models.LR4)) {
            stringBuilder.append("<td>R<sub>3</sub></td><td align=\"center\">").append(HE.K.format(this.simpleModelVC.getR3())).append("</td><td>ohm</td>");
            stringBuilder.append("</tr>");
            stringBuilder.append("<tr>");
            stringBuilder.append("<td></td><td align=\"center\"></td><td></td>");
            stringBuilder.append("<td width=\"40\"></td>");
            stringBuilder.append("<td>L<sub>3</sub></td><td align=\"center\">").append(HE.U.format(this.simpleModelVC.getL3() / 1.0E-6)).append("</td><td>uH</td>");
            stringBuilder.append("</tr>");
        }
        stringBuilder.append("</table>");
        return stringBuilder.toString();
    }

    public String toString() {
        return "TSParams{RDC=" + HE.A.format(this.RDC) + ", RE=" + HE.A.format(this.RE) + this.motionalImpedance.paramString() + "}";
    }

    boolean hasZMstar() {
        return this.ZMstarReal != null;
    }

    boolean hasBldata() {
        return this.Bldata != null;
    }

    double getBlSlope() {
        return this.BlSlope;
    }

    double getBlOffset() {
        return this.BlOffset;
    }

    double getRE() {
        return this.RE;
    }

    void setRE(double d2) {
        this.RE = d2;
    }

    void setGLESR(double d2) {
        this.motionalImpedance.setParam(ModelParameter.GLESR, d2);
    }

    private double getResEquiv() {
        return this.motionalImpedance.getResEquiv();
    }

    private double getLcesEquiv() {
        return this.motionalImpedance.getLCES(this.motionalImpedance.getOmegaS());
    }

    private double getQES() {
        return this.motionalImpedance.getQES();
    }

    private double getQMS() {
        return this.motionalImpedance.getQMS();
    }

    private double getLCES() {
        return this.motionalImpedance.getParam(ModelParameter.LCES);
    }

    private double getCMES() {
        return this.motionalImpedance.getParam(ModelParameter.CMES);
    }

    LossyInductor getVoiceCoil() {
        return this.voiceCoil;
    }

    void setVoiceCoil(LossyInductor lossyInductor) {
        this.voiceCoil = lossyInductor.copy();
    }

    LossyInductor getSimpleModelVC() {
        return this.simpleModelVC;
    }

    void setSimpleModelVC(LossyInductor lossyInductor) {
        this.simpleModelVC = lossyInductor.copy();
    }

    TSMethod getMethod() {
        if (this.method != null) {
            return this.method;
        }
        if (this.addedMassMethod) {
            return TSMethod.ADDED_MASS;
        }
        return TSMethod.SEALED_BOX;
    }

    void setMethod(TSMethod tSMethod) {
        this.method = tSMethod;
    }

    double getDiam() {
        return this.diam;
    }

    double getVB() {
        return this.VB;
    }

    double getAddedMass() {
        return this.addedMass;
    }

    double getRDC() {
        return this.RDC;
    }

    void setRDC(double d2) {
        if (d2 != this.RDC) {
            this.RDC = d2;
        }
    }

    double getArea() {
        return this.S;
    }
}

