/*
 * Decompiled with CFR 0.152.
 */
package roomeqwizard;

import java.io.Serializable;
import java.util.logging.Level;
import roomeqwizard.RJ;
import roomeqwizard.RTADistortionData;
import roomeqwizard.WizardLogger;

public class SteppedSineDataPoint
implements Serializable,
Cloneable {
    static final long serialVersionUID = 100L;
    double freq;
    double generatorLeveldBFS;
    double thd;
    double thdPlusN;
    double nPlusD;
    double dBThd;
    double dBThdPlusN;
    double dBNandNHD;
    double[] harmonicData;
    double[] dBHarmonicData;
    float[] spectrumData;
    double imdPercent;
    double tdPlusNPercent;
    double imddB;
    double tdPlusNdB;
    double imdRef;
    double tdPlusNRef;
    double inputRMSdB;
    String imdSt;

    SteppedSineDataPoint(double d2, RJ rJ2, RTADistortionData rTADistortionData, boolean bl) {
        if (bl) {
            this.spectrumData = rJ2.k();
        }
        this.generatorLeveldBFS = d2;
        this.inputRMSdB = rTADistortionData.rmsdB;
        if (rTADistortionData.thdDataValid) {
            int n2;
            this.freq = rTADistortionData.fundamentalFreq;
            this.thd = rTADistortionData.thd;
            this.thdPlusN = rTADistortionData.thdPlusN;
            this.dBThd = rTADistortionData.dBthd;
            this.dBThdPlusN = rTADistortionData.dBthdPlusN;
            this.nPlusD = rTADistortionData.nAndNHD;
            this.dBNandNHD = rTADistortionData.dBNandNHD;
            this.harmonicData = new double[rTADistortionData.harmonics.size()];
            for (n2 = 0; n2 < rTADistortionData.harmonics.size(); ++n2) {
                this.harmonicData[n2] = rTADistortionData.harmonics.get(n2);
            }
            this.dBHarmonicData = new double[rTADistortionData.dBHarmonics.size()];
            for (n2 = 0; n2 < rTADistortionData.dBHarmonics.size(); ++n2) {
                this.dBHarmonicData[n2] = rTADistortionData.dBHarmonics.get(n2);
            }
        } else if (rTADistortionData.imdDataValid) {
            this.freq = rTADistortionData.f1;
            this.imdPercent = rTADistortionData.imdPercent;
            this.tdPlusNPercent = rTADistortionData.tdPlusNPercent;
            this.imddB = rTADistortionData.imddB;
            this.tdPlusNdB = rTADistortionData.tdPlusNdB;
            this.imdRef = rTADistortionData.imdRef;
            this.tdPlusNRef = rTADistortionData.tdPlusNRef;
        } else if (rTADistortionData.mttdDataValid) {
            this.freq = 1000.0;
            this.tdPlusNPercent = rTADistortionData.tdPlusNPercent;
            this.tdPlusNdB = rTADistortionData.tdPlusNdB;
            this.tdPlusNRef = rTADistortionData.tdPlusNRef;
        }
    }

    public SteppedSineDataPoint clone() {
        SteppedSineDataPoint steppedSineDataPoint = null;
        try {
            steppedSineDataPoint = (SteppedSineDataPoint)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            WizardLogger.getLogger().log(Level.SEVERE, null, cloneNotSupportedException);
        }
        return steppedSineDataPoint;
    }
}

