/*
 * Decompiled with CFR 0.152.
 */
package roomeqwizard;

public enum SpectrogramMode {
    STFT("Fourier"),
    WAVELET("Wavelet"),
    AIRYCWT("Airy CWT"),
    MORLETCWT("Morlet CWT"),
    RT60DECAY("RT60 Decay"),
    BURST_DECAY("Burst Decay");

    private final String description;

    private SpectrogramMode(String string2) {
        this.description = string2;
    }

    public boolean isWavelet() {
        return this == WAVELET || this == MORLETCWT || this == AIRYCWT;
    }

    public boolean isCWT() {
        return this == MORLETCWT || this == AIRYCWT;
    }

    public String toString() {
        return this.description;
    }

    public String apiName() {
        return this.description;
    }

    public static SpectrogramMode getEnum(String string) {
        for (SpectrogramMode spectrogramMode : SpectrogramMode.values()) {
            if (!spectrogramMode.name().equalsIgnoreCase(string)) continue;
            return spectrogramMode;
        }
        return STFT;
    }

    public static SpectrogramMode getFromApiName(String string) {
        for (SpectrogramMode spectrogramMode : SpectrogramMode.values()) {
            if (!spectrogramMode.apiName().equalsIgnoreCase(string)) continue;
            return spectrogramMode;
        }
        return null;
    }
}

