/*
 * Decompiled with CFR 0.152.
 */
package roomeqwizard;

import info.clearthought.layout.TableLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPopupMenu;
import javax.swing.JSpinner;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import roomeqwizard.$I;
import roomeqwizard.BE;
import roomeqwizard.ColorScheme;
import roomeqwizard.OA;
import roomeqwizard.XC;
import roomeqwizard.g;
import roomeqwizard.iC;
import roomeqwizard.lG;
import roomeqwizard.mD;
import roomeqwizard.sB;
import roomeqwizard.wA;

final class SpectrogramColorScheme
extends Enum<SpectrogramColorScheme> {
    public static final /* enum */ SpectrogramColorScheme NONE = new SpectrogramColorScheme("None");
    public static final /* enum */ SpectrogramColorScheme MULTICOLOR = new SpectrogramColorScheme("Rainbow");
    public static final /* enum */ SpectrogramColorScheme YELLOWBLUE = new SpectrogramColorScheme("Flame");
    public static final /* enum */ SpectrogramColorScheme IRON = new SpectrogramColorScheme("Iron");
    public static final /* enum */ SpectrogramColorScheme TEMPERATURE = new SpectrogramColorScheme("Heat");
    public static final /* enum */ SpectrogramColorScheme CUBEHELIX = new SpectrogramColorScheme("cubehelix");
    public static final /* enum */ SpectrogramColorScheme COPPER = new SpectrogramColorScheme("Copper");
    public static final /* enum */ SpectrogramColorScheme WHITE = new SpectrogramColorScheme("White");
    public static final /* enum */ SpectrogramColorScheme BLACK = new SpectrogramColorScheme("Black");
    static final String SCHEME_UPDATED = "colourSchemeUpdated";
    private final String description;
    private Color[] colorSet;
    private JPopupMenu popup;
    private boolean updatesEnabled = true;
    private static final /* synthetic */ SpectrogramColorScheme[] $VALUES;

    public static SpectrogramColorScheme[] values() {
        return (SpectrogramColorScheme[])$VALUES.clone();
    }

    public static SpectrogramColorScheme valueOf(String string) {
        return Enum.valueOf(SpectrogramColorScheme.class, string);
    }

    private SpectrogramColorScheme(String string2) {
        this.description = string2;
    }

    public String toString() {
        return this.description;
    }

    public static SpectrogramColorScheme getEnum(String string) {
        for (SpectrogramColorScheme spectrogramColorScheme : SpectrogramColorScheme.values()) {
            if (!spectrogramColorScheme.name().equalsIgnoreCase(string)) continue;
            return spectrogramColorScheme;
        }
        return MULTICOLOR;
    }

    JPopupMenu getSettingsPopup() {
        switch (this) {
            case CUBEHELIX: {
                if (this.popup == null) {
                    this.makePopup();
                }
                return this.popup;
            }
        }
        return null;
    }

    public Color getColor(double d2) {
        int n2;
        Color[] colorArray = this.colorSet();
        int n3 = colorArray.length;
        double[] dArray = new double[n3];
        for (n2 = 1; n2 < dArray.length - 1; ++n2) {
            dArray[n2] = (double)n2 / (double)(n3 - 1);
        }
        dArray[dArray.length - 1] = 1.0;
        if (d2 >= 1.0) {
            return colorArray[0];
        }
        if (d2 < 0.0) {
            return colorArray[colorArray.length - 1];
        }
        for (n2 = dArray.length - 2; n2 >= 0 && !(d2 >= dArray[n2]); --n2) {
        }
        int n4 = colorArray.length - 1 - n2;
        double d3 = (d2 - dArray[n2]) / (dArray[n2 + 1] - dArray[n2]);
        return this.useHSLInterpolation() ? $I.A(colorArray[n4], colorArray[n4 - 1], d3) : $I.B(colorArray[n4], colorArray[n4 - 1], d3);
    }

    private void makePopup() {
        this.popup = new JPopupMenu();
        g.getInstance().addPopup(this.popup);
        TableLayout tableLayout = new TableLayout((double[][])new double[][]{{0.0, -2.0, -2.0, 0.0}, {0.0, -2.0, 0.0}});
        tableLayout.setHGap(5);
        tableLayout.setVGap(5);
        this.popup.setLayout((LayoutManager)tableLayout);
        int n2 = 1;
        int n3 = 1;
        sB sB2 = new sB("Start hue (deg):");
        sB2.setFont(OA.H());
        this.popup.add((Component)sB2, n3 + "," + n2);
        int n4 = lG.\u00fc();
        if (n4 < 0 || n4 >= 360) {
            n4 = (Integer)lG.\u00c7("cubehelixstarthue");
        }
        final iC iC2 = new iC(new BE(n4, -360, 360, 10));
        XC.A(iC2);
        XC.A((JSpinner)iC2, OA.H());
        iC2.setToolTipText(lG.R("cubehelixstarthue"));
        iC2.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                final JSpinner jSpinner = (JSpinner)changeEvent.getSource();
                final int n2 = ((Number)jSpinner.getValue()).intValue();
                if (n2 >= 360) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            jSpinner.setValue(n2 - 360);
                        }
                    });
                } else if (n2 < 0) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            jSpinner.setValue(n2 + 360);
                        }
                    });
                } else {
                    lG.\u0103(n2);
                    SpectrogramColorScheme.this.updateSchemeSettings();
                }
            }
        });
        this.popup.add((Component)iC2, n3 + 1 + "," + n2);
        tableLayout.insertRow(++n2, -2.0);
        sB sB3 = new sB("Rotation (deg):");
        sB3.setFont(OA.H());
        this.popup.add((Component)sB3, n3 + "," + n2);
        int n5 = lG.\u0259();
        if (n5 < -1080 || n5 >= 1080) {
            n5 = (Integer)lG.\u00c7("cubehelixrotation");
        }
        final iC iC3 = new iC(new BE(n5, -1080, 1080, 10));
        XC.A(iC3);
        XC.A((JSpinner)iC3, OA.H());
        iC3.setToolTipText(lG.R("cubehelixrotation"));
        iC3.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                JSpinner jSpinner = (JSpinner)changeEvent.getSource();
                int n2 = ((Number)jSpinner.getValue()).intValue();
                lG.U(n2);
                SpectrogramColorScheme.this.updateSchemeSettings();
            }
        });
        this.popup.add((Component)iC3, n3 + 1 + "," + n2);
        tableLayout.insertRow(++n2, -2.0);
        sB sB4 = new sB("Hue factor:");
        sB4.setFont(OA.H());
        this.popup.add((Component)sB4, n3 + "," + n2);
        double d2 = lG.\u0198();
        if (d2 < 0.0 || d2 > 5.0) {
            d2 = (Double)lG.\u00c7("cubehelixhuefactor");
        }
        final iC iC4 = new iC(new BE(d2, 0.0, 3.0, 0.1));
        ((JSpinner)iC4).setEditor(new JSpinner.NumberEditor((JSpinner)iC4, "0.0"));
        XC.A(iC4);
        XC.A((JSpinner)iC4, OA.H());
        iC4.setToolTipText(lG.R("cubehelixhuefactor"));
        iC4.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                JSpinner jSpinner = (JSpinner)changeEvent.getSource();
                double d2 = ((Number)jSpinner.getValue()).doubleValue();
                lG.\u00cd(d2);
                SpectrogramColorScheme.this.updateSchemeSettings();
            }
        });
        this.popup.add((Component)iC4, n3 + 1 + "," + n2);
        tableLayout.insertRow(++n2, -2.0);
        sB sB5 = new sB("Min grey:");
        sB5.setFont(OA.H());
        this.popup.add((Component)sB5, n3 + "," + n2);
        double d3 = lG.\u03ec();
        if (d3 < 0.0 || d3 > 1.0) {
            d3 = (Double)lG.\u00c7("cubehelixmingrey");
        }
        final iC iC5 = new iC(new BE(d3, 0.0, 1.0, 0.01));
        ((JSpinner)iC5).setEditor(new JSpinner.NumberEditor((JSpinner)iC5, "0.00"));
        XC.A(iC5);
        XC.A((JSpinner)iC5, OA.H());
        iC5.setToolTipText(lG.R("cubehelixmingrey"));
        iC5.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                JSpinner jSpinner = (JSpinner)changeEvent.getSource();
                double d2 = ((Number)jSpinner.getValue()).doubleValue();
                lG.\u00d2(d2);
                SpectrogramColorScheme.this.updateSchemeSettings();
            }
        });
        this.popup.add((Component)iC5, n3 + 1 + "," + n2);
        tableLayout.insertRow(++n2, -2.0);
        sB sB6 = new sB("Max grey:");
        sB6.setFont(OA.H());
        this.popup.add((Component)sB6, n3 + "," + n2);
        double d4 = lG.\u03f0();
        if (d4 < 0.0 || d4 > 1.0) {
            d4 = (Double)lG.\u00c7("cubehelixmaxgrey");
        }
        final iC iC6 = new iC(new BE(d4, 0.0, 1.0, 0.01));
        ((JSpinner)iC6).setEditor(new JSpinner.NumberEditor((JSpinner)iC6, "0.00"));
        XC.A(iC6);
        XC.A((JSpinner)iC6, OA.H());
        iC6.setToolTipText(lG.R("cubehelixmaxgrey"));
        iC6.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                JSpinner jSpinner = (JSpinner)changeEvent.getSource();
                double d2 = ((Number)jSpinner.getValue()).doubleValue();
                lG.\u00a4(d2);
                SpectrogramColorScheme.this.updateSchemeSettings();
            }
        });
        this.popup.add((Component)iC6, n3 + 1 + "," + n2);
        tableLayout.insertRow(++n2, 10.0);
        tableLayout.insertRow(++n2, -2.0);
        JButton jButton = new JButton("Reset to defaults");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SpectrogramColorScheme.this.updatesEnabled = false;
                int n2 = (Integer)lG.\u00c7("cubehelixstarthue");
                lG.\u0103(n2);
                iC2.setValue(n2);
                int n3 = (Integer)lG.\u00c7("cubehelixrotation");
                lG.U(n3);
                iC3.setValue(n3);
                double d2 = (Double)lG.\u00c7("cubehelixhuefactor");
                lG.\u00cd(d2);
                iC4.setValue(d2);
                double d3 = (Double)lG.\u00c7("cubehelixmingrey");
                lG.\u00d2(d3);
                iC5.setValue(d3);
                double d4 = (Double)lG.\u00c7("cubehelixmaxgrey");
                lG.\u00a4(d4);
                iC6.setValue(d4);
                SpectrogramColorScheme.this.updatesEnabled = true;
                SpectrogramColorScheme.this.updateSchemeSettings();
            }
        });
        this.popup.add((Component)jButton, n3 + "," + n2 + "," + (n3 + 1) + "," + n2);
    }

    private void updateSchemeSettings() {
        if (this.updatesEnabled) {
            this.initCubeHelix();
            this.popup.firePropertyChange(SCHEME_UPDATED, false, true);
        }
    }

    private void initCubeHelix() {
        int n2 = lG.\u00fc();
        int n3 = lG.\u0259();
        double d2 = lG.\u0198();
        double d3 = lG.\u03ec();
        double d4 = lG.\u03f0();
        double d5 = 1.0;
        int n4 = 11;
        this.colorSet = SpectrogramColorScheme.cubehelix(n2, n3, d2, d5, d3, d4, n4);
    }

    int settingsHash() {
        switch (this) {
            case CUBEHELIX: {
                int n2 = 7;
                n2 = n2 * 67 + lG.\u00fc();
                n2 = n2 * 67 + lG.\u0259();
                n2 = n2 * 67 + Double.valueOf(lG.\u0198()).hashCode();
                n2 = n2 * 67 + Double.valueOf(lG.\u03ec()).hashCode();
                n2 = n2 * 67 + Double.valueOf(lG.\u03f0()).hashCode();
                return n2;
            }
        }
        return 0;
    }

    Color gridColor() {
        switch (this) {
            case CUBEHELIX: 
            case MULTICOLOR: 
            case YELLOWBLUE: 
            case COPPER: 
            case TEMPERATURE: 
            case IRON: 
            case WHITE: {
                return wA.E(ColorScheme.DARK);
            }
            case BLACK: {
                return wA.E(ColorScheme.LIGHT);
            }
            case NONE: {
                return wA.G();
            }
        }
        assert (false) : "unhandled enum: " + (Object)((Object)this);
        return wA.G();
    }

    Color contrastColor() {
        switch (this) {
            case TEMPERATURE: {
                return Color.GREEN;
            }
        }
        return wA.b();
    }

    Color cursorColor() {
        return this.contrastColor().darker();
    }

    boolean useXORCursor() {
        switch (this) {
            case CUBEHELIX: 
            case MULTICOLOR: 
            case YELLOWBLUE: 
            case COPPER: 
            case TEMPERATURE: 
            case IRON: 
            case NONE: {
                return true;
            }
            case WHITE: 
            case BLACK: {
                return false;
            }
        }
        assert (false) : "unhandled ColorSchemes enum: " + (Object)((Object)this);
        return true;
    }

    boolean useHSLInterpolation() {
        switch (this) {
            case MULTICOLOR: {
                return true;
            }
            case CUBEHELIX: 
            case YELLOWBLUE: 
            case COPPER: 
            case TEMPERATURE: 
            case IRON: 
            case WHITE: 
            case BLACK: 
            case NONE: {
                return false;
            }
        }
        assert (false) : "unhandled ColorSchemes enum: " + (Object)((Object)this);
        return false;
    }

    Color cursorXORColor() {
        switch (this) {
            case CUBEHELIX: 
            case MULTICOLOR: 
            case YELLOWBLUE: 
            case COPPER: 
            case TEMPERATURE: 
            case IRON: 
            case WHITE: 
            case BLACK: 
            case NONE: {
                return Color.GRAY;
            }
        }
        assert (false) : "unhandled ColorSchemes enum: " + (Object)((Object)this);
        return Color.GRAY;
    }

    Color[] colorSet() {
        switch (this) {
            case NONE: {
                if (this.colorSet != null) break;
                this.colorSet = new Color[0];
                break;
            }
            case IRON: {
                if (this.colorSet != null) break;
                this.colorSet = new Color[]{new Color(255, 255, 250), new Color(255, 238, 91), new Color(254, 203, 1), new Color(252, 157, 0), new Color(243, 111, 1), new Color(231, 72, 20), new Color(209, 27, 120), new Color(176, 1, 152), new Color(113, 0, 157), new Color(40, 0, 137), new Color(0, 0, 10)};
                break;
            }
            case TEMPERATURE: {
                if (this.colorSet != null) break;
                this.colorSet = new Color[]{mD.B(0.0f, 100.0f, 25.0f), mD.B(0.0f, 100.0f, 40.0f), mD.B(20.0f, 100.0f, 50.0f), mD.B(40.0f, 100.0f, 50.0f), mD.B(60.0f, 80.0f, 50.0f), mD.B(120.0f, 100.0f, 75.0f), mD.B(180.0f, 80.0f, 50.0f), mD.B(200.0f, 100.0f, 50.0f), mD.B(220.0f, 100.0f, 45.0f), mD.B(240.0f, 100.0f, 40.0f), mD.B(240.0f, 100.0f, 25.0f)};
                break;
            }
            case MULTICOLOR: {
                if (this.colorSet != null) break;
                this.colorSet = new Color[]{mD.B(0.0f, 100.0f, 50.0f), mD.B(27.0f, 100.0f, 48.0f), mD.B(54.0f, 100.0f, 46.0f), mD.B(71.0f, 100.0f, 39.0f), mD.B(100.0f, 100.0f, 37.0f), mD.B(130.0f, 100.0f, 35.0f), mD.B(160.0f, 100.0f, 37.0f), mD.B(180.0f, 100.0f, 30.0f), mD.B(210.0f, 100.0f, 30.0f), mD.B(240.0f, 100.0f, 32.0f), mD.B(270.0f, 100.0f, 20.0f)};
                break;
            }
            case YELLOWBLUE: {
                if (this.colorSet != null) break;
                this.colorSet = new Color[]{mD.B(60.0f, 100.0f, 99.6f), mD.B(60.0f, 100.0f, 70.0f), mD.B(60.0f, 90.0f, 55.0f), mD.B(30.0f, 100.0f, 45.0f), mD.B(0.0f, 100.0f, 40.0f), mD.B(330.0f, 100.0f, 35.0f), mD.B(300.0f, 100.0f, 30.0f), mD.B(270.0f, 85.0f, 40.8f), mD.B(240.0f, 75.0f, 50.0f), mD.B(240.0f, 75.0f, 40.0f), mD.B(240.0f, 100.0f, 25.0f)};
                break;
            }
            case CUBEHELIX: {
                if (this.colorSet != null) break;
                this.initCubeHelix();
                break;
            }
            case COPPER: {
                if (this.colorSet != null) break;
                float f2 = 50.0f;
                float f3 = 11.0f;
                this.colorSet = new Color[11];
                float f4 = 39.0f / (float)(this.colorSet.length - 1);
                for (int i2 = 0; i2 < this.colorSet.length; ++i2) {
                    float f5 = 50.0f - (float)i2 * f4;
                    this.colorSet[i2] = mD.B(20.0f, 100.0f, f5);
                }
                break;
            }
            case WHITE: {
                if (this.colorSet != null) break;
                float f6 = 95.0f;
                float f7 = 5.0f;
                this.colorSet = new Color[11];
                float f8 = 90.0f / (float)(this.colorSet.length - 1);
                for (int i3 = 0; i3 < this.colorSet.length; ++i3) {
                    float f9 = 95.0f - (float)i3 * f8;
                    this.colorSet[i3] = mD.B(0.0f, 0.0f, f9);
                }
                break;
            }
            case BLACK: {
                if (this.colorSet != null) break;
                float f10 = 5.0f;
                float f11 = 95.0f;
                this.colorSet = new Color[11];
                float f12 = -90.0f / (float)(this.colorSet.length - 1);
                for (int i4 = 0; i4 < this.colorSet.length; ++i4) {
                    float f13 = 5.0f - (float)i4 * f12;
                    this.colorSet[i4] = mD.B(0.0f, 0.0f, f13);
                }
                break;
            }
        }
        return this.colorSet;
    }

    int bands() {
        return this.colorSet().length;
    }

    Color[] colorSteps() {
        return this.colorSet();
    }

    private Color[] colorSteps(double d2) {
        if (d2 == 0.0) {
            return this.colorSet();
        }
        int n2 = 5;
        d2 *= 10.0 / (double)n2;
        double[] dArray = new double[2 * n2];
        for (int i2 = -n2; i2 < n2; ++i2) {
            dArray[i2 + n2] = SpectrogramColorScheme.sigmoid(d2, i2);
        }
        double d3 = -dArray[0];
        for (int i3 = 0; i3 < dArray.length; ++i3) {
            dArray[i3] = 0.5 * (dArray[i3] / d3 + 1.0);
        }
        Color[] colorArray = this.colorSet();
        Color[] colorArray2 = new Color[(colorArray.length - 1) * dArray.length + 1];
        int n3 = colorArray.length - 1;
        for (int i4 = 0; i4 < n3; ++i4) {
            for (int i5 = 0; i5 < dArray.length; ++i5) {
                Color color;
                colorArray2[i4 * dArray.length + i5] = color = $I.B(colorArray[i4], colorArray[i4 + 1], dArray[i5]);
            }
        }
        colorArray2[colorArray2.length - 1] = colorArray[colorArray.length - 1];
        return colorArray2;
    }

    static double sigmoid(double d2, double d3) {
        return 1.0 / (1.0 + Math.exp(-d2 * d3)) - 0.5;
    }

    static Color[] cubehelix(double d2, double d3, double d4, double d5, double d6, double d7, int n2) {
        Color[] colorArray = new Color[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            double d8 = (double)i2 / (double)(n2 - 1);
            double d9 = (d2 + 120.0 + d3 * d8) * Math.PI / 180.0;
            d8 = Math.pow(d8, d5);
            double d10 = (d7 - d6) * d8 + d6;
            double d11 = d4 * d10 * (1.0 - d10) / 2.0;
            double d12 = Math.cos(d9);
            double d13 = Math.sin(d9);
            float f2 = (float)(d10 + d11 * (-0.14861 * d12 + 1.78277 * d13));
            float f3 = (float)(d10 + d11 * (-0.29227 * d12 - 0.90649 * d13));
            float f4 = (float)(d10 + d11 * (1.97294 * d12));
            if (f2 < 0.0f) {
                f2 = 0.0f;
            } else if (f2 > 1.0f) {
                f2 = 1.0f;
            }
            if (f3 < 0.0f) {
                f3 = 0.0f;
            } else if (f3 > 1.0f) {
                f3 = 1.0f;
            }
            if (f4 < 0.0f) {
                f4 = 0.0f;
            } else if (f4 > 1.0f) {
                f4 = 1.0f;
            }
            colorArray[n2 - i2 - 1] = new Color(f2, f3, f4);
        }
        return colorArray;
    }

    void printHSL() {
        System.out.println(this.toString());
        for (Color color : this.colorSet()) {
            float[] fArray = mD.A(color);
            System.out.printf("HSLColor.toRGB(%5.1ff, %5.1ff, %5.1ff),%n", Float.valueOf(fArray[0]), Float.valueOf(fArray[1]), Float.valueOf(fArray[2]));
        }
    }

    static {
        $VALUES = new SpectrogramColorScheme[]{NONE, MULTICOLOR, YELLOWBLUE, IRON, TEMPERATURE, CUBEHELIX, COPPER, WHITE, BLACK};
    }
}

