/*
 * Decompiled with CFR 0.152.
 */
package roomeqwizard;

import com.A.A.A;
import com.A.A.C;
import java.awt.geom.Point2D;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Arrays;
import roomeqwizard.AD;
import roomeqwizard.GJ;
import roomeqwizard.IH;
import roomeqwizard.Interpolation;
import roomeqwizard.JK;
import roomeqwizard.OctaveFilterSettings;
import roomeqwizard.WindowSettings;
import roomeqwizard.kJ;
import roomeqwizard.lH;
import roomeqwizard.zB;

public class SampledData
implements Serializable,
IH {
    static final long serialVersionUID = -1234567890987654322L;
    protected float[] data;
    protected int n;
    protected double T;
    protected double startTime;
    protected double endTime;
    protected float absMaxVal;
    protected float normVal;
    protected int absMaxIndex;
    @Deprecated
    protected float absMaxInterpIndex;
    private Double absMaxDoubleIndex;
    protected Interpolation oversampler;
    protected int oversampleFactor;
    protected Interpolation interpolator;
    protected double smoothT = -1.0;
    protected float[] unsmoothed;
    protected OctaveFilterSettings filtSettings;
    protected float[] unfilt;
    protected float unfiltAbsMaxVal;
    protected float unfiltNormVal;
    protected int unfiltAbsMaxIndex;
    @Deprecated
    protected float unfiltAbsMaxInterpIndex;
    private Double unfiltAbsMaxDoubleIndex;
    protected int unfiltFnz;
    protected int unfiltLnz;
    protected boolean fillAfterUnfiltLnz;
    protected boolean isCausal;
    protected boolean inverted = false;
    protected transient zB oversampled;
    protected transient GJ graphTimeData;
    protected transient WindowSettings windows;
    protected transient SampledData sdSource;

    public SampledData(int n2, double d2, float[] fArray, double d3, int n3) {
        this.n = n2;
        this.T = d2;
        this.oversampler = Interpolation.SINC;
        this.oversampleFactor = n3;
        this.interpolator = Interpolation.HERMITE;
        this.startTime = d3;
        this.endTime = d3 + (double)(n2 - 1) * d2;
        this.data = new float[n2];
        System.arraycopy(fArray, 0, this.data, 0, n2);
        this.maxScan();
        this.normVal = this.absMaxVal;
    }

    public SampledData(SampledData sampledData, WindowSettings windowSettings) {
        this.sdSource = sampledData;
        this.windows = windowSettings;
        int n2 = windowSettings.getWindowedSpan();
        int n3 = sampledData.oversampler == Interpolation.NONE ? 1 : sampledData.oversampleFactor;
        this.n = n2 * n3;
        this.T = sampledData.T / (double)n3;
        this.oversampler = Interpolation.NONE;
        this.oversampleFactor = 1;
        this.interpolator = Interpolation.HERMITE;
        double d2 = sampledData.getStartTime();
        int n4 = windowSettings.getPreImpulseIndex();
        this.startTime = d2 + (double)n4 * sampledData.T;
        this.endTime = this.startTime + (double)(this.n - 1) * this.T;
        this.normVal = sampledData.normVal;
    }

    public Object readResolve() throws ObjectStreamException {
        if (this.absMaxDoubleIndex == null) {
            this.absMaxDoubleIndex = this.absMaxInterpIndex;
        }
        if (this.unfiltAbsMaxDoubleIndex == null) {
            this.unfiltAbsMaxDoubleIndex = this.unfiltAbsMaxInterpIndex;
        }
        if (this.endTime != this.startTime + (double)(this.n - 1) * this.T) {
            this.endTime = this.startTime + (double)(this.n - 1) * this.T;
        }
        return this;
    }

    public SampledData copy() {
        SampledData sampledData;
        if (this.sdSource == null) {
            sampledData = new SampledData(this.n, this.T, this.data, this.startTime, this.oversampleFactor);
            sampledData.setInterpolator(this.interpolator);
            sampledData.setOversampler(this.oversampler);
            sampledData.setNormVal(this.normVal);
        } else {
            sampledData = new SampledData(this.sdSource, this.windows);
        }
        return sampledData;
    }

    public void scale(double d2) {
        if (this.data != null) {
            int n2 = 0;
            while (n2 < this.data.length) {
                int n3 = n2++;
                this.data[n3] = (float)((double)this.data[n3] * d2);
            }
            this.absMaxVal = (float)((double)this.absMaxVal * d2);
            this.normVal = (float)((double)this.normVal * d2);
        }
    }

    public void setCausal(boolean bl) {
        this.isCausal = bl;
    }

    public boolean isCausal() {
        return this.isCausal;
    }

    public boolean isInverted() {
        return this.inverted;
    }

    public void setInverted(boolean bl) {
        if (this.inverted != bl) {
            int n2;
            for (n2 = 0; n2 < this.data.length; ++n2) {
                this.data[n2] = -this.data[n2];
            }
            if (this.filtSettings != null && this.filtSettings.filterFc != 0.0) {
                for (n2 = 0; n2 < this.unfilt.length; ++n2) {
                    this.unfilt[n2] = -this.unfilt[n2];
                }
            }
            this.inverted = bl;
            this.dataChanged();
        }
    }

    public void prepareForDeletion() {
        this.unfilt = null;
        this.unsmoothed = null;
        this.data = null;
        if (this.graphTimeData != null) {
            this.graphTimeData = null;
        }
        if (this.oversampled != null) {
            this.oversampled.E = null;
            this.oversampled = null;
        }
    }

    protected void maxScan() {
        this.maxScan(0, this.n);
    }

    protected void maxScan(int n2, int n3) {
        float f2 = 0.0f;
        int n4 = 0;
        for (int i2 = n2; i2 < n3; ++i2) {
            float f3;
            float f4 = f3 = this.data[i2] < 0.0f ? -this.data[i2] : this.data[i2];
            if (!(f3 > f2)) continue;
            f2 = f3;
            n4 = i2;
        }
        this.absMaxIndex = n4;
        Point2D.Double double_ = this.oversampleFactor > 1 ? lH.A(this.data, this.absMaxIndex, Interpolation.SINC) : lH.A(this.data, this.absMaxIndex);
        this.absMaxVal = (float)Math.abs(double_.y);
        this.absMaxDoubleIndex = double_.x;
    }

    protected zB getOversampled() {
        if (this.oversampled == null || this.oversampled.A()) {
            if (this.sdSource == null) {
                double d2;
                int n2;
                this.oversampled = this.oversampler.oversample(this.data, this.T, this.oversampleFactor);
                this.oversampled.B = this.startTime;
                this.oversampled.H = this.endTime;
                if (this.isCausal && (n2 = (int)Math.floor(-this.startTime / (d2 = this.T / (double)this.oversampleFactor))) > 0) {
                    Arrays.fill(this.oversampled.E, 0, n2, 0.0f);
                }
            } else {
                int n3 = this.windows.getWindowedSpan();
                int n4 = this.windows.getPreImpulseIndex();
                zB zB2 = this.sdSource.getOversampled(n4, n4 + n3);
                int n5 = zB2.A;
                float[] fArray = new float[n3 * n5];
                int n6 = zB2.D - zB2.F;
                int n7 = Math.min(n6, fArray.length);
                System.arraycopy(zB2.E, zB2.F, fArray, 0, n7);
                for (int i2 = 0; i2 < n3 * n5; ++i2) {
                    int n8 = i2;
                    fArray[n8] = (float)((double)fArray[n8] * this.windows.windowAmpl(this.startTime + (double)i2 * this.T));
                }
                this.oversampled = new zB(fArray, 1);
                this.oversampled.B = this.startTime;
                this.oversampled.H = this.endTime;
                this.data = fArray;
                this.n = fArray.length;
                this.maxScan();
            }
        }
        return this.oversampled;
    }

    protected zB getOversampled(int n2, int n3) {
        zB zB2;
        if (this.oversampled == null || this.oversampled.A()) {
            int n4 = this.oversampler == Interpolation.NONE ? 1 : this.oversampleFactor;
            zB2 = this.oversampler.oversample(this.data, n2, n3, this.T, n4);
        } else {
            zB2 = new zB(this.oversampled.E, n2 * this.oversampled.A, n3 * this.oversampled.A, 1);
            zB2.A = this.oversampled.A;
        }
        zB2.B = this.startTime + (double)n2 * this.T;
        zB2.H = this.startTime + (double)n3 * this.T;
        return zB2;
    }

    @Override
    public float getNormVal() {
        return this.normVal;
    }

    @Override
    public void setNormVal(float f2) {
        this.normVal = f2;
    }

    @Override
    public void resetNormVal() {
        this.normVal = this.absMaxVal;
    }

    @Override
    public JK getGraphTimeData() {
        if (this.graphTimeData == null) {
            this.graphTimeData = new GJ(this);
        }
        return this.graphTimeData;
    }

    @Override
    public double getT() {
        return this.T;
    }

    @Override
    public int getN() {
        return this.n;
    }

    @Override
    public float value(double d2) {
        float[] fArray;
        double d3;
        if (!this.inTimeRange(d2)) {
            return 0.0f;
        }
        if (this.sdSource != null) {
            this.getOversampled();
        }
        if (this.oversampled != null && this.oversampled.B()) {
            d3 = this.T / (double)this.oversampled.A;
            fArray = this.oversampled.E;
        } else {
            d3 = this.T;
            fArray = this.data;
        }
        double d4 = (d2 - this.startTime) / d3;
        int n2 = (int)Math.max(Math.floor(d4), 0.0);
        if (fArray == null || n2 >= fArray.length) {
            return 0.0f;
        }
        float f2 = (float)(d4 - (double)n2);
        return this.interpolator.interpolate(fArray, n2, f2);
    }

    @Override
    public float value(double d2, boolean bl) {
        float f2 = this.value(d2);
        if (bl) {
            f2 /= this.normVal;
        }
        return f2;
    }

    public float[] getValues(int n2, int n3, boolean bl) {
        int n4 = n3 - n2 + 1;
        float[] fArray = new float[n4];
        if (bl) {
            for (int i2 = n2; i2 <= n3; ++i2) {
                fArray[i2 - n2] = this.data[i2] / this.normVal;
            }
        } else {
            System.arraycopy(this.data, n2, fArray, 0, n4);
        }
        return fArray;
    }

    @Override
    public float[][] pointsBetween(double d2, double d3, boolean bl) {
        if (d3 < this.startTime || d2 > this.endTime || d2 >= d3) {
            return null;
        }
        if (d2 < this.startTime) {
            d2 = this.startTime;
            d3 = Math.max(d2 + this.T, d3);
        }
        if (d3 > this.endTime) {
            d3 = this.endTime;
            d2 = Math.min(d2, d3 - this.T);
        }
        float[][] fArrayArray = new float[2][];
        int n2 = (int)Math.max(Math.floor((d2 - this.startTime) / this.T), 0.0);
        n2 = Math.min(n2, this.getN() - 1);
        int n3 = (int)Math.min(Math.floor((d3 - this.startTime) / this.T), (double)(this.getN() - 1));
        fArrayArray[0] = new float[2];
        fArrayArray[0][0] = (float)(this.startTime + (double)n2 * this.T);
        fArrayArray[0][1] = (float)this.T;
        fArrayArray[1] = this.getValues(n2, n3, bl);
        return fArrayArray;
    }

    @Override
    public boolean inTimeRange(double d2) {
        double d3 = this.oversampled != null && this.oversampled.B() ? this.T / (double)this.oversampled.A : this.T;
        return d2 >= this.startTime - d3 / 3.0 && d2 <= this.endTime + d3 / 3.0;
    }

    @Override
    public float[] getData() {
        if (this.sdSource != null) {
            this.getOversampled();
        }
        return this.data;
    }

    public void setData(float[] fArray) {
        this.data = fArray;
    }

    public float[] getNormData() {
        if (this.sdSource != null) {
            this.getOversampled();
        }
        float[] fArray = new float[this.data.length];
        for (int i2 = 0; i2 < this.data.length; ++i2) {
            fArray[i2] = this.data[i2] / this.normVal;
        }
        return fArray;
    }

    @Override
    public double getStartTime() {
        return this.startTime;
    }

    @Override
    public double getEndTime() {
        return this.endTime;
    }

    public void setStartTime(double d2) {
        if (d2 != this.startTime) {
            this.startTime = d2;
            this.endTime = this.startTime + (double)(this.n - 1) * this.T;
            if (this.oversampled != null && this.oversampled.B()) {
                if (this.sdSource != null) {
                    this.oversampled.B = this.startTime;
                    this.oversampled.H = this.endTime;
                } else {
                    this.oversampled.B = this.startTime + this.T * (double)this.oversampled.F / (double)this.oversampled.A;
                    this.oversampled.H = this.startTime + this.T * (double)this.oversampled.D / (double)this.oversampled.A;
                }
            }
        }
    }

    public double getAbsMaxVal() {
        return this.absMaxVal;
    }

    public int getAbsMaxIndex() {
        return this.absMaxIndex;
    }

    public int getTZeroIndex() {
        return (int)Math.round(-this.startTime / this.T);
    }

    public Double getAbsMaxInterpIndex() {
        return this.absMaxDoubleIndex;
    }

    public Interpolation getInterpolator() {
        return this.interpolator;
    }

    public void setInterpolator(Interpolation interpolation) {
        this.interpolator = interpolation;
    }

    public void setOversampler(Interpolation interpolation) {
        this.oversampler = interpolation;
    }

    public Interpolation getOversampler() {
        return this.oversampler;
    }

    public double getSmoothTC() {
        return this.smoothT;
    }

    public void smooth(double d2) {
        if (d2 == 0.0) {
            this.smoothT = -1.0;
            if (this.unsmoothed != null) {
                this.data = this.unsmoothed;
                this.unsmoothed = null;
                this.dataChanged();
            }
        } else if (this.smoothT == 0.0 || Math.abs(1.0 - d2 / this.smoothT) > 0.001) {
            this.smoothT = d2;
            if (this.unsmoothed == null) {
                this.unsmoothed = this.data;
            }
            this.data = kJ.A(d2 / this.T, this.unsmoothed);
            this.dataChanged();
        }
    }

    public OctaveFilterSettings getFiltSettings() {
        if (this.filtSettings == null) {
            this.filtSettings = new OctaveFilterSettings();
        }
        return this.filtSettings;
    }

    public float[] getUnfilteredData() {
        if (this.unfilt == null) {
            return this.data;
        }
        return this.unfilt;
    }

    public boolean octaveFilter(OctaveFilterSettings octaveFilterSettings, boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = this.filtSettings == null || octaveFilterSettings.differsFrom(this.filtSettings);
        if (bl2) {
            if (this.unfilt == null) {
                this.unfilt = this.data;
                this.unfiltAbsMaxIndex = this.absMaxIndex;
                this.unfiltAbsMaxDoubleIndex = this.absMaxDoubleIndex;
                this.unfiltAbsMaxVal = this.absMaxVal;
                this.unfiltNormVal = this.normVal;
                this.unfiltLnz = lH.C(this.unfilt);
                this.unfiltFnz = lH.B(this.unfilt);
                this.fillAfterUnfiltLnz = this.unfiltLnz - this.unfiltFnz > this.data.length / 4;
            }
            this.data = this.unfilt;
            this.normVal = this.unfiltNormVal;
            this.absMaxVal = this.unfiltAbsMaxVal;
            this.absMaxIndex = this.unfiltAbsMaxIndex;
            this.absMaxDoubleIndex = this.unfiltAbsMaxDoubleIndex;
            if (octaveFilterSettings.filterFc > 0.0) {
                this.data = AD.A(this.data, 1.0 / this.T, octaveFilterSettings);
                if (this.fillAfterUnfiltLnz) {
                    Arrays.fill(this.data, this.unfiltLnz, this.data.length, 0.0f);
                }
                this.maxScan();
                this.resetNormVal();
            }
            this.filtSettings = octaveFilterSettings;
            if (!bl) {
                this.dataChanged();
            }
        }
        return bl2;
    }

    public void resample(double d2) {
        int n2;
        C c2 = new C(A.D, d2, d2);
        int n3 = this.data.length;
        int n4 = n2 = (int)Math.ceil((double)n3 * d2);
        boolean bl = true;
        float[] fArray = new float[n2];
        c2.A(d2, this.data, 0, n3, bl, fArray, 0, n4);
        this.data = fArray;
        this.n = this.data.length;
        this.T /= d2;
        this.endTime = this.startTime + (double)(this.n - 1) * this.T;
        this.dataChanged();
    }

    protected void dataChanged() {
        if (this.oversampled != null) {
            this.oversampled.A(false);
        }
        if (this.graphTimeData != null) {
            this.graphTimeData.A();
        }
    }

    public void shorten(int n2) {
        if (n2 < this.n) {
            float[] fArray = new float[n2];
            this.n = n2;
            System.arraycopy(this.data, 0, fArray, 0, n2);
            this.data = fArray;
            this.endTime = this.startTime + (double)(this.n - 1) * this.T;
            this.maxScan();
            this.dataChanged();
        }
    }

    public void trimTo(int n2, int n3) {
        if (n2 < this.n && n3 < this.n) {
            float[] fArray = new float[n3 - n2];
            this.n = fArray.length;
            this.startTime += (double)n2 * this.T;
            this.endTime = this.startTime + (double)(this.n - 1) * this.T;
            System.arraycopy(this.data, n2, fArray, 0, this.n);
            this.data = fArray;
            this.maxScan();
            this.dataChanged();
        }
    }

    public double getPeakTime() {
        return this.startTime + this.absMaxDoubleIndex * this.T;
    }

    public void zeroSamplesAfter(int n2) {
        for (int i2 = n2 + 1; i2 < this.n; ++i2) {
            this.data[i2] = 0.0f;
        }
    }

    public static int getCAPTURED_OVERSAMPLE() {
        return 1;
    }

    public static int getFDWOversample(int n2) {
        if (n2 <= 524288) {
            return 2;
        }
        return 1;
    }

    public static int getIROversample(int n2) {
        if (n2 <= 524288) {
            return 4;
        }
        if (n2 <= 0x100000) {
            return 2;
        }
        return 1;
    }

    public static int getSTEP_OVERSAMPLE() {
        return 1;
    }

    public static int getWINIR_OVERSAMPLE() {
        return 1;
    }

    public static int getENVELOPE_OVERSAMPLE() {
        return 1;
    }

    public static int getSCHROEDER_OVERSAMPLE() {
        return 1;
    }

    public static int getDEFAULT_OVERSAMPLE() {
        return 1;
    }
}

