/*
 * Decompiled with CFR 0.152.
 */
package roomeqwizard;

import java.util.Comparator;

public enum SampleRates {
    RATE8K(8000, "8 kHz"),
    RATE16K(16000, "16 kHz"),
    RATE24K(24000, "24 kHz"),
    RATE32K(32000, "32 kHz"),
    RATE44K(44100, "44.1 kHz"),
    RATE48K(48000, "48 kHz"),
    RATE88K(88200, "88.2 kHz"),
    RATE96K(96000, "96 kHz"),
    RATE176K(176400, "176.4 kHz"),
    RATE192K(192000, "192 kHz"),
    RATE352K(352800, "352.8 kHz"),
    RATE384K(384000, "384 kHz"),
    RATE706K(705600, "705.6 kHz"),
    RATE768K(768000, "768 kHz"),
    RATE1411K(1411200, "1411.2 kHz"),
    RATE1536K(0x177000, "1536 kHz");

    private int rate;
    private String description;
    private static Comparator comparator;

    private SampleRates(int n3, String string2) {
        this.rate = n3;
        this.description = string2;
    }

    public String toString() {
        return this.description;
    }

    public String getDescription() {
        return this.description;
    }

    public int intValue() {
        return this.rate;
    }

    public double doubleValue() {
        return this.rate;
    }

    public static SampleRates getRateEnum(int n2) {
        for (SampleRates sampleRates : SampleRates.values()) {
            if (sampleRates.intValue() != n2) continue;
            return sampleRates;
        }
        return RATE48K;
    }

    public static SampleRates getRateEnumNoFallback(int n2) {
        for (SampleRates sampleRates : SampleRates.values()) {
            if (sampleRates.intValue() != n2) continue;
            return sampleRates;
        }
        return null;
    }

    public static SampleRates getRateEnumNoFallback(float f2) {
        for (SampleRates sampleRates : SampleRates.values()) {
            if ((float)sampleRates.intValue() != f2) continue;
            return sampleRates;
        }
        return null;
    }

    public static SampleRates getRateEnumFromDescription(String string) {
        for (SampleRates sampleRates : SampleRates.values()) {
            if (!sampleRates.description.equals(string)) continue;
            return sampleRates;
        }
        return RATE48K;
    }

    public static SampleRates[] scValues() {
        return new SampleRates[]{RATE44K, RATE48K, RATE88K, RATE96K, RATE176K, RATE192K, RATE352K, RATE384K, RATE706K, RATE768K, RATE1411K, RATE1536K};
    }

    public static int getMaxRate() {
        int n2 = RATE44K.intValue();
        for (SampleRates sampleRates : SampleRates.values()) {
            if (sampleRates.intValue() <= n2) continue;
            n2 = sampleRates.intValue();
        }
        return n2;
    }

    public static int getNextRate(double d2) {
        for (SampleRates sampleRates : SampleRates.values()) {
            if (!((double)sampleRates.intValue() > 2.0 * d2)) continue;
            return sampleRates.intValue();
        }
        return (int)Math.round(2.0 * d2);
    }

    public static Comparator getComparator() {
        return comparator;
    }

    static {
        comparator = new _A();
    }

    private static final class _A
    implements Comparator<SampleRates> {
        private _A() {
        }

        public int A(SampleRates sampleRates, SampleRates sampleRates2) {
            return sampleRates.intValue() - sampleRates2.intValue();
        }
    }
}

