/*
 * Decompiled with CFR 0.152.
 */
package roomeqwizard;

import java.io.Serializable;
import roomeqwizard.BaseImpedanceModel;
import roomeqwizard.EK;
import roomeqwizard.HD;
import roomeqwizard.ModelParameter;
import roomeqwizard.MotionalImpedance;
import roomeqwizard.MotionalImpedanceModel;
import roomeqwizard.TSParams;

class SILOGModel
extends BaseImpedanceModel
implements Serializable {
    static final long serialVersionUID = 1L;
    private double GLES;
    private double GLESR;
    private double L0;
    private double lambda;
    private boolean disableLambda;
    private boolean optimiseGLESR;
    private MotionalImpedanceModel model;

    SILOGModel(TSParams tSParams, MotionalImpedanceModel motionalImpedanceModel) {
        super(tSParams);
        this.model = motionalImpedanceModel;
        switch (motionalImpedanceModel) {
            case FDD: {
                this.disableLambda = true;
                this.optimiseGLESR = false;
                break;
            }
            case SILOG: {
                this.disableLambda = false;
                this.optimiseGLESR = false;
                break;
            }
            case SILOGR: {
                this.disableLambda = false;
                this.optimiseGLESR = true;
                break;
            }
            default: {
                assert (false) : "Unhandled enum type";
                break;
            }
        }
    }

    @Override
    public MotionalImpedanceModel getModel() {
        return this.model;
    }

    @Override
    public void setPrimaryValues(MotionalImpedance motionalImpedance) {
        assert (motionalImpedance instanceof SILOGModel);
        this.primaryOmegaS = motionalImpedance.getOmegaS();
        this.primaryCMES = motionalImpedance.getParam(ModelParameter.CMES);
        this.lambda = motionalImpedance.getParam(ModelParameter.LAMBDA);
    }

    @Override
    public void initialise(double d2, float f2, float f3, float f4, double d3, double d4, boolean bl) {
        super.initialise(d2, f2, f3, f4, d3, d4, bl);
        double d5 = d4 - d3;
        this.RES = d5 * (1.0 + 500.0 / this.omegaS);
        this.L0 = this.LCES;
        this.GLES = 0.002 * this.RES;
        if (bl) {
            this.lambda = 0.1;
        }
        if (this.optimiseGLESR && bl) {
            this.GLESR = d3;
        } else if (this.getModel() == MotionalImpedanceModel.FDD) {
            this.GLESR = 0.0;
        }
    }

    @Override
    public int getOptimiserParamCount() {
        switch (this.model) {
            case FDD: {
                return 3;
            }
            case SILOG: {
                return 4;
            }
            case SILOGR: {
                return 5;
            }
        }
        assert (false) : "Unhandled enum type";
        return 5;
    }

    @Override
    public void scaleParams(double[] dArray, HD[] hDArray, double d2, boolean bl) {
        this.CMES = dArray.length > 1 ? hDArray[0].A(this.CMES, dArray[0], 0.0, 0.0) : dArray[0];
        if (!bl) {
            this.L0 = hDArray[1].A(this.L0, dArray[1], 0.0, 0.0);
        }
        if (dArray.length > 2) {
            int n2 = 2;
            if (this.isPrimary) {
                this.GLES = hDArray[n2].A(this.GLES, dArray[n2], 0.0, 0.0);
            }
            ++n2;
            if (this.isPrimary && this.optimiseGLESR) {
                this.GLESR = hDArray[n2].A(this.GLESR, dArray[n2], 0.0, 0.0);
                ++n2;
            }
            if (this.isPrimary && !this.disableLambda) {
                this.lambda = hDArray[n2].A(this.lambda, dArray[n2], 0.0, 0.0);
            }
        }
        this.recalcParams(d2);
    }

    @Override
    public double modelFit(double[] dArray, HD[] hDArray, boolean bl, double d2, double[] dArray2, double[] dArray3, double[] dArray4, double[] dArray5) {
        double d3 = this.RES;
        double d4 = this.GLES;
        double d5 = this.GLESR;
        double d6 = this.L0;
        double d7 = this.CMES;
        double d8 = this.lambda;
        double d9 = this.primaryOmegaS;
        this.scaleParams(dArray, hDArray, d2, bl);
        double d10 = this.calculateError(dArray2, dArray3, dArray4, dArray5);
        this.RES = d3;
        this.GLES = d4;
        this.GLESR = d5;
        this.L0 = d6;
        this.CMES = d7;
        this.lambda = d8;
        this.primaryOmegaS = d9;
        this.recalcParams(d2);
        return d10;
    }

    @Override
    public double modelFit(double d2, boolean bl, double d3, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4) {
        double d4 = this.CMES;
        this.CMES = d2;
        double d5 = this.calculateError(dArray, dArray2, dArray3, dArray4);
        this.CMES = d4;
        this.recalcParams(d3);
        return d5;
    }

    @Override
    public double fitNewValue(double d2, double d3, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4) {
        assert (false) : "fitNewValue not applicable for SI-LOG";
        return 0.0;
    }

    @Override
    public double[] fMinLimits(boolean bl) {
        assert (!bl);
        double[] dArray = new double[2];
        double d2 = this.primaryOmegaS / this.peakOmega;
        double d3 = d2 * d2 * this.primaryCMES;
        dArray[0] = 0.9 * d3;
        dArray[1] = 1.1 * d3;
        return dArray;
    }

    @Override
    protected void calcCompliance(double d2) {
        double d3 = this.getLambdaFactor(d2);
        this.LCES = this.L0 * d3;
        this.YLCES = 1.0 / (this.GLESR + d2 * this.GLES * d3);
    }

    @Override
    protected double getYES() {
        return 1.0 / this.RES + this.YLCES;
    }

    protected void calcOmegaSValues() {
        this.omegaS = this.peakOmega;
        for (int i2 = 0; i2 < 10; ++i2) {
            this.calcCompliance(this.omegaS);
            double d2 = 1.0 / Math.sqrt(this.CMES * this.LCES);
            double d3 = Math.abs(1.0 - d2 / this.omegaS);
            this.omegaS = d2;
            if (d3 < 1.0E-4) break;
        }
        double d4 = this.omegaS / (Math.PI * 2);
        double d5 = this.ts.zParabolic(d4);
        EK eK2 = this.ts.getVoiceCoil().Z(this.omegaS);
        double d6 = 1.0 / this.YLCES;
        double d7 = d5 - this.ts.getRDC() - eK2.B;
        double d8 = d6 / d7;
        this.RES = d8 <= 1.0 || d8 - 1.0 < 1.0E-6 ? 1000000.0 : 1.0 / (1.0 / d7 - 1.0 / d6);
        if (this.RES < d7) {
            this.RES = d7;
        }
        this.LCESAtOmegaS = this.LCES;
        this.RESAtOmegaS = 1.0 / (1.0 / this.RES + this.YLCES);
    }

    @Override
    public void recalcParams(double d2) {
        this.calcOmegaSValues();
        if (this.isPrimary) {
            this.primaryOmegaS = this.omegaS;
        }
        this.QES = this.omegaS * this.CMES * d2;
        this.QMS = this.omegaS * this.CMES * this.RESAtOmegaS;
        this.QTS = this.QES * this.QMS / (this.QES + this.QMS);
    }

    @Override
    public double getResEquiv() {
        return this.RESAtOmegaS;
    }

    @Override
    public double getLCES(double d2) {
        return this.L0 * this.getLambdaFactor(d2);
    }

    private double getLambdaFactor(double d2) {
        double d3 = 1.0;
        if (d2 < 10.0) {
            d2 = 10.0;
        }
        if (!this.disableLambda && this.primaryOmegaS > 0.0) {
            d3 = 1.0 - this.lambda * Math.log10(d2 / this.primaryOmegaS);
        }
        if (d3 < 1.0E-6) {
            d3 = 1.0E-6;
        }
        return d3;
    }

    @Override
    public void setParam(ModelParameter modelParameter, double d2) {
        switch (modelParameter) {
            case RES: {
                this.RES = d2;
                break;
            }
            case CMES: {
                this.CMES = d2;
                break;
            }
            case L0: {
                this.L0 = d2;
                break;
            }
            case GLES: {
                this.GLES = d2;
                break;
            }
            case GLESR: {
                this.GLESR = d2;
                break;
            }
            case LAMBDA: {
                this.lambda = d2;
                break;
            }
            default: {
                assert (false) : "Unhandled enum type " + (Object)((Object)modelParameter);
                break;
            }
        }
    }

    @Override
    public double getParam(ModelParameter modelParameter) {
        switch (modelParameter) {
            case RES: {
                return this.RES;
            }
            case CMES: {
                return this.CMES;
            }
            case L0: {
                return this.L0;
            }
            case GLES: {
                return this.GLES;
            }
            case GLESR: {
                return this.GLESR;
            }
            case LAMBDA: {
                return this.lambda;
            }
        }
        assert (false) : "Unhandled enum type " + (Object)((Object)modelParameter);
        return 0.0;
    }
}

