/*
 * Decompiled with CFR 0.152.
 */
package roomeqwizard;

import java.awt.Color;
import java.io.Serializable;
import roomeqwizard.SpeakerID;
import roomeqwizard.fG;
import roomeqwizard.lI;

class RoomSpeaker
implements lI,
Comparable<RoomSpeaker>,
Serializable {
    static final long serialVersionUID = 0L;
    static final double NOMINAL_DIM = 0.3;
    static final String[] orientations = new String[]{fG.A(0.0), fG.A(90.0), fG.A(180.0), fG.A(270.0)};
    protected final double width = 0.3;
    protected final double depth = 0.3;
    protected final double height = 0.3;
    protected final double acousticDeltaX = 0.3;
    protected final double acousticDeltaY = 0.15;
    protected final double acousticDeltaZ = 0.15;
    protected final double driverDiam = 0.25;
    protected final SpeakerID id;
    protected final Color color;
    protected boolean isSelected;
    protected double rearDist;
    protected double leftDist;
    protected double floorDist;
    protected double angle;
    protected transient int planx0;
    protected transient int plany0;
    protected transient int planx1;
    protected transient int plany1;
    protected transient int elevx0;
    protected transient int elevy0;
    protected transient int elevx1;
    protected transient int elevy1;

    RoomSpeaker(SpeakerID speakerID, Color color) {
        this.id = speakerID;
        this.color = color;
    }

    void setCoords(double[] dArray) {
        this.rearDist = dArray[0];
        this.leftDist = dArray[1];
        this.floorDist = dArray[2];
    }

    void setSelected(boolean bl) {
        this.isSelected = bl;
    }

    SpeakerID getID() {
        return this.id;
    }

    String getLetter() {
        return this.id.getLetter();
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    void setAngle(double d2) {
        this.angle = d2;
    }

    double getAngle() {
        return this.angle;
    }

    @Override
    public void setPlanBounds(int n2, int n3, int n4, int n5) {
        this.planx0 = n2;
        this.plany0 = n3;
        this.planx1 = n4;
        this.plany1 = n5;
    }

    int getPlanY1() {
        return this.plany1;
    }

    @Override
    public void setElevationBounds(int n2, int n3, int n4, int n5) {
        this.elevx0 = n2;
        this.elevy0 = n3;
        this.elevx1 = n4;
        this.elevy1 = n5;
    }

    @Override
    public int limitdx(int n2, double d2, int n3, int n4, int n5, int n6) {
        throw new AssertionError();
    }

    @Override
    public int limitdy(int n2, double d2, int n3, int n4, int n5, int n6) {
        throw new AssertionError();
    }

    @Override
    public int limitdz(int n2, double d2, int n3, int n4, int n5, int n6) {
        throw new AssertionError();
    }

    @Override
    public boolean withinPlan(int n2, int n3) {
        return n2 >= this.planx0 && n2 <= this.planx1 && n3 >= this.plany0 && n3 <= this.plany1;
    }

    @Override
    public boolean withinElevation(int n2, int n3) {
        return n2 >= this.elevx0 && n2 <= this.elevx1 && n3 >= this.elevy0 && n3 <= this.elevy1;
    }

    @Override
    public boolean movesInWidth() {
        return true;
    }

    @Override
    public boolean movesInLength() {
        return true;
    }

    @Override
    public boolean movesInHeight() {
        return true;
    }

    @Override
    public boolean upIsSelected() {
        throw new AssertionError();
    }

    @Override
    public boolean downIsSelected() {
        throw new AssertionError();
    }

    @Override
    public boolean fwdIsSelected() {
        throw new AssertionError();
    }

    @Override
    public boolean backIsSelected() {
        throw new AssertionError();
    }

    @Override
    public double getUpOffset() {
        throw new AssertionError();
    }

    @Override
    public double getDownOffset() {
        throw new AssertionError();
    }

    @Override
    public double getFwdOffset() {
        throw new AssertionError();
    }

    @Override
    public double getBackOffset() {
        throw new AssertionError();
    }

    @Override
    public boolean isSelected() {
        return this.isSelected;
    }

    public void setPairedTo(lI lI2) {
    }

    @Override
    public lI getPairedTo() {
        return null;
    }

    @Override
    public double[] getCoords() {
        double[] dArray = new double[]{this.rearDist, this.leftDist, this.floorDist};
        return dArray;
    }

    @Override
    public double[] getDragOffsets() {
        return new double[3];
    }

    @Override
    public double[] getDraggedCoords() {
        return new double[3];
    }

    double getX() {
        return this.rearDist;
    }

    double getY() {
        return this.leftDist;
    }

    double getZ() {
        return this.floorDist;
    }

    double fromRear() {
        return this.rearDist;
    }

    double fromLeft() {
        return this.leftDist;
    }

    double fromFloor() {
        return this.floorDist;
    }

    double[] getAcousticOffsetsAndSize() {
        double[] dArray = new double[6];
        switch ((int)this.angle) {
            case 0: {
                dArray[0] = 0.0;
                dArray[1] = -0.15;
                break;
            }
            case 90: {
                dArray[0] = 0.15;
                dArray[1] = -0.3;
                break;
            }
            case 180: {
                dArray[0] = 0.3;
                dArray[1] = -0.15;
                break;
            }
            case 270: {
                dArray[0] = 0.15;
                dArray[1] = 0.0;
                break;
            }
            default: {
                assert (false) : "Unhandled source angle in getCoords: " + this.angle;
                break;
            }
        }
        dArray[2] = -0.15;
        dArray[3] = 0.3;
        dArray[4] = 0.3;
        dArray[5] = 0.3;
        return dArray;
    }

    double[] getBoundaryOffsets() {
        double[] dArray = new double[6];
        switch ((int)this.angle) {
            case 0: {
                dArray[0] = 0.0;
                dArray[1] = 0.15;
                dArray[3] = 0.3;
                dArray[4] = 0.15;
                break;
            }
            case 90: {
                dArray[3] = 0.15;
                dArray[4] = 0.3;
                dArray[0] = 0.15;
                dArray[1] = 0.0;
                break;
            }
            case 180: {
                dArray[3] = 0.0;
                dArray[4] = 0.15;
                dArray[0] = 0.3;
                dArray[1] = 0.15;
                break;
            }
            case 270: {
                dArray[0] = 0.15;
                dArray[1] = 0.3;
                dArray[3] = 0.15;
                dArray[4] = 0.0;
                break;
            }
            default: {
                assert (false) : "Unhandled source angle in getBoundaryOffsets: " + this.angle;
                break;
            }
        }
        dArray[2] = 0.15;
        dArray[5] = 0.15;
        return dArray;
    }

    double getAcousticDeltaX() {
        return 0.3;
    }

    double getAcousticDeltaY() {
        return 0.15;
    }

    double getAcousticDeltaZ() {
        return 0.15;
    }

    double getWidth() {
        return 0.3;
    }

    double getDepth() {
        return 0.3;
    }

    double getDriverDiam() {
        return 0.25;
    }

    @Override
    public void setPlanMove(double d2, double d3) {
    }

    @Override
    public void setElevationMove(double d2, double d3) {
    }

    @Override
    public void setDragOffsets(double d2, double d3, double d4) {
    }

    @Override
    public String moveLabel() {
        return this.id.getLabel();
    }

    @Override
    public int compareTo(RoomSpeaker roomSpeaker) {
        if (roomSpeaker == null) {
            throw new NullPointerException();
        }
        if (roomSpeaker.getPlanY1() > this.getPlanY1()) {
            return -1;
        }
        if (roomSpeaker.getPlanY1() > this.getPlanY1()) {
            return 1;
        }
        return 0;
    }

    static RoomSpeaker[] sortedByDistanceFromFront(RoomSpeaker[] roomSpeakerArray) {
        int n2 = 0;
        for (RoomSpeaker roomSpeaker : roomSpeakerArray) {
            if (!roomSpeaker.isSelected()) continue;
            ++n2;
        }
        RoomSpeaker[] roomSpeakerArray2 = new RoomSpeaker[n2];
        int n3 = 0;
        RoomSpeaker[] roomSpeakerArray3 = roomSpeakerArray;
        int n4 = roomSpeakerArray3.length;
        for (int i2 = 0; i2 < n4; ++i2) {
            RoomSpeaker roomSpeaker = roomSpeakerArray3[i2];
            if (!roomSpeaker.isSelected()) continue;
            roomSpeakerArray2[n3++] = roomSpeaker;
        }
        for (int i3 = 0; i3 < roomSpeakerArray2.length - 1; ++i3) {
            for (n4 = roomSpeakerArray2.length - 1; n4 > i3; --n4) {
                RoomSpeaker roomSpeaker = roomSpeakerArray2[n4];
                if (roomSpeaker.getPlanY1() >= roomSpeakerArray2[n4 - 1].getPlanY1()) continue;
                roomSpeakerArray2[n4] = roomSpeakerArray2[n4 - 1];
                roomSpeakerArray2[n4 - 1] = roomSpeaker;
            }
        }
        return roomSpeakerArray2;
    }
}

