/*
 * Decompiled with CFR 0.152.
 */
package roomeqwizard;

import java.io.Serializable;
import roomeqwizard.EK;
import roomeqwizard.LOGModel;
import roomeqwizard.ModelParameter;
import roomeqwizard.MotionalImpedance;
import roomeqwizard.MotionalImpedanceModel;
import roomeqwizard.TSParams;
import roomeqwizard.lH;

class Ritter3PCModel
extends LOGModel
implements Serializable {
    static final long serialVersionUID = 1L;
    private double W0;

    Ritter3PCModel(TSParams tSParams) {
        super(tSParams);
    }

    @Override
    public MotionalImpedanceModel getModel() {
        return MotionalImpedanceModel.RITTER3PC;
    }

    @Override
    public void setPrimaryValues(MotionalImpedance motionalImpedance) {
        assert (motionalImpedance instanceof Ritter3PCModel);
        this.R0 = motionalImpedance.getParam(ModelParameter.R0);
        this.L0 = motionalImpedance.getParam(ModelParameter.L0);
        this.beta = motionalImpedance.getParam(ModelParameter.BETA);
        this.W0 = motionalImpedance.getParam(ModelParameter.W0);
        this.primaryOmegaS = motionalImpedance.getOmegaS();
        this.primaryCMES = motionalImpedance.getParam(ModelParameter.CMES);
    }

    @Override
    public void initialise(double d2, float f2, float f3, float f4, double d3, double d4, boolean bl) {
        super.initialise(d2, f2, f3, f4, d3, d4, bl);
        this.beta = 0.01;
        this.L0 = this.LCES;
        this.R0 = d4 - d3;
        this.W0 = d2 * 3.0 * Math.PI;
        this.primaryOmegaS = this.peakOmega;
        this.primaryCMES = this.CMES;
        this.calcCompliance(this.peakOmega);
        this.calcOmegaSValues();
    }

    @Override
    public void setPeakOmega(double d2) {
        super.setPeakOmega(d2);
        this.W0 = this.peakOmega * 1.5;
        this.primaryOmegaS = this.peakOmega;
        this.calcCompliance(this.peakOmega);
        this.calcOmegaSValues();
    }

    @Override
    public double[] fMinLimits(boolean bl) {
        double[] dArray = new double[2];
        if (this.isPrimary || !bl) {
            dArray[0] = 0.0;
            dArray[1] = 0.4;
        } else {
            double d2 = this.primaryOmegaS / this.peakOmega;
            double d3 = d2 * d2 * this.primaryCMES;
            dArray[0] = 0.9 * d3;
            dArray[1] = 1.1 * d3;
        }
        return dArray;
    }

    @Override
    protected EK sigma(double d2, double d3) {
        double d4 = this.W0 * this.W0 + d2 * d2;
        double d5 = 1.0 - d3 * Math.log(lH.A(d2 * d2 / d4, this.W0 * d2 / d4));
        if (d5 < 1.0E-9) {
            d5 = 1.0E-9;
        }
        double d6 = -d3 * Math.atan2(this.W0 * d2 / d4, d2 * d2 / d4);
        return EK.B(d5, d6);
    }

    @Override
    protected void calcCompliance(double d2) {
        double d3 = this.W0 * this.W0 + d2 * d2;
        double d4 = 1.0 - this.beta * Math.log(lH.A(d2 * d2 / d3, this.W0 * d2 / d3));
        if (d4 < 1.0E-9) {
            d4 = 1.0E-9;
        }
        double d5 = -this.beta * Math.atan2(this.W0 * d2 / d3, d2 * d2 / d3);
        double d6 = d4 * d4 + d5 * d5;
        this.LCES = this.L0 * d6 / d4;
        this.YLCES = -d5 / (this.L0 * d2 * d6);
    }

    @Override
    protected double calcLCES(double d2) {
        double d3 = this.W0 * this.W0 + d2 * d2;
        double d4 = 1.0 - this.beta * Math.log(lH.A(d2 * d2 / d3, this.W0 * d2 / d3));
        if (d4 < 1.0E-9) {
            d4 = 1.0E-9;
        }
        double d5 = -this.beta * Math.atan2(this.W0 * d2 / d3, d2 * d2 / d3);
        double d6 = d4 * d4 + d5 * d5;
        return this.L0 * d6 / d4;
    }

    @Override
    public void setParam(ModelParameter modelParameter, double d2) {
        switch (modelParameter) {
            case R0: {
                this.R0 = d2;
                break;
            }
            case RES: {
                this.RESAtOmegaS = d2;
                break;
            }
            case CMES: {
                this.CMES = d2;
                break;
            }
            case LCES: {
                this.LCESAtOmegaS = d2;
                break;
            }
            case BETA: {
                this.beta = d2;
                break;
            }
            case L0: {
                this.L0 = d2;
                break;
            }
            case W0: {
                this.W0 = d2;
                break;
            }
            default: {
                assert (false) : "Unhandled enum type " + (Object)((Object)modelParameter);
                break;
            }
        }
    }

    @Override
    public double getParam(ModelParameter modelParameter) {
        switch (modelParameter) {
            case R0: {
                return this.R0;
            }
            case RES: {
                return this.RESAtOmegaS;
            }
            case CMES: {
                return this.CMES;
            }
            case LCES: {
                return this.LCESAtOmegaS;
            }
            case BETA: {
                return this.beta;
            }
            case L0: {
                return this.L0;
            }
            case W0: {
                return this.W0;
            }
        }
        assert (false) : "Unhandled enum type " + (Object)((Object)modelParameter);
        return 0.0;
    }
}

