/*
 * Decompiled with CFR 0.152.
 */
package roomeqwizard;

import java.io.Serializable;
import java.util.Arrays;
import roomeqwizard.ISO3382Param;

final class RT60
implements Serializable,
Cloneable {
    static final long serialVersionUID = -1234567899987654321L;
    public static final double WARNING_R_THREHOLD = 0.99;
    double Fc = Double.NaN;
    int octaveFrac = 0;
    int order = 0;
    boolean reverseFiltered = false;
    boolean zeroPhaseFiltered = false;
    double[] EDT = new double[]{Double.NaN, Double.NaN, Double.NaN};
    double[] T20 = new double[]{Double.NaN, Double.NaN, Double.NaN};
    double[] T30 = new double[]{Double.NaN, Double.NaN, Double.NaN};
    double[] Topt = new double[]{Double.NaN, Double.NaN, Double.NaN};
    float[] decayCurve;
    double decayCurveStartTime;
    double timeStep;
    double C50 = Double.NaN;
    double C80 = Double.NaN;
    double D50 = Double.NaN;
    int ToptStartdB = -5;
    int ToptEnddB = -5;
    double TS = Double.NaN;
    double modelT60 = Double.NaN;
    double modelNoise = Double.NaN;
    double modelLevel = Double.NaN;
    int fitStartIndex;
    int fitEndIndex;
    int validEndIndex;
    int fitStartSlice;
    int fitEndSlice;
    double fitError;
    double fitDataStartTime;
    double[] modelResult;

    RT60(boolean bl, boolean bl2) {
        this.reverseFiltered = bl;
        this.zeroPhaseFiltered = bl2;
    }

    RT60() {
        this(false, false);
    }

    boolean hasModelData() {
        return Double.isFinite(this.modelT60);
    }

    boolean hasFitData() {
        return this.validEndIndex != 0;
    }

    public Object clone() {
        RT60 rT60 = null;
        try {
            rT60 = (RT60)super.clone();
            rT60.EDT = (double[])this.EDT.clone();
            rT60.T20 = (double[])this.T20.clone();
            rT60.T30 = (double[])this.T30.clone();
            rT60.Topt = (double[])this.Topt.clone();
            rT60.decayCurve = (float[])this.decayCurve.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return rT60;
    }

    boolean filterDirectionDifferent(boolean bl) {
        return this.reverseFiltered != bl;
    }

    boolean filterPhaseDifferent(boolean bl) {
        return this.zeroPhaseFiltered != bl;
    }

    boolean filterOrderDifferent(int n2) {
        return this.order != n2;
    }

    boolean hasValidData() {
        return !Double.isNaN(this.Topt[0]);
    }

    double[] ISO3382ValueSet(ISO3382Param iSO3382Param) {
        switch (iSO3382Param) {
            case EDT: {
                return this.EDT;
            }
            case T20: {
                return this.T20;
            }
            case T30: {
                return this.T30;
            }
            case CURVATURE: {
                return new double[]{100.0 * (this.T30[0] / this.T20[0] - 1.0)};
            }
            case C50: {
                return new double[]{this.C50};
            }
            case C80: {
                return new double[]{this.C80};
            }
            case D50: {
                return new double[]{this.D50};
            }
            case TS: {
                return new double[]{this.TS};
            }
            case TOPT: {
                return this.Topt;
            }
            case T60M: {
                return new double[]{this.modelT60};
            }
        }
        return this.Topt;
    }

    double ISO3382Value(ISO3382Param iSO3382Param) {
        switch (iSO3382Param) {
            case EDT: {
                return this.EDT[0];
            }
            case T20: {
                return this.T20[0];
            }
            case T30: {
                return this.T30[0];
            }
            case CURVATURE: {
                return 100.0 * (this.T30[0] / this.T20[0] - 1.0);
            }
            case C50: {
                return this.C50;
            }
            case C80: {
                return this.C80;
            }
            case D50: {
                return this.D50;
            }
            case TS: {
                return this.TS;
            }
            case TOPT: {
                return this.Topt[0];
            }
            case T60M: {
                return this.modelT60;
            }
        }
        return this.Topt[0];
    }

    void setISO3382Value(ISO3382Param iSO3382Param, double d2) {
        switch (iSO3382Param) {
            case EDT: {
                this.EDT[0] = d2;
                break;
            }
            case T20: {
                this.T20[0] = d2;
                break;
            }
            case T30: {
                this.T30[0] = d2;
                break;
            }
            case C50: {
                this.C50 = d2;
                break;
            }
            case C80: {
                this.C80 = d2;
                break;
            }
            case D50: {
                this.D50 = d2;
                break;
            }
            case TS: {
                this.TS = d2;
                break;
            }
            case TOPT: {
                this.Topt[0] = d2;
                break;
            }
            case T60M: {
                this.modelT60 = d2;
                break;
            }
            default: {
                assert (false) : "cannot set " + (Object)((Object)iSO3382Param);
                break;
            }
        }
    }

    double correlationCoefficient(ISO3382Param iSO3382Param) {
        switch (iSO3382Param) {
            case EDT: {
                return this.EDT[1];
            }
            case T20: {
                return this.T20[1];
            }
            case T30: {
                return this.T30[1];
            }
            case TOPT: {
                return this.Topt[1];
            }
        }
        return 1.0;
    }

    double rt60Value(ISO3382Param iSO3382Param) {
        switch (iSO3382Param) {
            case EDT: {
                return this.EDT[0];
            }
            case T20: {
                return this.T20[0];
            }
            case T30: {
                return this.T30[0];
            }
            case TOPT: {
                return this.Topt[0];
            }
            case T60M: {
                return this.modelT60;
            }
        }
        return 0.0;
    }

    double slope(ISO3382Param iSO3382Param) {
        switch (iSO3382Param) {
            case EDT: {
                return -60.0 / this.EDT[0];
            }
            case T20: {
                return -60.0 / this.T20[0];
            }
            case T30: {
                return -60.0 / this.T30[0];
            }
            case TOPT: {
                return -60.0 / this.Topt[0];
            }
            case T60M: {
                return -60.0 / this.modelT60;
            }
        }
        return 0.0;
    }

    double intercept(ISO3382Param iSO3382Param) {
        switch (iSO3382Param) {
            case EDT: {
                return this.EDT[2];
            }
            case T20: {
                return this.T20[2];
            }
            case T30: {
                return this.T30[2];
            }
            case TOPT: {
                return this.Topt[2];
            }
            case T60M: {
                return 10.0 * Math.log10(this.modelLevel) + this.fitDataStartTime * 60.0 / this.modelT60;
            }
        }
        return 1.0;
    }

    boolean edtValid() {
        return !Double.isNaN(this.edtValue());
    }

    double edtValue() {
        return this.EDT[0];
    }

    double edtCorrelationCoefficient() {
        return this.EDT[1];
    }

    double edtSlope() {
        return -60.0 / this.edtValue();
    }

    double edtIntercept() {
        return this.EDT[2];
    }

    boolean tOptValid() {
        return !Double.isNaN(this.tOptValue());
    }

    double tOptValue() {
        return this.Topt[0];
    }

    double toptCorrelationCoefficient() {
        return this.Topt[1];
    }

    double tOptSlope() {
        return -60.0 / this.tOptValue();
    }

    double tOptIntercept() {
        return this.Topt[2];
    }

    boolean t20Valid() {
        return !Double.isNaN(this.t20Value());
    }

    double t20Value() {
        return this.T20[0];
    }

    double t20CorrelationCoefficient() {
        return this.T20[1];
    }

    double t20Slope() {
        return -60.0 / this.t20Value();
    }

    double t20Intercept() {
        return this.T20[2];
    }

    boolean t30Valid() {
        return !Double.isNaN(this.t30Value());
    }

    double t30Value() {
        return this.T30[0];
    }

    double t30CorrelationCoefficient() {
        return this.T30[1];
    }

    double t30Slope() {
        return -60.0 / this.t30Value();
    }

    double t30Intercept() {
        return this.T30[2];
    }

    static boolean hasClarity(RT60[] rT60Array) {
        for (RT60 rT60 : rT60Array) {
            if (rT60 == null || rT60.C50 == 0.0) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "RT60{Fc=" + this.Fc + ", octaveFrac=" + this.octaveFrac + ", reverseFiltered=" + this.reverseFiltered + ", zeroPhaseFiltered=" + this.zeroPhaseFiltered + ", \nEDT=" + Arrays.toString(this.EDT) + ", \nT20=" + Arrays.toString(this.T20) + ", \nT30=" + Arrays.toString(this.T30) + ", \nTopt=" + Arrays.toString(this.Topt) + ", \nschroederStartTime=" + this.decayCurveStartTime + ", \nC50=" + this.C50 + ", C80=" + this.C80 + ", D50=" + this.D50 + ", \nToptStartdB=" + this.ToptStartdB + ", ToptEnddB=" + this.ToptEnddB + ", \nTS=" + this.TS + '}';
    }
}

