/*
 * Decompiled with CFR 0.152.
 */
package roomeqwizard;

import com.formdev.flatlaf.ui.FlatArrowButton;
import com.formdev.flatlaf.ui.FlatStylingSupport;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.ui.MigLayoutVisualPadding;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicSpinnerUI;
import roomeqwizard.QF;
import roomeqwizard.WizardLogger;

public class REWSpinnerUI
extends BasicSpinnerUI
implements FlatStylingSupport.StyleableUI {
    public static final String SPINNER_BUTTON_TYPE = "JSpinner.buttonType";
    public static final String SIDE_BY_SIDE_BUTTONS = "Spinner.sideBySideButtons";
    public static final String SIDE_BY_SIDE_MIN_HEIGHT = "Spinner.sideByMinHeight";
    @FlatStylingSupport.Styleable
    protected int minimumWidth;
    @FlatStylingSupport.Styleable
    protected String buttonStyle;
    @FlatStylingSupport.Styleable
    protected String arrowType;
    protected boolean isIntelliJTheme;
    @FlatStylingSupport.Styleable
    protected Color disabledBackground;
    @FlatStylingSupport.Styleable
    protected Color disabledForeground;
    @FlatStylingSupport.Styleable
    protected Color focusedBackground;
    @FlatStylingSupport.Styleable
    protected Color buttonBackground;
    @FlatStylingSupport.Styleable
    protected Color buttonDisabledBackground;
    @FlatStylingSupport.Styleable
    protected Color buttonHoverBackground;
    @FlatStylingSupport.Styleable
    protected Color buttonPressedBackground;
    @FlatStylingSupport.Styleable
    protected float buttonSeparatorWidth;
    @FlatStylingSupport.Styleable
    protected Color buttonSeparatorColor;
    @FlatStylingSupport.Styleable
    protected Color buttonDisabledSeparatorColor;
    @FlatStylingSupport.Styleable
    protected Color buttonArrowColor;
    @FlatStylingSupport.Styleable
    protected Color buttonDisabledArrowColor;
    @FlatStylingSupport.Styleable
    protected Color buttonHoverArrowColor;
    @FlatStylingSupport.Styleable
    protected Color buttonPressedArrowColor;
    @FlatStylingSupport.Styleable
    protected Insets padding;
    private _A handler;
    private Map<String, Object> oldStyleValues;
    private AtomicBoolean borderShared;
    private boolean sideBySideButtons;
    private int sideBySideMinHeight;
    private boolean sideBySideButtonsUIDefault;
    private int sideBySideMinHeightUIDefault;

    public static ComponentUI createUI(JComponent jComponent) {
        return new REWSpinnerUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.installStyle();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        LookAndFeel.installProperty(this.spinner, "opaque", false);
        this.minimumWidth = UIManager.getInt("Component.minimumWidth");
        this.buttonStyle = UIManager.getString("Spinner.buttonStyle");
        this.arrowType = UIManager.getString("Component.arrowType");
        this.isIntelliJTheme = UIManager.getBoolean("Component.isIntelliJTheme");
        this.disabledBackground = UIManager.getColor("Spinner.disabledBackground");
        this.disabledForeground = UIManager.getColor("Spinner.disabledForeground");
        this.focusedBackground = UIManager.getColor("Spinner.focusedBackground");
        this.buttonBackground = UIManager.getColor("Spinner.buttonBackground");
        this.buttonHoverBackground = UIManager.getColor("Button.hoverBackground");
        this.buttonPressedBackground = UIManager.getColor("Button.pressedBackground");
        this.buttonDisabledBackground = UIManager.getColor("Button.disabledBackground");
        this.buttonSeparatorWidth = FlatUIUtils.getUIFloat((String)"Spinner.buttonSeparatorWidth", (float)FlatUIUtils.getUIFloat((String)"Component.borderWidth", (float)1.0f));
        this.buttonSeparatorColor = UIManager.getColor("Spinner.buttonSeparatorColor");
        this.buttonDisabledSeparatorColor = UIManager.getColor("Spinner.buttonDisabledSeparatorColor");
        this.buttonArrowColor = UIManager.getColor("Spinner.buttonArrowColor");
        this.buttonDisabledArrowColor = UIManager.getColor("Spinner.buttonDisabledArrowColor");
        this.buttonHoverArrowColor = UIManager.getColor("Spinner.buttonHoverArrowColor");
        this.buttonPressedArrowColor = UIManager.getColor("Spinner.buttonPressedArrowColor");
        this.padding = UIManager.getInsets("Spinner.padding");
        this.sideBySideButtonsUIDefault = UIManager.getBoolean(SIDE_BY_SIDE_BUTTONS);
        this.sideBySideMinHeightUIDefault = UIManager.getInt(SIDE_BY_SIDE_MIN_HEIGHT);
        MigLayoutVisualPadding.install((JComponent)this.spinner);
    }

    @Override
    protected void uninstallDefaults() {
        super.uninstallDefaults();
        this.disabledBackground = null;
        this.disabledForeground = null;
        this.focusedBackground = null;
        this.buttonBackground = null;
        this.buttonHoverBackground = null;
        this.buttonPressedBackground = null;
        this.buttonDisabledBackground = null;
        this.buttonSeparatorColor = null;
        this.buttonDisabledSeparatorColor = null;
        this.buttonArrowColor = null;
        this.buttonDisabledArrowColor = null;
        this.buttonHoverArrowColor = null;
        this.buttonPressedArrowColor = null;
        this.padding = null;
        this.sideBySideButtonsUIDefault = false;
        this.oldStyleValues = null;
        this.borderShared = null;
        MigLayoutVisualPadding.uninstall((JComponent)this.spinner);
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.addEditorFocusListener(this.spinner.getEditor());
        this.spinner.addFocusListener(this.getHandler());
        this.spinner.addPropertyChangeListener(this.getHandler());
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.removeEditorFocusListener(this.spinner.getEditor());
        this.spinner.removeFocusListener(this.getHandler());
        this.spinner.removePropertyChangeListener(this.getHandler());
        this.handler = null;
    }

    private _A getHandler() {
        if (this.handler == null) {
            this.handler = new _A();
        }
        return this.handler;
    }

    protected void installStyle() {
        try {
            this.applyStyle(FlatStylingSupport.getResolvedStyle((JComponent)this.spinner, (String)"Spinner"));
        }
        catch (RuntimeException runtimeException) {
            WizardLogger.getLogger().log(Level.SEVERE, "Style installation exception", runtimeException);
        }
    }

    protected void applyStyle(Object object) {
        this.oldStyleValues = FlatStylingSupport.parseAndApply(this.oldStyleValues, (Object)object, this::applyStyleProperty);
        this.updateEditorPadding();
        this.updateArrowButtonsStyle();
    }

    protected Object applyStyleProperty(String string, Object object) {
        if (this.borderShared == null) {
            this.borderShared = new AtomicBoolean(true);
        }
        return REWSpinnerUI.applyToAnnotatedObjectOrBorder(this, string, object, this.spinner, this.borderShared);
    }

    static Object applyToAnnotatedObjectOrBorder(Object object, String string, Object object2, JComponent jComponent, AtomicBoolean atomicBoolean) {
        try {
            return FlatStylingSupport.applyToAnnotatedObject((Object)object, (String)string, (Object)object2);
        }
        catch (FlatStylingSupport.UnknownStyleException unknownStyleException) {
            Border border = jComponent.getBorder();
            if (border instanceof FlatStylingSupport.StyleableBorder) {
                if (atomicBoolean.get()) {
                    border = REWSpinnerUI.cloneBorder(border);
                    jComponent.setBorder(border);
                    atomicBoolean.set(false);
                }
                try {
                    return ((FlatStylingSupport.StyleableBorder)border).applyStyleProperty(string, object2);
                }
                catch (FlatStylingSupport.UnknownStyleException unknownStyleException2) {
                    // empty catch block
                }
            }
            try {
                return REWSpinnerUI.applyToProperty(jComponent, string, object2);
            }
            catch (FlatStylingSupport.UnknownStyleException unknownStyleException3) {
                throw unknownStyleException;
            }
        }
    }

    static Border cloneBorder(Border border) {
        Class<?> clazz = border.getClass();
        try {
            return (Border)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            throw new IllegalArgumentException("failed to clone border '" + clazz.getName() + "'", exception);
        }
    }

    private static Object applyToProperty(Object object, String string, Object object2) throws FlatStylingSupport.UnknownStyleException, IllegalArgumentException {
        Class<?> clazz = object.getClass();
        String string2 = REWSpinnerUI.buildMethodName("get", string);
        String string3 = REWSpinnerUI.buildMethodName("set", string);
        try {
            Method method;
            try {
                method = clazz.getMethod(string2, new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                method = clazz.getMethod(REWSpinnerUI.buildMethodName("is", string), new Class[0]);
            }
            Method method2 = clazz.getMethod(string3, method.getReturnType());
            Object object3 = method.invoke(object, new Object[0]);
            method2.invoke(object, REWSpinnerUI.convertToEnum(object2, method.getReturnType()));
            return object3;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new FlatStylingSupport.UnknownStyleException(string);
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException exception) {
            throw new IllegalArgumentException("failed to invoke property methods '" + clazz.getName() + "." + string2 + "()' or '" + string3 + "(...)'", exception);
        }
    }

    private static String buildMethodName(String string, String string2) {
        int n2 = string.length();
        int n3 = string2.length();
        char[] cArray = new char[n2 + n3];
        string.getChars(0, n2, cArray, 0);
        string2.getChars(0, n3, cArray, n2);
        cArray[n2] = Character.toUpperCase(cArray[n2]);
        return new String(cArray);
    }

    private static Object convertToEnum(Object object, Class<?> clazz) throws IllegalArgumentException {
        if (Enum.class.isAssignableFrom(clazz) && object instanceof String) {
            try {
                object = Enum.valueOf(clazz, (String)object);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IllegalArgumentException("unknown enum value '" + object + "' in enum '" + clazz.getName() + "'", illegalArgumentException);
            }
        }
        return object;
    }

    public Map<String, Class<?>> getStyleableInfos(JComponent jComponent) {
        return FlatStylingSupport.getAnnotatedStyleableInfos((Object)this, (Border)this.spinner.getBorder());
    }

    public Object getStyleableValue(JComponent jComponent, String string) {
        return FlatStylingSupport.getAnnotatedStyleableValue((Object)this, (Border)this.spinner.getBorder(), (String)string);
    }

    @Override
    protected JComponent createEditor() {
        JComponent jComponent = super.createEditor();
        this.configureEditor(jComponent);
        return jComponent;
    }

    @Override
    protected void replaceEditor(JComponent jComponent, JComponent jComponent2) {
        super.replaceEditor(jComponent, jComponent2);
        this.configureEditor(jComponent2);
        this.removeEditorFocusListener(jComponent);
        this.addEditorFocusListener(jComponent2);
    }

    protected void configureEditor(JComponent jComponent) {
        jComponent.setOpaque(false);
        JTextField jTextField = REWSpinnerUI.getEditorTextField(jComponent);
        if (jTextField != null) {
            jTextField.setOpaque(false);
        }
        this.updateEditorPadding();
        this.updateEditorColors();
    }

    private void addEditorFocusListener(JComponent jComponent) {
        JTextField jTextField = REWSpinnerUI.getEditorTextField(jComponent);
        if (jTextField != null) {
            jTextField.addFocusListener(this.getHandler());
        }
    }

    private void removeEditorFocusListener(JComponent jComponent) {
        JTextField jTextField = REWSpinnerUI.getEditorTextField(jComponent);
        if (jTextField != null) {
            jTextField.removeFocusListener(this.getHandler());
        }
    }

    private void updateEditorPadding() {
        JTextField jTextField = REWSpinnerUI.getEditorTextField(this.spinner.getEditor());
        if (jTextField != null) {
            jTextField.putClientProperty("JTextField.padding", this.padding);
        }
    }

    private void updateEditorColors() {
        JTextField jTextField = REWSpinnerUI.getEditorTextField(this.spinner.getEditor());
        if (jTextField != null) {
            jTextField.setForeground(FlatUIUtils.nonUIResource((Color)this.getForeground(true)));
            jTextField.setDisabledTextColor(FlatUIUtils.nonUIResource((Color)this.getForeground(false)));
        }
    }

    private static JTextField getEditorTextField(JComponent jComponent) {
        return jComponent instanceof JSpinner.DefaultEditor ? ((JSpinner.DefaultEditor)jComponent).getTextField() : null;
    }

    public static boolean isPermanentFocusOwner(JSpinner jSpinner) {
        if (FlatUIUtils.isPermanentFocusOwner((Component)jSpinner)) {
            return true;
        }
        JTextField jTextField = REWSpinnerUI.getEditorTextField(jSpinner.getEditor());
        return jTextField != null && FlatUIUtils.isPermanentFocusOwner((Component)jTextField);
    }

    protected Color getBackground(boolean bl) {
        if (bl) {
            Color color = this.spinner.getBackground();
            if (!(color instanceof UIResource)) {
                return color;
            }
            if (this.focusedBackground != null && REWSpinnerUI.isPermanentFocusOwner(this.spinner)) {
                return this.focusedBackground;
            }
            return color;
        }
        return this.isIntelliJTheme ? FlatUIUtils.getParentBackground((JComponent)this.spinner) : this.disabledBackground;
    }

    protected Color getForeground(boolean bl) {
        return bl ? this.spinner.getForeground() : this.disabledForeground;
    }

    @Override
    protected LayoutManager createLayout() {
        return this.getHandler();
    }

    @Override
    protected Component createNextButton() {
        return this.createArrowButton(1, "Spinner.nextButton");
    }

    @Override
    protected Component createPreviousButton() {
        return this.createArrowButton(5, "Spinner.previousButton");
    }

    private Component createArrowButton(int n2, String string) {
        QF qF2 = new QF(n2, this.arrowType, this.buttonArrowColor, this.buttonDisabledArrowColor, this.buttonHoverArrowColor, null, this.buttonPressedArrowColor, null);
        qF2.setName(string);
        qF2.setYOffset(n2 == 1 ? 1.25f : -1.25f);
        if (n2 == 1) {
            this.installNextButtonListeners((Component)((Object)qF2));
        } else {
            this.installPreviousButtonListeners((Component)((Object)qF2));
        }
        return qF2;
    }

    private void updateArrowButtonsStyle() {
        for (Component component : this.spinner.getComponents()) {
            if (component instanceof FlatArrowButton) {
                ((FlatArrowButton)component).updateStyle(this.arrowType, this.buttonArrowColor, this.buttonDisabledArrowColor, this.buttonHoverArrowColor, null, this.buttonPressedArrowColor, null);
                continue;
            }
            if (!(component instanceof QF)) continue;
            ((QF)((Object)component)).updateStyle(this.arrowType, this.buttonArrowColor, this.buttonDisabledArrowColor, this.buttonHoverArrowColor, null, this.buttonPressedArrowColor, null);
        }
    }

    private Color getBackground(Component component) {
        if (component == null) {
            return this.buttonBackground;
        }
        if (!component.isEnabled()) {
            return this.buttonDisabledBackground;
        }
        if (component instanceof AbstractButton) {
            ButtonModel buttonModel = ((AbstractButton)component).getModel();
            if (this.buttonPressedBackground != null && buttonModel.isPressed()) {
                return this.buttonPressedBackground;
            }
            if (this.buttonHoverBackground != null && buttonModel.isRollover()) {
                return this.buttonHoverBackground;
            }
        }
        return this.buttonBackground;
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        boolean bl;
        float f2 = FlatUIUtils.getBorderFocusWidth((JComponent)jComponent);
        float f3 = FlatUIUtils.getBorderArc((JComponent)jComponent);
        if (jComponent.isOpaque() && (f2 > 0.0f || f3 > 0.0f)) {
            FlatUIUtils.paintParentBackground((Graphics)graphics, (JComponent)jComponent);
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        Object[] objectArray = FlatUIUtils.setRenderingHints((Graphics)graphics2D);
        int n2 = jComponent.getWidth();
        int n3 = jComponent.getHeight();
        boolean bl2 = this.spinner.isEnabled();
        graphics2D.setColor(this.getBackground(bl2));
        FlatUIUtils.paintComponentBackground((Graphics2D)graphics2D, (int)0, (int)0, (int)n2, (int)n3, (float)f2, (float)f3);
        boolean bl3 = bl = !"none".equals(this.buttonStyle);
        if (bl && (this.handler.D != null || this.handler.B != null)) {
            Object object;
            if (bl2 && this.buttonBackground != null) {
                object = graphics2D.getClip();
                Component component = this.handler.B;
                graphics2D.setColor(this.getBackground(component));
                graphics2D.clipRect(component.getX(), component.getY(), component.getWidth(), component.getHeight());
                FlatUIUtils.paintComponentBackground((Graphics2D)graphics2D, (int)0, (int)0, (int)n2, (int)n3, (float)f2, (float)f3);
                graphics2D.setClip((Shape)object);
                component = this.handler.D;
                graphics2D.setColor(this.getBackground(component));
                graphics2D.clipRect(component.getX(), component.getY(), component.getWidth(), component.getHeight());
                FlatUIUtils.paintComponentBackground((Graphics2D)graphics2D, (int)0, (int)0, (int)n2, (int)n3, (float)f2, (float)f3);
                graphics2D.setClip((Shape)object);
            }
            Object object2 = object = bl2 ? this.buttonSeparatorColor : this.buttonDisabledSeparatorColor;
            if (object != null && this.buttonSeparatorWidth > 0.0f) {
                boolean bl4 = this.spinner.getComponentOrientation().isLeftToRight();
                int n4 = this.handler.B.getX();
                int n5 = this.handler.B.getWidth();
                int n6 = this.handler.D.getX();
                int n7 = this.handler.D.getWidth();
                graphics2D.setColor((Color)object);
                float f4 = UIScale.scale((float)this.buttonSeparatorWidth);
                float f5 = bl4 ? (float)Math.min(n4, n6) : (float)Math.max(n4 + n5, n6 + n7) - f4;
                graphics2D.fill(new Rectangle2D.Float(f5, f2, f4, (float)(n3 - 1) - f2 * 2.0f));
            }
        }
        this.paint(graphics, jComponent);
        FlatUIUtils.resetRenderingHints((Graphics)graphics, (Object[])objectArray);
    }

    private class _A
    implements LayoutManager,
    FocusListener,
    PropertyChangeListener {
        private Component C = null;
        private Component D;
        private Component B;

        private _A() {
        }

        @Override
        public void addLayoutComponent(String string, Component component) {
            switch (string) {
                case "Editor": {
                    this.C = component;
                    break;
                }
                case "Next": {
                    this.D = component;
                    break;
                }
                case "Previous": {
                    this.B = component;
                }
            }
        }

        @Override
        public void removeLayoutComponent(Component component) {
            if (component == this.C) {
                this.C = null;
            } else if (component == this.D) {
                this.D = null;
            } else if (component == this.B) {
                this.B = null;
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container container) {
            Insets insets = container.getInsets();
            Insets insets2 = UIScale.scale((Insets)REWSpinnerUI.this.padding);
            Dimension dimension = this.C != null ? this.C.getPreferredSize() : new Dimension(0, 0);
            int n2 = FlatUIUtils.minimumWidth((JComponent)REWSpinnerUI.this.spinner, (int)REWSpinnerUI.this.minimumWidth);
            int n3 = dimension.height + insets2.top + insets2.bottom;
            this.A(container);
            boolean bl = REWSpinnerUI.this.sideBySideButtons && REWSpinnerUI.this.sideBySideMinHeight > 0 && n3 < UIScale.scale((int)(2 * REWSpinnerUI.this.sideBySideMinHeight));
            int n4 = bl ? 2 * n3 : n3;
            float f2 = FlatUIUtils.getBorderFocusWidth((JComponent)REWSpinnerUI.this.spinner);
            return new Dimension(Math.max(insets.left + insets.right + dimension.width + insets2.left + insets2.right + n4, UIScale.scale((int)n2) + Math.round(f2 * 2.0f)), insets.top + insets.bottom + n3);
        }

        private void A(Container container) {
            Object object = ((JSpinner)container).getClientProperty(REWSpinnerUI.SIDE_BY_SIDE_BUTTONS);
            if (object instanceof Boolean) {
                REWSpinnerUI.this.sideBySideButtons = (Boolean)object;
            } else {
                REWSpinnerUI.this.sideBySideButtons = REWSpinnerUI.this.sideBySideButtonsUIDefault;
            }
            object = ((JSpinner)container).getClientProperty(REWSpinnerUI.SIDE_BY_SIDE_MIN_HEIGHT);
            if (object instanceof Integer) {
                REWSpinnerUI.this.sideBySideMinHeight = (Integer)object;
            } else {
                REWSpinnerUI.this.sideBySideMinHeight = REWSpinnerUI.this.sideBySideMinHeightUIDefault;
            }
        }

        @Override
        public Dimension minimumLayoutSize(Container container) {
            return this.preferredLayoutSize(container);
        }

        @Override
        public void layoutContainer(Container container) {
            int n2;
            Dimension dimension = container.getSize();
            Insets insets = container.getInsets();
            Rectangle rectangle = FlatUIUtils.subtractInsets((Rectangle)new Rectangle(dimension), (Insets)insets);
            if (this.D == null && this.B == null) {
                if (this.C != null) {
                    this.C.setBounds(rectangle);
                }
                return;
            }
            Rectangle rectangle2 = new Rectangle(rectangle);
            Rectangle rectangle3 = new Rectangle(rectangle);
            FontMetrics fontMetrics = REWSpinnerUI.this.spinner.getFontMetrics(REWSpinnerUI.this.spinner.getFont());
            int n3 = fontMetrics.getHeight() + UIScale.scale((int)REWSpinnerUI.this.padding.top) + UIScale.scale((int)REWSpinnerUI.this.padding.bottom);
            int n4 = n3 * 3 / 4;
            int n5 = Math.min(Math.max(rectangle3.height, n4), n3);
            this.A(container);
            boolean bl = REWSpinnerUI.this.sideBySideButtons && REWSpinnerUI.this.sideBySideMinHeight > 0 && rectangle3.height < UIScale.scale((int)(2 * REWSpinnerUI.this.sideBySideMinHeight));
            int n6 = rectangle3.width = bl ? 2 * n5 : n5;
            if (container.getComponentOrientation().isLeftToRight()) {
                rectangle2.width -= rectangle3.width;
                rectangle3.x += rectangle2.width;
            } else {
                rectangle2.x += rectangle3.width;
                rectangle2.width -= rectangle3.width;
            }
            if (this.C != null) {
                this.C.setBounds(rectangle2);
            }
            if (bl) {
                if (this.D instanceof FlatArrowButton) {
                    ((FlatArrowButton)this.D).setYOffset(0.0f);
                    ((FlatArrowButton)this.B).setYOffset(-1.0f);
                } else if (this.D instanceof QF) {
                    ((QF)((Object)this.D)).setYOffset(0.0f);
                    ((QF)((Object)this.B)).setYOffset(-1.0f);
                }
            }
            int n7 = bl ? rectangle3.height : rectangle3.height / 2 + rectangle3.height % 2;
            int n8 = n2 = bl ? rectangle3.width / 2 : 0;
            if (this.D != null) {
                this.D.setBounds(rectangle3.x + n2, rectangle3.y, n5, n7);
            }
            if (this.B != null) {
                int n9 = rectangle3.y + rectangle3.height - n7;
                this.B.setBounds(rectangle3.x, n9, n5, n7);
            }
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            JTextField jTextField;
            REWSpinnerUI.this.spinner.repaint();
            if (focusEvent.getComponent() == REWSpinnerUI.this.spinner && (jTextField = REWSpinnerUI.getEditorTextField(REWSpinnerUI.this.spinner.getEditor())) != null) {
                jTextField.requestFocusInWindow();
            }
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            REWSpinnerUI.this.spinner.repaint();
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            switch (propertyChangeEvent.getPropertyName()) {
                case "foreground": 
                case "enabled": {
                    REWSpinnerUI.this.updateEditorColors();
                    break;
                }
                case "JComponent.roundRect": 
                case "JComponent.outline": {
                    REWSpinnerUI.this.spinner.repaint();
                    break;
                }
                case "JComponent.minimumWidth": {
                    REWSpinnerUI.this.spinner.revalidate();
                    break;
                }
                case "FlatLaf.style": 
                case "FlatLaf.styleClass": {
                    REWSpinnerUI.this.installStyle();
                    REWSpinnerUI.this.spinner.revalidate();
                    REWSpinnerUI.this.spinner.repaint();
                }
            }
        }
    }
}

