/*
 * Decompiled with CFR 0.152.
 */
package roomeqwizard;

import ca.odell.glazedlists.gui.TableFormat;
import roomeqwizard.MeasData;
import roomeqwizard.S;
import roomeqwizard.SweepAnalyser;

class QK
implements TableFormat<S> {
    MeasData C;
    double A;
    double B;

    QK(MeasData measData) {
        this.C = measData;
        if (measData != null && measData.getLfa() != null) {
            this.A = measData.getSPLCalOffset() - 3.0;
            this.B = measData.getLfa().P * measData.getLfa().P;
        }
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public String getColumnName(int n2) {
        switch (n2) {
            case 0: {
                return "Freq Hz";
            }
            case 1: {
                return "Peak dB";
            }
            case 2: {
                return "T60 ms";
            }
            case 3: {
                return "BW Hz";
            }
            case 4: {
                return "Q";
            }
        }
        throw new IllegalStateException();
    }

    public Object A(S s2, int n2) {
        if (s2 == null || this.C == null || !this.C.hasLfa()) {
            return null;
        }
        switch (n2) {
            case 0: {
                return s2.C;
            }
            case 1: {
                double d2 = 10.0 * Math.log10(s2.S * s2.S * this.B);
                return SweepAnalyser.A(d2, this.C.irData.splOffset, s2.C, this.C.useCal(), this.C.meterCal, this.C.scCal) - 3.0;
            }
            case 2: {
                return 1000.0 * s2.J;
            }
            case 3: {
                return s2.L;
            }
            case 4: {
                return s2.F;
            }
        }
        throw new IllegalStateException();
    }
}

