/*
 * Decompiled with CFR 0.152.
 */
package roomeqwizard;

import java.util.ArrayList;
import roomeqwizard.pA;

public enum OctaveFraction implements pA
{
    ONE(1, "1 octave"),
    HALF(2, "1/2 octave"),
    THIRD(3, "1/3 octave"),
    SIXTH(6, "1/6 octave"),
    TWELFTH(12, "1/12 octave"),
    TWENTYFOURTH(24, "1/24 octave"),
    FORTYEIGHTH(48, "1/48 octave");

    private static final Double[] R160;
    private final double fraction;
    private final int ppo;
    private final String description;

    private OctaveFraction(int n3, String string2) {
        this.ppo = n3;
        this.fraction = 1.0 / (double)n3;
        this.description = string2;
    }

    public String toString() {
        return this.description;
    }

    public String apiName() {
        return this.description;
    }

    public double getFraction() {
        return this.fraction;
    }

    public int getPPO() {
        return this.ppo;
    }

    public static OctaveFraction getEnum(String string) {
        for (OctaveFraction octaveFraction : OctaveFraction.values()) {
            if (!octaveFraction.name().equalsIgnoreCase(string)) continue;
            return octaveFraction;
        }
        return ONE;
    }

    public static OctaveFraction getFromApiName(String string) {
        for (OctaveFraction octaveFraction : OctaveFraction.values()) {
            if (!octaveFraction.apiName().equalsIgnoreCase(string)) continue;
            return octaveFraction;
        }
        return null;
    }

    public static OctaveFraction getEnum(int n2) {
        for (OctaveFraction octaveFraction : OctaveFraction.values()) {
            if (octaveFraction.ppo != n2) continue;
            return octaveFraction;
        }
        return null;
    }

    public double freqFactor() {
        return Math.pow(2.0, this.fraction);
    }

    @Override
    public Double[] generateFreqList(double d2, double d3) {
        double d4;
        double d5 = 0.0;
        int n2 = 48 / this.ppo;
        ArrayList<Double> arrayList = new ArrayList<Double>();
        if (this.ppo <= 48 && n2 * this.ppo == 48) {
            d4 = Math.pow(10.0, (int)Math.log10(d2));
            int n3 = 0;
            do {
                int n4;
                for (n4 = n3; n4 < R160.length; n4 += n2) {
                    d5 = d4 * R160[n4];
                    if (d5 >= d2 && d5 <= d3 && !arrayList.contains(d5)) {
                        arrayList.add(d5);
                    }
                    if (d5 > d3) break;
                }
                d4 *= 10.0;
                n3 = n4 % R160.length;
            } while (d5 <= d3);
        } else {
            d5 = d2;
            d4 = Math.pow(2.0, 1.0 / (double)this.ppo);
            do {
                arrayList.add(d5);
            } while ((d5 *= d4) <= d3);
        }
        Double[] doubleArray = new Double[arrayList.size()];
        arrayList.toArray(doubleArray);
        return doubleArray;
    }

    static {
        R160 = new Double[]{1.0, 1.015, 1.03, 1.044, 1.06, 1.075, 1.09, 1.106, 1.12, 1.138, 1.15, 1.172, 1.18, 1.206, 1.22, 1.241, 1.25, 1.265, 1.28, 1.315, 1.32, 1.34, 1.36, 1.38, 1.4, 1.43, 1.45, 1.475, 1.5, 1.525, 1.55, 1.575, 1.6, 1.625, 1.65, 1.675, 1.7, 1.725, 1.75, 1.775, 1.8, 1.825, 1.85, 1.875, 1.9, 1.925, 1.95, 1.975, 2.0, 2.03, 2.06, 2.09, 2.12, 2.14, 2.18, 2.2, 2.24, 2.27, 2.3, 2.33, 2.36, 2.4, 2.43, 2.47, 2.5, 2.54, 2.58, 2.62, 2.65, 2.69, 2.72, 2.76, 2.8, 2.85, 2.9, 2.95, 3.0, 3.04, 3.07, 3.11, 3.15, 3.2, 3.25, 3.3, 3.35, 3.4, 3.45, 3.5, 3.55, 3.6, 3.65, 3.7, 3.75, 3.82, 3.87, 3.95, 4.0, 4.06, 4.12, 4.18, 4.25, 4.31, 4.37, 4.44, 4.5, 4.55, 4.62, 4.68, 4.75, 4.82, 4.87, 4.94, 5.0, 5.08, 5.15, 5.22, 5.3, 5.38, 5.45, 5.52, 5.6, 5.7, 5.8, 5.9, 6.0, 6.08, 6.15, 6.22, 6.3, 6.4, 6.5, 6.6, 6.7, 6.8, 6.9, 7.0, 7.1, 7.2, 7.3, 7.4, 7.5, 7.62, 7.75, 7.88, 8.0, 8.12, 8.25, 8.38, 8.5, 8.62, 8.75, 8.85, 9.0, 9.12, 9.25, 9.38, 9.5, 9.62, 9.75, 9.88};
    }
}

