/*
 * Decompiled with CFR 0.152.
 */
package roomeqwizard;

public enum NoiseSelection {
    FULL("Full range", "Full", "full-range"),
    SUB("Sub Cal (30 to 80 Hz)", "Sub", "sub-cal"),
    SPKR("Speaker Cal (500 to 2000 Hz)", "Spkr", "speaker-cal"),
    CUSTOM("Custom", "Custom", "custom"),
    OCTAVE("Octave", "Octave", "octave"),
    THIRD_OCTAVE("1/3 Octave", "1/3 Octave", "third-octave"),
    CTA2034("CTA-2034", "CTA2034", "cta2034");

    private final String longName;
    private final String shortName;
    private final String apiName;

    private NoiseSelection(String string2, String string3, String string4) {
        this.longName = string2;
        this.shortName = string3;
        this.apiName = string4;
    }

    public String getLongName() {
        return this.longName;
    }

    public String getShortName() {
        return this.shortName;
    }

    public String apiName() {
        return this.apiName;
    }

    public boolean pinkOnly() {
        switch (this) {
            case CTA2034: 
            case SPKR: 
            case SUB: {
                return true;
            }
        }
        return false;
    }

    public static NoiseSelection getEnum(String string) {
        for (NoiseSelection noiseSelection : NoiseSelection.values()) {
            if (!noiseSelection.name().equalsIgnoreCase(string)) continue;
            return noiseSelection;
        }
        return FULL;
    }

    public static NoiseSelection getFromApiName(String string) {
        for (NoiseSelection noiseSelection : NoiseSelection.values()) {
            if (!noiseSelection.apiName().equalsIgnoreCase(string)) continue;
            return noiseSelection;
        }
        return null;
    }
}

