/*
 * Decompiled with CFR 0.152.
 */
package roomeqwizard;

import java.util.Arrays;

public enum NoiseCurve {
    NC("NC"),
    NR("NR"),
    PNC("PNC"),
    NCB("NCB");

    private final String prefix;
    private static final double ABOVE_MAX = 999.0;
    private static final double[] OCTAVE_CENTRES;
    private static final double[][] NCB_TABLE;
    private static final float[] NCB_FREQS;
    private static final double[][] PNC_TABLE;
    private static final float[] PNC_FREQS;
    private static final double[][] NC_TABLE;
    private static final float[] NC_FREQS;
    private static double[][] NR_TABLE;
    private static final float[] NR_FREQS;
    private static final double[] NR_A;
    private static final double[] NR_B;

    private NoiseCurve(String string2) {
        this.prefix = string2;
    }

    public String prefix() {
        return this.prefix;
    }

    public String toString() {
        return this.prefix;
    }

    public String apiName() {
        return this.prefix;
    }

    public float[] frequencies() {
        switch (this) {
            case PNC: {
                return PNC_FREQS;
            }
            case NC: {
                return NC_FREQS;
            }
            case NR: {
                return NR_FREQS;
            }
            case NCB: {
                return NCB_FREQS;
            }
        }
        return null;
    }

    public double[][] table() {
        switch (this) {
            case PNC: {
                return PNC_TABLE;
            }
            case NC: {
                return NC_TABLE;
            }
            case NR: {
                if (NR_TABLE == null) {
                    int n2 = 0;
                    int n3 = 80;
                    int n4 = 5;
                    int n5 = 1 + (n3 - n2) / n4;
                    NR_TABLE = new double[n5][];
                    int n6 = 0;
                    for (int i2 = n2; i2 <= n3; i2 += n4) {
                        double[] dArray = new double[NR_FREQS.length + 1];
                        dArray[0] = i2;
                        for (int i3 = 0; i3 < NR_FREQS.length; ++i3) {
                            dArray[i3 + 1] = (double)i2 * NR_B[i3] + NR_A[i3];
                        }
                        NoiseCurve.NR_TABLE[n6++] = dArray;
                    }
                }
                return NR_TABLE;
            }
            case NCB: {
                return NCB_TABLE;
            }
        }
        return null;
    }

    public double getNoiseCurveFigure(float f2, float f3, double d2) {
        int n2 = Arrays.binarySearch(this.frequencies(), f2);
        if (n2 >= 0) {
            double d3 = 999.0;
            block0 : switch (this) {
                case NR: {
                    d3 = ((double)f3 - NR_A[n2]) / NR_B[n2];
                    break;
                }
                default: {
                    for (int i2 = 0; i2 < this.table().length; ++i2) {
                        double[] dArray = this.table()[i2];
                        if (!((double)f3 <= dArray[n2 + 1])) continue;
                        if (i2 > 0) {
                            double[] dArray2 = this.table()[i2 - 1];
                            double d4 = (double)f3 - dArray2[n2 + 1];
                            double d5 = dArray[n2 + 1] - dArray2[n2 + 1];
                            d3 = dArray2[0] + Math.ceil(5.0 * d4 / d5);
                            break block0;
                        }
                        d3 = dArray[0];
                        break block0;
                    }
                }
            }
            if (d3 > d2) {
                d2 = d3;
            }
        }
        return d2;
    }

    public static boolean isValid(double d2) {
        return d2 != 999.0;
    }

    public static NoiseCurve getEnum(String string) {
        for (NoiseCurve noiseCurve : NoiseCurve.values()) {
            if (!noiseCurve.name().equalsIgnoreCase(string)) continue;
            return noiseCurve;
        }
        return NC;
    }

    public static NoiseCurve getFromApiName(String string) {
        for (NoiseCurve noiseCurve : NoiseCurve.values()) {
            if (!noiseCurve.apiName().equalsIgnoreCase(string)) continue;
            return noiseCurve;
        }
        return null;
    }

    public static float nominalOctaveCentre(float f2) {
        double d2 = 0.01;
        for (double d3 : OCTAVE_CENTRES) {
            if (!(Math.abs(d3 / (double)f2 - 1.0) < d2)) continue;
            return (float)d3;
        }
        return 0.0f;
    }

    static {
        OCTAVE_CENTRES = new double[]{31.5, 63.0, 125.0, 250.0, 500.0, 1000.0, 2000.0, 4000.0, 8000.0};
        NCB_TABLE = new double[][]{{10.0, 81.0, 61.0, 43.0, 31.0, 21.0, 15.0, 12.0, 8.0, 5.0, 2.0}, {15.0, 81.0, 62.0, 45.0, 35.0, 26.0, 20.0, 17.0, 13.0, 10.0, 7.0}, {20.0, 81.0, 64.0, 48.0, 38.0, 30.0, 25.0, 22.0, 18.0, 15.0, 12.0}, {25.0, 81.0, 66.0, 51.0, 43.0, 35.0, 30.0, 27.0, 23.0, 20.0, 17.0}, {30.0, 82.0, 68.0, 54.0, 47.0, 39.0, 35.0, 32.0, 28.0, 25.0, 22.0}, {35.0, 83.0, 71.0, 58.0, 51.0, 44.0, 40.0, 37.0, 33.0, 30.0, 27.0}, {40.0, 85.0, 74.0, 61.0, 55.0, 49.0, 45.0, 42.0, 38.0, 35.0, 32.0}, {45.0, 87.0, 77.0, 65.0, 59.0, 53.0, 50.0, 47.0, 43.0, 40.0, 37.0}, {50.0, 89.0, 80.0, 68.0, 63.0, 58.0, 55.0, 52.0, 48.0, 45.0, 42.0}, {55.0, 92.0, 83.0, 72.0, 67.0, 62.0, 60.0, 57.0, 53.0, 50.0, 47.0}, {60.0, 94.0, 86.0, 75.0, 71.0, 67.0, 65.0, 62.0, 58.0, 55.0, 52.0}, {65.0, 96.0, 88.0, 79.0, 75.0, 72.0, 70.0, 67.0, 63.0, 60.0, 57.0}};
        NCB_FREQS = new float[]{16.75f, 31.5f, 63.0f, 125.0f, 250.0f, 500.0f, 1000.0f, 2000.0f, 4000.0f, 8000.0f};
        PNC_TABLE = new double[][]{{15.0, 58.0, 43.0, 35.0, 28.0, 21.0, 15.0, 10.0, 8.0, 8.0}, {20.0, 59.0, 46.0, 39.0, 32.0, 26.0, 20.0, 15.0, 13.0, 13.0}, {25.0, 60.0, 49.0, 43.0, 37.0, 31.0, 25.0, 20.0, 18.0, 18.0}, {30.0, 61.0, 52.0, 46.0, 41.0, 35.0, 30.0, 25.0, 23.0, 23.0}, {35.0, 62.0, 55.0, 50.0, 45.0, 40.0, 35.0, 30.0, 28.0, 28.0}, {40.0, 64.0, 59.0, 54.0, 50.0, 45.0, 40.0, 35.0, 33.0, 33.0}, {45.0, 67.0, 63.0, 58.0, 54.0, 50.0, 45.0, 41.0, 38.0, 38.0}, {50.0, 70.0, 66.0, 62.0, 58.0, 54.0, 50.0, 46.0, 43.0, 43.0}, {55.0, 73.0, 70.0, 66.0, 62.0, 59.0, 55.0, 51.0, 48.0, 48.0}, {60.0, 76.0, 73.0, 69.0, 66.0, 63.0, 59.0, 56.0, 53.0, 53.0}, {65.0, 79.0, 76.0, 73.0, 70.0, 67.0, 64.0, 61.0, 58.0, 58.0}};
        PNC_FREQS = new float[]{31.5f, 63.0f, 125.0f, 250.0f, 500.0f, 1000.0f, 2000.0f, 4000.0f, 8000.0f};
        NC_TABLE = new double[][]{{15.0, 47.0, 36.0, 29.0, 22.0, 17.0, 14.0, 12.0, 11.0}, {20.0, 51.0, 41.0, 33.0, 26.0, 22.0, 19.0, 17.0, 16.0}, {25.0, 54.0, 45.0, 38.0, 31.0, 27.0, 24.0, 22.0, 21.0}, {30.0, 57.0, 48.0, 41.0, 35.0, 31.0, 29.0, 28.0, 27.0}, {35.0, 60.0, 53.0, 46.0, 40.0, 36.0, 34.0, 33.0, 32.0}, {40.0, 64.0, 57.0, 51.0, 45.0, 41.0, 39.0, 38.0, 37.0}, {45.0, 67.0, 60.0, 54.0, 49.0, 46.0, 44.0, 43.0, 42.0}, {50.0, 71.0, 64.0, 59.0, 54.0, 51.0, 49.0, 48.0, 47.0}, {55.0, 74.0, 67.0, 62.0, 58.0, 56.0, 54.0, 53.0, 52.0}, {60.0, 77.0, 71.0, 67.0, 63.0, 61.0, 59.0, 58.0, 57.0}, {65.0, 80.0, 75.0, 71.0, 68.0, 66.0, 64.0, 63.0, 62.0}, {70.0, 83.0, 79.0, 75.0, 72.0, 71.0, 70.0, 69.0, 68.0}};
        NC_FREQS = new float[]{63.0f, 125.0f, 250.0f, 500.0f, 1000.0f, 2000.0f, 4000.0f, 8000.0f};
        NR_FREQS = new float[]{31.5f, 63.0f, 125.0f, 250.0f, 500.0f, 1000.0f, 2000.0f, 4000.0f, 8000.0f};
        NR_A = new double[]{55.4, 35.4, 22.0, 12.0, 4.8, 0.0, -3.5, -6.1, -8.0};
        NR_B = new double[]{0.681, 0.79, 0.87, 0.93, 0.974, 1.0, 1.015, 1.025, 1.03};
    }
}

