/*
 * Decompiled with CFR 0.152.
 */
package roomeqwizard;

import java.util.ArrayList;
import roomeqwizard.ModelParameter;

public enum MotionalImpedanceModel {
    FDD("FDD"),
    SILOG("SI-LOG"),
    SILOGR("SI-LOGR"),
    LOG("LOG"),
    RITTER3PC("Ritter 3PC");

    private final String title;
    private ArrayList<ModelParameter> params;

    private MotionalImpedanceModel(String string2) {
        this.title = string2;
    }

    private void initParams() {
        this.params = new ArrayList();
        switch (this) {
            case FDD: {
                this.params.add(ModelParameter.RES);
                this.params.add(ModelParameter.CMES);
                this.params.add(ModelParameter.L0);
                this.params.add(ModelParameter.GLES);
                break;
            }
            case SILOG: {
                this.params.add(ModelParameter.RES);
                this.params.add(ModelParameter.CMES);
                this.params.add(ModelParameter.L0);
                this.params.add(ModelParameter.GLES);
                this.params.add(ModelParameter.LAMBDA);
                break;
            }
            case SILOGR: {
                this.params.add(ModelParameter.RES);
                this.params.add(ModelParameter.CMES);
                this.params.add(ModelParameter.L0);
                this.params.add(ModelParameter.GLES);
                this.params.add(ModelParameter.GLESR);
                this.params.add(ModelParameter.LAMBDA);
                break;
            }
            case LOG: {
                this.params.add(ModelParameter.R0);
                this.params.add(ModelParameter.CMES);
                this.params.add(ModelParameter.L0);
                this.params.add(ModelParameter.BETA);
                break;
            }
            case RITTER3PC: {
                this.params.add(ModelParameter.R0);
                this.params.add(ModelParameter.CMES);
                this.params.add(ModelParameter.L0);
                this.params.add(ModelParameter.BETA);
                this.params.add(ModelParameter.W0);
            }
        }
    }

    ArrayList<ModelParameter> getParams() {
        if (this.params == null) {
            this.initParams();
        }
        return this.params;
    }

    boolean includesGLESR() {
        return this == SILOGR;
    }

    String title() {
        return this.title;
    }

    public String toString() {
        return this.title;
    }

    public static MotionalImpedanceModel getEnum(String string) {
        for (MotionalImpedanceModel motionalImpedanceModel : MotionalImpedanceModel.values()) {
            if (!motionalImpedanceModel.name().equalsIgnoreCase(string)) continue;
            return motionalImpedanceModel;
        }
        return FDD;
    }
}

