/*
 * Decompiled with CFR 0.152.
 */
package roomeqwizard;

import java.awt.geom.Point2D;
import java.io.Serializable;
import roomeqwizard.HE;
import roomeqwizard.MeasData;
import roomeqwizard.iB;
import roomeqwizard.lG;

public class MinPhaseTails
implements Serializable,
Cloneable {
    static final long serialVersionUID = 1L;
    private static final double TRANSITION_OCTAVES = 0.16666666666666666;
    private boolean appendLFTail = false;
    private boolean appendHFTail = false;
    private double lfStart = 0.0;
    private double hfStart = 0.0;
    private double lfSlope = 0.0;
    private double hfSlope = 0.0;
    private int factor = 1;
    private boolean replicate = false;
    private boolean warpFreq = false;
    private boolean includeCal = lG.\u0211();
    private transient iB lfTransition;
    private transient iB hfTransition;

    public iB getLfTransition(MeasData measData) {
        if (this.lfTransition == null) {
            this.lfTransition = this.calculateTransition(measData, false);
        }
        return this.lfTransition;
    }

    public iB getHfTransition(MeasData measData) {
        if (this.hfTransition == null) {
            this.hfTransition = this.calculateTransition(measData, true);
        }
        return this.hfTransition;
    }

    private iB calculateTransition(MeasData measData, boolean bl) {
        float f2;
        float f3;
        double d2;
        double d3;
        double d4;
        if (bl) {
            d4 = this.getHfStart();
            d3 = this.getHfSlope();
            d2 = -1.0;
        } else {
            d4 = this.getLfStart();
            d3 = this.getLfSlope();
            d2 = 1.0;
        }
        double d5 = 25.0 * Math.log(2.0);
        Double d6 = measData.dataSlopedBPerOctave((float)d4, 6.0);
        if (d6 == null) {
            d6 = 0.0;
        }
        float f4 = measData.spl((float)d4, 0.0f);
        float f5 = (float)Math.log(d4);
        float f6 = f4;
        double d7 = Math.atan(d6 / (d5 * Math.log(2.0)));
        double d8 = Math.log(2.0) * 0.16666666666666666;
        double d9 = d5 * d8 * Math.sin(d7) * d2;
        double d10 = d8 * Math.cos(d7) * d2;
        float f7 = (float)((double)f5 - d10);
        float f8 = (float)((double)f4 - d9);
        double d11 = measData.getSampleRate() * (double)measData.getMinPhaseFactor(this, measData.getSampleRate(), false);
        double d12 = d3;
        double d13 = 1.0;
        int n2 = 0;
        do {
            double d14 = Math.atan(d12 / (d5 * Math.log(2.0)));
            double d15 = d5 * d8 * Math.sin(d14) * d2;
            double d16 = d8 * Math.cos(d14) * d2;
            f3 = (float)((double)f7 - d16);
            f2 = (float)((double)f8 - d15);
            if (!bl || !this.warpFreq) continue;
            double d17 = Math.exp(f3);
            double d18 = this.tailSlope(d3, d17, d11);
            d13 = d18 / d12;
            d12 = d18;
        } while (this.warpFreq && Math.abs(d13 - 1.0) > 0.001 && n2++ < 8);
        return new iB(f5, f6, f7, f8, f3, f2);
    }

    public double tailSlope(double d2, double d3, double d4) {
        double d5 = 0.010416666666666666;
        double d6 = Math.pow(2.0, d5);
        if (d3 > d4 / (2.0 * d6)) {
            return d2;
        }
        double d7 = d3 / d6;
        double d8 = d3 * d6;
        double d9 = this.freqRatio(d7, d3, d4);
        double d10 = this.freqRatio(d8, d3, d4);
        double d11 = Math.log(d9) / Math.log(2.0);
        double d12 = Math.log(d10) / Math.log(2.0);
        double d13 = d2 * d11;
        double d14 = d2 * d12;
        double d15 = (d14 - d13) / (2.0 * d5);
        return d15;
    }

    public double freqRatio(double d2, double d3, double d4) {
        double d5 = this.warpFreq ? Math.tan(d2 * Math.PI / d4) / Math.tan(d3 * Math.PI / d4) : d2 / d3;
        return d5;
    }

    public static double tailFactor(double d2, double d3, double d4, double d5, boolean bl) {
        if (d2 >= d4 && d3 > 0.0) {
            return 1.0;
        }
        if (d2 <= d4 && d3 < 0.0) {
            return 1.0;
        }
        double d6 = d3 < 0.0 && bl ? Math.tan(d2 * Math.PI / d5) / Math.tan(d4 * Math.PI / d5) : d2 / d4;
        double d7 = Math.log(d6) / Math.log(2.0);
        double d8 = d3 * d7;
        return Math.pow(10.0, d8 / 10.0);
    }

    public double taildB(MeasData measData, float f2, boolean bl) {
        double d2;
        iB iB2;
        if (bl) {
            if (this.hfTransition == null) {
                this.hfTransition = this.calculateTransition(measData, bl);
            }
            iB2 = this.hfTransition;
        } else {
            if (this.lfTransition == null) {
                this.lfTransition = this.calculateTransition(measData, bl);
            }
            iB2 = this.lfTransition;
        }
        if (bl) {
            double d3 = this.getHfStart();
            d2 = this.getHfSlope();
            if ((double)f2 < d3) {
                f2 = (float)d3;
            }
        } else {
            double d4 = this.getLfStart();
            d2 = this.getLfSlope();
            if ((double)f2 > d4) {
                f2 = (float)d4;
            }
        }
        Point2D.Float float_ = iB2.A();
        double d5 = Math.exp(float_.x);
        if (bl && (double)f2 > d5 || !bl && (double)f2 < d5) {
            double d6;
            double d7;
            if (d2 < 0.0 && this.warpFreq) {
                d7 = measData.getSampleRate() * (double)measData.getMinPhaseFactor(this, measData.getSampleRate(), false);
                d6 = Math.tan((double)f2 * Math.PI / d7) / Math.tan(d5 * Math.PI / d7);
            } else {
                d6 = (double)f2 / d5;
            }
            d7 = Math.log(d6) / Math.log(2.0);
            double d8 = d2 * d7;
            return (double)float_.y + d8;
        }
        return iB2.A((float)Math.log(f2));
    }

    public MinPhaseTails clone() {
        try {
            return (MinPhaseTails)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError();
        }
    }

    public void copySettings(MinPhaseTails minPhaseTails) {
        this.appendLFTail = minPhaseTails.appendLFTail;
        this.appendHFTail = minPhaseTails.appendHFTail;
        this.lfStart = minPhaseTails.lfStart;
        this.hfStart = minPhaseTails.hfStart;
        this.lfSlope = minPhaseTails.lfSlope;
        this.hfSlope = minPhaseTails.hfSlope;
        this.factor = minPhaseTails.factor;
        this.replicate = minPhaseTails.replicate;
        this.warpFreq = minPhaseTails.warpFreq;
        this.includeCal = minPhaseTails.includeCal;
    }

    public boolean replicateData() {
        return this.replicate;
    }

    public void setReplicateData(boolean bl) {
        this.replicate = bl;
    }

    public boolean warpFreq() {
        return this.warpFreq;
    }

    public void setWarpFreq(boolean bl) {
        this.warpFreq = bl;
    }

    public boolean includeCal() {
        return this.includeCal;
    }

    public void setIncludeCal(boolean bl) {
        this.includeCal = bl;
    }

    public boolean appendLFTail() {
        return this.appendLFTail;
    }

    public void setAppendLFTail(boolean bl) {
        this.appendLFTail = bl;
    }

    public boolean appendHFTail() {
        return this.appendHFTail;
    }

    public void setAppendHFTail(boolean bl) {
        this.appendHFTail = bl;
    }

    public double getLfStart() {
        return this.lfStart;
    }

    public void setLfStart(double d2) {
        if (this.lfStart != d2) {
            this.lfStart = d2;
            this.lfTransition = null;
        }
    }

    public double getHfStart() {
        return this.hfStart;
    }

    public void setHfStart(double d2) {
        if (this.hfStart != d2) {
            this.hfStart = d2;
            this.hfTransition = null;
        }
    }

    public double getLfSlope() {
        return this.lfSlope;
    }

    public void setLfSlope(double d2) {
        if (this.lfSlope != d2) {
            this.lfSlope = d2;
            this.lfTransition = null;
        }
    }

    public double getHfSlope() {
        if (this.hfSlope > 0.0) {
            this.hfSlope = -this.hfSlope;
        }
        return this.hfSlope;
    }

    public void setHfSlope(double d2) {
        if (this.hfSlope != d2) {
            this.hfSlope = d2;
            this.hfTransition = null;
        }
    }

    public int getFactor() {
        return this.factor;
    }

    public void setFactor(int n2) {
        this.factor = n2;
    }

    public String description() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.appendLFTail) {
            stringBuilder.append("LF tail from ");
            stringBuilder.append(HE.A(this.lfStart));
            stringBuilder.append(" at ");
            stringBuilder.append(HE.I.format(this.lfSlope));
            stringBuilder.append(" dB/octave");
        } else {
            stringBuilder.append("No LF tail");
            if (this.replicate) {
                stringBuilder.append(", data replicated below min freq");
            }
        }
        if (this.appendHFTail) {
            stringBuilder.append("\nHF tail from ");
            stringBuilder.append(HE.A(this.hfStart));
            stringBuilder.append(" at ");
            stringBuilder.append(HE.I.format(this.hfSlope));
            stringBuilder.append(" dB/octave");
        } else {
            stringBuilder.append("\nNo HF tail");
            if (this.replicate) {
                stringBuilder.append(", data replicated above max freq");
            }
        }
        return stringBuilder.toString();
    }
}

