/*
 * Decompiled with CFR 0.152.
 */
package roomeqwizard;

import java.io.Serializable;
import java.util.logging.Level;
import roomeqwizard.IH;
import roomeqwizard.JK;
import roomeqwizard.MJ;
import roomeqwizard.W;
import roomeqwizard.Window;
import roomeqwizard.WizardLogger;

public class MeasSweepFunction
implements Serializable,
IH {
    static final long serialVersionUID = 1L;
    private static final int FADE_IN_OCTAVE_FRAC = 1;
    private static final int FADE_OUT_OCTAVE_FRAC = 12;
    private static final double FADE_OUT_NYQUIST_SAMPLES = 10.0;
    private static final boolean FADE_LINEAR = false;
    private final double[] DIST_LEVELS_PERCENT = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
    static final int LIN_THRESH = 10;
    private final float absMaxVal;
    private float normVal;
    private final float sampleRate;
    private final double requestedStart;
    private final int initialSilence;
    private final double f2;
    private final int sweepLength;
    private final int totalSamples;
    private final double leveldBFS;
    private final double scale;
    private double linSamples;
    private double logSamples;
    private int actualSweepLength;
    private final double f1;
    private double k;
    private boolean fromDC;
    private double L;
    private final double logFreqRatio;
    private final double fadeInFraction;
    private final double fadeOutFraction;
    private final double fadeOutNyquistDurn;
    private final boolean fadeLinear;
    private final double linearThresh;
    private double fadeInDurn;
    private double fadeOutDurn;
    private boolean invertLinear = false;
    private double linDurn;
    private double logDurn;
    private double initialSilenceDurn;
    private double totalSweepDurn;
    private double oneOverL;
    private double twoPIf1L;
    private double logFreqFactor;
    private double kTimesPI;
    private transient JK graphTimeData;
    private boolean addDistortion = false;

    void setAddDistortion(boolean bl) {
        this.addDistortion = bl;
    }

    MeasSweepFunction(MJ mJ2, double d2, double d3) {
        this.fadeInFraction = 1.0;
        this.fadeOutFraction = 12.0;
        this.fadeLinear = false;
        this.linearThresh = d3;
        this.leveldBFS = d2;
        this.scale = Math.pow(10.0, Math.min(d2 + 3.0103, 0.0) / 20.0);
        this.normVal = this.absMaxVal = (float)this.scale;
        this.sampleRate = mJ2.N();
        this.fadeOutNyquistDurn = 10.0 / (double)this.sampleRate;
        this.requestedStart = mJ2.M();
        this.f2 = mJ2.F();
        this.initialSilence = mJ2.K();
        this.initialSilenceDurn = (double)this.initialSilence / (double)this.sampleRate;
        this.sweepLength = mJ2.C();
        this.totalSamples = mJ2.E();
        this.totalSweepDurn = (double)this.totalSamples / (double)this.sampleRate;
        this.f1 = this.calcF1(this.requestedStart, this.f2);
        this.logFreqRatio = Math.log(this.f2 / this.f1);
        this.calcSweepLengthsAndParams();
        this.calcFadeDurations();
        if (this.linSamples > 1.0) {
            this.k = this.f1 * (double)this.sampleRate / this.linSamples;
            this.kTimesPI = this.k * Math.PI;
        }
    }

    @Override
    public float value(double d2) {
        if (d2 < this.initialSilenceDurn || d2 > this.totalSweepDurn) {
            return 0.0f;
        }
        if ((d2 -= this.initialSilenceDurn) < this.linDurn) {
            double d3 = this.linearSweep(d2);
            if (this.invertLinear) {
                d3 = -d3;
            }
            if (this.fadeLinear && d2 < this.fadeInDurn) {
                d3 *= Window.hann(d2 / (2.0 * this.fadeInDurn));
            }
            return (float)d3;
        }
        if ((d2 -= this.linDurn) <= this.logDurn) {
            double d4 = this.logSweep(d2);
            if (!this.fromDC && d2 < this.fadeInDurn) {
                return (float)(d4 * Window.hann(d2 / (2.0 * this.fadeInDurn)));
            }
            if (d2 > this.logDurn - this.fadeOutDurn) {
                return (float)(d4 * Window.hann((d2 + 2.0 * this.fadeOutDurn - this.logDurn) / (2.0 * this.fadeOutDurn)));
            }
            return (float)d4;
        }
        return 0.0f;
    }

    @Override
    public float value(double d2, boolean bl) {
        float f2 = this.value(d2);
        if (bl) {
            f2 /= this.normVal;
        }
        return f2;
    }

    float normValue(double d2) {
        return this.value(d2) / this.normVal;
    }

    double freq(double d2) {
        if ((d2 -= this.initialSilenceDurn) < 0.0) {
            d2 = 0.0;
        }
        if (d2 < this.linDurn) {
            return this.linearSweepFreq(d2);
        }
        if ((d2 -= this.linDurn) <= this.logDurn) {
            return this.logSweepFreq(d2);
        }
        return this.f2;
    }

    double time(double d2) {
        if (d2 < this.linearThresh) {
            return this.initialSilenceDurn + d2 / this.k;
        }
        if (d2 < this.f2) {
            return this.initialSilenceDurn + this.linDurn + Math.log(d2 / this.f1) / this.logFreqFactor;
        }
        return this.initialSilenceDurn + this.linDurn + this.logDurn;
    }

    double envelope(double d2) {
        if (d2 < this.initialSilenceDurn || d2 > this.totalSweepDurn) {
            return 0.0;
        }
        if ((d2 -= this.initialSilenceDurn) < this.linDurn) {
            if (this.fadeLinear && d2 < this.fadeInDurn) {
                return this.scale * Window.hann(d2 / (2.0 * this.fadeInDurn));
            }
            return this.scale;
        }
        if ((d2 -= this.linDurn) <= this.logDurn) {
            if (!this.fromDC && d2 < this.fadeInDurn) {
                return this.scale * Window.hann(d2 / (2.0 * this.fadeInDurn));
            }
            if (d2 > this.logDurn - this.fadeOutDurn) {
                return this.scale * Window.hann((d2 + 2.0 * this.fadeOutDurn - this.logDurn) / (2.0 * this.fadeOutDurn));
            }
            return this.scale;
        }
        return 0.0;
    }

    double getLogDurn() {
        return this.logDurn;
    }

    double getLinSamples() {
        return this.linSamples;
    }

    double getLogFreqRatio() {
        return this.logFreqRatio;
    }

    double getF1() {
        return this.f1;
    }

    double getF2() {
        return this.f2;
    }

    double getHarmonicFactor() {
        return this.L;
    }

    int getActualSweepLength() {
        return this.actualSweepLength;
    }

    int getInitialSilence() {
        return this.initialSilence;
    }

    private double calcF1(double d2, double d3) {
        double d4;
        this.fromDC = false;
        double d5 = d2;
        if (d5 < this.linearThresh) {
            d5 = this.linearThresh;
            this.fromDC = true;
        }
        if ((d5 = d3 / (d4 = Math.ceil(d3 / d5))) < this.linearThresh) {
            d5 = d3 / (d4 -= 1.0);
            this.fromDC = true;
        }
        return d5;
    }

    private void calcSweepLengthsAndParams() {
        this.linSamples = 0.0;
        int n2 = (int)Math.round((double)this.sweepLength * this.f1 / ((double)this.sampleRate * this.logFreqRatio));
        if (n2 < 1) {
            n2 = 1;
        }
        this.L = (double)n2 / this.f1;
        this.logSamples = (double)this.sampleRate * this.logFreqRatio * this.L;
        int n3 = this.totalSamples - this.initialSilence - this.sweepLength;
        if (this.fromDC) {
            this.linSamples = this.logSamples / this.logFreqRatio;
            while (n2 > 1 && this.linSamples + this.logSamples > (double)(this.sweepLength + n3 / 2)) {
                this.L = (double)(--n2) / this.f1;
                this.logSamples = (double)this.sampleRate * this.logFreqRatio * this.L;
                this.linSamples = this.logSamples / this.logFreqRatio;
            }
        } else {
            while (n2 > 1 && this.logSamples > (double)(this.sweepLength + n3 / 2)) {
                this.L = (double)(--n2) / this.f1;
                this.logSamples = (double)this.sampleRate * this.logFreqRatio * this.L;
            }
        }
        this.oneOverL = 1.0 / this.L;
        this.twoPIf1L = Math.PI * 2 * this.f1 * this.L;
        if (this.linSamples > 0.0 && (n2 & 1) == 1) {
            this.invertLinear = true;
        }
        this.actualSweepLength = (int)(Math.ceil(this.linSamples) + Math.ceil(this.logSamples));
        this.linDurn = this.linSamples / (double)this.sampleRate;
        this.logDurn = this.logSamples / (double)this.sampleRate;
        this.logFreqFactor = this.logFreqRatio / this.logDurn;
    }

    private void calcFadeDurations() {
        double d2 = this.logFreqRatio / Math.log(2.0);
        double d3 = this.logDurn / d2;
        this.fadeInDurn = this.fadeLinear && this.fromDC ? this.linDurn : d3 / this.fadeInFraction;
        this.fadeOutDurn = this.f2 < (double)(this.sampleRate / 2.0f - 1.0f) ? d3 / this.fadeOutFraction : this.fadeOutNyquistDurn;
    }

    private double linearSweep(double d2) {
        if (this.addDistortion) {
            double d3 = this.kTimesPI * d2 * d2;
            return this.distortedSine(d3, this.linearSweepFreq(d2));
        }
        return this.scale * Math.sin(this.kTimesPI * d2 * d2);
    }

    private double distortedSine(double d2, double d3) {
        double d4 = Math.sin(d2);
        for (int i2 = 0; i2 < this.DIST_LEVELS_PERCENT.length; ++i2) {
            int n2 = 2 + i2;
            double d5 = (double)n2 * d3;
            double d6 = 0.97;
            if (d5 < 0.97 * (double)this.sampleRate / 2.0) {
                d4 += this.DIST_LEVELS_PERCENT[i2] * 0.01 * Math.sin((double)n2 * d2);
                continue;
            }
            if (!(d5 < (double)(this.sampleRate / 2.0f))) continue;
            double d7 = Window.Types.HANNING.rightWindowVal((d5 * 2.0 / (double)this.sampleRate - 0.97) / 0.030000000000000027);
            d4 += d7 * this.DIST_LEVELS_PERCENT[i2] * 0.01 * Math.sin((double)n2 * d2);
        }
        return this.scale * d4;
    }

    private double linearSweepFreq(double d2) {
        return this.k * d2;
    }

    private double logSweep(double d2) {
        if (this.addDistortion) {
            double d3 = this.twoPIf1L * Math.exp(d2 * this.oneOverL);
            return this.distortedSine(d3, this.logSweepFreq(d2));
        }
        return this.scale * Math.sin(this.twoPIf1L * Math.exp(d2 * this.oneOverL));
    }

    private double logSweepFreq(double d2) {
        return this.f1 * Math.exp(this.logFreqFactor * d2);
    }

    @Override
    public boolean inTimeRange(double d2) {
        return d2 >= 0.0 && d2 <= this.totalSweepDurn;
    }

    @Override
    public double getT() {
        return 1.0 / (double)this.sampleRate;
    }

    @Override
    public int getN() {
        return this.totalSamples;
    }

    @Override
    public float[] getData() {
        float[] fArray = new float[2 * this.totalSamples];
        for (int i2 = this.initialSilence; i2 < this.initialSilence + this.actualSweepLength; ++i2) {
            double d2 = (double)i2 / (double)this.sampleRate;
            fArray[i2] = this.value(d2);
        }
        return fArray;
    }

    public float[] getNormData() {
        float[] fArray = new float[2 * this.totalSamples];
        for (int i2 = this.initialSilence; i2 < this.initialSilence + this.actualSweepLength; ++i2) {
            double d2 = (double)i2 / (double)this.sampleRate;
            fArray[i2] = this.normValue(d2);
        }
        return fArray;
    }

    @Override
    public JK getGraphTimeData() {
        if (this.graphTimeData == null) {
            this.graphTimeData = new W(this);
        }
        return this.graphTimeData;
    }

    @Override
    public float getNormVal() {
        return this.normVal;
    }

    @Override
    public void setNormVal(float f2) {
        this.normVal = f2;
    }

    @Override
    public void resetNormVal() {
        this.normVal = this.absMaxVal;
    }

    @Override
    public double getStartTime() {
        return 0.0;
    }

    @Override
    public double getEndTime() {
        return this.totalSweepDurn;
    }

    public void setStartTime(double d2) {
        WizardLogger.getLogger().log(Level.SEVERE, "Unexpected use of setStartTime() in MeasSweepFunction");
    }

    public float[] getValues(int n2, int n3, boolean bl) {
        int n4 = n3 - n2 + 1;
        float[] fArray = new float[n4];
        double d2 = this.getT();
        double d3 = (double)n2 * d2;
        for (int i2 = 0; i2 < n4; ++i2) {
            float f2 = this.value(d3);
            if (bl) {
                f2 /= this.normVal;
            }
            fArray[i2] = f2;
            d3 += d2;
        }
        return fArray;
    }

    @Override
    public float[][] pointsBetween(double d2, double d3, boolean bl) {
        assert (d3 > d2) : "incorrect time value order for pointsBetween, " + d2 + ", " + d3;
        double d4 = 0.0;
        double d5 = this.totalSweepDurn;
        if (d3 < d4 || d2 > d5 || d2 >= d3) {
            return null;
        }
        if (d2 < d4) {
            d2 = d4;
        }
        if (d3 > d5) {
            d3 = d5;
        }
        float[][] fArrayArray = new float[2][];
        double d6 = this.getT();
        int n2 = (int)Math.max(Math.floor((d2 - d4) / d6), 0.0);
        int n3 = (int)Math.min(Math.floor((d3 - d4) / d6), (double)(this.getN() - 1));
        fArrayArray[0] = new float[2];
        fArrayArray[0][0] = (float)(d4 + (double)n2 * d6);
        fArrayArray[0][1] = (float)d6;
        fArrayArray[1] = this.getValues(n2, n3, bl);
        return fArrayArray;
    }
}

