/*
 * Decompiled with CFR 0.152.
 */
package roomeqwizard;

import roomeqwizard.IF;
import roomeqwizard.IH;
import roomeqwizard.JK;
import roomeqwizard.W;

public class MC
implements IH {
    private int D;
    private double F;
    private double B;
    private double H;
    private float K;
    private float I;
    private float C;
    private float[] G;
    private float[] J;
    private transient JK E;

    private float A(int n2) {
        int n3 = n2 >> 4;
        int n4 = n3 << 4;
        int n5 = n2 - n4;
        float f2 = this.G[n3];
        float f3 = this.J[n4];
        for (int i2 = n4 + 1; i2 <= n4 + n5; ++i2) {
            f2 += 0.5f * (f3 + this.J[i2]) * this.C;
            f3 = this.J[i2];
        }
        return f2;
    }

    @Override
    public boolean inTimeRange(double d2) {
        return d2 >= this.B - this.F / 3.0 && d2 <= this.H + this.F / 3.0;
    }

    @Override
    public double getT() {
        return this.F;
    }

    @Override
    public float value(double d2) {
        if (!this.inTimeRange(d2)) {
            return 0.0f;
        }
        double d3 = (d2 - this.B) / this.F;
        int n2 = (int)Math.max(Math.floor(d3), 0.0);
        if (n2 >= this.D) {
            return 0.0f;
        }
        float f2 = (float)(d3 - (double)n2);
        return this.A(n2, f2);
    }

    private float A(int n2, float f2) {
        if (n2 < 0) {
            return this.A(0);
        }
        if (n2 < this.D - 2 && n2 > 0) {
            return IF.A(f2, this.A(n2 - 1), this.A(n2), this.A(n2 + 1), this.A(n2 + 2), 0.0f);
        }
        if (n2 < this.D - 1) {
            return this.A(n2) + (this.A(n2 + 1) - this.A(n2)) * f2;
        }
        return this.A(this.D - 1);
    }

    @Override
    public float value(double d2, boolean bl) {
        float f2 = this.value(d2);
        if (bl) {
            f2 /= this.getNormVal();
        }
        return f2;
    }

    @Override
    public int getN() {
        return this.D;
    }

    @Override
    public float[] getData() {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public float getNormVal() {
        return this.I;
    }

    @Override
    public void setNormVal(float f2) {
        this.I = f2;
    }

    @Override
    public void resetNormVal() {
        this.I = this.K;
    }

    @Override
    public double getStartTime() {
        return this.B;
    }

    @Override
    public double getEndTime() {
        return this.H;
    }

    @Override
    public float[][] pointsBetween(double d2, double d3, boolean bl) {
        assert (d3 > d2) : "incorrect time value order for pointsBetween, " + d2 + ", " + d3;
        if (d3 < this.B || d2 > this.H || d2 >= d3) {
            return null;
        }
        if (d2 < this.B) {
            d2 = this.B;
            d3 = Math.max(d2 + this.F, d3);
        }
        if (d3 > this.H) {
            d3 = this.H;
            d2 = Math.min(d2, d3 - this.F);
        }
        float[][] fArrayArray = new float[2][];
        int n2 = (int)Math.max(Math.floor((d2 - this.B) / this.F), 0.0);
        n2 = Math.min(n2, this.getN() - 1);
        int n3 = (int)Math.min(Math.floor((d3 - this.B) / this.F), (double)(this.getN() - 1));
        fArrayArray[0] = new float[2];
        fArrayArray[0][0] = (float)(this.B + (double)n2 * this.F);
        fArrayArray[0][1] = (float)this.F;
        fArrayArray[1] = this.A(n2, n3, bl);
        return fArrayArray;
    }

    public float[] A(int n2, int n3, boolean bl) {
        int n4 = n3 - n2 + 1;
        float[] fArray = new float[n4];
        if (bl) {
            for (int i2 = n2; i2 <= n3; ++i2) {
                fArray[i2 - n2] = this.A(i2) / this.I;
            }
        } else {
            for (int i3 = n2; i3 <= n3; ++i3) {
                fArray[i3 - n2] = this.A(i3);
            }
        }
        return fArray;
    }

    @Override
    public JK getGraphTimeData() {
        if (this.E == null) {
            this.E = new W(this);
        }
        return this.E;
    }
}

