/*
 * Decompiled with CFR 0.152.
 */
package roomeqwizard;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import javax.swing.JOptionPane;
import roomeqwizard.EK;
import roomeqwizard.HD;
import roomeqwizard.HE;
import roomeqwizard.MeasData;
import roomeqwizard.ModelParameter;
import roomeqwizard.TSParams;
import roomeqwizard.g;

class LossyInductor
implements Serializable {
    static final long serialVersionUID = -12333333333333333L;
    static final double MAX_LE = 0.1;
    static final double MAX_RSS = 100000.0;
    private Models model;
    private double[] values;
    private double Kre;
    private double Kim;
    static final int LE_i = 0;
    static final int R2_i = 1;
    static final int L2_i = 2;
    static final int R3_i = 3;
    static final int L3_i = 4;
    static final int dR_i = 0;
    static final int Leb_i = 1;
    static final int Le_i = 2;
    static final int Rss_i = 3;
    static final int Ke_i = 4;
    static final int K_i = 0;
    static final int n_i = 1;
    private boolean forcedRToZero = false;
    private boolean calculatedR = true;

    LossyInductor(Models models) {
        this.model = models;
        this.values = new double[models.getParams().size()];
    }

    LossyInductor copy() {
        LossyInductor lossyInductor = new LossyInductor(this.model);
        lossyInductor.setValues(this.values);
        lossyInductor.forcedRToZero(this.forcedRToZero);
        lossyInductor.calculatedR(this.calculatedR);
        return lossyInductor;
    }

    void forcedRToZero(boolean bl) {
        this.forcedRToZero = bl;
    }

    void calculatedR(boolean bl) {
        this.calculatedR = bl;
    }

    boolean dRIsForcedToZero() {
        return this.forcedRToZero;
    }

    void clearValues() {
        Arrays.fill(this.values, 0.0);
    }

    int getParamCount() {
        return this.values.length;
    }

    void scaleParams(double[] dArray, HD[] hDArray) {
        double d2 = 0.0;
        if (this.model == Models.TF && this.calculatedR) {
            d2 = this.getdR();
        }
        for (int i2 = 0; i2 < this.values.length; ++i2) {
            this.values[i2] = hDArray[i2].A(this.values[i2], dArray[i2], 0.0, 0.0);
        }
        if (this.model == Models.TF) {
            if (this.values[2] > 0.1) {
                this.values[2] = 0.1;
            }
            if (this.values[3] > 100000.0) {
                this.values[3] = 100000.0;
            }
        }
        if (this.model == Models.TF && (this.calculatedR || this.forcedRToZero)) {
            this.setdR(d2);
        }
    }

    void initRL(double d2, double d3) {
        switch (this.model) {
            case LR2: {
                this.setR2(d2);
                this.setL2(d3);
                break;
            }
            case LR4: {
                this.setR2(d2);
                this.setL2(d3 / 2.0);
                this.setR3(d2 / 2.0);
                this.setL3(d3);
                break;
            }
            default: {
                assert (false) : "Unhandled inductor model in initRL";
                break;
            }
        }
    }

    boolean isZeroValued() {
        for (int i2 = 0; i2 < this.values.length; ++i2) {
            if (this.values[i2] == 0.0) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        switch (this.model) {
            case LR2: {
                StringBuilder stringBuilder = new StringBuilder("LR-2 LE ");
                stringBuilder.append(HE.U.format(this.values[0] / 1.0E-6)).append(" uH, R2 ");
                stringBuilder.append(HE.K.format(this.values[1])).append(" Ohms, L2 ");
                stringBuilder.append(HE.U.format(this.values[2] / 1.0E-6)).append(" uH");
                return stringBuilder.toString();
            }
            case LR4: {
                StringBuilder stringBuilder = new StringBuilder("LR-4 LE ");
                stringBuilder.append(HE.U.format(this.values[0] / 1.0E-6)).append(" uH, R2 ");
                stringBuilder.append(HE.K.format(this.values[1])).append(" Ohms, L2 ");
                stringBuilder.append(HE.U.format(this.values[2] / 1.0E-6)).append(" uH, R3 ");
                stringBuilder.append(HE.K.format(this.values[3])).append(" Ohms, L3 ");
                stringBuilder.append(HE.U.format(this.values[4] / 1.0E-6)).append(" uH");
                return stringBuilder.toString();
            }
            case TF: {
                StringBuilder stringBuilder = new StringBuilder("TF: dR ");
                stringBuilder.append(HE.A.format(this.values[0])).append(" ohms, Leb ");
                stringBuilder.append(HE.A.format(this.values[1] / 1.0E-6)).append(" uH, Le ");
                stringBuilder.append(HE.A.format(this.values[2] / 0.001)).append(" mH, Rss ");
                stringBuilder.append(HE.K.format(this.values[3])).append(" Ohms, Ke ");
                stringBuilder.append(HE.O.format(this.values[4])).append(" S-H");
                return stringBuilder.toString();
            }
            case Leach: {
                StringBuilder stringBuilder = new StringBuilder("Leach: K*1000 ");
                stringBuilder.append(HE.O.format(this.values[0] * 1000.0)).append(" , n ");
                stringBuilder.append(HE.O.format(this.values[1] / 1.0E-6));
                return stringBuilder.toString();
            }
        }
        assert (false) : "Unhandled inductor model in toString";
        return "???";
    }

    EK Z(double d2) {
        EK eK2;
        switch (this.model) {
            case LR2: {
                double d3 = this.values[1];
                if (d3 == 0.0) {
                    return new EK(0.0, d2 * 0.0);
                }
                double d4 = this.values[0];
                double d5 = this.values[2];
                EK eK3 = new EK(0.0, d2 * d3 * d5);
                eK3.G(d3, d2 * d5);
                eK2 = new EK(0.0, d2 * d4);
                eK2.I(eK3);
                break;
            }
            case LR4: {
                double d6 = this.values[1];
                if (d6 == 0.0) {
                    return new EK(0.0, d2 * 0.0);
                }
                double d7 = this.values[0];
                double d8 = this.values[2];
                EK eK4 = new EK(0.0, d2 * d6 * d8);
                eK4.G(d6, d2 * d8);
                eK2 = new EK(0.0, d2 * d7);
                eK2.I(eK4);
                double d9 = this.values[3];
                double d10 = this.values[4];
                eK4 = new EK(0.0, d2 * d9 * d10);
                eK4.G(d9, d2 * d10);
                eK2.I(eK4);
                break;
            }
            case TF: {
                double d11 = this.values[0];
                double d12 = this.values[1];
                double d13 = this.values[2];
                double d14 = this.values[3];
                double d15 = this.values[4];
                eK2 = new EK(d11, d2 * d12);
                if (d13 == 0.0) {
                    return eK2;
                }
                EK eK5 = d14 != 0.0 ? new EK(1.0 / d14, -1.0 / (d2 * d13)) : new EK(0.0, -1.0 / (d2 * d13));
                double d16 = Math.sqrt(d2);
                double d17 = d15 * d16 / Math.sqrt(2.0);
                EK eK6 = new EK(d17, d17);
                eK5.I(EK.F(eK6));
                eK2.I(EK.F(eK5));
                break;
            }
            case Leach: {
                double d18 = this.values[1];
                if (d18 == 0.0) {
                    return new EK(0.0, 0.0);
                }
                double d19 = Math.pow(d2, d18);
                return new EK(this.Kre * d19, this.Kim * d19);
            }
            default: {
                assert (false) : "Unhandled inductor model in Z";
                return new EK();
            }
        }
        return eK2;
    }

    void fitLeach(TSParams tSParams, double d2) {
        double d3;
        MeasData measData = tSParams.meas;
        double d4 = Math.max((double)(measData.endFreq / 8.0f), d2);
        double d5 = Math.min(measData.endFreq, 20000.0f);
        int n2 = 48;
        double d6 = Math.log(d5 / d4) / Math.log(2.0);
        int n3 = (int)(d6 * (double)n2);
        double d7 = Math.pow(2.0, -1.0 / (double)n2);
        float f2 = (float)d5;
        double d8 = 0.0;
        double d9 = 0.0;
        double d10 = 0.0;
        double d11 = 0.0;
        double d12 = 0.0;
        for (int i2 = 0; i2 < n3; ++i2) {
            double d13 = (double)(f2 * 2.0f) * Math.PI;
            double d14 = Math.log(d13);
            d8 += d14;
            d9 += d14 * d14;
            double d15 = measData.splUnsmoothed(f2, 0.0f);
            double d16 = measData.phaseUnsmoothed(f2, 0.0f);
            double d17 = d16 * Math.PI / 180.0;
            double d18 = d15 * Math.cos(d17);
            double d19 = d15 * Math.sin(d17);
            EK eK2 = tSParams.ZM(d13);
            EK eK3 = new EK(d18 - tSParams.getRE() - eK2.B, d19 - eK2.A);
            double d20 = Math.log(EK.H(eK3));
            d10 += d20;
            d11 += d20 * d14;
            d12 += Math.atan2(eK3.A, eK3.B);
            f2 = (float)((double)f2 * d7);
        }
        double d21 = d9 - d8 * d8 / (double)n3 + (double)n3 * 2.4674011002723395;
        double d22 = 1.0 / d21 * (d11 - d10 * d8 / (double)n3 + d12 * Math.PI / 2.0);
        if (d22 > 0.0 && d22 <= 1.0) {
            double d23 = (d10 - d22 * d8) / (double)n3;
            d3 = Math.exp(d23);
            this.Kre = d3 * Math.cos(d22 * Math.PI / 2.0);
            this.Kim = d3 * Math.sin(d22 * Math.PI / 2.0);
        } else {
            d22 = 0.0;
            d3 = 0.0;
            this.Kre = 0.0;
            this.Kim = 0.0;
            JOptionPane.showMessageDialog(g.getDialogParent(), "The high frequency inductance match for\n\n" + measData.getTitle() + "\n\nfailed, the impedance measurement may not be\nfrom a single drive unit without crossover or\nthe measurement may not be valid", "Failed to match HF impedance", 2);
        }
        this.values[0] = d3;
        this.values[1] = d22;
    }

    double[] getValues() {
        double[] dArray = new double[this.values.length];
        System.arraycopy(this.values, 0, dArray, 0, this.values.length);
        return dArray;
    }

    void setValues(double[] dArray) {
        if (this.values == null || this.values.length != dArray.length) {
            this.values = new double[dArray.length];
        }
        System.arraycopy(dArray, 0, this.values, 0, dArray.length);
        if (this.model == Models.Leach) {
            this.updateKreKim();
        }
    }

    void setLE(double d2) {
        this.values[0] = d2;
    }

    double getLE() {
        return this.values[0];
    }

    void setL2(double d2) {
        this.values[2] = d2;
    }

    double getL2() {
        return this.values[2];
    }

    void setL3(double d2) {
        this.values[4] = d2;
    }

    double getL3() {
        return this.values[4];
    }

    void setR2(double d2) {
        this.values[1] = d2;
    }

    double getR2() {
        return this.values[1];
    }

    void setR3(double d2) {
        this.values[3] = d2;
    }

    double getR3() {
        return this.values[3];
    }

    Models getModel() {
        return this.model;
    }

    void setModel(Models models) {
        this.model = models;
    }

    void setdR(double d2) {
        if (this.forcedRToZero) {
            d2 = 0.0;
        }
        this.values[0] = d2;
    }

    double getdR() {
        return this.values[0];
    }

    void setLETF(double d2) {
        this.values[2] = d2;
    }

    double getLETF() {
        return this.values[2];
    }

    void setKe(double d2) {
        this.values[4] = d2;
    }

    double getKe() {
        return this.values[4];
    }

    void setLeb(double d2) {
        this.values[1] = d2;
    }

    double getLeb() {
        return this.values[1];
    }

    void setRss(double d2) {
        this.values[3] = d2;
    }

    double getRss() {
        return this.values[3];
    }

    void setK(double d2) {
        this.values[0] = d2;
        this.updateKreKim();
    }

    double getK() {
        return this.values[0];
    }

    void setN(double d2) {
        this.values[1] = d2;
        this.updateKreKim();
    }

    double getN() {
        return this.values[1];
    }

    private void updateKreKim() {
        this.Kre = this.values[0] * Math.cos(this.values[1] * Math.PI / 2.0);
        this.Kim = this.values[0] * Math.sin(this.values[1] * Math.PI / 2.0);
    }

    void setParam(ModelParameter modelParameter, double d2) {
        switch (modelParameter) {
            case LE: {
                this.setLE(d2);
                break;
            }
            case R2: {
                this.setR2(d2);
                break;
            }
            case L2: {
                this.setL2(d2);
                break;
            }
            case R3: {
                this.setR3(d2);
                break;
            }
            case L3: {
                this.setL3(d2);
                break;
            }
            case K: {
                this.setK(d2);
                break;
            }
            case N: {
                this.setN(d2);
                break;
            }
            case DR: {
                this.setdR(d2);
                break;
            }
            case LEB: {
                this.setLeb(d2);
                break;
            }
            case LETF: {
                this.setLETF(d2);
                break;
            }
            case RSS: {
                this.setRss(d2);
                break;
            }
            case KE: {
                this.setKe(d2);
                break;
            }
            default: {
                assert (false) : "Unhandled enum type";
                break;
            }
        }
    }

    double getParam(ModelParameter modelParameter) {
        switch (modelParameter) {
            case LE: {
                return this.getLE();
            }
            case R2: {
                return this.getR2();
            }
            case L2: {
                return this.getL2();
            }
            case R3: {
                return this.getR3();
            }
            case L3: {
                return this.getL3();
            }
            case K: {
                return this.getK();
            }
            case N: {
                return this.getN();
            }
            case DR: {
                return this.getdR();
            }
            case LEB: {
                return this.getLeb();
            }
            case LETF: {
                return this.getLETF();
            }
            case RSS: {
                return this.getRss();
            }
            case KE: {
                return this.getKe();
            }
        }
        assert (false) : "Unhandled enum type";
        return 0.0;
    }

    EnumMap<ModelParameter, Double> copySettings() {
        EnumMap<ModelParameter, Double> enumMap = new EnumMap<ModelParameter, Double>(ModelParameter.class);
        for (ModelParameter modelParameter : this.getModel().getParams()) {
            enumMap.put(modelParameter, this.getParam(modelParameter));
        }
        return enumMap;
    }

    String paramString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (ModelParameter modelParameter : this.getModel().getParams()) {
            DecimalFormat decimalFormat = new DecimalFormat(modelParameter.getFormatSt());
            stringBuilder.append(modelParameter.getPlainSymbol()).append(": ");
            stringBuilder.append(decimalFormat.format(this.getParam(modelParameter) / modelParameter.getScaling()));
            if (modelParameter.getUnitSt().length() > 0) {
                stringBuilder.append(" ").append(modelParameter.getUnitSt());
            }
            stringBuilder.append("; ");
        }
        return stringBuilder.toString();
    }

    static final class Models
    extends Enum<Models> {
        public static final /* enum */ Models LR2 = new Models();
        public static final /* enum */ Models LR4 = new Models();
        public static final /* enum */ Models TF = new Models();
        public static final /* enum */ Models Leach = new Models();
        private ArrayList<ModelParameter> params;
        private static final /* synthetic */ Models[] $VALUES;

        public static Models[] values() {
            return (Models[])$VALUES.clone();
        }

        public static Models valueOf(String string) {
            return Enum.valueOf(Models.class, string);
        }

        boolean isTFModel() {
            return this == TF;
        }

        public String toString() {
            switch (this) {
                case LR2: {
                    return "LR-2: R2//L2";
                }
                case LR4: {
                    return "LR-4: R2//L2 + R3//L3";
                }
                case TF: {
                    return "Thorborg-Futtrup: deltaR + Leb + Le//Rss//Ke";
                }
                case Leach: {
                    return "Leach: K, n";
                }
            }
            assert (false) : "Unhandled inductor model in toString";
            return "???";
        }

        public String title() {
            switch (this) {
                case LR2: {
                    return "LR-2";
                }
                case LR4: {
                    return "LR-4";
                }
                case TF: {
                    return "T-F";
                }
                case Leach: {
                    return "Leach";
                }
            }
            assert (false) : "Unhandled inductor model in toString";
            return "???";
        }

        private void initParams() {
            this.params = new ArrayList();
            switch (this) {
                case LR2: {
                    this.params.add(ModelParameter.LE);
                    this.params.add(ModelParameter.R2);
                    this.params.add(ModelParameter.L2);
                    break;
                }
                case LR4: {
                    this.params.add(ModelParameter.LE);
                    this.params.add(ModelParameter.R2);
                    this.params.add(ModelParameter.L2);
                    this.params.add(ModelParameter.R3);
                    this.params.add(ModelParameter.L3);
                    break;
                }
                case Leach: {
                    this.params.add(ModelParameter.K);
                    this.params.add(ModelParameter.N);
                    break;
                }
                case TF: {
                    this.params.add(ModelParameter.DR);
                    this.params.add(ModelParameter.LEB);
                    this.params.add(ModelParameter.LETF);
                    this.params.add(ModelParameter.RSS);
                    this.params.add(ModelParameter.KE);
                }
            }
        }

        ArrayList<ModelParameter> getParams() {
            if (this.params == null) {
                this.initParams();
            }
            return this.params;
        }

        static {
            $VALUES = new Models[]{LR2, LR4, TF, Leach};
        }
    }
}

