/*
 * Decompiled with CFR 0.152.
 */
package roomeqwizard;

import java.awt.geom.Line2D;
import java.io.Serializable;
import java.util.logging.Level;
import roomeqwizard.DH;
import roomeqwizard.IF;
import roomeqwizard.Interpolation;
import roomeqwizard.WizardLogger;
import roomeqwizard.kJ;

class LogDataSet
implements DH,
Serializable,
Cloneable {
    static final long serialVersionUID = 1L;
    double startFreq;
    double endFreq;
    int ppo;
    double logStep;
    double logStepLog;
    private Interpolation interpolationType = Interpolation.HERMITE;
    private double tension = 0.0;
    private double[] data;
    private Double invalidValue;

    public LogDataSet(double d2, int n2, double[] dArray, Double d3) {
        this.startFreq = d2;
        this.ppo = n2;
        this.data = dArray;
        this.invalidValue = d3;
        this.logStep = Math.pow(2.0, 1.0 / (double)n2);
        this.logStepLog = 1.0 / (double)n2 * Math.log(2.0);
        this.endFreq = this.indexToFreq(dArray.length - 1);
    }

    @Override
    public LogDataSet clone() {
        LogDataSet logDataSet = null;
        try {
            logDataSet = (LogDataSet)super.clone();
            if (this.data != null) {
                logDataSet.data = (double[])this.data.clone();
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            WizardLogger.getLogger().log(Level.SEVERE, null, cloneNotSupportedException);
        }
        return logDataSet;
    }

    public void setInterpolationType(Interpolation interpolation) {
        this.interpolationType = interpolation;
    }

    public void setTension(double d2) {
        this.tension = d2;
    }

    public int length() {
        return this.data.length;
    }

    public double indexToFreq(double d2) {
        return this.startFreq * Math.exp(d2 * this.logStepLog);
    }

    @Override
    public double freqToIndex(double d2) {
        return Math.log(d2 / this.startFreq) / this.logStepLog;
    }

    @Override
    public double value(double d2) {
        if (d2 < this.startFreq) {
            return this.invalidValue;
        }
        if (d2 > this.endFreq) {
            return this.invalidValue;
        }
        double d3 = this.freqToIndex(d2);
        if (d3 < 0.0) {
            d3 = 0.0;
        }
        int n2 = (int)d3;
        switch (this.interpolationType) {
            case HERMITE: {
                if (n2 < this.data.length - 2 && n2 > 0 && this.data[n2 - 1] != this.invalidValue && this.data[n2] != this.invalidValue && this.data[n2 + 1] != this.invalidValue && this.data[n2 + 2] != this.invalidValue) {
                    double d4 = this.startFreq * Math.pow(this.logStep, n2);
                    double d5 = Math.log(d2 / d4) / this.logStepLog;
                    return IF.A(d5, this.data[n2 - 1], this.data[n2], this.data[n2 + 1], this.data[n2 + 2], this.tension);
                }
            }
            case LINEAR: {
                if (n2 < this.data.length - 1 && this.data[n2] != this.invalidValue && this.data[n2 + 1] != this.invalidValue) {
                    double d6 = this.startFreq * Math.pow(this.logStep, n2);
                    double d7 = Math.log(d2 / d6) / this.logStepLog;
                    return this.data[n2] + (this.data[n2 + 1] - this.data[n2]) * d7;
                }
            }
            case NONE: {
                return this.data[Math.min((int)Math.round(d3), this.data.length - 1)];
            }
        }
        assert (false) : "Unhandled enum type";
        return this.invalidValue;
    }

    public Line2D.Float minMax(double d2, double d3) {
        int n2;
        float f2 = (float)this.value(d2);
        Line2D.Float float_ = new Line2D.Float((float)d2, f2, (float)d2, f2);
        int n3 = (int)Math.round(this.freqToIndex(d2));
        if (n3 < 0) {
            n3 = 0;
        }
        if (n3 > this.data.length - 1) {
            n3 = this.data.length - 1;
        }
        if ((n2 = (int)Math.round(this.freqToIndex(d2 + d3))) < 0) {
            n2 = 0;
        }
        if (n2 > this.data.length - 1) {
            n2 = this.data.length - 1;
        }
        if (n2 <= n3) {
            float f3;
            float_.x1 = f3 = (float)this.indexToFreq(n3);
            float_.y1 = (float)this.data[n3];
            float_.x2 = float_.x1;
            float_.y2 = float_.y1;
        } else {
            float f4;
            float f5;
            float f6 = f5 = (float)this.data[n3];
            int n4 = n3;
            int n5 = n3;
            for (int i2 = n3 + 1; i2 <= n2; ++i2) {
                f4 = (float)this.data[i2];
                if (f4 < f5) {
                    f5 = f4;
                    n4 = i2;
                    continue;
                }
                if (!(f4 > f6)) continue;
                f6 = f4;
                n5 = i2;
            }
            float f7 = (float)this.indexToFreq(n4);
            f4 = (float)this.indexToFreq(n5);
            if (n4 <= n5) {
                float_.x1 = f7;
                float_.y1 = f5;
                float_.x2 = f4;
                float_.y2 = f6;
            } else {
                float_.x1 = f4;
                float_.y1 = f6;
                float_.x2 = f7;
                float_.y2 = f5;
            }
        }
        return float_;
    }

    public float[][] pointsBetween(double d2, double d3) {
        int n2;
        assert (d3 > d2) : "incorrect time value order for pointsBetween, " + d2 + ", " + d3;
        if (d3 < this.startFreq || d2 > this.endFreq) {
            return null;
        }
        if (d2 < this.startFreq) {
            d2 = this.startFreq;
        }
        if (d3 > this.endFreq) {
            d3 = this.endFreq;
        }
        float[][] fArrayArray = new float[2][];
        int n3 = (int)Math.ceil(Math.log(d2 / this.startFreq) / this.logStepLog);
        int n4 = (int)Math.floor(0.1 + Math.log(d3 / this.startFreq) / this.logStepLog);
        if (n4 >= this.data.length) {
            n4 = this.data.length - 1;
        }
        int n5 = n4 - n3 + 1;
        fArrayArray[0] = new float[n5];
        fArrayArray[1] = new float[n5];
        for (n2 = 0; n2 < n5; ++n2) {
            fArrayArray[0][n2] = (float)(this.startFreq * Math.pow(this.logStep, n3 + n2));
        }
        for (n2 = 0; n2 < n5; ++n2) {
            fArrayArray[1][n2] = (float)this.data[n3 + n2];
        }
        return fArrayArray;
    }

    public double minWithinSpan(double d2, double d3) {
        double d4 = Double.MAX_VALUE;
        int n2 = (int)Math.max(Math.round(this.freqToIndex(d2)), 0L);
        int n3 = (int)Math.min(Math.round(this.freqToIndex(d3)), (long)(this.data.length - 1));
        for (int i2 = n2; i2 <= n3; ++i2) {
            d4 = Math.min(d4, this.data[i2]);
        }
        return d4;
    }

    public double maxWithinSpan(double d2, double d3) {
        double d4 = -1.7976931348623157E308;
        int n2 = (int)Math.max(Math.round(this.freqToIndex(d2)), 0L);
        int n3 = (int)Math.min(Math.round(this.freqToIndex(d3)), (long)(this.data.length - 1));
        for (int i2 = n2; i2 <= n3; ++i2) {
            d4 = Math.max(d4, this.data[i2]);
        }
        return d4;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void smoothLogData(double d2, float[] fArray, float[] fArray2, double d3, int n2, boolean bl) {
        int n3;
        if (d3 == 1.0) {
            System.arraycopy(fArray, 0, fArray2, 0, fArray.length);
            if (!kJ.K(d2)) throw new UnsupportedOperationException("Only fixed fraction smoothing is supported");
            kJ.A(d2, fArray2, n2);
            return;
        }
        float[] fArray3 = new float[fArray.length];
        float f2 = 0.0f;
        if (bl) {
            for (int i2 = 0; i2 < fArray.length; ++i2) {
                fArray3[i2] = (float)Math.pow(fArray[i2], d3);
            }
        } else {
            double d4 = d3 / 20.0;
            for (n3 = 0; n3 < fArray.length; ++n3) {
                float f3 = fArray[n3];
                if (!(f3 > f2)) continue;
                f2 = f3;
            }
            for (n3 = 0; n3 < fArray.length; ++n3) {
                fArray3[n3] = (float)Math.pow(10.0, (double)(fArray[n3] - f2) * d4);
            }
        }
        if (!kJ.K(d2)) {
            throw new UnsupportedOperationException("Only fixed fraction smoothing is supported");
        }
        kJ.A(d2, fArray3, n2);
        if (bl) {
            double d5 = 1.0 / d3;
            for (n3 = 0; n3 < fArray.length; ++n3) {
                if (fArray3[n3] <= 0.0f) {
                    fArray3[n3] = 1.0E-12f;
                }
                fArray3[n3] = (float)Math.pow(fArray3[n3], d5);
            }
        } else {
            double d6 = 20.0 / d3;
            for (n3 = 0; n3 < fArray3.length; ++n3) {
                if (fArray3[n3] <= 0.0f) {
                    fArray3[n3] = 1.0E-12f;
                }
                fArray3[n3] = (float)(d6 * Math.log10(fArray3[n3]) + (double)f2);
            }
        }
        System.arraycopy(fArray3, 0, fArray2, 0, fArray.length);
    }
}

