/*
 * Decompiled with CFR 0.152.
 */
package roomeqwizard;

import java.awt.geom.Line2D;
import java.io.Serializable;
import java.util.logging.Level;
import roomeqwizard.DH;
import roomeqwizard.IF;
import roomeqwizard.Interpolation;
import roomeqwizard.WizardLogger;

class LinearDataSet
implements DH,
Serializable,
Cloneable {
    static final long serialVersionUID = 1L;
    double startFreq;
    double endFreq;
    double freqStep;
    private Interpolation interpolationType = Interpolation.HERMITE;
    private double tension = 0.0;
    private double[] data;
    private Double invalidValue;

    public LinearDataSet(double d2, double d3, double[] dArray, Double d4) {
        this.startFreq = d2;
        this.freqStep = d3;
        this.data = dArray;
        this.invalidValue = d4;
        this.endFreq = this.indexToFreq(dArray.length - 1);
    }

    @Override
    public LinearDataSet clone() {
        LinearDataSet linearDataSet = null;
        try {
            linearDataSet = (LinearDataSet)super.clone();
            if (this.data != null) {
                linearDataSet.data = (double[])this.data.clone();
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            WizardLogger.getLogger().log(Level.SEVERE, null, cloneNotSupportedException);
        }
        return linearDataSet;
    }

    public void setInterpolationType(Interpolation interpolation) {
        this.interpolationType = interpolation;
    }

    public void setTension(double d2) {
        this.tension = d2;
    }

    public int length() {
        return this.data.length;
    }

    public double indexToFreq(double d2) {
        return this.startFreq + d2 * this.freqStep;
    }

    @Override
    public double freqToIndex(double d2) {
        return (d2 - this.startFreq) / this.freqStep;
    }

    @Override
    public double value(double d2) {
        if (d2 < this.startFreq) {
            return this.invalidValue;
        }
        if (d2 > this.endFreq) {
            return this.invalidValue;
        }
        double d3 = this.freqToIndex(d2);
        if (d3 < 0.0) {
            d3 = 0.0;
        }
        int n2 = (int)d3;
        switch (this.interpolationType) {
            case HERMITE: {
                if (n2 < this.data.length - 2 && n2 > 0 && this.data[n2 - 1] != this.invalidValue && this.data[n2] != this.invalidValue && this.data[n2 + 1] != this.invalidValue && this.data[n2 + 2] != this.invalidValue) {
                    double d4 = this.startFreq + (double)n2 * this.freqStep;
                    double d5 = (d2 - d4) / this.freqStep;
                    return IF.A(d5, this.data[n2 - 1], this.data[n2], this.data[n2 + 1], this.data[n2 + 2], this.tension);
                }
            }
            case LINEAR: {
                if (n2 < this.data.length - 1 && this.data[n2] != this.invalidValue && this.data[n2 + 1] != this.invalidValue) {
                    double d6 = this.startFreq + (double)n2 * this.freqStep;
                    double d7 = (d2 - d6) / this.freqStep;
                    return this.data[n2] + (this.data[n2 + 1] - this.data[n2]) * d7;
                }
            }
            case NONE: {
                return this.data[Math.min((int)Math.round(d3), this.data.length - 1)];
            }
        }
        assert (false) : "Unhandled enum type";
        return this.invalidValue;
    }

    public Line2D.Float minMax(double d2, double d3) {
        int n2;
        float f2 = (float)this.value(d2);
        Line2D.Float float_ = new Line2D.Float((float)d2, f2, (float)d2, f2);
        int n3 = (int)Math.round(this.freqToIndex(d2));
        if (n3 < 0) {
            n3 = 0;
        }
        if (n3 > this.data.length - 1) {
            n3 = this.data.length - 1;
        }
        if ((n2 = (int)Math.round(this.freqToIndex(d2 + d3))) < 0) {
            n2 = 0;
        }
        if (n2 > this.data.length - 1) {
            n2 = this.data.length - 1;
        }
        if (n2 <= n3) {
            float f3;
            float_.x1 = f3 = (float)this.indexToFreq(n3);
            float_.y1 = (float)this.data[n3];
            float_.x2 = float_.x1;
            float_.y2 = float_.y1;
        } else {
            float f4;
            float f5;
            float f6 = f5 = (float)this.data[n3];
            int n4 = n3;
            int n5 = n3;
            for (int i2 = n3 + 1; i2 <= n2; ++i2) {
                f4 = (float)this.data[i2];
                if (f4 < f5) {
                    f5 = f4;
                    n4 = i2;
                    continue;
                }
                if (!(f4 > f6)) continue;
                f6 = f4;
                n5 = i2;
            }
            float f7 = (float)this.indexToFreq(n4);
            f4 = (float)this.indexToFreq(n5);
            if (n4 <= n5) {
                float_.x1 = f7;
                float_.y1 = f5;
                float_.x2 = f4;
                float_.y2 = f6;
            } else {
                float_.x1 = f4;
                float_.y1 = f6;
                float_.x2 = f7;
                float_.y2 = f5;
            }
        }
        return float_;
    }

    public double minWithinSpan(double d2, double d3) {
        double d4 = Double.MAX_VALUE;
        int n2 = (int)Math.max(Math.round(this.freqToIndex(d2)), 0L);
        int n3 = (int)Math.min(Math.round(this.freqToIndex(d3)), (long)(this.data.length - 1));
        for (int i2 = n2; i2 <= n3; ++i2) {
            d4 = Math.min(d4, this.data[i2]);
        }
        return d4;
    }

    public double maxWithinSpan(double d2, double d3) {
        double d4 = -1.7976931348623157E308;
        int n2 = (int)Math.max(Math.round(this.freqToIndex(d2)), 0L);
        int n3 = (int)Math.min(Math.round(this.freqToIndex(d3)), (long)(this.data.length - 1));
        for (int i2 = n2; i2 <= n3; ++i2) {
            d4 = Math.max(d4, this.data[i2]);
        }
        return d4;
    }

    public float[][] pointsBetween(double d2, double d3) {
        int n2;
        assert (d3 > d2) : "incorrect time value order for pointsBetween, " + d2 + ", " + d3;
        if (d3 < this.startFreq || d2 > this.endFreq) {
            return null;
        }
        if (d2 < this.startFreq) {
            d2 = this.startFreq;
        }
        if (d3 > this.endFreq) {
            d3 = this.endFreq;
        }
        float[][] fArrayArray = new float[2][];
        int n3 = (int)Math.ceil((d2 - this.startFreq) / this.freqStep);
        int n4 = (int)Math.floor(0.1 + (d3 - this.startFreq) / this.freqStep);
        if (n4 >= this.data.length) {
            n4 = this.data.length - 1;
        }
        int n5 = n4 - n3 + 1;
        fArrayArray[0] = new float[n5];
        fArrayArray[1] = new float[n5];
        for (n2 = 0; n2 < n5; ++n2) {
            fArrayArray[0][n2] = (float)(this.startFreq + (double)(n3 + n2) * this.freqStep);
        }
        for (n2 = 0; n2 < n5; ++n2) {
            fArrayArray[1][n2] = (float)this.data[n3 + n2];
        }
        return fArrayArray;
    }
}

