/*
 * Decompiled with CFR 0.152.
 */
package roomeqwizard;

import javax.swing.JFormattedTextField;
import roomeqwizard.lG;

public final class LevelUnit
extends Enum<LevelUnit> {
    public static final /* enum */ LevelUnit DBU = new LevelUnit("dBu", "dBu", 2);
    public static final /* enum */ LevelUnit DBV = new LevelUnit("dBV", "dBV", 2);
    public static final /* enum */ LevelUnit VOLT = new LevelUnit("Volts", "V", 3);
    public static final /* enum */ LevelUnit DBFS = new LevelUnit("dBFS", "dBFS", 2);
    private static final double dbVdBuOffset;
    private final String description;
    private final String unit;
    private final int fractionDigits;
    private static final /* synthetic */ LevelUnit[] $VALUES;

    public static LevelUnit[] values() {
        return (LevelUnit[])$VALUES.clone();
    }

    public static LevelUnit valueOf(String string) {
        return Enum.valueOf(LevelUnit.class, string);
    }

    private LevelUnit(String string2, String string3, int n3) {
        this.description = string2;
        this.unit = string3;
        this.fractionDigits = n3;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return this.description;
    }

    public String suffix() {
        return this.unit;
    }

    public int getFractionDigits() {
        return this.fractionDigits;
    }

    public int columns(JFormattedTextField jFormattedTextField) {
        return 7;
    }

    public boolean convertLinear() {
        switch (this) {
            case DBFS: 
            case DBU: 
            case DBV: {
                return false;
            }
            case VOLT: {
                return true;
            }
        }
        assert (false) : "Unhandled enum type";
        return false;
    }

    public double convertTodBFS(double d2) {
        switch (this) {
            case DBFS: {
                return d2;
            }
            case DBU: {
                return d2 + dbVdBuOffset + lG.\u0424();
            }
            case DBV: {
                return d2 + lG.\u0424();
            }
            case VOLT: {
                return 20.0 * Math.log10(d2) + lG.\u0424();
            }
        }
        assert (false) : "Unhandled enum type";
        return d2;
    }

    public double convertdBFSToUnit(double d2) {
        switch (this) {
            case DBFS: {
                return d2;
            }
            case DBU: {
                return d2 - (lG.\u0424() + dbVdBuOffset);
            }
            case DBV: {
                return d2 - lG.\u0424();
            }
            case VOLT: {
                return Math.pow(10.0, (d2 - lG.\u0424()) / 20.0);
            }
        }
        assert (false) : "Unhandled enum type";
        return d2;
    }

    public static LevelUnit getEnum(String string) {
        for (LevelUnit levelUnit : LevelUnit.values()) {
            if (!levelUnit.name().equalsIgnoreCase(string)) continue;
            return levelUnit;
        }
        return DBFS;
    }

    public static LevelUnit getUnitFromSuffix(String string) {
        for (LevelUnit levelUnit : LevelUnit.values()) {
            if (!levelUnit.suffix().equalsIgnoreCase(string)) continue;
            return levelUnit;
        }
        return null;
    }

    static {
        $VALUES = new LevelUnit[]{DBU, DBV, VOLT, DBFS};
        dbVdBuOffset = 10.0 * Math.log10(0.6);
    }
}

