/*
 * Decompiled with CFR 0.152.
 */
package roomeqwizard;

import javax.swing.JFormattedTextField;
import roomeqwizard.HE;

public final class LengthUnit
extends Enum<LengthUnit> {
    public static final /* enum */ LengthUnit METRE = new LengthUnit("metres", "m");
    public static final /* enum */ LengthUnit FOOT = new LengthUnit("feet", "ft");
    static final double METRES_PER_FOOT = 0.3048;
    private final String description;
    private final String suffix;
    private static final /* synthetic */ LengthUnit[] $VALUES;

    public static LengthUnit[] values() {
        return (LengthUnit[])$VALUES.clone();
    }

    public static LengthUnit valueOf(String string) {
        return Enum.valueOf(LengthUnit.class, string);
    }

    private LengthUnit(String string2, String string3) {
        this.description = string2;
        this.suffix = string3;
    }

    public String toString() {
        return this.description;
    }

    public String suffix() {
        return this.suffix;
    }

    public String apiName() {
        return this.description;
    }

    public double metresToUnit(double d2) {
        if (this == METRE) {
            return d2;
        }
        return d2 / 0.3048;
    }

    public double toMetres(double d2) {
        if (this == METRE) {
            return d2;
        }
        return d2 * 0.3048;
    }

    public String volumeSt(double d2) {
        switch (this) {
            case METRE: {
                if (d2 < 1000.0) {
                    return HE.U.format(d2);
                }
                return HE.I.format(d2);
            }
            case FOOT: {
                return HE.I.format(d2 * 35.3146667);
            }
        }
        assert (false) : "Unhandled length unit in convertVolume";
        return HE.U.format(d2);
    }

    public int columns(JFormattedTextField jFormattedTextField) {
        return 6;
    }

    public static LengthUnit getEnum(String string) {
        for (LengthUnit lengthUnit : LengthUnit.values()) {
            if (!lengthUnit.name().equalsIgnoreCase(string)) continue;
            return lengthUnit;
        }
        return METRE;
    }

    public static LengthUnit getFromApiName(String string) {
        for (LengthUnit lengthUnit : LengthUnit.values()) {
            if (!lengthUnit.apiName().equalsIgnoreCase(string)) continue;
            return lengthUnit;
        }
        return null;
    }

    static {
        $VALUES = new LengthUnit[]{METRE, FOOT};
    }
}

