/*
 * Decompiled with CFR 0.152.
 */
package roomeqwizard;

import java.io.Serializable;
import roomeqwizard.BaseImpedanceModel;
import roomeqwizard.EK;
import roomeqwizard.HD;
import roomeqwizard.ModelParameter;
import roomeqwizard.MotionalImpedance;
import roomeqwizard.MotionalImpedanceModel;
import roomeqwizard.TSParams;
import roomeqwizard.ZJ;

class LOGModel
extends BaseImpedanceModel
implements Serializable {
    static final long serialVersionUID = 1L;
    protected double beta;
    protected double L0;
    protected double R0;
    protected double lastR0;
    protected double lastL0;
    protected double lastCMES;

    LOGModel(TSParams tSParams) {
        super(tSParams);
    }

    @Override
    public MotionalImpedanceModel getModel() {
        return MotionalImpedanceModel.LOG;
    }

    @Override
    public void setPrimaryValues(MotionalImpedance motionalImpedance) {
        assert (motionalImpedance instanceof LOGModel);
        this.R0 = motionalImpedance.getParam(ModelParameter.R0);
        this.L0 = motionalImpedance.getParam(ModelParameter.L0);
        this.beta = motionalImpedance.getParam(ModelParameter.BETA);
        this.primaryOmegaS = motionalImpedance.getOmegaS();
        this.primaryCMES = motionalImpedance.getParam(ModelParameter.CMES);
    }

    @Override
    public void initialise(double d2, float f2, float f3, float f4, double d3, double d4, boolean bl) {
        super.initialise(d2, f2, f3, f4, d3, d4, bl);
        this.beta = 0.01;
        this.L0 = this.LCES;
        this.R0 = d4 - d3;
        this.primaryOmegaS = this.peakOmega;
        this.primaryCMES = this.CMES;
        this.calcCompliance(this.peakOmega);
        this.calcOmegaSValues();
    }

    @Override
    public int getOptimiserParamCount() {
        return 1;
    }

    @Override
    public void scaleParams(double[] dArray, HD[] hDArray, double d2, boolean bl) {
        if (this.isPrimary || !bl) {
            this.beta = dArray.length > 1 ? hDArray[0].A(this.beta, dArray[0], 0.0, 0.0) : dArray[0];
            this.CMES = this.lastCMES;
            this.R0 = this.lastR0;
            this.L0 = this.lastL0;
        } else {
            this.CMES = dArray.length > 1 ? hDArray[0].A(this.CMES, dArray[0], 0.0, 0.0) : dArray[0];
        }
        this.recalcParams(d2);
    }

    @Override
    public double modelFit(double[] dArray, HD[] hDArray, boolean bl, double d2, double[] dArray2, double[] dArray3, double[] dArray4, double[] dArray5) {
        double d3 = this.CMES;
        double d4 = this.L0;
        double d5 = this.R0;
        double d6 = this.beta;
        if (this.isPrimary || !bl) {
            this.beta = hDArray[0].A(this.beta, dArray[0], 0.0, 0.0);
            double[] dArray6 = this.solveForAllAtBeta(dArray2, dArray3, dArray4, this.beta);
            this.CMES = dArray6[0];
            this.R0 = dArray6[1];
            this.L0 = dArray6[2];
            this.lastCMES = this.CMES;
            this.lastR0 = this.R0;
            this.lastL0 = this.L0;
        } else {
            this.lastCMES = this.CMES = hDArray[0].A(this.CMES, dArray[0], 0.0, 0.0);
        }
        this.calcOmegaSValues();
        double d7 = this.calculateError(dArray2, dArray3, dArray4, dArray5);
        this.CMES = d3;
        this.L0 = d4;
        this.R0 = d5;
        this.beta = d6;
        this.recalcParams(d2);
        return d7;
    }

    @Override
    public double modelFit(double d2, boolean bl, double d3, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4) {
        double d4 = this.CMES;
        double d5 = this.L0;
        double d6 = this.R0;
        double d7 = this.beta;
        if (this.isPrimary || !bl) {
            this.beta = d2;
            double[] dArray5 = this.solveForAllAtBeta(dArray, dArray2, dArray3, this.beta);
            this.CMES = dArray5[0];
            this.R0 = dArray5[1];
            this.L0 = dArray5[2];
            this.lastCMES = this.CMES;
            this.lastR0 = this.R0;
            this.lastL0 = this.L0;
        } else {
            this.lastCMES = this.CMES = d2;
        }
        this.calcOmegaSValues();
        double d8 = this.calculateError(dArray, dArray2, dArray3, dArray4);
        this.CMES = d4;
        this.L0 = d5;
        this.R0 = d6;
        this.beta = d7;
        this.recalcParams(d3);
        return d8;
    }

    @Override
    public double fitNewValue(double d2, double d3, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4) {
        this.beta = d2;
        double[] dArray5 = this.solveForAllAtBeta(dArray, dArray2, dArray3, this.beta);
        this.CMES = dArray5[0];
        this.R0 = dArray5[1];
        this.L0 = dArray5[2];
        this.lastCMES = this.CMES;
        this.lastR0 = this.R0;
        this.lastL0 = this.L0;
        this.calcOmegaSValues();
        this.recalcParams(d3);
        double d4 = this.calculateError(dArray, dArray2, dArray3, dArray4);
        return d4;
    }

    @Override
    public double[] fMinLimits(boolean bl) {
        double[] dArray = new double[2];
        if (this.isPrimary || !bl) {
            dArray[0] = 0.0;
            dArray[1] = 1.0 / Math.log(this.peakOmega);
        } else {
            double d2 = this.primaryOmegaS / this.peakOmega;
            double d3 = d2 * d2 * this.primaryCMES;
            dArray[0] = 0.9 * d3;
            dArray[1] = 1.1 * d3;
        }
        return dArray;
    }

    double[] solveForAllAtBeta(double[] dArray, double[] dArray2, double[] dArray3, double d2) {
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        int n2 = dArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            double d10 = dArray[i2];
            double d11 = d10 * d10;
            d3 += d11;
            EK eK2 = this.sigma(d10, d2);
            d4 += eK2.B;
            d5 += eK2.A / d10;
            d6 += (eK2.B * eK2.B + eK2.A * eK2.A) / d11;
            EK eK3 = EK.B(dArray2[i2], dArray3[i2]);
            d7 += d10 * eK3.A;
            d8 += eK3.B;
            d9 += (eK2.B * eK3.A - eK2.A * eK3.B) / d10;
        }
        double[][] dArrayArray = new double[][]{{d3, 0.0, d4}, {0.0, n2, -d5}, {d4, -d5, d6}};
        ZJ zJ2 = new ZJ(dArrayArray);
        double[] dArray4 = new double[]{d7, d8, d9};
        double[] dArray5 = zJ2.A(dArray4);
        if (dArray5[1] < 1.0E-6) {
            dArray5[1] = 1.0E-6;
        }
        dArray5[1] = 1.0 / dArray5[1];
        dArray5[2] = -1.0 / dArray5[2];
        return dArray5;
    }

    double solveForCMESAtBeta(double[] dArray, double[] dArray2, double[] dArray3, double d2) {
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        int n2 = dArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            double d9 = dArray[i2];
            double d10 = d9 * d9;
            d3 += d10;
            EK eK2 = this.sigma(d9, d2);
            d4 += eK2.B;
            d5 += eK2.A / d9;
            d6 += (eK2.B * eK2.B + eK2.A * eK2.A) / d10;
            EK eK3 = EK.B(dArray2[i2], dArray3[i2]);
            d7 += d9 * eK3.A;
            d8 += (eK2.B * eK3.A - eK2.A * eK3.B) / d9;
        }
        double d11 = 1.0 / this.R0;
        double d12 = -1.0 / this.L0;
        double d13 = (d7 - d4 * d12) / d3;
        double d14 = (d8 + d5 * d11 - d6 * d12) / d4;
        double d15 = (d13 + d14) * 0.5;
        return d15;
    }

    protected EK sigma(double d2, double d3) {
        double d4 = 1.0 - d3 * Math.log(d2);
        if (d4 < 1.0E-9) {
            d4 = 1.0E-9;
        }
        double d5 = -d3 * Math.PI / 2.0;
        return EK.B(d4, d5);
    }

    @Override
    protected void calcCompliance(double d2) {
        double d3 = 1.0 - this.beta * Math.log(d2);
        if (d3 < 1.0E-9) {
            d3 = 1.0E-9;
        }
        double d4 = -this.beta * Math.PI / 2.0;
        double d5 = d3 * d3 + d4 * d4;
        this.LCES = this.L0 * d5 / d3;
        this.YLCES = -d4 / (this.L0 * d2 * d5);
    }

    @Override
    protected double calcLCES(double d2) {
        double d3 = 1.0 - this.beta * Math.log(d2);
        if (d3 < 1.0E-9) {
            d3 = 1.0E-9;
        }
        double d4 = -this.beta * Math.PI / 2.0;
        double d5 = d3 * d3 + d4 * d4;
        return this.L0 * d5 / d3;
    }

    protected void calcOmegaSValues() {
        this.omegaS = this.peakOmega;
        for (int i2 = 0; i2 < 10; ++i2) {
            this.calcCompliance(this.omegaS);
            double d2 = 1.0 / Math.sqrt(this.CMES * this.LCES);
            double d3 = Math.abs(1.0 - d2 / this.omegaS);
            this.omegaS = d2;
            if (d3 < 1.0E-4) break;
        }
        this.LCESAtOmegaS = this.LCES;
        this.RESAtOmegaS = 1.0 / (1.0 / this.R0 + this.YLCES);
    }

    @Override
    protected double getYES() {
        return 1.0 / this.R0 + this.YLCES;
    }

    @Override
    public void recalcParams(double d2) {
        this.calcOmegaSValues();
        this.QES = this.omegaS * this.CMES * d2;
        this.QMS = this.omegaS * this.CMES * this.RESAtOmegaS;
        this.QTS = this.QES * this.QMS / (this.QES + this.QMS);
    }

    @Override
    public double getResEquiv() {
        return this.RESAtOmegaS;
    }

    @Override
    public void setParam(ModelParameter modelParameter, double d2) {
        switch (modelParameter) {
            case R0: {
                this.R0 = d2;
                break;
            }
            case RES: {
                this.RES = d2;
                break;
            }
            case CMES: {
                this.CMES = d2;
                break;
            }
            case LCES: {
                this.LCESAtOmegaS = d2;
                break;
            }
            case BETA: {
                this.beta = d2;
                break;
            }
            case L0: {
                this.L0 = d2;
                break;
            }
            default: {
                assert (false) : "Unhandled enum type " + (Object)((Object)modelParameter);
                break;
            }
        }
    }

    @Override
    public double getParam(ModelParameter modelParameter) {
        switch (modelParameter) {
            case R0: {
                return this.R0;
            }
            case RES: {
                return this.RES;
            }
            case CMES: {
                return this.CMES;
            }
            case LCES: {
                return this.LCESAtOmegaS;
            }
            case BETA: {
                return this.beta;
            }
            case L0: {
                return this.L0;
            }
        }
        assert (false) : "Unhandled enum type " + (Object)((Object)modelParameter);
        return 0.0;
    }
}

